/*
 * Decompiled with CFR 0.152.
 */
package plugins.lagache.debleach;

import Jama.Matrix;
import icy.gui.frame.IcyFrame;
import icy.gui.frame.progress.AnnounceFrame;
import icy.image.IcyBufferedImage;
import icy.sequence.Sequence;
import icy.system.thread.ThreadUtil;
import icy.type.DataType;
import icy.type.collection.array.Array1DUtil;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.ezplug.EzComponent;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzVar;
import plugins.adufour.ezplug.EzVarBoolean;
import plugins.adufour.ezplug.EzVarEnum;
import plugins.adufour.ezplug.EzVarInteger;
import plugins.adufour.ezplug.EzVarListener;
import plugins.adufour.ezplug.EzVarSequence;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarSequence;

public class Debleach
extends EzPlug
implements Block {
    private EzVarSequence input = new EzVarSequence("Input Sequence");
    private EzVarInteger nb_frames = new EzVarInteger("Number of frames used to fit bleaching constants (input sequence time length by default)", new Integer[0], true);
    private VarSequence output = new VarSequence("Debleached sequence", null);
    EzVarEnum<MethodType> method = new EzVarEnum("Method:", (Enum[])MethodType.values());
    EzVarBoolean graph = new EzVarBoolean("plot Intensity graph", false);

    protected void initialize() {
        this.input = new EzVarSequence("Input");
        super.addEzComponent((EzComponent)this.input);
        super.addEzComponent((EzComponent)this.nb_frames);
        super.addEzComponent(this.method);
        this.getUI().setParametersIOVisible(false);
        this.method.addVarChangeListener((EzVarListener)new EzVarListener<MethodType>(){

            public void variableChanged(EzVar<MethodType> source, MethodType newValue) {
                Debleach.this.updateDefaultParams();
            }
        });
        super.addEzComponent((EzComponent)this.graph);
    }

    private void updateDefaultParams() {
        MethodType _method = (MethodType)((Object)this.method.getValue());
        switch (_method) {
            case FIT: {
                break;
            }
            case FIT2: {
                break;
            }
        }
    }

    protected void execute() {
        if (this.input.getValue() == null) {
            new AnnounceFrame("Please first select a sequence");
            return;
        }
        if (((Sequence)this.input.getValue()).getSizeT() < 2) {
            new AnnounceFrame("Please select a sequence with at least 2 frames");
            return;
        }
        if (this.input.getValue() != null) {
            int nb = 10;
            nb = this.nb_frames.getValue() != null ? ((Integer)this.nb_frames.getValue() < ((Sequence)this.input.getValue()).getSizeT() ? ((Integer)this.nb_frames.getValue()).intValue() : ((Sequence)this.input.getValue()).getSizeT()) : ((Sequence)this.input.getValue()).getSizeT();
            MethodType _method = (MethodType)((Object)this.method.getValue());
            switch (_method) {
                case FIT: {
                    if (nb < 1) {
                        new AnnounceFrame("Please choose a positive number of frames for bleach fitting");
                        return;
                    }
                    this.debleachFromFit((Sequence)this.input.getValue(), nb);
                    break;
                }
                case FIT2: {
                    this.debleachOldSchool((Sequence)this.input.getValue(), nb);
                }
            }
        } else {
            new AnnounceFrame("Please first open a sequence");
            return;
        }
    }

    private void debleachFromFit(Sequence seqIn, int nb) {
        ArrayList<Double> measurementList = new ArrayList<Double>();
        Sequence seqOut = new Sequence();
        measurementList.clear();
        int t = 0;
        while (t < seqIn.getSizeT()) {
            double meanIntensity = this.getMeanIntensity(seqIn, t);
            measurementList.add(meanIntensity);
            ++t;
        }
        double[] bleach = this.BleachConstant(nb, measurementList);
        if (((Boolean)this.graph.getValue()).booleanValue()) {
            this.plotGraph(measurementList, bleach, nb);
        }
        int t2 = 0;
        while (t2 < seqIn.getSizeT()) {
            IcyBufferedImage image = new IcyBufferedImage(seqIn.getWidth(), seqIn.getHeight(), 1, DataType.DOUBLE);
            double[] _out = Array1DUtil.arrayToDoubleArray((Object)image.getDataXY(0), (boolean)image.isSignedDataType());
            IcyBufferedImage imageIn = seqIn.getImage(t2, 0);
            double[] _in = Array1DUtil.arrayToDoubleArray((Object)imageIn.getDataXY(0), (boolean)imageIn.isSignedDataType());
            int x = 0;
            while (x < _in.length) {
                _out[x] = _in[x] * Math.exp(-bleach[1] * (double)t2);
                ++x;
            }
            image.setDataXY(0, Array1DUtil.doubleArrayToArray((double[])_out, (Object)image.getDataXY(0)));
            seqOut.setImage(t2, 0, (BufferedImage)image);
            ++t2;
        }
        seqOut.setName("Debleached sequence");
        this.addSequence(seqOut);
        this.output.setValue((Object)seqOut);
    }

    private void debleachOldSchool(Sequence seqIn, int nb) {
        ArrayList<Double> measurementList = new ArrayList<Double>();
        Sequence seqOut = new Sequence();
        measurementList.clear();
        int t = 0;
        while (t < seqIn.getSizeT()) {
            double meanIntensity = this.getMeanIntensity(seqIn, t);
            measurementList.add(meanIntensity);
            ++t;
        }
        double[] bleach = new double[2];
        if (((Boolean)this.graph.getValue()).booleanValue()) {
            this.plotGraph(measurementList, bleach, nb);
        }
        int t2 = 0;
        while (t2 < seqIn.getSizeT()) {
            IcyBufferedImage image = new IcyBufferedImage(seqIn.getWidth(), seqIn.getHeight(), 1, DataType.USHORT);
            double[] _out = Array1DUtil.arrayToDoubleArray((Object)image.getDataXY(0), (boolean)image.isSignedDataType());
            IcyBufferedImage imageIn = seqIn.getImage(t2, 0);
            double[] _in = Array1DUtil.arrayToDoubleArray((Object)imageIn.getDataXY(0), (boolean)imageIn.isSignedDataType());
            int x = 0;
            while (x < _in.length) {
                _out[x] = _in[x] * measurementList.get(0) / measurementList.get(t2);
                ++x;
            }
            image.setDataXY(0, Array1DUtil.doubleArrayToArray((double[])_out, (Object)image.getDataXY(0)));
            seqOut.setImage(t2, 0, (BufferedImage)image);
            ++t2;
        }
        seqOut.setName("Debleached sequence");
        this.addSequence(seqOut);
        this.output.setValue((Object)seqOut);
    }

    public void clean() {
    }

    private double[] BleachConstant(int m, ArrayList<Double> measurementList) {
        int n = measurementList.size();
        Matrix measures = new Matrix(1, m);
        Matrix x = new Matrix(1, m);
        int j = 0;
        while (j < m) {
            Double i = measurementList.get(n - m + j);
            measures.set(0, j, i.doubleValue());
            x.set(0, j, (double)(n - m + j));
            ++j;
        }
        Matrix H = new Matrix(m, 2);
        Matrix unit = new Matrix(m, 1, 1.0);
        int[] c1 = new int[]{0};
        int[] c2 = new int[]{1};
        H.setMatrix(0, m - 1, c1, unit);
        H.setMatrix(0, m - 1, c2, x.transpose());
        Matrix bb = new Matrix(1, m);
        int j2 = 0;
        while (j2 < m) {
            bb.set(0, j2, Math.log(measures.get(0, j2)));
            ++j2;
        }
        Matrix Y = bb.transpose();
        Matrix teta = H.transpose().times(H);
        teta = teta.inverse();
        teta = teta.times(H.transpose());
        teta = teta.times(Y);
        double a = Math.exp(teta.get(0, 0));
        double b = teta.get(1, 0);
        double[] bleach = new double[]{a, b};
        return bleach;
    }

    private void plotGraph(ArrayList<Double> measurementList, double[] bleach, int m) {
        XYSeriesCollection xyDataset = new XYSeriesCollection();
        final JFreeChart chart = ChartFactory.createXYLineChart((String)"mean intensity per pixel over t", (String)"t", (String)"mean i", (XYDataset)xyDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        XYSeries seriesXY = new XYSeries((Comparable)((Object)"Mean intensity"));
        xyDataset.addSeries(seriesXY);
        XYSeries seriesXYCorrected = new XYSeries((Comparable)((Object)"Corrected intensity"));
        xyDataset.addSeries(seriesXYCorrected);
        int n = measurementList.size();
        double a = bleach[0];
        double b = bleach[1];
        MethodType _method = (MethodType)((Object)this.method.getValue());
        switch (_method) {
            case FIT: {
                XYSeries seriesXYBleachFit = new XYSeries((Comparable)((Object)"bleach fit"));
                xyDataset.addSeries(seriesXYBleachFit);
                int j = 0;
                while (j < m) {
                    seriesXYBleachFit.add((double)(n - m + j), a * Math.exp(b * (double)(n - m + j)));
                    ++j;
                }
                int t = 0;
                while (t < measurementList.size()) {
                    seriesXYCorrected.add((double)t, measurementList.get(t) * Math.exp(-b * (double)t));
                    ++t;
                }
                t = 0;
                while (t < measurementList.size()) {
                    seriesXY.add((double)t, (Number)measurementList.get(t));
                    ++t;
                }
                break;
            }
            case FIT2: {
                int t = 0;
                while (t < measurementList.size()) {
                    seriesXYCorrected.add((double)t, (Number)measurementList.get(0));
                    ++t;
                }
                t = 0;
                while (t < measurementList.size()) {
                    seriesXY.add((double)t, (Number)measurementList.get(t));
                    ++t;
                }
                break;
            }
        }
        ThreadUtil.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                IcyFrame graphFrame = new IcyFrame("graph", true, true, true, true);
                graphFrame.setContentPane((Container)new ChartPanel(chart, 500, 200, 500, 200, 500, 500, false, false, true, true, true, true));
                graphFrame.setVisible(true);
                graphFrame.pack();
                graphFrame.addToMainDesktopPane();
                graphFrame.center();
            }
        });
    }

    double getMeanIntensity(Sequence sequence, int t) {
        double sum = 0.0;
        double nbIteration = 0.0;
        IcyBufferedImage image = sequence.getImage(t, 0);
        Rectangle bounds = sequence.getBounds();
        int y = (int)bounds.getMinY();
        while ((double)y < bounds.getMaxY()) {
            int x = (int)bounds.getMinX();
            while ((double)x < bounds.getMaxX()) {
                if (bounds.contains(x, y)) {
                    sum += image.getData(x, y, 0);
                    nbIteration += 1.0;
                }
                ++x;
            }
            ++y;
        }
        return sum / nbIteration;
    }

    public void declareInput(VarList inputMap) {
        inputMap.add(this.input.getVariable());
        inputMap.add(this.nb_frames.getVariable());
        inputMap.add(this.method.getVariable());
    }

    public void declareOutput(VarList outputMap) {
        outputMap.add((Var)this.output);
    }

    private static enum MethodType {
        FIT("Exponential fit of bleaching"),
        FIT2("Constant mean intensity");

        private final String name;

        private MethodType(String string2) {
            this.name = string2;
        }

        public String toString() {
            return this.name;
        }
    }
}

