/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.Array6D;
import mitiv.array.Byte6D;
import mitiv.array.Double6D;
import mitiv.array.Float6D;
import mitiv.array.Int6D;
import mitiv.array.Long6D;
import mitiv.array.ShapedArray;
import mitiv.array.Short1D;
import mitiv.array.Short5D;
import mitiv.array.ShortArray;
import mitiv.array.impl.FlatShort6D;
import mitiv.array.impl.StriddenShort6D;
import mitiv.base.Shape;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.ShortFunction;
import mitiv.base.mapping.ShortScanner;
import mitiv.exception.IllegalTypeException;
import mitiv.exception.NonConformableArrayException;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.random.ShortGenerator;

public abstract class Short6D
extends Array6D
implements ShortArray {
    protected Short6D(int n, int n2, int n3, int n4, int n5, int n6) {
        super(n, n2, n3, n4, n5, n6);
    }

    protected Short6D(int[] nArray) {
        super(nArray);
    }

    protected Short6D(Shape shape) {
        super(shape);
    }

    @Override
    public final int getType() {
        return 1;
    }

    public abstract short get(int var1, int var2, int var3, int var4, int var5, int var6);

    public abstract void set(int var1, int var2, int var3, int var4, int var5, int var6, short var7);

    @Override
    public void fill(short s) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    this.set(i, j, k, i2, i3, i4, s);
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim6; ++i) {
                for (int j = 0; j < this.dim5; ++j) {
                    for (int k = 0; k < this.dim4; ++k) {
                        for (int i5 = 0; i5 < this.dim3; ++i5) {
                            for (int i6 = 0; i6 < this.dim2; ++i6) {
                                for (int i7 = 0; i7 < this.dim1; ++i7) {
                                    this.set(i7, i6, i5, k, j, i, s);
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void increment(short s) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    this.set(i, j, k, i2, i3, i4, (short)(this.get(i, j, k, i2, i3, i4) + s));
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim6; ++i) {
                for (int j = 0; j < this.dim5; ++j) {
                    for (int k = 0; k < this.dim4; ++k) {
                        for (int i5 = 0; i5 < this.dim3; ++i5) {
                            for (int i6 = 0; i6 < this.dim2; ++i6) {
                                for (int i7 = 0; i7 < this.dim1; ++i7) {
                                    this.set(i7, i6, i5, k, j, i, (short)(this.get(i7, i6, i5, k, j, i) + s));
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void decrement(short s) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    this.set(i, j, k, i2, i3, i4, (short)(this.get(i, j, k, i2, i3, i4) - s));
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim6; ++i) {
                for (int j = 0; j < this.dim5; ++j) {
                    for (int k = 0; k < this.dim4; ++k) {
                        for (int i5 = 0; i5 < this.dim3; ++i5) {
                            for (int i6 = 0; i6 < this.dim2; ++i6) {
                                for (int i7 = 0; i7 < this.dim1; ++i7) {
                                    this.set(i7, i6, i5, k, j, i, (short)(this.get(i7, i6, i5, k, j, i) - s));
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void scale(short s) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    this.set(i, j, k, i2, i3, i4, (short)(this.get(i, j, k, i2, i3, i4) * s));
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim6; ++i) {
                for (int j = 0; j < this.dim5; ++j) {
                    for (int k = 0; k < this.dim4; ++k) {
                        for (int i5 = 0; i5 < this.dim3; ++i5) {
                            for (int i6 = 0; i6 < this.dim2; ++i6) {
                                for (int i7 = 0; i7 < this.dim1; ++i7) {
                                    this.set(i7, i6, i5, k, j, i, (short)(this.get(i7, i6, i5, k, j, i) * s));
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void map(ShortFunction shortFunction) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    this.set(i, j, k, i2, i3, i4, shortFunction.apply(this.get(i, j, k, i2, i3, i4)));
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim6; ++i) {
                for (int j = 0; j < this.dim5; ++j) {
                    for (int k = 0; k < this.dim4; ++k) {
                        for (int i5 = 0; i5 < this.dim3; ++i5) {
                            for (int i6 = 0; i6 < this.dim2; ++i6) {
                                for (int i7 = 0; i7 < this.dim1; ++i7) {
                                    this.set(i7, i6, i5, k, j, i, shortFunction.apply(this.get(i7, i6, i5, k, j, i)));
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void fill(ShortGenerator shortGenerator) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    this.set(i, j, k, i2, i3, i4, shortGenerator.nextShort());
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim6; ++i) {
                for (int j = 0; j < this.dim5; ++j) {
                    for (int k = 0; k < this.dim4; ++k) {
                        for (int i5 = 0; i5 < this.dim3; ++i5) {
                            for (int i6 = 0; i6 < this.dim2; ++i6) {
                                for (int i7 = 0; i7 < this.dim1; ++i7) {
                                    this.set(i7, i6, i5, k, j, i, shortGenerator.nextShort());
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void scan(ShortScanner shortScanner) {
        boolean bl = false;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    if (bl) {
                                        shortScanner.update(this.get(i, j, k, i2, i3, i4));
                                        continue;
                                    }
                                    shortScanner.initialize(this.get(i, j, k, i2, i3, i4));
                                    bl = true;
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim6; ++i) {
                for (int j = 0; j < this.dim5; ++j) {
                    for (int k = 0; k < this.dim4; ++k) {
                        for (int i5 = 0; i5 < this.dim3; ++i5) {
                            for (int i6 = 0; i6 < this.dim2; ++i6) {
                                for (int i7 = 0; i7 < this.dim1; ++i7) {
                                    if (bl) {
                                        shortScanner.update(this.get(i7, i6, i5, k, j, i));
                                        continue;
                                    }
                                    shortScanner.initialize(this.get(i7, i6, i5, k, j, i));
                                    bl = true;
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public final short[] flatten() {
        return this.flatten(false);
    }

    @Override
    public short min() {
        short s = this.get(0, 0, 0, 0, 0, 0);
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    if (bl) {
                                        bl = false;
                                        continue;
                                    }
                                    short s2 = this.get(i, j, k, i2, i3, i4);
                                    if (s2 >= s) continue;
                                    s = s2;
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim6; ++i) {
                for (int j = 0; j < this.dim5; ++j) {
                    for (int k = 0; k < this.dim4; ++k) {
                        for (int i5 = 0; i5 < this.dim3; ++i5) {
                            for (int i6 = 0; i6 < this.dim2; ++i6) {
                                for (int i7 = 0; i7 < this.dim1; ++i7) {
                                    if (bl) {
                                        bl = false;
                                        continue;
                                    }
                                    short s3 = this.get(i7, i6, i5, k, j, i);
                                    if (s3 >= s) continue;
                                    s = s3;
                                }
                            }
                        }
                    }
                }
            }
        }
        return s;
    }

    @Override
    public short max() {
        short s = this.get(0, 0, 0, 0, 0, 0);
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    if (bl) {
                                        bl = false;
                                        continue;
                                    }
                                    short s2 = this.get(i, j, k, i2, i3, i4);
                                    if (s2 <= s) continue;
                                    s = s2;
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim6; ++i) {
                for (int j = 0; j < this.dim5; ++j) {
                    for (int k = 0; k < this.dim4; ++k) {
                        for (int i5 = 0; i5 < this.dim3; ++i5) {
                            for (int i6 = 0; i6 < this.dim2; ++i6) {
                                for (int i7 = 0; i7 < this.dim1; ++i7) {
                                    if (bl) {
                                        bl = false;
                                        continue;
                                    }
                                    short s3 = this.get(i7, i6, i5, k, j, i);
                                    if (s3 <= s) continue;
                                    s = s3;
                                }
                            }
                        }
                    }
                }
            }
        }
        return s;
    }

    @Override
    public short[] getMinAndMax() {
        short[] sArray = new short[2];
        this.getMinAndMax(sArray);
        return sArray;
    }

    @Override
    public void getMinAndMax(short[] sArray) {
        short s;
        short s2 = s = this.get(0, 0, 0, 0, 0, 0);
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    if (bl) {
                                        bl = false;
                                        continue;
                                    }
                                    short s3 = this.get(i, j, k, i2, i3, i4);
                                    if (s3 < s) {
                                        s = s3;
                                    }
                                    if (s3 <= s2) continue;
                                    s2 = s3;
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim6; ++i) {
                for (int j = 0; j < this.dim5; ++j) {
                    for (int k = 0; k < this.dim4; ++k) {
                        for (int i5 = 0; i5 < this.dim3; ++i5) {
                            for (int i6 = 0; i6 < this.dim2; ++i6) {
                                for (int i7 = 0; i7 < this.dim1; ++i7) {
                                    if (bl) {
                                        bl = false;
                                        continue;
                                    }
                                    short s4 = this.get(i7, i6, i5, k, j, i);
                                    if (s4 < s) {
                                        s = s4;
                                    }
                                    if (s4 <= s2) continue;
                                    s2 = s4;
                                }
                            }
                        }
                    }
                }
            }
        }
        sArray[0] = s;
        sArray[1] = s2;
    }

    @Override
    public int sum() {
        int n = 0;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    n += this.get(i, j, k, i2, i3, i4);
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim6; ++i) {
                for (int j = 0; j < this.dim5; ++j) {
                    for (int k = 0; k < this.dim4; ++k) {
                        for (int i5 = 0; i5 < this.dim3; ++i5) {
                            for (int i6 = 0; i6 < this.dim2; ++i6) {
                                for (int i7 = 0; i7 < this.dim1; ++i7) {
                                    n += this.get(i7, i6, i5, k, j, i);
                                }
                            }
                        }
                    }
                }
            }
        }
        return n;
    }

    @Override
    public double average() {
        return (double)this.sum() / (double)this.number;
    }

    @Override
    public Byte6D toByte() {
        byte[] byArray = new byte[this.number];
        if (this.isFlat()) {
            short[] sArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                byArray[i] = (byte)sArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim6; ++i) {
                for (int j = 0; j < this.dim5; ++j) {
                    for (int k = 0; k < this.dim4; ++k) {
                        for (int i2 = 0; i2 < this.dim3; ++i2) {
                            for (int i3 = 0; i3 < this.dim2; ++i3) {
                                for (int i4 = 0; i4 < this.dim1; ++i4) {
                                    byArray[++n] = (byte)this.get(i4, i3, i2, k, j, i);
                                }
                            }
                        }
                    }
                }
            }
        }
        return Byte6D.wrap(byArray, this.getShape());
    }

    @Override
    public Short6D toShort() {
        return this;
    }

    @Override
    public Int6D toInt() {
        int[] nArray = new int[this.number];
        if (this.isFlat()) {
            short[] sArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                nArray[i] = sArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim6; ++i) {
                for (int j = 0; j < this.dim5; ++j) {
                    for (int k = 0; k < this.dim4; ++k) {
                        for (int i2 = 0; i2 < this.dim3; ++i2) {
                            for (int i3 = 0; i3 < this.dim2; ++i3) {
                                for (int i4 = 0; i4 < this.dim1; ++i4) {
                                    nArray[++n] = this.get(i4, i3, i2, k, j, i);
                                }
                            }
                        }
                    }
                }
            }
        }
        return Int6D.wrap(nArray, this.getShape());
    }

    @Override
    public Long6D toLong() {
        long[] lArray = new long[this.number];
        if (this.isFlat()) {
            short[] sArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                lArray[i] = sArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim6; ++i) {
                for (int j = 0; j < this.dim5; ++j) {
                    for (int k = 0; k < this.dim4; ++k) {
                        for (int i2 = 0; i2 < this.dim3; ++i2) {
                            for (int i3 = 0; i3 < this.dim2; ++i3) {
                                for (int i4 = 0; i4 < this.dim1; ++i4) {
                                    lArray[++n] = this.get(i4, i3, i2, k, j, i);
                                }
                            }
                        }
                    }
                }
            }
        }
        return Long6D.wrap(lArray, this.getShape());
    }

    @Override
    public Float6D toFloat() {
        float[] fArray = new float[this.number];
        if (this.isFlat()) {
            short[] sArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                fArray[i] = sArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim6; ++i) {
                for (int j = 0; j < this.dim5; ++j) {
                    for (int k = 0; k < this.dim4; ++k) {
                        for (int i2 = 0; i2 < this.dim3; ++i2) {
                            for (int i3 = 0; i3 < this.dim2; ++i3) {
                                for (int i4 = 0; i4 < this.dim1; ++i4) {
                                    fArray[++n] = this.get(i4, i3, i2, k, j, i);
                                }
                            }
                        }
                    }
                }
            }
        }
        return Float6D.wrap(fArray, this.getShape());
    }

    @Override
    public Double6D toDouble() {
        double[] dArray = new double[this.number];
        if (this.isFlat()) {
            short[] sArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                dArray[i] = sArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim6; ++i) {
                for (int j = 0; j < this.dim5; ++j) {
                    for (int k = 0; k < this.dim4; ++k) {
                        for (int i2 = 0; i2 < this.dim3; ++i2) {
                            for (int i3 = 0; i3 < this.dim2; ++i3) {
                                for (int i4 = 0; i4 < this.dim1; ++i4) {
                                    dArray[++n] = this.get(i4, i3, i2, k, j, i);
                                }
                            }
                        }
                    }
                }
            }
        }
        return Double6D.wrap(dArray, this.getShape());
    }

    @Override
    public Short6D copy() {
        return new FlatShort6D(this.flatten(true), this.shape);
    }

    @Override
    public void assign(ShapedArray shapedArray) {
        if (!this.getShape().equals(shapedArray.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        Short6D short6D = shapedArray.getType() == 1 ? (Short6D)shapedArray : (Short6D)shapedArray.toShort();
        if (this.getOrder() == 2 && short6D.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    this.set(i, j, k, i2, i3, i4, short6D.get(i, j, k, i2, i3, i4));
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim6; ++i) {
                for (int j = 0; j < this.dim5; ++j) {
                    for (int k = 0; k < this.dim4; ++k) {
                        for (int i5 = 0; i5 < this.dim3; ++i5) {
                            for (int i6 = 0; i6 < this.dim2; ++i6) {
                                for (int i7 = 0; i7 < this.dim1; ++i7) {
                                    this.set(i7, i6, i5, k, j, i, short6D.get(i7, i6, i5, k, j, i));
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void assign(ShapedVector shapedVector) {
        if (!this.getShape().equals(shapedVector.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        int n = -1;
        if (shapedVector.getType() == 5) {
            DoubleShapedVector doubleShapedVector = (DoubleShapedVector)shapedVector;
            for (int i = 0; i < this.dim6; ++i) {
                for (int j = 0; j < this.dim5; ++j) {
                    for (int k = 0; k < this.dim4; ++k) {
                        for (int i2 = 0; i2 < this.dim3; ++i2) {
                            for (int i3 = 0; i3 < this.dim2; ++i3) {
                                for (int i4 = 0; i4 < this.dim1; ++i4) {
                                    this.set(i4, i3, i2, k, j, i, (short)doubleShapedVector.get(++n));
                                }
                            }
                        }
                    }
                }
            }
        } else if (shapedVector.getType() == 4) {
            FloatShapedVector floatShapedVector = (FloatShapedVector)shapedVector;
            for (int i = 0; i < this.dim6; ++i) {
                for (int j = 0; j < this.dim5; ++j) {
                    for (int k = 0; k < this.dim4; ++k) {
                        for (int i5 = 0; i5 < this.dim3; ++i5) {
                            for (int i6 = 0; i6 < this.dim2; ++i6) {
                                for (int i7 = 0; i7 < this.dim1; ++i7) {
                                    this.set(i7, i6, i5, k, j, i, (short)floatShapedVector.get(++n));
                                }
                            }
                        }
                    }
                }
            }
        } else {
            throw new IllegalTypeException();
        }
    }

    @Override
    public Short6D create() {
        return new FlatShort6D(this.getShape());
    }

    public static Short6D create(int n, int n2, int n3, int n4, int n5, int n6) {
        return new FlatShort6D(n, n2, n3, n4, n5, n6);
    }

    public static Short6D create(int[] nArray) {
        return new FlatShort6D(nArray);
    }

    public static Short6D create(Shape shape) {
        return new FlatShort6D(shape);
    }

    public static Short6D wrap(short[] sArray, int n, int n2, int n3, int n4, int n5, int n6) {
        return new FlatShort6D(sArray, n, n2, n3, n4, n5, n6);
    }

    public static Short6D wrap(short[] sArray, int[] nArray) {
        return new FlatShort6D(sArray, nArray);
    }

    public static Short6D wrap(short[] sArray, Shape shape) {
        return new FlatShort6D(sArray, shape);
    }

    public static Short6D wrap(short[] sArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13) {
        return new StriddenShort6D(sArray, n, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, n13);
    }

    @Override
    public abstract Short5D slice(int var1);

    @Override
    public abstract Short5D slice(int var1, int var2);

    @Override
    public abstract Short6D view(Range var1, Range var2, Range var3, Range var4, Range var5, Range var6);

    @Override
    public abstract Short6D view(int[] var1, int[] var2, int[] var3, int[] var4, int[] var5, int[] var6);

    @Override
    public abstract Short1D as1D();
}

