/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.Array1D;
import mitiv.array.Byte1D;
import mitiv.array.Double1D;
import mitiv.array.Float1D;
import mitiv.array.Int1D;
import mitiv.array.LongArray;
import mitiv.array.LongScalar;
import mitiv.array.ShapedArray;
import mitiv.array.Short1D;
import mitiv.array.impl.FlatLong1D;
import mitiv.array.impl.StriddenLong1D;
import mitiv.base.Shape;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.LongFunction;
import mitiv.base.mapping.LongScanner;
import mitiv.exception.IllegalTypeException;
import mitiv.exception.NonConformableArrayException;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.random.LongGenerator;

public abstract class Long1D
extends Array1D
implements LongArray {
    protected Long1D(int n) {
        super(n);
    }

    protected Long1D(int[] nArray) {
        super(nArray);
    }

    protected Long1D(Shape shape) {
        super(shape);
    }

    @Override
    public final int getType() {
        return 3;
    }

    public abstract long get(int var1);

    public abstract void set(int var1, long var2);

    @Override
    public void fill(long l) {
        for (int i = 0; i < this.dim1; ++i) {
            this.set(i, l);
        }
    }

    @Override
    public void increment(long l) {
        for (int i = 0; i < this.dim1; ++i) {
            this.set(i, this.get(i) + l);
        }
    }

    @Override
    public void decrement(long l) {
        for (int i = 0; i < this.dim1; ++i) {
            this.set(i, this.get(i) - l);
        }
    }

    @Override
    public void scale(long l) {
        for (int i = 0; i < this.dim1; ++i) {
            this.set(i, this.get(i) * l);
        }
    }

    @Override
    public void map(LongFunction longFunction) {
        for (int i = 0; i < this.dim1; ++i) {
            this.set(i, longFunction.apply(this.get(i)));
        }
    }

    @Override
    public void fill(LongGenerator longGenerator) {
        for (int i = 0; i < this.dim1; ++i) {
            this.set(i, longGenerator.nextLong());
        }
    }

    @Override
    public void scan(LongScanner longScanner) {
        longScanner.initialize(this.get(0));
        for (int i = 1; i < this.dim1; ++i) {
            longScanner.update(this.get(i));
        }
    }

    @Override
    public final long[] flatten() {
        return this.flatten(false);
    }

    @Override
    public long min() {
        long l = this.get(0);
        for (int i = 1; i < this.dim1; ++i) {
            long l2 = this.get(i);
            if (l2 >= l) continue;
            l = l2;
        }
        return l;
    }

    @Override
    public long max() {
        long l = this.get(0);
        for (int i = 1; i < this.dim1; ++i) {
            long l2 = this.get(i);
            if (l2 <= l) continue;
            l = l2;
        }
        return l;
    }

    @Override
    public long[] getMinAndMax() {
        long[] lArray = new long[2];
        this.getMinAndMax(lArray);
        return lArray;
    }

    @Override
    public void getMinAndMax(long[] lArray) {
        long l;
        long l2 = l = this.get(0);
        for (int i = 1; i < this.dim1; ++i) {
            long l3 = this.get(i);
            if (l3 < l) {
                l = l3;
            }
            if (l3 <= l2) continue;
            l2 = l3;
        }
        lArray[0] = l;
        lArray[1] = l2;
    }

    @Override
    public long sum() {
        long l = this.get(0);
        for (int i = 1; i < this.dim1; ++i) {
            l += this.get(i);
        }
        return l;
    }

    @Override
    public double average() {
        return (double)this.sum() / (double)this.number;
    }

    @Override
    public Byte1D toByte() {
        byte[] byArray = new byte[this.number];
        if (this.isFlat()) {
            long[] lArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                byArray[i] = (byte)lArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim1; ++i) {
                byArray[++n] = (byte)this.get(i);
            }
        }
        return Byte1D.wrap(byArray, this.getShape());
    }

    @Override
    public Short1D toShort() {
        short[] sArray = new short[this.number];
        if (this.isFlat()) {
            long[] lArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                sArray[i] = (short)lArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim1; ++i) {
                sArray[++n] = (short)this.get(i);
            }
        }
        return Short1D.wrap(sArray, this.getShape());
    }

    @Override
    public Int1D toInt() {
        int[] nArray = new int[this.number];
        if (this.isFlat()) {
            long[] lArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                nArray[i] = (int)lArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim1; ++i) {
                nArray[++n] = (int)this.get(i);
            }
        }
        return Int1D.wrap(nArray, this.getShape());
    }

    @Override
    public Long1D toLong() {
        return this;
    }

    @Override
    public Float1D toFloat() {
        float[] fArray = new float[this.number];
        if (this.isFlat()) {
            long[] lArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                fArray[i] = lArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim1; ++i) {
                fArray[++n] = this.get(i);
            }
        }
        return Float1D.wrap(fArray, this.getShape());
    }

    @Override
    public Double1D toDouble() {
        double[] dArray = new double[this.number];
        if (this.isFlat()) {
            long[] lArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                dArray[i] = lArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim1; ++i) {
                dArray[++n] = this.get(i);
            }
        }
        return Double1D.wrap(dArray, this.getShape());
    }

    @Override
    public Long1D copy() {
        return new FlatLong1D(this.flatten(true), this.shape);
    }

    @Override
    public void assign(ShapedArray shapedArray) {
        if (!this.getShape().equals(shapedArray.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        Long1D long1D = shapedArray.getType() == 3 ? (Long1D)shapedArray : (Long1D)shapedArray.toLong();
        for (int i = 0; i < this.dim1; ++i) {
            this.set(i, long1D.get(i));
        }
    }

    @Override
    public void assign(ShapedVector shapedVector) {
        if (!this.getShape().equals(shapedVector.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        if (shapedVector.getType() == 5) {
            DoubleShapedVector doubleShapedVector = (DoubleShapedVector)shapedVector;
            for (int i = 0; i < this.dim1; ++i) {
                this.set(i, (long)doubleShapedVector.get(i));
            }
        } else if (shapedVector.getType() == 4) {
            FloatShapedVector floatShapedVector = (FloatShapedVector)shapedVector;
            for (int i = 0; i < this.dim1; ++i) {
                this.set(i, (long)floatShapedVector.get(i));
            }
        } else {
            throw new IllegalTypeException();
        }
    }

    @Override
    public Long1D create() {
        return new FlatLong1D(this.getShape());
    }

    public static Long1D create(int n) {
        return new FlatLong1D(n);
    }

    public static Long1D create(int[] nArray) {
        return new FlatLong1D(nArray);
    }

    public static Long1D create(Shape shape) {
        return new FlatLong1D(shape);
    }

    public static Long1D wrap(long[] lArray, int n) {
        return new FlatLong1D(lArray, n);
    }

    public static Long1D wrap(long[] lArray, int[] nArray) {
        return new FlatLong1D(lArray, nArray);
    }

    public static Long1D wrap(long[] lArray, Shape shape) {
        return new FlatLong1D(lArray, shape);
    }

    public static Long1D wrap(long[] lArray, int n, int n2, int n3) {
        return new StriddenLong1D(lArray, n, n2, n3);
    }

    @Override
    public abstract LongScalar slice(int var1);

    @Override
    public abstract LongScalar slice(int var1, int var2);

    @Override
    public abstract Long1D view(Range var1);

    @Override
    public abstract Long1D view(int[] var1);

    @Override
    public abstract Long1D as1D();
}

