/*
 * Decompiled with CFR 0.152.
 */
package mcib3d.geom;

import mcib3d.geom.Vector3D;
import mcib3d.utils.ArrayUtil;

public class GeomTransform3D {
    double[][] matrix;
    int size = 4;
    boolean identity;

    public GeomTransform3D() {
        double[][] mat = new double[][]{{1.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 1.0}};
        this.matrix = mat;
        this.identity = true;
    }

    public GeomTransform3D(double[][] transfmatrix) {
        this.matrix = transfmatrix;
        this.testIdentity();
    }

    public GeomTransform3D(ArrayUtil transform) {
        double[][] mat = new double[][]{{1.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 1.0}};
        this.matrix = mat;
        this.setTranslation(transform.getValue(0), transform.getValue(1), transform.getValue(2));
        this.setRotationDegrees(transform.getValue(3), transform.getValue(4), transform.getValue(5));
        this.testIdentity();
    }

    public GeomTransform3D(double tx, double ty, double tz, double rx, double ry, double rz) {
        double[][] mat = new double[][]{{1.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 1.0}};
        this.matrix = mat;
        this.setTranslation(tx, ty, tz);
        this.setRotationDegrees(rx, ry, rz);
        this.testIdentity();
    }

    public void reset() {
        double[][] mat = new double[][]{{1.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 1.0}};
        this.matrix = mat;
        this.identity = true;
    }

    public void setTransform(double tx, double ty, double tz, double rx, double ry, double rz) {
        this.setTranslation(tx, ty, tz);
        this.setRotationDegrees(rx, ry, rz);
        this.testIdentity();
    }

    public void setTranslation(double x, double y, double z) {
        double[][] trans = new double[][]{{1.0, 0.0, 0.0, x}, {0.0, 1.0, 0.0, y}, {0.0, 0.0, 1.0, z}, {0.0, 0.0, 0.0, 1.0}};
        this.multBy(trans);
        this.testIdentity();
    }

    public void setScale(double sx, double sy, double sz) {
        double[][] scale = new double[][]{{sx, 0.0, 0.0, 0.0}, {0.0, sy, 0.0, 0.0}, {0.0, 0.0, sz, 0.0}, {0.0, 0.0, 0.0, 1.0}};
        this.multBy(scale);
        this.testIdentity();
    }

    public void setRotationXAxis(double angleRadian) {
        double cos = Math.cos(angleRadian);
        double sin = Math.sin(angleRadian);
        double[][] rot = new double[][]{{1.0, 0.0, 0.0, 0.0}, {0.0, cos, -sin, 0.0}, {0.0, sin, cos, 0.0}, {0.0, 0.0, 0.0, 1.0}};
        this.multBy(rot);
        this.testIdentity();
    }

    public void setRotationYAxis(double angleRadian) {
        double cos = Math.cos(angleRadian);
        double sin = Math.sin(angleRadian);
        double[][] rot = new double[][]{{cos, 0.0, -sin, 0.0}, {0.0, 1.0, 0.0, 0.0}, {sin, 0.0, cos, 0.0}, {0.0, 0.0, 0.0, 1.0}};
        this.multBy(rot);
        this.testIdentity();
    }

    public void setRotationZAxis(double angleRadian) {
        double cos = Math.cos(angleRadian);
        double sin = Math.sin(angleRadian);
        double[][] rot = new double[][]{{cos, -sin, 0.0, 0.0}, {sin, cos, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 1.0}};
        this.multBy(rot);
        this.testIdentity();
    }

    public void setRotation(double angleRadianXAxis, double angleRadianYAxis, double angleRadianZAxis) {
        this.setRotationXAxis(angleRadianXAxis);
        this.setRotationYAxis(angleRadianYAxis);
        this.setRotationZAxis(angleRadianZAxis);
    }

    public void setRotation(Vector3D axis, double angle) {
        axis.normalize();
        double c = Math.cos(angle);
        double s = Math.sin(angle);
        double t = 1.0 - c;
        axis.normalize();
        double x = axis.getX();
        double y = axis.getY();
        double z = axis.getZ();
        double[][] rot = new double[][]{{t * x * x + c, t * x * y - s * z, t * x * z + s * y, 0.0}, {t * x * y + s * z, t * y * y + c, t * y * z - s * x, 0.0}, {t * x * z - s * y, t * y * z + s * x, t * z * z + c, 0.0}, {0.0, 0.0, 0.0, 1.0}};
        this.multBy(rot);
        this.testIdentity();
    }

    public void setRotationDegrees(double angleDegreesXAxis, double angleDegreesYAxis, double angleDegreesZAxis) {
        this.setRotationXAxis(Math.toRadians(angleDegreesXAxis));
        this.setRotationYAxis(Math.toRadians(angleDegreesYAxis));
        this.setRotationZAxis(Math.toRadians(angleDegreesZAxis));
    }

    public void addTransform(GeomTransform3D transfo) {
        this.multBy(transfo.matrix);
    }

    public void addTransform(ArrayUtil transfo) {
        this.multBy(new GeomTransform3D((ArrayUtil)transfo).matrix);
    }

    private void multBy(double[][] other) {
        double[][] result = new double[this.size][this.size];
        for (int j = 0; j < this.size; ++j) {
            for (int i = 0; i < this.size; ++i) {
                for (int k = 0; k < this.size; ++k) {
                    double[] dArray = result[i];
                    int n = j;
                    dArray[n] = dArray[n] + this.matrix[i][k] * other[k][j];
                }
            }
        }
        this.matrix = result;
    }

    public double getValue(int row, int column) {
        return this.matrix[row][column];
    }

    public double[][] getMatrix() {
        return this.matrix;
    }

    public void invert() {
        double[][] inv = new double[4][4];
        GeomTransform3D.invert4x4(inv, this.matrix);
        this.matrix = inv;
    }

    private void testIdentity() {
        double[][] mat = new double[][]{{1.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 1.0}};
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                if (this.matrix[i][j] == mat[i][j]) continue;
                this.identity = false;
                return;
            }
        }
        this.identity = true;
    }

    public boolean isIdentity() {
        return this.identity;
    }

    public Vector3D getVectorTransformed(Vector3D P, Vector3D C) {
        double px = P.getX() - C.getX();
        double py = P.getY() - C.getY();
        double pz = P.getZ() - C.getZ();
        double rx = this.matrix[0][0] * px + this.matrix[0][1] * py + this.matrix[0][2] * pz + this.matrix[0][3];
        double ry = this.matrix[1][0] * px + this.matrix[1][1] * py + this.matrix[1][2] * pz + this.matrix[1][3];
        double rz = this.matrix[2][0] * px + this.matrix[2][1] * py + this.matrix[2][2] * pz + this.matrix[2][3];
        Vector3D res = new Vector3D(rx + C.getX(), ry + C.getY(), rz + C.getZ());
        return res;
    }

    public static void invert4x4(double[][] mi, double[][] m) {
        double[] t = new double[20];
        double[] x = new double[4];
        t[0] = m[0][0];
        t[1] = m[0][1];
        t[2] = m[0][2];
        t[3] = m[0][3];
        t[4] = 1.0;
        t[5] = m[1][0];
        t[6] = m[1][1];
        t[7] = m[1][2];
        t[8] = m[1][3];
        t[9] = 0.0;
        t[10] = m[2][0];
        t[11] = m[2][1];
        t[12] = m[2][2];
        t[13] = m[2][3];
        t[14] = 0.0;
        t[15] = m[3][0];
        t[16] = m[3][1];
        t[17] = m[3][2];
        t[18] = m[3][3];
        t[19] = 0.0;
        if (GeomTransform3D.GaussElim(t, x) <= 0) {
            return;
        }
        mi[0][0] = x[0];
        mi[1][0] = x[1];
        mi[2][0] = x[2];
        mi[3][0] = x[3];
        t[0] = m[0][0];
        t[1] = m[0][1];
        t[2] = m[0][2];
        t[3] = m[0][3];
        t[4] = 0.0;
        t[5] = m[1][0];
        t[6] = m[1][1];
        t[7] = m[1][2];
        t[8] = m[1][3];
        t[9] = 1.0;
        t[10] = m[2][0];
        t[11] = m[2][1];
        t[12] = m[2][2];
        t[13] = m[2][3];
        t[14] = 0.0;
        t[15] = m[3][0];
        t[16] = m[3][1];
        t[17] = m[3][2];
        t[18] = m[3][3];
        t[19] = 0.0;
        if (GeomTransform3D.GaussElim(t, x) <= 0) {
            return;
        }
        mi[0][1] = x[0];
        mi[1][1] = x[1];
        mi[2][1] = x[2];
        mi[3][1] = x[3];
        t[0] = m[0][0];
        t[1] = m[0][1];
        t[2] = m[0][2];
        t[3] = m[0][3];
        t[4] = 0.0;
        t[5] = m[1][0];
        t[6] = m[1][1];
        t[7] = m[1][2];
        t[8] = m[1][3];
        t[9] = 0.0;
        t[10] = m[2][0];
        t[11] = m[2][1];
        t[12] = m[2][2];
        t[13] = m[2][3];
        t[14] = 1.0;
        t[15] = m[3][0];
        t[16] = m[3][1];
        t[17] = m[3][2];
        t[18] = m[3][3];
        t[19] = 0.0;
        if (GeomTransform3D.GaussElim(t, x) <= 0) {
            return;
        }
        mi[0][2] = x[0];
        mi[1][2] = x[1];
        mi[2][2] = x[2];
        mi[3][2] = x[3];
        t[0] = m[0][0];
        t[1] = m[0][1];
        t[2] = m[0][2];
        t[3] = m[0][3];
        t[4] = 0.0;
        t[5] = m[1][0];
        t[6] = m[1][1];
        t[7] = m[1][2];
        t[8] = m[1][3];
        t[9] = 0.0;
        t[10] = m[2][0];
        t[11] = m[2][1];
        t[12] = m[2][2];
        t[13] = m[2][3];
        t[14] = 0.0;
        t[15] = m[3][0];
        t[16] = m[3][1];
        t[17] = m[3][2];
        t[18] = m[3][3];
        t[19] = 1.0;
        if (GeomTransform3D.GaussElim(t, x) <= 0) {
            return;
        }
        mi[0][3] = x[0];
        mi[1][3] = x[1];
        mi[2][3] = x[2];
        mi[3][3] = x[3];
    }

    private static int GaussElim(double[] a, double[] x) {
        int i;
        int n = x.length;
        for (int i2 = 0; i2 < n; ++i2) {
            x[i2] = 0.0;
        }
        int w = n + 1;
        for (i = 0; i < n - 1; ++i) {
            int p;
            for (p = i; p < n && a[p * w + i] == 0.0; ++p) {
            }
            if (p == n) {
                return 0;
            }
            if (p != i) {
                for (int k = 0; k < w; ++k) {
                    double temp = a[i * w + k];
                    a[i * w + k] = a[p * w + k];
                    a[p * w + k] = temp;
                }
            }
            for (int j = i + 1; j < n; ++j) {
                double m = a[j * w + i] / a[i * w + i];
                for (int k = 0; k <= n; ++k) {
                    a[j * w + k] = a[j * w + k] - m * a[i * w + k];
                }
            }
        }
        if (a[(n - 1) * w + (n - 1)] == 0.0) {
            return 0;
        }
        x[n - 1] = a[(n - 1) * w + n] / a[(n - 1) * w + (n - 1)];
        for (i = n - 2; i >= 0; --i) {
            double s = 0.0;
            for (int j = i + 1; j < n; ++j) {
                s += a[i * w + j] * x[j];
            }
            x[i] = (a[i * w + n] - s) / a[i * w + i];
        }
        return 1;
    }
}

