/*
 * Decompiled with CFR 0.152.
 */
package mcib3d.geom;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.process.ByteProcessor;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import mcib3d.geom.MereoObject3D;
import mcib3d.geom.Object3DLabel;
import mcib3d.geom.Object3DVoxels;
import mcib3d.geom.ObjectCreator3D;
import mcib3d.geom.Point3D;
import mcib3d.geom.Vector3D;
import mcib3d.geom.Voxel3D;
import mcib3d.image3d.ImageByte;
import mcib3d.image3d.ImageFloat;
import mcib3d.image3d.ImageHandler;
import mcib3d.image3d.ImageInt;
import mcib3d.image3d.ImageShort;
import mcib3d.image3d.distanceMap3d.EDT;
import mcib3d.image3d.processing.BinaryMorpho;
import mcib3d.image3d.processing.FastFilters3D;
import mcib3d.utils.ArrayUtil;
import mcib3d.utils.KDTreeC;
import mcib3d.utils.Logger.AbstractLog;

public abstract class Object3D
implements Comparable<Object3D> {
    public static final byte MEASURE_NONE = 0;
    public static final byte MEASURE_VOLUME_PIX = 1;
    public static final byte MEASURE_VOLUME_UNIT = 2;
    public static final byte MEASURE_MAIN_ELONGATION = 3;
    public static final byte MEASURE_COMPACTNESS_VOXELS = 4;
    public static final byte MEASURE_COMPACTNESS_UNITS = 12;
    public static final byte MEASURE_SPHERICITY = 5;
    public static final byte MEASURE_AREA_PIX = 6;
    public static final byte MEASURE_AREA_UNIT = 7;
    public static final byte MEASURE_DC_AVG = 8;
    public static final byte MEASURE_DC_SD = 9;
    public static final byte MEASURE_INTENSITY_AVG = 10;
    public static final byte MEASURE_INTENSITY_SD = 11;
    public static final byte MEASURE_INTENSITY_MIN = 12;
    public static final byte MEASURE_INTENSITY_MAX = 13;
    public static final byte MEASURE_INTENSITY_MEDIAN = 14;
    public double s200 = Double.NaN;
    public boolean verbose = false;
    public boolean multiThread = false;
    public double compare = 0.0;
    protected String name = "";
    protected int type = 0;
    protected String comment = "";
    protected int xmin;
    protected int ymin;
    protected int zmin;
    protected int xmax;
    protected int ymax;
    protected int zmax;
    protected double bx = Double.NaN;
    protected double by = Double.NaN;
    protected double bz = Double.NaN;
    protected double cx = Double.NaN;
    protected double cy = Double.NaN;
    protected double cz = Double.NaN;
    protected double areaNbVoxels = -1.0;
    protected double areaContactUnit = -1.0;
    protected double areaContactVoxels = -1.0;
    protected int volume = -1;
    protected double feret = Double.NaN;
    protected Voxel3D feret1 = null;
    protected Voxel3D feret2 = null;
    protected double integratedDensity = Double.NaN;
    protected double meanDensity = Double.NaN;
    protected double sigma = Double.NaN;
    protected double pixmin = Double.NaN;
    protected double pixmax = Double.NaN;
    protected int value = 0;
    protected ArrayList<Voxel3D> contours = null;
    protected KDTreeC kdtreeContours = null;
    protected double s110;
    protected double s101;
    protected double s020;
    protected double s011;
    protected double s002;
    protected double s300 = Double.NaN;
    protected double s210;
    protected double s201;
    protected double s030;
    protected double s120;
    protected double s021;
    protected double s003;
    protected double s102;
    protected double s012;
    protected double s111;
    protected double s400 = Double.NaN;
    protected double s040;
    protected double s004;
    protected double s220;
    protected double s202;
    protected double s022;
    protected double s121;
    protected double s112;
    protected double s211;
    protected double s103;
    protected double s301;
    protected double s130;
    protected double s310;
    protected double s013;
    protected double s031;
    protected EigenvalueDecomposition eigen = null;
    protected ImageInt miniLabelImage = null;
    protected ImageInt labelImage = null;
    protected ImageHandler currentQuantifImage = null;
    protected double resXY = 1.0;
    protected double resZ = 1.0;
    protected String units = "pixels";
    AbstractLog logger;
    boolean logging = true;
    double distcentermin = Double.NaN;
    double distcentermax = Double.NaN;
    double distcentermean = Double.NaN;
    double distcentersigma = Double.NaN;

    public static int getNbMoments3D() {
        return 5;
    }

    public static double pcColocSum(Object3D A, Object3D B) {
        double vA = A.getVolumePixels();
        double vB = B.getVolumePixels();
        double vC = A.getColoc(B);
        return 100.0 * vC / (vA + vB);
    }

    public double getResXY() {
        return this.resXY;
    }

    public void setResXY(double rxy) {
        this.resXY = rxy;
    }

    public double getResZ() {
        return this.resZ;
    }

    public void setResZ(double rz) {
        this.resZ = rz;
    }

    public String getUnits() {
        return this.units;
    }

    public void setUnits(String u) {
        this.units = u;
    }

    public Calibration getCalibration() {
        Calibration cal = new Calibration();
        cal.pixelWidth = this.resXY;
        cal.pixelHeight = this.resXY;
        cal.pixelDepth = this.resZ;
        cal.setUnit(this.units);
        return cal;
    }

    public void setCalibration(Calibration cal) {
        this.resXY = cal.pixelWidth;
        this.resZ = cal.pixelDepth;
        this.units = cal.getUnits();
    }

    public final void setCalibration(double rxy, double rz, String u) {
        this.resXY = rxy;
        this.resZ = rz;
        this.units = u;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public ImageInt getLabelImage() {
        if (this.labelImage == null) {
            this.labelImage = this.createSegImage();
        }
        return this.labelImage;
    }

    public void setLabelImage(ImageInt labelImage) {
        this.labelImage = labelImage;
    }

    public ImageInt getMaxLabelImage(int val) {
        return this.createMaxSegImage(val);
    }

    public int getVolumePixels() {
        if (this.volume == -1) {
            this.computeVolume();
        }
        return this.volume;
    }

    public double getMeasure(int Measure) {
        if (Measure == 1) {
            return this.getVolumePixels();
        }
        if (Measure == 2) {
            return this.getVolumeUnit();
        }
        if (Measure == 6) {
            return this.getAreaPixels();
        }
        if (Measure == 7) {
            return this.getAreaUnit();
        }
        if (Measure == 3) {
            return this.getMainElongation();
        }
        if (Measure == 4) {
            return this.getCompactness(false);
        }
        if (Measure == 12) {
            return this.getCompactness(true);
        }
        if (Measure == 8) {
            return this.getDistCenterMean();
        }
        if (Measure == 9) {
            return this.getDistCenterSigma();
        }
        if (Measure == 10) {
            if (this.currentQuantifImage != null) {
                return this.getPixMeanValue(this.currentQuantifImage);
            }
            return 0.0;
        }
        if (Measure == 11) {
            if (this.currentQuantifImage != null) {
                return this.getPixStdDevValue(this.currentQuantifImage);
            }
            return 0.0;
        }
        if (Measure == 13) {
            if (this.currentQuantifImage != null) {
                return this.getPixMaxValue(this.currentQuantifImage);
            }
            return 0.0;
        }
        if (Measure == 14) {
            if (this.currentQuantifImage != null) {
                return this.getPixMedianValue(this.currentQuantifImage);
            }
            return 0.0;
        }
        if (Measure == 12) {
            if (this.currentQuantifImage != null) {
                return this.getPixMinValue(this.currentQuantifImage);
            }
            return 0.0;
        }
        return Double.NaN;
    }

    private void computeVolume() {
        this.volume = this.getVoxels().size();
    }

    public double getVolumeUnit() {
        return (double)this.getVolumePixels() * this.resXY * this.resXY * this.resZ;
    }

    protected abstract void computeCenter();

    protected abstract void computeMassCenter(ImageHandler var1);

    protected abstract void computeMassCenter(ImageHandler var1, ImageHandler var2);

    public float[] getArrayValues(ImageHandler ima) {
        ArrayList<Voxel3D> vox = this.getVoxels();
        float[] res = new float[vox.size()];
        int i = 0;
        for (Voxel3D v : vox) {
            int z;
            int y;
            int x = v.getRoundX();
            if (!ima.contains(x, y = v.getRoundY(), z = v.getRoundZ())) continue;
            res[i++] = ima.getPixel(x, y, z);
        }
        return res;
    }

    public double getQuantilePixValue(ImageHandler ima, double quantile) {
        if (quantile == 1.0) {
            return this.getPixMaxValue(ima);
        }
        if (quantile == 0.0) {
            return this.getPixMinValue(ima);
        }
        float[] vals = this.getArrayValues(ima);
        if (vals.length == 0) {
            return Double.NaN;
        }
        Arrays.sort(vals);
        double index = quantile * (double)(vals.length - 1);
        if (index <= 0.0) {
            return vals[0];
        }
        if (index >= (double)(vals.length - 1)) {
            return vals[vals.length - 1];
        }
        double d = index - (double)((int)index);
        if (d == 0.0) {
            return vals[(int)index];
        }
        double val1 = vals[(int)index];
        double val2 = vals[(int)(index + 1.0)];
        return d * val2 + (1.0 - d) * val1;
    }

    protected abstract void computeBounding();

    public abstract void computeContours();

    protected abstract void computeMoments2(boolean var1);

    protected abstract void computeMoments3();

    protected abstract void computeMoments4();

    public double[] getMomentsRaw2() {
        if (Double.isNaN(this.s200)) {
            this.computeMoments2(false);
        }
        return new double[]{this.s200, this.s020, this.s002, this.s110, this.s101, this.s011};
    }

    public double[] getMomentsRaw3() {
        if (Double.isNaN(this.s300)) {
            this.computeMoments3();
        }
        return new double[]{this.s300, this.s030, this.s003, this.s210, this.s201, this.s120, this.s021, this.s102, this.s012, this.s111};
    }

    public double[] getMomentsRaw4() {
        if (Double.isNaN(this.s400)) {
            this.computeMoments4();
        }
        return new double[]{this.s400, this.s040, this.s004, this.s220, this.s202, this.s022, this.s121, this.s112, this.s211, this.s103, this.s301, this.s130, this.s310, this.s013, this.s031};
    }

    public double[] getGeometricInvariants() {
        if (Double.isNaN(this.s200)) {
            this.computeMoments2(false);
        }
        if (Double.isNaN(this.s300)) {
            this.computeMoments3();
        }
        if (Double.isNaN(this.s400)) {
            this.computeMoments4();
        }
        double[] inv = new double[6];
        double v = this.getVolumeUnit();
        inv[0] = (this.s400 + this.s040 + this.s004 + 2.0 * this.s220 + 2.0 * this.s202 + 2.0 * this.s022) / Math.pow(v, 2.3333333333333335);
        inv[1] = (this.s400 * this.s040 + this.s400 * this.s004 + this.s004 * this.s040 + 3.0 * this.s220 * this.s220 + 3.0 * this.s202 * this.s202 + 3.0 * this.s022 * this.s022 - 4.0 * this.s103 * this.s301 - 4.0 * this.s130 * this.s310 - 4.0 * this.s013 * this.s031 + 2.0 * this.s022 * this.s202 + 2.0 * this.s022 * this.s220 + 2.0 * this.s220 * this.s202 + 2.0 * this.s022 * this.s400 + 2.0 * this.s004 * this.s220 + 2.0 * this.s040 * this.s202 - 4.0 * this.s103 * this.s121 - 4.0 * this.s130 * this.s112 - 4.0 * this.s013 * this.s211 - 4.0 * this.s121 * this.s301 - 4.0 * this.s112 * this.s310 - 4.0 * this.s211 * this.s031 + 4.0 * this.s211 * this.s211 + 4.0 * this.s112 * this.s112 + 4.0 * this.s121 * this.s121) / Math.pow(v, 4.666666666666667);
        inv[2] = (this.s400 * this.s400 + this.s040 * this.s040 + this.s004 * this.s004 + 4.0 * this.s130 * this.s130 + 4.0 * this.s103 * this.s103 + 4.0 * this.s013 * this.s013 + 4.0 * this.s031 * this.s031 + 4.0 * this.s310 * this.s310 + 4.0 * this.s301 * this.s301 + 6.0 * this.s220 * this.s220 + 6.0 * this.s202 * this.s202 + 6.0 * this.s022 * this.s022 + 12.0 * this.s112 * this.s112 + 12.0 * this.s121 * this.s121 + 12.0 * this.s211 * this.s211) / Math.pow(v, 4.666666666666667);
        inv[3] = (this.s300 * this.s300 + this.s030 * this.s030 + this.s003 * this.s003 + 3.0 * (this.s210 * this.s210 + this.s201 * this.s201 + this.s120 * this.s120 + this.s021 * this.s021 + this.s102 * this.s102 + this.s012 * this.s012) + 6.0 * this.s111) / Math.pow(v, 4.0);
        inv[4] = (this.s300 * this.s300 + this.s030 * this.s030 + this.s003 * this.s003 + this.s210 * this.s210 + this.s201 * this.s201 + this.s120 * this.s120 + this.s021 * this.s021 + this.s102 * this.s102 + this.s012 * this.s012 + 2.0 * (this.s300 * this.s120 + this.s300 * this.s102 + this.s030 * this.s210 + this.s030 * this.s012 + this.s003 * this.s201 + this.s003 * this.s021 + this.s120 * this.s102 + this.s021 * this.s201 + this.s012 * this.s210)) / Math.pow(v, 4.0);
        inv[5] = (this.s200 * (this.s400 + this.s220 + this.s202) + this.s020 * (this.s220 + this.s040 + this.s022) + this.s002 * (this.s202 + this.s022 + this.s004) + 2.0 * this.s110 * (this.s310 + this.s130 + this.s112) + 2.0 * this.s101 * (this.s301 * this.s121 + this.s103) + 2.0 * this.s011 * (this.s211 + this.s031 + this.s013)) / Math.pow(v, 4.0);
        return inv;
    }

    public double[] getHomogeneousInvariants() {
        if (Double.isNaN(this.s200)) {
            this.computeMoments2(false);
        }
        if (Double.isNaN(this.s300)) {
            this.computeMoments3();
        }
        if (Double.isNaN(this.s400)) {
            this.computeMoments4();
        }
        double[] inv = new double[5];
        double v = this.getVolumeUnit();
        inv[0] = (this.s200 + this.s020 + this.s002) / (v * v);
        inv[1] = (this.s200 * this.s200 + this.s020 * this.s020 + this.s002 * this.s002 + 2.0 * this.s101 * this.s101 + 2.0 * this.s110 * this.s110 + 2.0 * this.s011 * this.s011) / (v * v * v * v);
        inv[2] = (this.s200 * this.s200 * this.s200 + 3.0 * this.s200 * this.s110 * this.s110 + 3.0 * this.s200 * this.s101 * this.s101 + 3.0 * this.s110 * this.s110 * this.s020 + 3.0 * this.s101 * this.s101 * this.s020 + this.s020 * this.s020 * this.s020 + 3.0 * this.s020 * this.s011 * this.s011 + 3.0 * this.s011 * this.s011 * this.s002 + this.s002 * this.s002 * this.s002 + 6.0 * this.s110 * this.s101 * this.s011) / Math.pow(v, 6.0);
        inv[3] = (this.s300 * this.s300 + this.s030 * this.s030 + this.s003 * this.s003 + 3.0 * this.s210 * this.s201 + 3.0 * this.s201 * this.s201 + 3.0 * this.s120 * this.s120 + 3.0 * this.s102 * this.s102 + 3.0 * this.s021 * this.s021 + 3.0 * this.s012 * this.s012 + 6.0 * this.s111 * this.s111) / Math.pow(v, 5.0);
        inv[4] = (this.s300 * this.s300 + 2.0 * this.s300 * this.s120 + 2.0 * this.s300 * this.s102 + 2.0 * this.s210 * this.s030 + 2.0 * this.s201 * this.s003 + this.s030 * this.s030 + 2.0 * this.s030 * this.s012 + 2.0 * this.s021 * this.s003 + this.s003 * this.s003 + this.s210 * this.s210 + 2.0 * this.s210 * this.s012 + this.s201 * this.s201 + 2.0 * this.s201 * this.s021 + this.s120 * this.s120 + 2.0 * this.s120 + this.s102 + this.s102 * this.s102 + this.s021 * this.s021 + this.s012 + this.s012) / Math.pow(v, 5.0);
        return inv;
    }

    public double[] getMoments3D() {
        this.computeMoments2(false);
        double v = this.getVolumeUnit();
        double v53 = Math.pow(v, 1.0);
        this.s200 /= v53;
        this.s020 /= v53;
        this.s002 /= v53;
        this.s011 /= v53;
        this.s101 /= v53;
        this.s110 /= v53;
        double J1 = this.s200 + this.s020 + this.s002;
        double J2 = this.s020 * this.s002 - this.s011 * this.s011 + this.s200 * this.s002 - this.s101 * this.s101 + this.s200 * this.s020 - this.s110 * this.s110;
        double J3 = this.s200 * this.s020 * this.s002 + 2.0 * this.s110 * this.s101 * this.s011 - this.s002 * this.s110 * this.s110 - this.s020 * this.s101 * this.s101 - this.s200 * this.s011 * this.s011;
        double I1 = J1 * J1 / J2;
        double I2 = J3 / (J1 * J1 * J1);
        return new double[]{J1, J2, J3, I1, I2};
    }

    public abstract Voxel3D getPixelMax(ImageHandler var1);

    public ArrayList<Voxel3D> listVoxels(ImageHandler ima) {
        return this.listVoxels(ima, Double.NEGATIVE_INFINITY);
    }

    public abstract ArrayUtil listValues(ImageHandler var1);

    public abstract ArrayUtil listValues(ImageHandler var1, float var2);

    public abstract ArrayList<Voxel3D> listVoxels(ImageHandler var1, double var2);

    public abstract ArrayList<Voxel3D> listVoxels(ImageHandler var1, double var2, double var4);

    public ArrayList<Voxel3D> listVoxelsByDistance(Point3D P0, double dist0, double dist1, boolean contourOnly) {
        ArrayList<Voxel3D> list;
        ArrayList<Voxel3D> res = new ArrayList<Voxel3D>();
        if (contourOnly) {
            if (this.contours == null) {
                this.computeContours();
            }
            list = this.contours;
        } else {
            list = this.getVoxels();
        }
        for (Voxel3D Vox : list) {
            double dist = Vox.distance(P0, this.resXY, this.resZ);
            if (!(dist > dist0) || !(dist < dist1)) continue;
            Voxel3D V = new Voxel3D(Vox);
            V.setValue(dist);
            res.add(V);
        }
        return res;
    }

    public Object3DVoxels getObject3DVoxels() {
        if (this instanceof Object3DVoxels) {
            return (Object3DVoxels)this;
        }
        if (this instanceof Object3DLabel) {
            return ((Object3DLabel)this).buildObject3DVoxels();
        }
        return null;
    }

    public double pcColoc(Object3D obj) {
        if (this.disjointBox(obj)) {
            return 0.0;
        }
        int cpt = this.getColoc(obj);
        if (cpt == 0) {
            return 0.0;
        }
        return 100.0 * (double)cpt / (double)this.getVolumePixels();
    }

    public abstract void draw(ObjectCreator3D var1, int var2);

    public abstract boolean draw(ByteProcessor var1, int var2, int var3);

    public abstract void draw(ImageStack var1, int var2);

    public abstract void draw(ImageHandler var1, int var2);

    public void drawAt(ImageHandler mask, int col, Point3D center) {
        double cx = this.getCenterX();
        double cy = this.getCenterY();
        double cz = this.getCenterZ();
        this.translate(center.getX() - cx, center.getY() - cy, center.getZ() - cz);
        this.draw(mask, col);
        this.translate(-center.getX() + cx, -center.getY() + cy, -center.getZ() + cz);
    }

    public abstract void draw(ImageHandler var1, int var2, int var3, int var4, int var5);

    public void draw(ImageHandler mask) {
        this.draw(mask, this.getValue());
    }

    public void drawLink(ImageHandler mask, Object3D other, int col) {
        ObjectCreator3D create = new ObjectCreator3D(mask);
        create.createLine(this.getCenterAsPoint(), other.getCenterAsPoint(), (float)col, 1);
    }

    public abstract void draw(ImageStack var1, int var2, int var3, int var4);

    public abstract Roi createRoi(int var1);

    public PolygonRoi getConvexPolygonRoi(int z) {
        ArrayList<Voxel3D> contours3D = this.getContours();
        int[] x = new int[contours3D.size()];
        int[] y = new int[contours3D.size()];
        int nbPoint = -1;
        for (Voxel3D contour : contours3D) {
            if (!(Math.abs((double)z - contour.z) < 0.5)) continue;
            x[++nbPoint] = contour.getRoundX();
            y[nbPoint] = contour.getRoundY();
        }
        int[] xx = new int[nbPoint + 1];
        int[] yy = new int[nbPoint + 1];
        System.arraycopy(x, 0, xx, 0, nbPoint + 1);
        System.arraycopy(y, 0, yy, 0, nbPoint + 1);
        PolygonRoi pRoi = new PolygonRoi(xx, yy, nbPoint, 2);
        return new PolygonRoi(pRoi.getConvexHull(), 2);
    }

    public void init() {
        this.cx = Double.NaN;
        this.cy = Double.NaN;
        this.cz = Double.NaN;
        this.bx = Double.NaN;
        this.by = Double.NaN;
        this.bz = Double.NaN;
        this.s200 = Double.NaN;
        this.s110 = Double.NaN;
        this.s101 = Double.NaN;
        this.s020 = Double.NaN;
        this.s011 = Double.NaN;
        this.s002 = Double.NaN;
        this.eigen = null;
        this.distcentermin = Double.NaN;
        this.distcentermax = Double.NaN;
        this.distcentermean = Double.NaN;
        this.distcentersigma = Double.NaN;
        this.feret = Double.NaN;
        this.feret1 = null;
        this.feret2 = null;
        this.integratedDensity = Double.NaN;
        this.pixmax = Double.NaN;
        this.pixmin = Double.NaN;
        this.sigma = Double.NaN;
        this.volume = -1;
        this.areaNbVoxels = -1.0;
        this.areaContactUnit = -1.0;
        this.miniLabelImage = null;
        this.computeBounding();
        this.computeCenter();
    }

    public ArrayList<Voxel3D> getContours() {
        if (this.contours == null) {
            this.computeContours();
        }
        return this.contours;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int v) {
        this.value = v;
    }

    public int getXmin() {
        return this.xmin;
    }

    public int getYmin() {
        return this.ymin;
    }

    public int getZmin() {
        return this.zmin;
    }

    public int getXmax() {
        return this.xmax;
    }

    public int getYmax() {
        return this.ymax;
    }

    public int getZmax() {
        return this.zmax;
    }

    public int[] getBoundingBox() {
        return new int[]{this.xmin, this.xmax, this.ymin, this.ymax, this.zmin, this.zmax};
    }

    public double getCenterX() {
        Vector3D ce = this.getCenterAsVector();
        return ce.getX();
    }

    public double getCenterY() {
        Vector3D ce = this.getCenterAsVector();
        return ce.getY();
    }

    public double getCenterZ() {
        Vector3D ce = this.getCenterAsVector();
        return ce.getZ();
    }

    public boolean isEmpty() {
        return this.getVolumePixels() == 0;
    }

    public double getIntegratedDensity(ImageHandler ima) {
        if (this.currentQuantifImage == null || this.currentQuantifImage != ima) {
            this.computeMassCenter(ima);
            this.currentQuantifImage = ima;
        }
        return this.integratedDensity;
    }

    public double getIntegratedDensity(ImageHandler ima, ImageHandler mask) {
        this.computeMassCenter(ima, mask);
        this.currentQuantifImage = null;
        return this.integratedDensity;
    }

    public double getMassCenterX(ImageHandler ima) {
        if (this.currentQuantifImage == null || this.currentQuantifImage != ima) {
            this.computeMassCenter(ima);
            this.currentQuantifImage = ima;
        }
        return this.cx;
    }

    public void setNewCenter(double x, double y, double z) {
        this.translate(x - this.getCenterX(), y - this.getCenterY(), z - this.getCenterZ());
    }

    public void setNewCenter(Object3D obj) {
        this.translate(obj.getCenterX() - this.getCenterX(), obj.getCenterY() - this.getCenterY(), obj.getCenterZ() - this.getCenterZ());
    }

    public abstract void translate(double var1, double var3, double var5);

    public void translate(Vector3D V) {
        this.translate(V.getX(), V.getY(), V.getZ());
    }

    public double getMassCenterY(ImageHandler ima) {
        if (this.currentQuantifImage == null || this.currentQuantifImage != ima) {
            this.computeMassCenter(ima);
            this.currentQuantifImage = ima;
        }
        return this.cy;
    }

    public double getMassCenterZ(ImageHandler ima) {
        if (this.currentQuantifImage == null || this.currentQuantifImage != ima) {
            this.computeMassCenter(ima);
            this.currentQuantifImage = ima;
        }
        return this.cz;
    }

    public Vector3D getCenterAsVector() {
        if (Double.isNaN(this.bx)) {
            this.computeCenter();
        }
        return new Vector3D(this.bx, this.by, this.bz);
    }

    public Vector3D getCenterAsVectorUnit() {
        if (Double.isNaN(this.bx)) {
            this.computeCenter();
        }
        return new Vector3D(this.bx * this.resXY, this.by * this.resXY, this.bz * this.resZ);
    }

    public Point3D getCenterAsPoint() {
        if (Double.isNaN(this.bx)) {
            this.computeCenter();
        }
        return new Point3D(this.bx, this.by, this.bz);
    }

    public double[] getCenterAsArray() {
        if (Double.isNaN(this.bx)) {
            this.computeCenter();
        }
        return this.getCenterAsPoint().getArray();
    }

    public double getAreaPixels() {
        if (this.areaNbVoxels == -1.0) {
            this.computeContours();
        }
        return this.areaContactVoxels;
    }

    public double getAreaUnit() {
        if (this.areaContactUnit == -1.0) {
            this.computeContours();
        }
        return this.areaContactUnit;
    }

    public double getCompactness(boolean useUnit) {
        if (useUnit) {
            double s3 = Math.pow(this.getAreaUnit(), 3.0);
            double v2 = Math.pow(this.getVolumeUnit(), 2.0);
            return v2 * 36.0 * Math.PI / s3;
        }
        double s3 = Math.pow(this.getAreaPixels(), 3.0);
        double v2 = Math.pow(this.getVolumePixels(), 2.0);
        return v2 * 36.0 * Math.PI / s3;
    }

    public double getCompactness() {
        return this.getCompactness(false);
    }

    public double getSphericity() {
        return this.getSphericity(false);
    }

    public double getSphericity(boolean useUnit) {
        return Math.pow(this.getCompactness(useUnit), 0.333333);
    }

    public double getRatioBox() {
        double vol = this.getVolumePixels();
        double volbox = this.getVolumeBoundingBoxPixel();
        return vol / volbox;
    }

    public double getRatioEllipsoid() {
        double vol = this.getVolumeUnit();
        double volell = this.getVolumeEllipseUnit();
        return vol / volell;
    }

    public double getVolumeBoundingBoxPixel() {
        return (this.zmax - this.zmin + 1) * (this.xmax - this.xmin + 1) * (this.ymax - this.ymin + 1);
    }

    public double getVolumeBoundingBoxOrientedPixel() {
        ArrayList<Voxel3D> oriContours = this.getBoundingOriented();
        double minx = Double.POSITIVE_INFINITY;
        double maxx = Double.NEGATIVE_INFINITY;
        double miny = Double.POSITIVE_INFINITY;
        double maxy = Double.NEGATIVE_INFINITY;
        double minz = Double.POSITIVE_INFINITY;
        double maxz = Double.NEGATIVE_INFINITY;
        for (Voxel3D vox : oriContours) {
            double x = vox.getX();
            double y = vox.getY();
            double z = vox.getZ();
            if (x > maxx) {
                maxx = x;
            }
            if (x < minx) {
                minx = x;
            }
            if (y > maxy) {
                maxy = y;
            }
            if (y < miny) {
                miny = y;
            }
            if (z > maxz) {
                maxz = z;
            }
            if (!(z < minz)) continue;
            minz = z;
        }
        double[] bbo = new double[]{minx, maxx, miny, maxy, minz, maxz};
        return (bbo[1] - bbo[0] + 1.0) * (bbo[3] - bbo[2] + 1.0) * (bbo[5] - bbo[4] + 1.0);
    }

    public ArrayList<Voxel3D> getBoundingOriented() {
        Vector3D V0 = this.getVectorAxis(2);
        V0.normalize();
        Vector3D V1 = this.getVectorAxis(1);
        V1.normalize();
        Vector3D V2 = this.getVectorAxis(0);
        V2.normalize();
        double v0x = V0.getX();
        double v0y = V0.getY();
        double v0z = V0.getZ();
        double v1x = V1.getX();
        double v1y = V1.getY();
        double v1z = V1.getZ();
        double v2x = V2.getX();
        double v2y = V2.getY();
        double v2z = V2.getZ();
        double[] cen = this.getCenterAsArray();
        double ccx = cen[0];
        double ccy = cen[1];
        double ccz = cen[2];
        ArrayList<Voxel3D> cont = this.getContours();
        ArrayList<Voxel3D> orientedCont = new ArrayList<Voxel3D>();
        for (Voxel3D vox : cont) {
            double nx = v0x * (vox.getX() - ccx) + v1x * (vox.getY() - ccy) + v2x * (vox.getZ() - ccz) + ccx;
            double ny = v0y * (vox.getX() - ccx) + v1y * (vox.getY() - ccy) + v2y * (vox.getZ() - ccz) + ccy;
            double nz = v0z * (vox.getX() - ccx) + v1z * (vox.getY() - ccy) + v2z * (vox.getZ() - ccz) + ccz;
            orientedCont.add(new Voxel3D(nx, ny, nz, (double)this.getValue()));
        }
        return orientedCont;
    }

    public double getVolumeEllipseUnit() {
        double r1 = this.getRadiusMoments(2);
        double r2 = r1 / this.getMainElongation();
        double r3 = r2 / this.getMedianElongation();
        return 4.18879 * r1 * r2 * r3;
    }

    protected void computeEigen() {
        if (this.eigen == null) {
            Matrix mat = new Matrix(3, 3);
            if (Double.isNaN(this.s200)) {
                this.computeMoments2(true);
            }
            mat.set(0, 0, this.s200);
            mat.set(0, 1, this.s110);
            mat.set(0, 2, this.s101);
            mat.set(1, 0, this.s110);
            mat.set(1, 1, this.s020);
            mat.set(1, 2, this.s011);
            mat.set(2, 0, this.s101);
            mat.set(2, 1, this.s011);
            mat.set(2, 2, this.s002);
            this.eigen = new EigenvalueDecomposition(mat);
        }
    }

    public Matrix getMatrixAxes() {
        this.computeEigen();
        Matrix M = this.eigen.getV().copy();
        double tmp = M.get(0, 2);
        M.set(0, 2, M.get(0, 0));
        M.set(0, 0, tmp);
        tmp = M.get(1, 2);
        M.set(1, 2, M.get(1, 0));
        M.set(1, 0, tmp);
        tmp = M.get(2, 2);
        M.set(2, 2, M.get(2, 0));
        M.set(2, 0, tmp);
        return M;
    }

    public double getValueAxis(int order) {
        this.computeEigen();
        double[] evalues = this.eigen.getRealEigenvalues();
        return evalues[order];
    }

    public Vector3D getMainAxis() {
        return this.getVectorAxis(2);
    }

    public Vector3D getVectorAxis(int order) {
        this.computeEigen();
        Matrix evect = this.eigen.getV();
        return new Vector3D(evect.get(0, order), evect.get(1, order), evect.get(2, order));
    }

    public double getRadiusMoments(int order) {
        return Math.sqrt(5.0 * this.getValueAxis(order));
    }

    public double getMainElongation() {
        if (this.getValueAxis(1) != 0.0) {
            return Math.sqrt(this.getValueAxis(2) / this.getValueAxis(1));
        }
        return Double.NaN;
    }

    public double getMedianElongation() {
        if (this.getValueAxis(0) != 0.0) {
            return Math.sqrt(this.getValueAxis(1) / this.getValueAxis(0));
        }
        return Double.NaN;
    }

    public void computeContours(ImageHandler ima) {
        this.areaNbVoxels = 0.0;
        this.contours = new ArrayList();
        for (int k = this.zmin; k <= this.zmax; ++k) {
            for (int j = this.ymin; j <= this.ymax; ++j) {
                for (int i = this.xmin; i <= this.xmax; ++i) {
                    if (ima.getPixel(i, j, k) != (float)this.value) continue;
                    this.areaNbVoxels += 1.0;
                    Voxel3D temp = new Voxel3D(i, j, k, this.value);
                    this.contours.add(temp);
                }
            }
        }
    }

    public double getDistCenterMin() {
        if (Double.isNaN(this.distcentermin)) {
            this.computeDistCenter();
        }
        return this.distcentermin;
    }

    public double getDistCenterMax() {
        if (Double.isNaN(this.distcentermax)) {
            this.computeDistCenter();
        }
        return this.distcentermax;
    }

    public double getDistCenterMean() {
        if (Double.isNaN(this.distcentermean)) {
            this.computeDistCenter();
        }
        return this.distcentermean;
    }

    public double getDistCenterSigma() {
        if (Double.isNaN(this.distcentersigma)) {
            this.computeDistCenter();
        }
        return this.distcentersigma;
    }

    public boolean centerInside() {
        Point3D P = this.getCenterAsPoint();
        return this.inside(P.getX(), P.getY(), P.getZ());
    }

    private void computeDistCenter() {
        if (this.centerInside()) {
            double distmax = 0.0;
            double distmin = Double.POSITIVE_INFINITY;
            double distsum = 0.0;
            double distsum2 = 0.0;
            double rx2 = this.resXY * this.resXY;
            double rz2 = this.resZ * this.resZ;
            Vector3D vc = this.getCenterAsVector();
            Voxel3D center = new Voxel3D(vc.getX(), vc.getY(), vc.getZ(), 0.0);
            double ccx = center.getX();
            double ccy = center.getY();
            double ccz = center.getZ();
            ArrayList<Voxel3D> cont = this.getContours();
            int s = this.getContours().size();
            for (int j = 0; j < s; ++j) {
                Voxel3D p2 = cont.get(j);
                double dist2 = rx2 * ((ccx - p2.getX()) * (ccx - p2.getX()) + (ccy - p2.getY()) * (ccy - p2.getY())) + rz2 * (ccz - p2.getZ()) * (ccz - p2.getZ());
                distsum += Math.sqrt(dist2);
                distsum2 += dist2;
                if (dist2 > distmax) {
                    distmax = dist2;
                }
                if (!(dist2 < distmin)) continue;
                distmin = dist2;
            }
            this.distcentermax = Math.sqrt(distmax);
            this.distcentermin = Math.sqrt(distmin);
            this.distcentermean = distsum / (double)s;
            this.distcentersigma = Math.sqrt((distsum2 - distsum * distsum / (double)s) / ((double)s - 1.0));
        }
    }

    private void computeFeret() {
        double distmax = 0.0;
        double rx2 = this.resXY * this.resXY;
        double rz2 = this.resZ * this.resZ;
        ArrayList<Voxel3D> cont = this.getContours();
        int s = cont.size();
        for (int i = 0; i < s; ++i) {
            Voxel3D p1 = cont.get(i);
            for (int j = i + 1; j < s; ++j) {
                Voxel3D p2 = cont.get(j);
                double dist = rx2 * ((p1.getX() - p2.getX()) * (p1.getX() - p2.getX()) + (p1.getY() - p2.getY()) * (p1.getY() - p2.getY())) + rz2 * (p1.getZ() - p2.getZ()) * (p1.getZ() - p2.getZ());
                if (!(dist > distmax)) continue;
                distmax = dist;
                this.feret1 = p1;
                this.feret2 = p2;
            }
        }
        this.feret = (float)Math.sqrt(distmax);
    }

    public double getFeret() {
        if (Double.isNaN(this.feret)) {
            this.computeFeret();
        }
        return this.feret;
    }

    public Voxel3D getFeretVoxel1() {
        if (this.feret1 == null) {
            this.computeFeret();
        }
        return this.feret1;
    }

    public Voxel3D getFeretVoxel2() {
        if (this.feret2 == null) {
            this.computeFeret();
        }
        return this.feret2;
    }

    public String toString() {
        return "Object3D : " + this.value + " (" + (int)(this.bx + 0.5) + "," + (int)(this.by + 0.5) + "," + (int)(this.bz + 0.5) + ")";
    }

    public double distBorderUnit(Object3D other) {
        return this.vectorBorderBorder(other).getLength(this.resXY, this.resZ);
    }

    public double distBorderPixel(Object3D other) {
        return this.vectorBorderBorder(other).getLength(1.0, 1.0);
    }

    public double distBorderUnit(Point3D point0, Object3D other, Point3D point1, boolean opposite) {
        Vector3D V = this.vectorBorderBorder(point0, other, point1, opposite);
        if (V != null) {
            return V.getLength(this.resXY, this.resZ);
        }
        return Double.NaN;
    }

    public double distCenterUnit(Object3D autre) {
        return Math.sqrt((this.bx - autre.bx) * (this.bx - autre.bx) * this.resXY * this.resXY + (this.by - autre.by) * (this.by - autre.by) * this.resXY * this.resXY + (this.bz - autre.bz) * (this.bz - autre.bz) * this.resZ * this.resZ);
    }

    public double distCenter2DUnit(Object3D autre) {
        return Math.sqrt((this.bx - autre.bx) * (this.bx - autre.bx) * this.resXY * this.resXY + (this.by - autre.by) * (this.by - autre.by) * this.resXY * this.resXY);
    }

    public double distCenterBorderUnit(Object3D autre) {
        return this.vectorCenterBorder(autre).getLength(this.resXY, this.resZ);
    }

    public double distPixelBorder(Point3D P) {
        return this.vectorPixelBorder(P.getX(), P.getY(), P.getZ()).getLength(this.resXY, this.resZ);
    }

    public double distPixelBorderUnit(double x, double y, double z) {
        return this.vectorPixelBorder(x, y, z).getLength(this.resXY, this.resZ);
    }

    public double distPixelBorderUnit(double x, double y, double z, Vector3D V) {
        Vector3D res = this.vectorPixelBorder(x, y, z, V);
        if (res != null) {
            return res.getLength(this.resXY, this.resZ);
        }
        return Double.NaN;
    }

    public double distPixelCenter(double x, double y, double z) {
        return Math.sqrt((this.bx - x) * (this.bx - x) * this.resXY * this.resXY + (this.by - y) * (this.by - y) * this.resXY * this.resXY + (this.bz - z) * (this.bz - z) * this.resZ * this.resZ);
    }

    public double distPixelCenter(Point3D P) {
        return Math.sqrt((this.bx - P.x) * (this.bx - P.x) * this.resXY * this.resXY + (this.by - P.y) * (this.by - P.y) * this.resXY * this.resXY + (this.bz - P.z) * (this.bz - P.z) * this.resZ * this.resZ);
    }

    public Vector3D getCenterUnit() {
        Vector3D ce = this.getCenterAsVector();
        return new Vector3D(ce.getX() * this.resXY, ce.getY() * this.resXY, ce.getZ() * this.resZ);
    }

    public boolean isContour(Voxel3D vox) {
        if (this.contours == null) {
            this.computeContours();
        }
        for (Voxel3D v : this.contours) {
            if (!(v.distBlock(vox) < 0.001)) continue;
            return true;
        }
        return false;
    }

    public boolean insideBounding(double x, double y, double z) {
        return x >= (double)this.xmin && x <= (double)this.xmax && y >= (double)this.ymin && y <= (double)this.ymax && z >= (double)this.zmin && z <= (double)this.zmax;
    }

    public boolean insideBounding(float x, float y, float z) {
        return x >= (float)this.xmin && x <= (float)this.xmax && y >= (float)this.ymin && y <= (float)this.ymax && z >= (float)this.zmin && z <= (float)this.zmax;
    }

    public boolean insideBounding(double x, double y, double z, int rx, int ry, int rz) {
        return x >= (double)(this.xmin - rx) && x <= (double)(this.xmax + rx) && y >= (double)(this.ymin - ry) && y <= (double)(this.ymax + ry) && z >= (double)(this.zmin - rz) && z <= (double)(this.zmax + rz);
    }

    public boolean inside(Point3D P) {
        return this.inside(P.getX(), P.getY(), P.getZ());
    }

    public boolean insideOne(ArrayList<Point3D> markers) {
        for (Point3D marker : markers) {
            if (!this.inside(marker)) continue;
            return true;
        }
        return false;
    }

    public boolean insideAll(ArrayList<Point3D> markers) {
        for (Point3D marker : markers) {
            if (this.inside(marker)) continue;
            return false;
        }
        return true;
    }

    public synchronized boolean inside(double x, double y, double z) {
        if (!this.insideBounding(x, y, z, 1, 1, 1)) {
            return false;
        }
        int val = this.value;
        if (val == 0) {
            val = 1;
        }
        ImageInt label = this.getLabelImage();
        int testX = (int)Math.round(x) - label.offsetX;
        int testY = (int)Math.round(y) - label.offsetY;
        int testZ = (int)Math.round(z) - label.offsetZ;
        if (testX < 0 || testY < 0 || testZ < 0 || testX >= label.sizeX || testY >= label.sizeY || testZ >= label.sizeZ) {
            return false;
        }
        return label.getPixel(testX, testY, testZ) == (float)val;
    }

    public boolean includesBox(Object3D autre) {
        int oxmin = autre.getXmin();
        int oxmax = autre.getXmax();
        int oymin = autre.getYmin();
        int oymax = autre.getYmax();
        int ozmin = autre.getZmin();
        int ozmax = autre.getZmax();
        return this.insideBounding(oxmin, oymin, ozmin) && this.insideBounding(oxmin, oymax, ozmin) && this.insideBounding(oxmax, oymin, ozmin) && this.insideBounding(oxmax, oymax, ozmin) && this.insideBounding(oxmin, oymin, ozmax) && this.insideBounding(oxmin, oymax, ozmax) && this.insideBounding(oxmax, oymin, ozmax) && this.insideBounding(oxmax, oymax, ozmax);
    }

    protected int[] getIntersectionBox(Object3D other) {
        int[] res = new int[]{Math.max(this.getXmin(), other.getXmin()), Math.min(this.getXmax(), other.getXmax()), Math.max(this.getYmin(), other.getYmin()), Math.min(this.getYmax(), other.getYmax()), Math.max(this.getZmin(), other.getZmin()), Math.min(this.getZmax(), other.getZmax())};
        return res;
    }

    private boolean computeOverlapBox(Object3D autre) {
        int oxmin = autre.getXmin();
        int oxmax = autre.getXmax();
        int oymin = autre.getYmin();
        int oymax = autre.getYmax();
        int ozmin = autre.getZmin();
        int ozmax = autre.getZmax();
        boolean intersectX = this.xmax >= oxmin && oxmax >= this.xmin;
        boolean intersectY = this.ymax >= oymin && oymax >= this.ymin;
        boolean intersectZ = this.zmax >= ozmin && ozmax >= this.zmin;
        return intersectX && intersectY && intersectZ;
    }

    public boolean overlapBox(Object3D other) {
        return this.computeOverlapBox(other);
    }

    public boolean disjointBox(Object3D other) {
        return !this.overlapBox(other);
    }

    public ImageInt createIntersectionImage(Object3D other, int val1, int val2, int border) {
        int zmi;
        int ymi;
        ImageInt label = this.getLabelImage();
        ImageInt label2 = other.getLabelImage();
        int xmi = Math.min(this.xmin, other.xmin) - border;
        if (xmi < 0) {
            xmi = 0;
        }
        if ((ymi = Math.min(this.ymin, other.ymin) - border) < 0) {
            ymi = 0;
        }
        if ((zmi = Math.min(this.zmin, other.zmin) - border) < 0) {
            zmi = 0;
        }
        int xma = Math.max(this.xmax, other.xmax) + border;
        int yma = Math.max(this.ymax, other.ymax) + border;
        int zma = Math.max(this.zmax, other.zmax) + border;
        ImageInt imgThis = this.createSegImage(xmi, ymi, zmi, xma, yma, zma, val1);
        ImageInt imgOther = other.createSegImage(xmi, ymi, zmi, xma, yma, zma, val2);
        ImageInt addImage = imgThis.addImage(imgOther);
        imgThis = null;
        imgOther = null;
        System.gc();
        this.labelImage = label;
        other.labelImage = label2;
        return addImage;
    }

    public ImageInt createIntersectionImage(Object3D other, int val1, int val2) {
        return this.createIntersectionImage(other, val1, val2, 0);
    }

    public Object3DVoxels getIntersectionObject(Object3D other) {
        if (this.disjointBox(other)) {
            return null;
        }
        ImageInt inter = this.createIntersectionImage(other, 1, 2);
        Object3DVoxels obj = new Object3DVoxels((ImageHandler)inter, 3);
        obj.setValue(this.getValue());
        obj.translate(this.getLabelImage().offsetX, this.getLabelImage().offsetX, this.getLabelImage().offsetX);
        inter = null;
        return obj;
    }

    public int[] surfaceContact(Object3D other, double dist_max) {
        int j0;
        int j;
        int i;
        double distbb = this.distBorderPixel(other);
        if (distbb > dist_max) {
            return new int[]{0, 0};
        }
        int surfNeg = 0;
        int s = this.getContours().size();
        ArrayList<Voxel3D> othercontours = other.getContours();
        int t = othercontours.size();
        double dmax2 = dist_max * dist_max;
        double[][] distres = new double[s][t];
        for (i = 0; i < s; ++i) {
            for (j = 0; j < t; ++j) {
                distres[i][j] = -1.0;
            }
        }
        for (i = 0; i < s; ++i) {
            Voxel3D p0 = this.contours.get(i);
            j0 = -1;
            if (other.inside(p0)) {
                ++surfNeg;
                continue;
            }
            double dmin = dmax2;
            for (j = 0; j < t; ++j) {
                Voxel3D p1 = othercontours.get(j);
                double dist = p0.distanceSquare(p1);
                if (!(dist <= dmin)) continue;
                dmin = dist;
                j0 = j;
            }
            if (j0 == -1) continue;
            distres[i][j0] = dmin;
        }
        int surfPos = 0;
        for (int j2 = 0; j2 < t; ++j2) {
            for (j0 = 0; j0 < s && distres[j0][j2] == -1.0; ++j0) {
            }
            if (j0 >= s) continue;
            ++surfPos;
        }
        return new int[]{surfPos, surfNeg};
    }

    public int edgeContact(Object3D other, int distSquareMax) {
        HashSet<Voxel3D> voxSet = new HashSet<Voxel3D>();
        for (Voxel3D v1 : this.getContours()) {
            for (Voxel3D v2 : other.getContours()) {
                if (!(v1.distanceSquare(v2) <= (double)distSquareMax)) continue;
                voxSet.add(v1);
            }
        }
        return voxSet.size();
    }

    public boolean edgeImage(ImageHandler img, boolean edgeXY, boolean edgeZ) {
        if (edgeXY && (this.xmin <= 0 || this.ymin <= 0 || this.xmax >= img.sizeX - 1 || this.ymax >= img.sizeY - 1)) {
            return true;
        }
        return edgeZ && (this.zmin <= 0 || this.zmax >= img.sizeZ - 1);
    }

    public double radiusCenter(Object3D obj) {
        return this.radiusCenter(obj, false);
    }

    public double radiusCenter(Object3D obj, boolean opposite) {
        Vector3D VV = opposite ? new Vector3D(obj.getCenterAsPoint(), this.getCenterAsPoint()) : new Vector3D(this.getCenterAsPoint(), obj.getCenterAsPoint());
        if (VV.getLength() == 0.0) {
            return 0.0;
        }
        return this.distPixelBorderUnit(this.getCenterX(), this.getCenterY(), this.getCenterZ(), VV);
    }

    public double radiusCenter(Vector3D V) {
        Vector3D VV = this.getCenterAsVector().add(V, -1.0f, 1.0f);
        return this.distPixelBorderUnit(this.getCenterX(), this.getCenterY(), this.getCenterZ(), VV);
    }

    public double radiusPixel(double x, double y, double z) {
        Vector3D V = this.getCenterAsVector().add(new Vector3D(x, y, z), -1.0f, 1.0f);
        return this.distPixelBorderUnit(this.getCenterX(), this.getCenterY(), this.getCenterZ(), V);
    }

    public Vector3D vectorBorderBorder(Object3D other) {
        Voxel3D[] voxs = this.VoxelsBorderBorder(other);
        return new Vector3D(voxs[0], voxs[1]);
    }

    public Voxel3D[] VoxelsBorderBorder(Object3D other) {
        double distanceMinimum = Double.MAX_VALUE;
        Voxel3D otherBorder = null;
        Voxel3D thisBorder = null;
        KDTreeC tree = this.getKdtreeContours();
        for (Voxel3D otherVoxel : other.getContours()) {
            double[] pos = otherVoxel.getArray();
            KDTreeC.Item item = tree.getNearestNeighbor(pos, 1)[0];
            if (!(item.distanceSq < distanceMinimum)) continue;
            otherBorder = otherVoxel;
            thisBorder = (Voxel3D)item.obj;
            distanceMinimum = item.distanceSq;
        }
        return new Voxel3D[]{thisBorder, otherBorder};
    }

    public Vector3D vectorBorderBorder(Point3D point0, Object3D other, Point3D point1, boolean opposite) {
        Vector3D dir = new Vector3D(point0, point1);
        Vector3D tmp = this.vectorPixelBorder(point0.getX(), point0.getY(), point0.getZ(), dir);
        if (tmp == null) {
            return null;
        }
        Vector3D V0 = point0.getVector3D().add(tmp);
        if (opposite) {
            dir = dir.multiply(-1.0);
        }
        if ((tmp = other.vectorPixelBorder(point1.getX(), point1.getY(), point1.getZ(), dir)) == null) {
            return null;
        }
        Vector3D V1 = point1.getVector3D().add(tmp);
        return new Vector3D(V0, V1);
    }

    public Vector3D vectorCenterBorder(Object3D other) {
        return other.vectorPixelBorder(this.getCenterAsVector());
    }

    public Vector3D vectorPixelBorder(Vector3D V) {
        return this.vectorPixelBorder(V.getX(), V.getY(), V.getZ());
    }

    public Voxel3D getPixelBorder(double x, double y, double z) {
        double[] pos = new double[]{x, y, z};
        KDTreeC.Item item = this.getKdtreeContours().getNearestNeighbor(pos, 1)[0];
        return (Voxel3D)item.obj;
    }

    public Vector3D vectorPixelBorder(double x, double y, double z) {
        Voxel3D vox = this.getPixelBorder(x, y, z);
        return new Vector3D(vox.getX() - x, vox.getY() - y, vox.getZ() - z);
    }

    public Vector3D vectorPixelBorder(double x, double y, double z, Vector3D V) {
        boolean in0;
        Vector3D dir = new Vector3D(V);
        dir.normalize();
        float vx = (float)dir.getX();
        float vy = (float)dir.getY();
        float vz = (float)dir.getZ();
        float px = (float)x;
        float py = (float)y;
        float pz = (float)z;
        float step = 0.5f;
        boolean in = in0 = this.inside((int)Math.round(x), (int)Math.round(y), (int)Math.round(z));
        while (in == in0 && this.insideBounding(px, py, pz, 1, 1, 1)) {
            in = this.inside(px += step * vx, py += step * vy, pz += step * vz);
        }
        if (in != in0) {
            return new Vector3D((double)px - 0.5 * (double)step * (double)vx - x, (double)py - 0.5 * (double)step * (double)vy - y, (double)pz - 0.5 * (double)step * (double)vz - z);
        }
        return null;
    }

    public Point3D pointPixelBorder(double x, double y, double z, Vector3D V) {
        double distmin = Double.MAX_VALUE;
        Vector3D dir = new Vector3D(V);
        dir.multiply(this.resXY, this.resXY, this.resZ);
        dir.normalize();
        Voxel3D stock = new Voxel3D();
        Vector3D here = new Vector3D(x, y, z);
        ArrayList<Voxel3D> cont = this.getContours();
        Iterator<Voxel3D> iterator = cont.iterator();
        while (iterator.hasNext()) {
            Voxel3D aCont;
            Voxel3D edge = aCont = iterator.next();
            Vector3D rad = new Vector3D(here, edge);
            rad.multiply(this.resXY, this.resXY, this.resZ);
            double dist = 1.0 - dir.colinear(rad);
            if (!(dist < distmin)) continue;
            distmin = dist;
            stock = edge;
        }
        return new Point3D(stock);
    }

    public Vector3D vectorPixelUnitBorder(Vector3D V) {
        return this.vectorPixelUnitBorder(V.getX(), V.getY(), V.getZ());
    }

    public Vector3D vectorPixelUnitBorder(Vector3D V, Vector3D dir) {
        return this.vectorPixelUnitBorder(V.getX(), V.getY(), V.getZ(), dir);
    }

    public Vector3D vectorPixelUnitBorder(double x, double y, double z) {
        return this.vectorPixelBorder(x / this.resXY, y / this.resXY, z / this.resZ);
    }

    public Vector3D vectorPixelUnitBorder(double x, double y, double z, Vector3D dir) {
        Vector3D dir2 = dir.multiply(1.0 / this.resXY, 1.0 / this.resXY, 1.0 / this.resZ);
        return this.vectorPixelBorder(x / this.resXY, y / this.resXY, z / this.resZ, dir2);
    }

    public double angle(Object3D a, Object3D b) {
        double OI = this.distCenterUnit(a);
        double OF = this.distCenterUnit(b);
        double IF = a.distCenterUnit(b);
        double cosangle = (IF * IF - OF * OF - OI * OI) / (-2.0 * OF * OI);
        return Math.toDegrees(Math.acos(cosangle));
    }

    public double getPixMeanValue(ImageHandler ima) {
        if (this.volume > 0) {
            if (this.currentQuantifImage == null || this.currentQuantifImage != ima) {
                this.computeMassCenter(ima);
                this.currentQuantifImage = ima;
            }
            return this.meanDensity;
        }
        return Double.NaN;
    }

    public double getPixMeanValueContour(ImageHandler ima) {
        if (this.volume > 0) {
            ArrayList<Voxel3D> contours = this.getContours();
            double sum = 0.0;
            for (Voxel3D voxel3D : contours) {
                sum += (double)ima.getPixel(voxel3D);
            }
            return sum / (double)contours.size();
        }
        return 0.0;
    }

    public double getPixMedianValue(ImageHandler ima) {
        if (this.volume > 0) {
            if (this.currentQuantifImage == null || this.currentQuantifImage != ima) {
                this.computeMassCenter(ima);
                this.currentQuantifImage = ima;
            }
            return this.listValues(ima).median();
        }
        return Double.NaN;
    }

    public double getPixModeValue(ImageHandler ima) {
        if (this.volume > 0) {
            return this.listValues(ima).getMode();
        }
        return Double.NaN;
    }

    public double getPixModeNonZero(ImageHandler ima) {
        if (this.volume > 0) {
            return this.listValues(ima).getModeNonZero();
        }
        return Double.NaN;
    }

    public double getMeanPixValueAroundBarycenter(boolean massCenter, ImageInt objectMap, ImageHandler ima, double radXY, double radZ) {
        int z;
        int y;
        int x;
        if (massCenter) {
            this.computeMassCenter(ima);
            x = (int)(this.cx + 0.5);
            y = (int)(this.cy + 0.5);
            z = (int)(this.cz + 0.5);
        } else {
            this.computeCenter();
            x = (int)(this.bx + 0.5);
            y = (int)(this.by + 0.5);
            z = (int)(this.bz + 0.5);
        }
        double res = 0.0;
        int count = 0;
        for (int zz = z - 1; zz <= z + 1; ++zz) {
            if (zz < 0 || zz >= ima.sizeZ) continue;
            for (int yy = y - 1; yy <= y + 1; ++yy) {
                if (yy < 0 || yy >= ima.sizeY) continue;
                for (int xx = x - 1; xx <= x + 1; ++xx) {
                    if (xx < 0 || xx >= ima.sizeX || objectMap.getPixelInt(xx, yy, zz) != this.getValue()) continue;
                    res += (double)ima.getPixel(xx, yy, zz);
                    ++count;
                }
            }
        }
        if (count > 0) {
            return res / (double)count;
        }
        return 0.0;
    }

    public double getPixMaxValue(ImageHandler ima) {
        if (this.currentQuantifImage == null || this.currentQuantifImage != ima) {
            this.computeMassCenter(ima);
            this.currentQuantifImage = ima;
        }
        return this.pixmax;
    }

    public double getPixCenterValue(ImageHandler ima) {
        if (ima.contains(this.getCenterX(), this.getCenterY(), this.getCenterZ())) {
            return ima.getPixel(this.getCenterAsPoint());
        }
        return Double.NaN;
    }

    public double getPixMinValue(ImageHandler ima) {
        if (this.currentQuantifImage == null || this.currentQuantifImage != ima) {
            this.computeMassCenter(ima);
            this.currentQuantifImage = ima;
        }
        return this.pixmin;
    }

    public void resetQuantifImage() {
        this.currentQuantifImage = null;
    }

    public double getPixStdDevValue(ImageHandler ima) {
        if (this.currentQuantifImage == null || this.currentQuantifImage != ima) {
            this.computeMassCenter(ima);
            this.currentQuantifImage = ima;
        }
        return this.sigma;
    }

    public ImageInt createSegImageMini2D(int val, int borderSize) {
        int ym;
        int xm = this.getXmin() - borderSize;
        if (xm < -borderSize) {
            xm = -borderSize;
        }
        if ((ym = this.getYmin() - borderSize) < -borderSize) {
            ym = -borderSize;
        }
        int w = this.getXmax() - xm + 1 + borderSize;
        int h = this.getYmax() - ym + 1 + borderSize;
        this.miniLabelImage = new ImageShort("Object_" + val, w, h, 1);
        for (Voxel3D o : this.getVoxels()) {
            double yy;
            Voxel3D vox = o;
            double xx = vox.getX() - (double)xm;
            if (!this.miniLabelImage.contains(xx, yy = vox.getY() - (double)ym, 0.0)) {
                System.out.println("outside miniseg " + xx + " " + yy);
                continue;
            }
            this.miniLabelImage.setPixel((int)Math.round(xx), (int)Math.round(yy), 0, val);
        }
        this.miniLabelImage.offsetX = xm;
        this.miniLabelImage.offsetY = ym;
        this.miniLabelImage.setScale((float)this.getResXY(), (float)this.getResXY(), this.getUnits());
        return this.miniLabelImage;
    }

    private ImageInt createSegImage() {
        if (this.value != 0) {
            return this.createSegImage(this.xmin, this.ymin, this.zmin, this.xmax, this.ymax, this.zmax, this.value);
        }
        return this.createSegImage(this.xmin, this.ymin, this.zmin, this.xmax, this.ymax, this.zmax, 1);
    }

    private ImageInt createMaxSegImage(int val) {
        return this.createSegImage(0, 0, 0, this.xmax, this.ymax, this.zmax, val);
    }

    public ImageInt createSegImage(int xmi, int ymi, int zmi, int xma, int yma, int zma, int val) {
        ImageShort segImage = new ImageShort("Object", xma - xmi + 1, yma - ymi + 1, zma - zmi + 1);
        int offX = xmi;
        int offY = ymi;
        int offZ = zmi;
        for (Voxel3D o : this.getVoxels()) {
            Voxel3D vox = o;
            if (!segImage.contains(vox.getRoundX() - offX, vox.getRoundY() - offY, vox.getRoundZ() - offZ)) continue;
            ((ImageInt)segImage).setPixel(vox.getRoundX() - offX, vox.getRoundY() - offY, vox.getRoundZ() - offZ, val);
        }
        segImage.setOffset(xmi, ymi, zmi);
        segImage.setScale(this.resXY, this.resZ, this.units);
        return segImage;
    }

    public ImageInt createSegImage(int bx, int by, int bz) {
        return this.createSegImage(this.xmin - bx, this.ymin - by, this.zmin - bz, this.xmax + bx, this.ymax + by, this.zmax + bz, this.value);
    }

    public abstract ArrayList<Voxel3D> getVoxels();

    public abstract void saveObject(String var1);

    protected void saveInfo(BufferedWriter bf) throws IOException {
        bf.write("cal=\t" + this.resXY + "\t" + this.resZ + "\t" + this.units + "\n");
        if (!this.comment.isEmpty()) {
            bf.write("comment=\t" + this.comment + "\n");
        }
        if (this.type > 0) {
            bf.write("type=\t" + this.type + "\n");
        }
        bf.write("value=\t" + this.value + "\n");
    }

    protected String loadInfo(BufferedReader bf) throws IOException {
        String data = bf.readLine();
        while (data != null) {
            String[] coord;
            if (data.startsWith("cal=")) {
                coord = data.split("\t");
                this.resXY = Double.parseDouble(coord[1]);
                this.resZ = Double.parseDouble(coord[2]);
                this.units = coord[3];
            } else if (data.startsWith("comment=")) {
                coord = data.split("\t");
                this.comment = coord[1];
            } else if (data.startsWith("type=")) {
                coord = data.split("\t");
                this.type = Integer.parseInt(coord[1]);
            } else {
                if (!data.startsWith("value=")) break;
                coord = data.split("\t");
                this.value = Integer.parseInt(coord[1]);
                if (this.value == 0) {
                    this.value = 1;
                }
            }
            data = bf.readLine();
        }
        return data;
    }

    public boolean includesMarkersNone(ImageInt imageMarkers) {
        for (Voxel3D voxel3D : this.getVoxels()) {
            if (!imageMarkers.contains(voxel3D) || !(imageMarkers.getPixel(voxel3D) > 0.0f)) continue;
            return false;
        }
        return true;
    }

    public boolean includesMarkersOneOnly(ImageInt imageMarkers) {
        int label = -1;
        for (Voxel3D voxel3D : this.getVoxels()) {
            int pixel;
            if (!imageMarkers.contains(voxel3D) || (pixel = imageMarkers.getPixelInt(voxel3D)) <= 0) continue;
            if (label == -1) {
                label = pixel;
            }
            if (label <= 0 || pixel == label) continue;
            return false;
        }
        return label > 0;
    }

    public boolean includesMarkersOneMore(ImageInt imageMarkers) {
        for (Voxel3D voxel3D : this.getVoxels()) {
            int pixel;
            if (!imageMarkers.contains(voxel3D) || (pixel = imageMarkers.getPixelInt(voxel3D)) <= 0) continue;
            return true;
        }
        return false;
    }

    public boolean includedInZonesNone(ImageInt imageZones) {
        for (Voxel3D voxel3D : this.getVoxels()) {
            if (!imageZones.contains(voxel3D) || !(imageZones.getPixel(voxel3D) > 0.0f)) continue;
            return false;
        }
        return true;
    }

    public boolean includedInZonesOneOnly(ImageInt imageZones) {
        int label = -1;
        for (Voxel3D voxel3D : this.getVoxels()) {
            if (!imageZones.contains(voxel3D)) continue;
            int pixel = imageZones.getPixelInt(voxel3D);
            if (pixel == 0) {
                return false;
            }
            if (label == -1) {
                label = pixel;
                continue;
            }
            if (pixel == label) continue;
            return false;
        }
        return true;
    }

    public boolean includedInZonesOneMore(ImageInt imageZones) {
        for (Voxel3D voxel3D : this.getVoxels()) {
            int pixel;
            if (!imageZones.contains(voxel3D) || (pixel = imageZones.getPixelInt(voxel3D)) != 0) continue;
            return false;
        }
        return true;
    }

    public boolean includes(Object3D obj) {
        if (!this.includesBox(obj)) {
            return false;
        }
        int co = this.getColoc(obj);
        return co == obj.getVolumePixels();
    }

    private KDTreeC getKdtreeContours() {
        if (this.contours == null) {
            this.computeContours();
        }
        if (this.kdtreeContours == null && this.contours != null && !this.contours.isEmpty()) {
            this.kdtreeContours = new KDTreeC(3);
            this.kdtreeContours.setScale3(this.resXY, this.resXY, this.resZ);
            for (Voxel3D v : this.contours) {
                this.kdtreeContours.add(v.getArray(), v);
            }
        }
        return this.kdtreeContours;
    }

    public abstract boolean hasOneVoxelColoc(Object3D var1);

    public abstract int getColoc(Object3D var1);

    public boolean touchBorders(ImageHandler img, boolean Z) {
        int[] bb = this.getBoundingBox();
        if (bb[0] <= 0 || bb[2] <= 0) {
            return true;
        }
        if (Z && bb[4] <= 0) {
            return true;
        }
        if (bb[1] >= img.sizeX - 1 || bb[3] >= img.sizeY - 1) {
            return true;
        }
        return Z && bb[5] >= img.sizeZ - 1;
    }

    public boolean touchBorders(ImagePlus img, boolean Z) {
        int[] bb = this.getBoundingBox();
        if (bb[0] <= 0 || bb[2] <= 0) {
            return true;
        }
        if (Z && bb[4] <= 0) {
            return true;
        }
        if (bb[1] >= img.getWidth() - 1 || bb[3] >= img.getHeight() - 1) {
            return true;
        }
        return Z && bb[5] >= img.getNSlices() - 1;
    }

    private Object3DVoxels getMorphologicalObject(int op, float radX, float radY, float radZ) {
        ImageInt segImage2;
        if (radX == 0.0f && radY == 0.0f && radZ == 0.0f) {
            return new Object3DVoxels(this);
        }
        if (op == 1 || op == 3) {
            this.labelImage = this.createSegImage((int)(radX + 1.0f), (int)(radY + 1.0f), (int)(radZ + 1.0f));
        }
        if (radY != radX || radZ == 0.0f) {
            int filter = 0;
            if (op == 1) {
                filter = 3;
            } else if (op == 2) {
                filter = 2;
            } else if (op == 3) {
                filter = 7;
            } else if (op == 4) {
                filter = 6;
            }
            segImage2 = FastFilters3D.filterIntImage(this.getLabelImage(), filter, radX, radY, radZ, 0, true);
            segImage2.setOffset(this.labelImage);
        } else {
            segImage2 = op == 1 ? BinaryMorpho.binaryDilate(this.getLabelImage(), radX, radZ, 0, true) : BinaryMorpho.binaryMorpho(this.getLabelImage(), op, radX, radZ, 0);
        }
        if (segImage2 == null) {
            return null;
        }
        Object3DVoxels objMorpho = new Object3DVoxels(segImage2);
        objMorpho.translate(segImage2.offsetX, segImage2.offsetY, segImage2.offsetZ);
        objMorpho.setCalibration(this.resXY, this.resZ, this.units);
        return objMorpho;
    }

    public boolean b_closed(float radX, float radY, float radZ) {
        Object3DVoxels closed = this.getClosedObject(radX, radY, radZ);
        MereoObject3D mereo = new MereoObject3D(this, closed);
        return mereo.Equality();
    }

    public boolean b_open(float radX, float radY, float radZ) {
        Object3DVoxels open = this.getOpenedObject(radX, radY, radZ);
        MereoObject3D mereo = new MereoObject3D(this, open);
        return mereo.Equality();
    }

    public boolean regular(float radX, float radY, float radZ) {
        if (!this.b_open(radX, radY, radZ)) {
            return false;
        }
        return this.b_closed(radX, radY, radZ);
    }

    public Object3DVoxels getDilatedObject(float radX, float radY, float radZ) {
        return this.getMorphologicalObject(1, radX, radY, radZ);
    }

    public Object3DVoxels getErodedObject(float radX, float radY, float radZ) {
        return this.getMorphologicalObject(2, radX, radY, radZ);
    }

    public Object3DVoxels getClosedObject(float radX, float radY, float radZ) {
        return this.getMorphologicalObject(3, radX, radY, radZ);
    }

    public Object3DVoxels getOpenedObject(float radX, float radY, float radZ) {
        return this.getMorphologicalObject(4, radX, radY, radZ);
    }

    public Object3DVoxels getLayerObject(float r1, float r2) {
        Object3DVoxels obMax = r2 > 0.0f ? this.getDilatedObject(r2, r2, r2) : this.getErodedObject(-r2, -r2, -r2);
        Object3DVoxels obMin = r1 > 0.0f ? this.getDilatedObject(r1, r1, r1) : this.getErodedObject(-r1, -r1, -r1);
        obMax.substractObject(obMin);
        return obMax;
    }

    public Object3DVoxels getLayerEVFObject(ImageInt mask, float ratio) {
        ImageHandler dup = mask.createSameDimensions();
        this.draw(dup, 255);
        ImageFloat edt = EDT.run(dup, 128.0f, (float)this.resXY, (float)this.resZ, true, 0);
        EDT.normalizeDistanceMap(edt, mask, true);
        ImageByte th = edt.thresholdRangeInclusive(0.0f, ratio);
        Object3DVoxels res = new Object3DVoxels((ImageHandler)th, 255);
        res.setCalibration(this.resXY, this.resZ, this.units);
        return res;
    }

    public Object3DVoxels getLayerEVFObject(Object3D mask, float ratio) {
        if (!mask.includesBox(this)) {
            return null;
        }
        ImageInt img = mask.getLabelImage();
        ImageHandler dup = img.createSameDimensions();
        this.draw(dup, 255, -img.offsetX, -img.offsetY, -img.offsetZ);
        ImageFloat edt = EDT.run(dup, 128.0f, (float)this.resXY, (float)this.resZ, true, 0);
        EDT.normalizeDistanceMap(edt, img, true);
        ImageByte th = edt.thresholdRangeInclusive(0.0f, ratio);
        Object3DVoxels res = new Object3DVoxels(th);
        res.setCalibration(this.resXY, this.resZ, this.units);
        res.translate(img.offsetX, img.offsetY, img.offsetZ);
        return res;
    }

    public Object3DVoxels getEllipsoid() {
        Vector3D V = this.getVectorAxis(2);
        Vector3D W = this.getVectorAxis(1);
        double rad1 = this.getRadiusMoments(2);
        double rad2 = Double.NaN;
        if (!Double.isNaN(this.getMainElongation())) {
            rad2 = rad1 / this.getMainElongation();
        }
        double rad3 = Double.NaN;
        if (!Double.isNaN(this.getMedianElongation())) {
            rad3 = rad2 / this.getMedianElongation();
        }
        int radius = (int)(rad1 / this.resXY) + 1;
        ObjectCreator3D ellipsoid = new ObjectCreator3D(2 * radius, 2 * radius, 2 * radius);
        ellipsoid.setResolution(this.getResXY(), this.getResZ(), this.getUnits());
        ellipsoid.createEllipsoidAxesUnit((double)radius * this.resXY, (double)radius * this.resXY, (double)radius * this.resZ, rad1, rad2, rad3, 1.0f, V, W, false);
        Object3DVoxels ell = new Object3DVoxels(ellipsoid.getImageHandler(), 1);
        ell.translate(this.getCenterX() - (double)radius, this.getCenterY() - (double)radius, this.getCenterZ() - (double)radius);
        return ell;
    }

    @Override
    public int compareTo(Object3D o) {
        if (this.compare < o.compare) {
            return -1;
        }
        if (this.compare > o.compare) {
            return 1;
        }
        return 0;
    }
}

