/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.Array3D;
import mitiv.array.Byte3D;
import mitiv.array.Double3D;
import mitiv.array.Float3D;
import mitiv.array.Int3D;
import mitiv.array.Long3D;
import mitiv.array.ShapedArray;
import mitiv.array.Short1D;
import mitiv.array.Short2D;
import mitiv.array.ShortArray;
import mitiv.array.impl.FlatShort3D;
import mitiv.array.impl.StriddenShort3D;
import mitiv.base.Shape;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.ShortFunction;
import mitiv.base.mapping.ShortScanner;
import mitiv.exception.IllegalTypeException;
import mitiv.exception.NonConformableArrayException;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.random.ShortGenerator;

public abstract class Short3D
extends Array3D
implements ShortArray {
    protected Short3D(int n, int n2, int n3) {
        super(n, n2, n3);
    }

    protected Short3D(int[] nArray) {
        super(nArray);
    }

    protected Short3D(Shape shape) {
        super(shape);
    }

    @Override
    public final int getType() {
        return 1;
    }

    public abstract short get(int var1, int var2, int var3);

    public abstract void set(int var1, int var2, int var3, short var4);

    @Override
    public void fill(short s) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        this.set(i, j, k, s);
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim3; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim1; ++k) {
                        this.set(k, j, i, s);
                    }
                }
            }
        }
    }

    @Override
    public void increment(short s) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        this.set(i, j, k, (short)(this.get(i, j, k) + s));
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim3; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim1; ++k) {
                        this.set(k, j, i, (short)(this.get(k, j, i) + s));
                    }
                }
            }
        }
    }

    @Override
    public void decrement(short s) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        this.set(i, j, k, (short)(this.get(i, j, k) - s));
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim3; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim1; ++k) {
                        this.set(k, j, i, (short)(this.get(k, j, i) - s));
                    }
                }
            }
        }
    }

    @Override
    public void scale(short s) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        this.set(i, j, k, (short)(this.get(i, j, k) * s));
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim3; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim1; ++k) {
                        this.set(k, j, i, (short)(this.get(k, j, i) * s));
                    }
                }
            }
        }
    }

    @Override
    public void map(ShortFunction shortFunction) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        this.set(i, j, k, shortFunction.apply(this.get(i, j, k)));
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim3; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim1; ++k) {
                        this.set(k, j, i, shortFunction.apply(this.get(k, j, i)));
                    }
                }
            }
        }
    }

    @Override
    public void fill(ShortGenerator shortGenerator) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        this.set(i, j, k, shortGenerator.nextShort());
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim3; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim1; ++k) {
                        this.set(k, j, i, shortGenerator.nextShort());
                    }
                }
            }
        }
    }

    @Override
    public void scan(ShortScanner shortScanner) {
        boolean bl = false;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        if (bl) {
                            shortScanner.update(this.get(i, j, k));
                            continue;
                        }
                        shortScanner.initialize(this.get(i, j, k));
                        bl = true;
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim3; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim1; ++k) {
                        if (bl) {
                            shortScanner.update(this.get(k, j, i));
                            continue;
                        }
                        shortScanner.initialize(this.get(k, j, i));
                        bl = true;
                    }
                }
            }
        }
    }

    @Override
    public final short[] flatten() {
        return this.flatten(false);
    }

    @Override
    public short min() {
        short s = this.get(0, 0, 0);
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        if (bl) {
                            bl = false;
                            continue;
                        }
                        short s2 = this.get(i, j, k);
                        if (s2 >= s) continue;
                        s = s2;
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim3; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim1; ++k) {
                        if (bl) {
                            bl = false;
                            continue;
                        }
                        short s3 = this.get(k, j, i);
                        if (s3 >= s) continue;
                        s = s3;
                    }
                }
            }
        }
        return s;
    }

    @Override
    public short max() {
        short s = this.get(0, 0, 0);
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        if (bl) {
                            bl = false;
                            continue;
                        }
                        short s2 = this.get(i, j, k);
                        if (s2 <= s) continue;
                        s = s2;
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim3; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim1; ++k) {
                        if (bl) {
                            bl = false;
                            continue;
                        }
                        short s3 = this.get(k, j, i);
                        if (s3 <= s) continue;
                        s = s3;
                    }
                }
            }
        }
        return s;
    }

    @Override
    public short[] getMinAndMax() {
        short[] sArray = new short[2];
        this.getMinAndMax(sArray);
        return sArray;
    }

    @Override
    public void getMinAndMax(short[] sArray) {
        short s;
        short s2 = s = this.get(0, 0, 0);
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        if (bl) {
                            bl = false;
                            continue;
                        }
                        short s3 = this.get(i, j, k);
                        if (s3 < s) {
                            s = s3;
                        }
                        if (s3 <= s2) continue;
                        s2 = s3;
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim3; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim1; ++k) {
                        if (bl) {
                            bl = false;
                            continue;
                        }
                        short s4 = this.get(k, j, i);
                        if (s4 < s) {
                            s = s4;
                        }
                        if (s4 <= s2) continue;
                        s2 = s4;
                    }
                }
            }
        }
        sArray[0] = s;
        sArray[1] = s2;
    }

    @Override
    public int sum() {
        int n = 0;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        n += this.get(i, j, k);
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim3; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim1; ++k) {
                        n += this.get(k, j, i);
                    }
                }
            }
        }
        return n;
    }

    @Override
    public double average() {
        return (double)this.sum() / (double)this.number;
    }

    @Override
    public Byte3D toByte() {
        byte[] byArray = new byte[this.number];
        if (this.isFlat()) {
            short[] sArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                byArray[i] = (byte)sArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim3; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim1; ++k) {
                        byArray[++n] = (byte)this.get(k, j, i);
                    }
                }
            }
        }
        return Byte3D.wrap(byArray, this.getShape());
    }

    @Override
    public Short3D toShort() {
        return this;
    }

    @Override
    public Int3D toInt() {
        int[] nArray = new int[this.number];
        if (this.isFlat()) {
            short[] sArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                nArray[i] = sArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim3; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim1; ++k) {
                        nArray[++n] = this.get(k, j, i);
                    }
                }
            }
        }
        return Int3D.wrap(nArray, this.getShape());
    }

    @Override
    public Long3D toLong() {
        long[] lArray = new long[this.number];
        if (this.isFlat()) {
            short[] sArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                lArray[i] = sArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim3; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim1; ++k) {
                        lArray[++n] = this.get(k, j, i);
                    }
                }
            }
        }
        return Long3D.wrap(lArray, this.getShape());
    }

    @Override
    public Float3D toFloat() {
        float[] fArray = new float[this.number];
        if (this.isFlat()) {
            short[] sArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                fArray[i] = sArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim3; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim1; ++k) {
                        fArray[++n] = this.get(k, j, i);
                    }
                }
            }
        }
        return Float3D.wrap(fArray, this.getShape());
    }

    @Override
    public Double3D toDouble() {
        double[] dArray = new double[this.number];
        if (this.isFlat()) {
            short[] sArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                dArray[i] = sArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim3; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim1; ++k) {
                        dArray[++n] = this.get(k, j, i);
                    }
                }
            }
        }
        return Double3D.wrap(dArray, this.getShape());
    }

    @Override
    public Short3D copy() {
        return new FlatShort3D(this.flatten(true), this.shape);
    }

    @Override
    public void assign(ShapedArray shapedArray) {
        if (!this.getShape().equals(shapedArray.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        Short3D short3D = shapedArray.getType() == 1 ? (Short3D)shapedArray : (Short3D)shapedArray.toShort();
        if (this.getOrder() == 2 && short3D.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        this.set(i, j, k, short3D.get(i, j, k));
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim3; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim1; ++k) {
                        this.set(k, j, i, short3D.get(k, j, i));
                    }
                }
            }
        }
    }

    @Override
    public void assign(ShapedVector shapedVector) {
        if (!this.getShape().equals(shapedVector.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        int n = -1;
        if (shapedVector.getType() == 5) {
            DoubleShapedVector doubleShapedVector = (DoubleShapedVector)shapedVector;
            for (int i = 0; i < this.dim3; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim1; ++k) {
                        this.set(k, j, i, (short)doubleShapedVector.get(++n));
                    }
                }
            }
        } else if (shapedVector.getType() == 4) {
            FloatShapedVector floatShapedVector = (FloatShapedVector)shapedVector;
            for (int i = 0; i < this.dim3; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim1; ++k) {
                        this.set(k, j, i, (short)floatShapedVector.get(++n));
                    }
                }
            }
        } else {
            throw new IllegalTypeException();
        }
    }

    @Override
    public Short3D create() {
        return new FlatShort3D(this.getShape());
    }

    public static Short3D create(int n, int n2, int n3) {
        return new FlatShort3D(n, n2, n3);
    }

    public static Short3D create(int[] nArray) {
        return new FlatShort3D(nArray);
    }

    public static Short3D create(Shape shape) {
        return new FlatShort3D(shape);
    }

    public static Short3D wrap(short[] sArray, int n, int n2, int n3) {
        return new FlatShort3D(sArray, n, n2, n3);
    }

    public static Short3D wrap(short[] sArray, int[] nArray) {
        return new FlatShort3D(sArray, nArray);
    }

    public static Short3D wrap(short[] sArray, Shape shape) {
        return new FlatShort3D(sArray, shape);
    }

    public static Short3D wrap(short[] sArray, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        return new StriddenShort3D(sArray, n, n2, n3, n4, n5, n6, n7);
    }

    @Override
    public abstract Short2D slice(int var1);

    @Override
    public abstract Short2D slice(int var1, int var2);

    @Override
    public abstract Short3D view(Range var1, Range var2, Range var3);

    @Override
    public abstract Short3D view(int[] var1, int[] var2, int[] var3);

    @Override
    public abstract Short1D as1D();
}

