/*
 * Decompiled with CFR 0.152.
 */
package mitiv.random;

import java.util.Date;
import mitiv.random.DoubleGenerator;
import mitiv.random.FloatGenerator;
import mitiv.random.RandomEngine;

public class MersenneTwisterGenerator
extends RandomEngine
implements DoubleGenerator,
FloatGenerator {
    private int mti;
    private final int[] mt = new int[624];
    private static final int N = 624;
    private static final int M = 397;
    private static final int MATRIX_A = -1727483681;
    private static final int UPPER_MASK = Integer.MIN_VALUE;
    private static final int LOWER_MASK = Integer.MAX_VALUE;
    private static final int TEMPERING_MASK_B = -1658038656;
    private static final int TEMPERING_MASK_C = -272236544;
    private static final int mag0 = 0;
    private static final int mag1 = -1727483681;
    public static final int DEFAULT_SEED = 4357;
    protected static final int MIN_VALUE = Integer.MIN_VALUE;
    protected static final int MAX_VALUE = Integer.MAX_VALUE;
    public static final double DBL_SCALE = MersenneTwisterGenerator.standardScale(-2.147483648E9, 2.147483647E9);
    public static final double DBL_BIAS = MersenneTwisterGenerator.standardBias(-2.147483648E9, 2.147483647E9);
    public static final float FLT_SCALE = (float)DBL_SCALE;
    public static final float FLT_BIAS = (float)DBL_BIAS;

    public MersenneTwisterGenerator() {
        this(4357);
    }

    public MersenneTwisterGenerator(int n) {
        this.reset(n);
    }

    public MersenneTwisterGenerator(Date date) {
        this((int)date.getTime());
    }

    private void nextBlock() {
        int n;
        int n2;
        int n3 = 227;
        for (n2 = 0; n2 < n3; ++n2) {
            n = this.mt[n2] & Integer.MIN_VALUE | this.mt[n2 + 1] & Integer.MAX_VALUE;
            this.mt[n2] = this.mt[n2 + 397] ^ n >>> 1 ^ ((n & 1) == 0 ? 0 : -1727483681);
        }
        while (n2 < 623) {
            n = this.mt[n2] & Integer.MIN_VALUE | this.mt[n2 + 1] & Integer.MAX_VALUE;
            this.mt[n2] = this.mt[n2 - n3] ^ n >>> 1 ^ ((n & 1) == 0 ? 0 : -1727483681);
            ++n2;
        }
        n = this.mt[623] & Integer.MIN_VALUE | this.mt[0] & Integer.MAX_VALUE;
        this.mt[623] = this.mt[396] ^ n >>> 1 ^ ((n & 1) == 0 ? 0 : -1727483681);
        this.mti = 0;
    }

    @Override
    public int next() {
        if (this.mti == 624) {
            this.nextBlock();
        }
        int n = this.mt[this.mti++];
        n ^= n >>> 11;
        n ^= n << 7 & 0x9D2C5680;
        n ^= n << 15 & 0xEFC60000;
        n ^= n >>> 18;
        return n;
    }

    @Override
    public void reset(int n) {
        this.mt[0] = n & 0xFFFFFFFF;
        for (int i = 1; i < 624; ++i) {
            this.mt[i] = 1812433253 * (this.mt[i - 1] ^ this.mt[i - 1] >> 30) + i;
        }
        this.mti = 624;
    }

    @Override
    public int min() {
        return Integer.MIN_VALUE;
    }

    @Override
    public int max() {
        return Integer.MAX_VALUE;
    }

    @Override
    public double nextDouble() {
        return DBL_SCALE * (double)this.next() - DBL_BIAS;
    }

    @Override
    public float nextFloat() {
        return FLT_SCALE * (float)this.next() - FLT_BIAS;
    }

    public static void main(String[] stringArray) {
        double d;
        System.out.printf("MIN_VALUE = 0x%08x\n", Integer.MIN_VALUE);
        System.out.printf("MAX_VALUE = 0x%08x\n", Integer.MAX_VALUE);
        System.out.printf("DBL_SCALE = %g\n", DBL_SCALE);
        System.out.printf("DBL_BIAS = %g\n", DBL_BIAS);
        System.out.printf("DBL_BIAS/DBL_SCALE = %g\n", DBL_BIAS / DBL_SCALE);
        MersenneTwisterGenerator mersenneTwisterGenerator = new MersenneTwisterGenerator(7864);
        System.out.printf("Sample:", new Object[0]);
        for (int i = 1; i < 10; ++i) {
            System.out.printf("  %8.6f", mersenneTwisterGenerator.nextDouble());
        }
        System.out.printf("\n", new Object[0]);
        int n = 10000000;
        double d2 = d = mersenneTwisterGenerator.nextDouble();
        double d3 = d;
        for (int i = 1; i < n; ++i) {
            double d4 = mersenneTwisterGenerator.nextDouble();
            d3 += d4;
            if (d4 < d2) {
                d2 = d4;
            }
            if (!(d4 > d)) continue;
            d = d4;
        }
        System.out.printf("Test of %d draws: avg = %g; min = %g; 1 - max = %g;\n", n, d3 / (double)n, d2, 1.0 - d);
    }
}

