/*
 * Decompiled with CFR 0.152.
 */
package mitiv.optim;

import mitiv.exception.IncorrectSpaceException;
import mitiv.linalg.Vector;
import mitiv.linalg.VectorSpace;

public abstract class ConvexSetProjector {
    protected final VectorSpace space;

    protected ConvexSetProjector(VectorSpace vectorSpace) {
        this.space = vectorSpace;
    }

    public VectorSpace getSpace() {
        return this.space;
    }

    public VectorSpace getInputSpace() {
        return this.space;
    }

    public VectorSpace getOutputSpace() {
        return this.space;
    }

    public void projectVariables(Vector vector, Vector vector2) {
        if (vector2 == null || !vector2.belongsTo(this.space) || vector == null || !vector.belongsTo(this.space)) {
            throw new IncorrectSpaceException();
        }
        this._projectVariables(vector, vector2);
    }

    public void projectVariables(Vector vector) {
        if (vector == null || !vector.belongsTo(this.space)) {
            throw new IncorrectSpaceException();
        }
        this._projectVariables(vector, vector);
    }

    protected abstract void _projectVariables(Vector var1, Vector var2);
}

