/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.customizer;

import com.sun.media.customizer.CusRegistry;
import com.sun.media.customizer.CustomDB;
import com.sun.media.customizer.DBItem;
import com.sun.media.customizer.I18N;
import com.sun.media.customizer.ProgressDiag;
import com.sun.media.customizer.TokenDef;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.media.CaptureDeviceInfo;
import javax.media.CaptureDeviceManager;
import javax.media.PlugInManager;

public class ProcessJAR
extends Thread
implements TokenDef {
    public static final String[] sollibs = new String[]{"libCvidPro.so", "libjmcvid.so", "libjmdaud.so", "libjmfCVIDPro.so", "libjmg723.so", "libjmgsm.so", "libjmh261.so", "libjmh263enc.so", "libjmiv32.so", "libjmjpeg.so", "libjmmpa.so", "libjmmpegv.so", "libjmmpx.so", "libjmmpx2.so", "libjmopi.so", "libjmsunray.so", "libjmvh263.so", "libjmxil.so", "libjmxlib.so", "libjsound.so", "soundbank.gm", "sound.jar"};
    public static final String[] win32libs = new String[]{"jmacm.dll", "jmam.dll", "jmcvid.dll", "jmdaud.dll", "jmdaudc.dll", "jmddraw.dll", "jmg723.dll", "jmgdi.dll", "jmgsm.dll", "jmh261.dll", "jmh263enc.dll", "jmiv32.dll", "jmjpeg.dll", "jmmci.dll", "jmmpa.dll", "jmmpegv.dll", "jmvcm.dll", "jmvfw.dll", "jmvh263.dll", "jsound.dll", "soundbank.gm", "sound.jar"};
    public static final Hashtable cdmap = new Hashtable();
    String srcJARname;
    String dstJARname;
    String workDir;
    int[] selected;
    ProgressDiag progressDlg;
    CusRegistry theRegistry;
    int release;
    boolean twojars;

    public ProcessJAR(String srcJARname, String dstJARname, int[] selected, ProgressDiag progressDlg, CusRegistry theRegistry, int release, boolean twojars) {
        this.srcJARname = srcJARname;
        this.dstJARname = dstJARname;
        this.selected = selected;
        this.progressDlg = progressDlg;
        this.theRegistry = theRegistry;
        this.workDir = this.theRegistry.getWorkDir();
        this.release = release;
        this.twojars = twojars;
    }

    public void run() {
        String libname;
        ZipEntry newZE;
        String fullName;
        String rClsName;
        DBItem dbentry;
        int nn;
        FileOutputStream fos;
        File dstFile;
        long entrysize;
        String clsname;
        ZipEntry srcZE;
        File dstFile2 = null;
        int progressSoFar = 0;
        ZipFile srcZF = null;
        ZipOutputStream zos = null;
        ZipOutputStream zos2 = null;
        InputStream is = null;
        try {
            Thread.sleep(30L);
        }
        catch (Exception ex) {
            // empty catch block
        }
        File srcFile = new File(this.srcJARname);
        long srcfilesize = srcFile.length();
        double readRate = 35.0 / (double)srcfilesize;
        try {
            srcZF = new ZipFile(srcFile);
        }
        catch (ZipException e) {
            this.errorMessage(e.getMessage());
            return;
        }
        catch (IOException e) {
            this.errorMessage(e.getMessage());
            return;
        }
        if (CustomDB.getSize() == 0) {
            CustomDB.buildDB();
        } else {
            CustomDB.clearAllMarks();
        }
        Vector<ZipEntry> orglist = new Vector<ZipEntry>();
        Enumeration<? extends ZipEntry> se = srcZF.entries();
        int classCountSoFar = 0;
        long filesizeSoFar = 0L;
        while (se.hasMoreElements()) {
            srcZE = se.nextElement();
            clsname = srcZE.getName();
            if (!clsname.endsWith(".class") && !clsname.endsWith(".gif")) continue;
            orglist.addElement(srcZE);
            entrysize = srcZE.getCompressedSize();
            filesizeSoFar += entrysize;
            if (++classCountSoFar % 5 != 0) continue;
            progressSoFar = (int)(readRate * (double)filesizeSoFar);
            this.progressDlg.updateValue(progressSoFar);
            this.progressDlg.updateSourceInfo(filesizeSoFar, classCountSoFar);
            this.myyield();
        }
        this.progressDlg.updateSourceInfo(srcfilesize, classCountSoFar);
        this.myyield();
        int notwanted = CustomDB.markAllClasses(this.selected);
        double writeRate = 50.0 / (double)(classCountSoFar - notwanted);
        this.progressDlg.updateNote(I18N.getResource("ProcessJAR.REGISTRY"));
        this.myyield();
        this.updateRegistry();
        if (!this.twojars) {
            dstFile = new File(this.dstJARname);
            try {
                fos = new FileOutputStream(dstFile);
                zos = new ZipOutputStream(fos);
            }
            catch (IOException e) {
                try {
                    srcZF.close();
                }
                catch (IOException ex) {
                    // empty catch block
                }
                dstFile.delete();
                this.errorMessage(e.getMessage());
                return;
            }
        }
        dstFile = new File(this.dstJARname);
        String pp = dstFile.getParent() + File.separator;
        String fn = dstFile.getName();
        dstFile = new File(pp + "core_" + fn);
        dstFile2 = new File(pp + "plugin_" + fn);
        try {
            fos = new FileOutputStream(dstFile);
            FileOutputStream fos2 = new FileOutputStream(dstFile2);
            zos = new ZipOutputStream(fos);
            zos2 = new ZipOutputStream(fos2);
        }
        catch (IOException e) {
            try {
                srcZF.close();
            }
            catch (IOException ex) {
                // empty catch block
            }
            dstFile.delete();
            dstFile2.delete();
            this.errorMessage(e.getMessage());
            return;
        }
        classCountSoFar = 0;
        filesizeSoFar = 0L;
        byte[] buffer = new byte[4096];
        this.progressDlg.updateNote(I18N.getResource("ProcessJAR.WRT"));
        this.myyield();
        int NNN = orglist.size();
        if (!this.twojars) {
            nn = 0;
            while (nn < NNN) {
                srcZE = (ZipEntry)orglist.elementAt(nn);
                clsname = srcZE.getName();
                entrysize = srcZE.getCompressedSize();
                dbentry = CustomDB.get(clsname);
                if (dbentry == null || dbentry.isMarked()) {
                    ++classCountSoFar;
                    rClsName = "com/sun/media/util/RegistryLib.class";
                    try {
                        int len;
                        if (clsname.equals(rClsName)) {
                            fullName = rClsName.replace('/', File.separatorChar);
                            fullName = this.workDir + File.separator + fullName;
                            is = new FileInputStream(fullName);
                        } else {
                            is = srcZF.getInputStream(srcZE);
                        }
                        newZE = new ZipEntry(clsname);
                        zos.putNextEntry(newZE);
                        while (is.available() != 0 && (len = is.read(buffer)) != -1) {
                            zos.write(buffer, 0, len);
                        }
                        zos.closeEntry();
                        is.close();
                        if (clsname.equals("com/sun/media/util/RegistryLib.class")) {
                            System.out.println("Default Registry replaced");
                            entrysize = newZE.getCompressedSize();
                        }
                    }
                    catch (IOException e) {
                        try {
                            srcZF.close();
                        }
                        catch (IOException ex) {
                            // empty catch block
                        }
                        dstFile.delete();
                        this.errorMessage(e.getMessage());
                        return;
                    }
                    filesizeSoFar += entrysize;
                }
                if (classCountSoFar % 5 == 0) {
                    progressSoFar = (int)(50.0 + writeRate * (double)classCountSoFar);
                    this.progressDlg.updateValue(progressSoFar);
                    this.progressDlg.updateTargetInfo(filesizeSoFar, classCountSoFar);
                    this.myyield();
                }
                ++nn;
            }
            try {
                zos.close();
                srcZF.close();
            }
            catch (IOException ex) {
                dstFile.delete();
                this.errorMessage(ex.getMessage());
                return;
            }
        }
        nn = 0;
        while (nn < NNN) {
            int len;
            srcZE = (ZipEntry)orglist.elementAt(nn);
            clsname = srcZE.getName();
            entrysize = srcZE.getCompressedSize();
            dbentry = CustomDB.get(clsname);
            if (dbentry == null) {
                ++classCountSoFar;
                try {
                    is = srcZF.getInputStream(srcZE);
                    newZE = new ZipEntry(clsname);
                    zos.putNextEntry(newZE);
                    while (is.available() != 0 && (len = is.read(buffer)) != -1) {
                        zos.write(buffer, 0, len);
                    }
                    zos.closeEntry();
                    is.close();
                }
                catch (IOException e) {
                    try {
                        srcZF.close();
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                    dstFile.delete();
                    this.errorMessage(e.getMessage());
                    return;
                }
            }
            if (dbentry.isMarked()) {
                ++classCountSoFar;
                rClsName = "com/sun/media/util/RegistryLib.class";
                try {
                    if (clsname.equals(rClsName)) {
                        fullName = rClsName.replace('/', File.separatorChar);
                        fullName = this.workDir + File.separator + fullName;
                        is = new FileInputStream(fullName);
                    } else {
                        is = srcZF.getInputStream(srcZE);
                    }
                    newZE = new ZipEntry(clsname);
                    zos2.putNextEntry(newZE);
                    while (is.available() != 0 && (len = is.read(buffer)) != -1) {
                        zos2.write(buffer, 0, len);
                    }
                    zos2.closeEntry();
                    is.close();
                    if (clsname.equals("com/sun/media/util/RegistryLib.class")) {
                        System.out.println("Default Registry replaced");
                        entrysize = newZE.getCompressedSize();
                    }
                }
                catch (IOException e) {
                    try {
                        srcZF.close();
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                    dstFile2.delete();
                    this.errorMessage(e.getMessage());
                    return;
                }
            }
            filesizeSoFar += entrysize;
            if (classCountSoFar % 5 == 0) {
                progressSoFar = (int)(50.0 + writeRate * (double)classCountSoFar);
                this.progressDlg.updateValue(progressSoFar);
                this.progressDlg.updateTargetInfo(filesizeSoFar, classCountSoFar);
                this.myyield();
            }
            ++nn;
        }
        try {
            zos.close();
            zos2.close();
            srcZF.close();
        }
        catch (IOException ex) {
            dstFile.delete();
            dstFile2.delete();
            this.errorMessage(ex.getMessage());
            return;
        }
        long dstfilesize = dstFile.length();
        if (this.twojars) {
            dstfilesize += dstFile2.length();
        }
        this.progressDlg.updateValue(100);
        this.progressDlg.updateTargetInfo(dstfilesize, classCountSoFar);
        this.progressDlg.enableDone();
        if (this.release >= 2) {
            System.out.println("***Needed native modules***");
        }
        if (this.release == 2) {
            libname = null;
            int i = 0;
            while (i < sollibs.length) {
                libname = sollibs[i];
                dbentry = CustomDB.get(libname);
                if (dbentry == null || dbentry.isMarked()) {
                    System.out.println(libname);
                }
                ++i;
            }
            System.out.println("libjmutil.so");
        }
        if (this.release == 3) {
            libname = null;
            int i = 0;
            while (i < win32libs.length) {
                libname = win32libs[i];
                dbentry = CustomDB.get(libname);
                if (dbentry == null || dbentry.isMarked()) {
                    System.out.println(libname);
                }
                ++i;
            }
            System.out.println("jmutil.dll");
        }
    }

    private void errorMessage(String msg) {
        this.progressDlg.sentErr(msg);
        this.myyield();
    }

    private void myyield() {
        try {
            Thread.sleep(15L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updateRegistry() {
        String newpin;
        String pin;
        boolean b_def;
        Hashtable newDefHash;
        Hashtable newFullHash = (Hashtable)this.theRegistry.getFullRegistry().clone();
        boolean b_full = newFullHash != null && newFullHash.size() > 0;
        if (b_full) {
            newDefHash = newFullHash;
            b_def = false;
        } else {
            newDefHash = (Hashtable)this.theRegistry.getDefaultRegistry().clone();
            b_def = newDefHash != null && newDefHash.size() > 0;
        }
        Vector v = PlugInManager.getPlugInList(null, null, (int)1);
        int len = v.size();
        int i = 0;
        while (i < len) {
            pin = (String)v.elementAt(i);
            pin.trim();
            newpin = pin.replace('.', '/') + ".class";
            DBItem dbentry = CustomDB.get(newpin);
            if (dbentry != null && !dbentry.isMarked()) {
                if (b_full) {
                    this.theRegistry.removePlugIn(newFullHash, pin, 1);
                } else if (b_def) {
                    this.theRegistry.removePlugIn(newDefHash, pin, 1);
                }
            }
            ++i;
        }
        v = PlugInManager.getPlugInList(null, null, (int)2);
        len = v.size();
        int i2 = 0;
        while (i2 < len) {
            pin = (String)v.elementAt(i2);
            pin.trim();
            newpin = pin.replace('.', '/') + ".class";
            DBItem dbentry = CustomDB.get(newpin);
            if (dbentry != null && !dbentry.isMarked()) {
                if (b_full) {
                    this.theRegistry.removePlugIn(newFullHash, pin, 2);
                } else if (b_def) {
                    this.theRegistry.removePlugIn(newDefHash, pin, 2);
                }
            }
            ++i2;
        }
        v = PlugInManager.getPlugInList(null, null, (int)5);
        len = v.size();
        int i3 = 0;
        while (i3 < len) {
            pin = (String)v.elementAt(i3);
            pin.trim();
            newpin = pin.replace('.', '/') + ".class";
            DBItem dbentry = CustomDB.get(newpin);
            if (dbentry != null && !dbentry.isMarked()) {
                if (b_full) {
                    this.theRegistry.removePlugIn(newFullHash, pin, 5);
                } else if (b_def) {
                    this.theRegistry.removePlugIn(newDefHash, pin, 5);
                }
            }
            ++i3;
        }
        v = PlugInManager.getPlugInList(null, null, (int)4);
        len = v.size();
        int i4 = 0;
        while (i4 < len) {
            pin = (String)v.elementAt(i4);
            pin.trim();
            newpin = pin.replace('.', '/') + ".class";
            DBItem dbentry = CustomDB.get(newpin);
            if (dbentry != null && !dbentry.isMarked()) {
                if (b_full) {
                    this.theRegistry.removePlugIn(newFullHash, pin, 4);
                } else if (b_def) {
                    this.theRegistry.removePlugIn(newDefHash, pin, 4);
                }
            }
            ++i4;
        }
        v = CaptureDeviceManager.getDeviceList(null);
        len = v.size();
        String dname = null;
        int i5 = 0;
        while (i5 < len) {
            CaptureDeviceInfo info = (CaptureDeviceInfo)v.elementAt(i5);
            dname = info.getLocator().getProtocol();
            if (!this.isCDSelected(dname)) {
                if (b_full) {
                    this.theRegistry.removeCaptureD(newFullHash, dname);
                } else if (b_def) {
                    this.theRegistry.removeCaptureD(newDefHash, dname);
                }
            }
            ++i5;
        }
        if (b_full) {
            this.writeRegistryLib(newFullHash);
        } else if (b_def) {
            this.writeRegistryLib(newDefHash);
        }
        try {
            String[] cmdarr = new String[]{this.theRegistry.getJavacPath() + File.separator + "javac", "-d", this.workDir, this.workDir + File.separator + "RegistryLib.java"};
            Process proc = Runtime.getRuntime().exec(cmdarr);
            proc.waitFor();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (this.release >= 2 && b_full) {
            this.theRegistry.saveRegistry(newFullHash);
        }
        this.progressDlg.updateValue(42);
        this.myyield();
    }

    private boolean isCDSelected(String dname) {
        DBItem dbentry = null;
        String pname = (String)cdmap.get(dname);
        dbentry = CustomDB.get(pname);
        return dbentry != null && dbentry.isMarked();
    }

    private void writeRegistryLib(Hashtable newhash) {
        byte[] properties = null;
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            int tableSize = newhash.size();
            oos.writeInt(tableSize);
            oos.writeInt(200);
            Enumeration e = newhash.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                Object value = newhash.get(key);
                oos.writeUTF(key);
                oos.writeObject(value);
                oos.flush();
            }
            oos.close();
            properties = bos.toByteArray();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.out.println("Sth is wrong when saving the registry");
            return;
        }
        try {
            String registryname = this.workDir + File.separator + "RegistryLib.java";
            DataOutputStream ds = new DataOutputStream(new FileOutputStream(registryname));
            ds.writeBytes("/* Generated by RegistryGen.\n   DO NOT EDIT.*/\n\n");
            ds.writeBytes("package com.sun.media.util;\n\n");
            ds.writeBytes("public abstract class ");
            ds.writeBytes("RegistryLib");
            ds.writeBytes(" {\n\n");
            if (properties.length > 0) {
                ds.writeBytes("   public static byte[] getData(){\n");
                ds.writeBytes("       int i;\n");
                ds.writeBytes("       byte[] b= new byte[" + properties.length + "];\n");
                ds.writeBytes("       for (i=0;i<b.length;i++)\n");
                ds.writeBytes("          b[i] = (byte)(s.charAt(i)-1);\n");
                ds.writeBytes("       return b;\n");
                ds.writeBytes("    }\n");
            } else {
                ds.writeBytes("   public static byte[] getData(){\n");
                ds.writeBytes("       return null;\n");
                ds.writeBytes("    }\n");
            }
            ds.writeBytes("    private static String s = \n        ");
            ds.writeBytes("\"");
            int len = properties.length;
            int j = 0;
            while (j < len) {
                ds.writeBytes("\\" + ProcessJAR.byte2oct((byte)(1 + properties[j])));
                if (j % 16 == 15) {
                    ds.writeBytes("\"+\n        \"");
                }
                ++j;
            }
            ds.writeBytes("\";\n\n");
            ds.writeBytes("}\n");
            ds.close();
        }
        catch (Exception ex) {
            System.out.println("Sth wrong when writing RegsitryLib");
        }
    }

    private static String byte2oct(byte b) {
        int i = b & 0xFF;
        int dig3 = i % 8;
        int dig2 = i / 8 % 8;
        int dig1 = i / 64;
        return "" + dig1 + "" + dig2 + "" + dig3;
    }

    static {
        cdmap.put("dsound", "com/sun/media/protocol/dsound/DataSource.class");
        cdmap.put("javasound", "com/sun/media/protocol/javasound/DataSource.class");
        cdmap.put("vfw", "com/sun/media/protocol/vfw/DataSource.class");
        cdmap.put("sunvideo", "com/sun/media/protocol/sunvideo/DataSource.class");
        cdmap.put("sunvideoplus", "com/sun/media/protocol/sunvideoplus/DataSource.class");
    }
}

