/*
 * Decompiled with CFR 0.152.
 */
package mitiv.base.indexing;

import mitiv.base.indexing.Range;
import mitiv.exception.IllegalRangeException;

public class CompiledRange {
    public final int offset;
    public final int stride;
    public final int number;
    public final boolean nothing;

    public CompiledRange(Range range, int n) {
        if (range == null) {
            this.offset = 0;
            this.stride = 1;
            this.number = n;
            this.nothing = true;
        } else {
            int n2 = range.getFirst(n);
            int n3 = range.getLast(n);
            int n4 = range.getStep();
            this.number = CompiledRange.count(n2, n3, n4, n);
            this.offset = n2;
            this.stride = n4;
            this.nothing = n2 == 0 && this.number == n && (n4 == 1 || n == 1);
        }
    }

    public CompiledRange(Range range, int n, int n2, int n3) {
        if (range == null) {
            this.offset = n2;
            this.stride = n3;
            this.number = n;
            this.nothing = true;
        } else {
            int n4 = range.getFirst(n);
            int n5 = range.getLast(n);
            int n6 = range.getStep();
            this.number = CompiledRange.count(n4, n5, n6, n);
            this.offset = n2 + n4 * n3;
            this.stride = n6 * n3;
            this.nothing = n4 == 0 && this.number == n && (n6 == 1 || n == 1);
        }
    }

    private static final int count(int n, int n2, int n3, int n4) {
        if (n <= n2) {
            if (0 <= n && n2 < n4) {
                if (n3 > 0) {
                    return (n2 - n) / n3 + 1;
                }
                if (n3 < 0) {
                    CompiledRange.emptyRange();
                } else {
                    CompiledRange.illegalStep();
                }
            }
        } else if (0 <= n2 && n < n4) {
            if (n3 < 0) {
                return (n2 - n) / n3 + 1;
            }
            if (n3 > 0) {
                CompiledRange.emptyRange();
            } else {
                CompiledRange.illegalStep();
            }
        }
        throw new IndexOutOfBoundsException("Range is outside bounds");
    }

    private static final void emptyRange() {
        throw new IllegalRangeException("Empty range");
    }

    private static final void illegalStep() {
        throw new IllegalRangeException("Illegal 0 step");
    }

    public final int getOffset() {
        return this.offset;
    }

    public final int getStride() {
        return this.stride;
    }

    public final int getNumber() {
        return this.number;
    }

    public final boolean doesNothing() {
        return this.nothing;
    }
}

