/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif;

import com.drew.imaging.PhotographicConversions;
import com.drew.lang.Rational;
import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.TagDescriptor;
import com.drew.metadata.exif.ExifSubIFDDirectory;
import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExifSubIFDDescriptor
extends TagDescriptor<ExifSubIFDDirectory> {
    private final boolean _allowDecimalRepresentationOfRationals = true;
    @NotNull
    private static final DecimalFormat SimpleDecimalFormatter = new DecimalFormat("0.#");

    public ExifSubIFDDescriptor(@NotNull ExifSubIFDDirectory directory) {
        super(directory);
    }

    @Override
    @Nullable
    public String getDescription(int tagType) {
        switch (tagType) {
            case 254: {
                return this.getNewSubfileTypeDescription();
            }
            case 255: {
                return this.getSubfileTypeDescription();
            }
            case 263: {
                return this.getThresholdingDescription();
            }
            case 266: {
                return this.getFillOrderDescription();
            }
            case 33434: {
                return this.getExposureTimeDescription();
            }
            case 37377: {
                return this.getShutterSpeedDescription();
            }
            case 33437: {
                return this.getFNumberDescription();
            }
            case 37122: {
                return this.getCompressedAverageBitsPerPixelDescription();
            }
            case 37382: {
                return this.getSubjectDistanceDescription();
            }
            case 37383: {
                return this.getMeteringModeDescription();
            }
            case 37384: {
                return this.getWhiteBalanceDescription();
            }
            case 37385: {
                return this.getFlashDescription();
            }
            case 37386: {
                return this.getFocalLengthDescription();
            }
            case 40961: {
                return this.getColorSpaceDescription();
            }
            case 40962: {
                return this.getExifImageWidthDescription();
            }
            case 40963: {
                return this.getExifImageHeightDescription();
            }
            case 41488: {
                return this.getFocalPlaneResolutionUnitDescription();
            }
            case 41486: {
                return this.getFocalPlaneXResolutionDescription();
            }
            case 41487: {
                return this.getFocalPlaneYResolutionDescription();
            }
            case 258: {
                return this.getBitsPerSampleDescription();
            }
            case 262: {
                return this.getPhotometricInterpretationDescription();
            }
            case 278: {
                return this.getRowsPerStripDescription();
            }
            case 279: {
                return this.getStripByteCountsDescription();
            }
            case 277: {
                return this.getSamplesPerPixelDescription();
            }
            case 284: {
                return this.getPlanarConfigurationDescription();
            }
            case 530: {
                return this.getYCbCrSubsamplingDescription();
            }
            case 34850: {
                return this.getExposureProgramDescription();
            }
            case 37378: {
                return this.getApertureValueDescription();
            }
            case 37381: {
                return this.getMaxApertureValueDescription();
            }
            case 41495: {
                return this.getSensingMethodDescription();
            }
            case 37380: {
                return this.getExposureBiasDescription();
            }
            case 41728: {
                return this.getFileSourceDescription();
            }
            case 41729: {
                return this.getSceneTypeDescription();
            }
            case 37121: {
                return this.getComponentConfigurationDescription();
            }
            case 36864: {
                return this.getExifVersionDescription();
            }
            case 40960: {
                return this.getFlashPixVersionDescription();
            }
            case 34855: {
                return this.getIsoEquivalentDescription();
            }
            case 37510: {
                return this.getUserCommentDescription();
            }
            case 41985: {
                return this.getCustomRenderedDescription();
            }
            case 41986: {
                return this.getExposureModeDescription();
            }
            case 41987: {
                return this.getWhiteBalanceModeDescription();
            }
            case 41988: {
                return this.getDigitalZoomRatioDescription();
            }
            case 41989: {
                return this.get35mmFilmEquivFocalLengthDescription();
            }
            case 41990: {
                return this.getSceneCaptureTypeDescription();
            }
            case 41991: {
                return this.getGainControlDescription();
            }
            case 41992: {
                return this.getContrastDescription();
            }
            case 41993: {
                return this.getSaturationDescription();
            }
            case 41994: {
                return this.getSharpnessDescription();
            }
            case 41996: {
                return this.getSubjectDistanceRangeDescription();
            }
        }
        return super.getDescription(tagType);
    }

    @Nullable
    public String getNewSubfileTypeDescription() {
        Integer value = ((ExifSubIFDDirectory)this._directory).getInteger(254);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                return "Full-resolution image";
            }
            case 2: {
                return "Reduced-resolution image";
            }
            case 3: {
                return "Single page of multi-page reduced-resolution image";
            }
            case 4: {
                return "Transparency mask";
            }
            case 5: {
                return "Transparency mask of reduced-resolution image";
            }
            case 6: {
                return "Transparency mask of multi-page image";
            }
            case 7: {
                return "Transparency mask of reduced-resolution multi-page image";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getSubfileTypeDescription() {
        Integer value = ((ExifSubIFDDirectory)this._directory).getInteger(255);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                return "Full-resolution image";
            }
            case 2: {
                return "Reduced-resolution image";
            }
            case 3: {
                return "Single page of multi-page image";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getThresholdingDescription() {
        Integer value = ((ExifSubIFDDirectory)this._directory).getInteger(263);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                return "No dithering or halftoning";
            }
            case 2: {
                return "Ordered dither or halftone";
            }
            case 3: {
                return "Randomized dither";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getFillOrderDescription() {
        Integer value = ((ExifSubIFDDirectory)this._directory).getInteger(266);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                return "Normal";
            }
            case 2: {
                return "Reversed";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getSubjectDistanceRangeDescription() {
        Integer value = ((ExifSubIFDDirectory)this._directory).getInteger(41996);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "Unknown";
            }
            case 1: {
                return "Macro";
            }
            case 2: {
                return "Close view";
            }
            case 3: {
                return "Distant view";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getSharpnessDescription() {
        Integer value = ((ExifSubIFDDirectory)this._directory).getInteger(41994);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "None";
            }
            case 1: {
                return "Low";
            }
            case 2: {
                return "Hard";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getSaturationDescription() {
        Integer value = ((ExifSubIFDDirectory)this._directory).getInteger(41993);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "None";
            }
            case 1: {
                return "Low saturation";
            }
            case 2: {
                return "High saturation";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getContrastDescription() {
        Integer value = ((ExifSubIFDDirectory)this._directory).getInteger(41992);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "None";
            }
            case 1: {
                return "Soft";
            }
            case 2: {
                return "Hard";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getGainControlDescription() {
        Integer value = ((ExifSubIFDDirectory)this._directory).getInteger(41991);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "None";
            }
            case 1: {
                return "Low gain up";
            }
            case 2: {
                return "Low gain down";
            }
            case 3: {
                return "High gain up";
            }
            case 4: {
                return "High gain down";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getSceneCaptureTypeDescription() {
        Integer value = ((ExifSubIFDDirectory)this._directory).getInteger(41990);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "Standard";
            }
            case 1: {
                return "Landscape";
            }
            case 2: {
                return "Portrait";
            }
            case 3: {
                return "Night scene";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String get35mmFilmEquivFocalLengthDescription() {
        Integer value = ((ExifSubIFDDirectory)this._directory).getInteger(41989);
        if (value == null) {
            return null;
        }
        if (value == 0) {
            return "Unknown";
        }
        return SimpleDecimalFormatter.format(value) + "mm";
    }

    @Nullable
    public String getDigitalZoomRatioDescription() {
        Rational value = ((ExifSubIFDDirectory)this._directory).getRational(41988);
        if (value == null) {
            return null;
        }
        if (value.getNumerator() == 0L) {
            return "Digital zoom not used.";
        }
        return SimpleDecimalFormatter.format(value.doubleValue());
    }

    @Nullable
    public String getWhiteBalanceModeDescription() {
        Integer value = ((ExifSubIFDDirectory)this._directory).getInteger(41987);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "Auto white balance";
            }
            case 1: {
                return "Manual white balance";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getExposureModeDescription() {
        Integer value = ((ExifSubIFDDirectory)this._directory).getInteger(41986);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "Auto exposure";
            }
            case 1: {
                return "Manual exposure";
            }
            case 2: {
                return "Auto bracket";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getCustomRenderedDescription() {
        Integer value = ((ExifSubIFDDirectory)this._directory).getInteger(41985);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "Normal process";
            }
            case 1: {
                return "Custom process";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getUserCommentDescription() {
        byte[] commentBytes = ((ExifSubIFDDirectory)this._directory).getByteArray(37510);
        if (commentBytes == null) {
            return null;
        }
        if (commentBytes.length == 0) {
            return "";
        }
        HashMap<String, String> encodingMap = new HashMap<String, String>();
        encodingMap.put("ASCII", System.getProperty("file.encoding"));
        encodingMap.put("UNICODE", "UTF-16LE");
        encodingMap.put("JIS", "Shift-JIS");
        try {
            if (commentBytes.length >= 10) {
                String firstTenBytesString = new String(commentBytes, 0, 10);
                for (Map.Entry pair : encodingMap.entrySet()) {
                    String encodingName = (String)pair.getKey();
                    String charset = (String)pair.getValue();
                    if (!firstTenBytesString.startsWith(encodingName)) continue;
                    for (int j = encodingName.length(); j < 10; ++j) {
                        byte b = commentBytes[j];
                        if (b == 0 || b == 32) continue;
                        return new String(commentBytes, j, commentBytes.length - j, charset).trim();
                    }
                    return new String(commentBytes, 10, commentBytes.length - 10, charset).trim();
                }
            }
            return new String(commentBytes, System.getProperty("file.encoding")).trim();
        }
        catch (UnsupportedEncodingException ex) {
            return null;
        }
    }

    @Nullable
    public String getIsoEquivalentDescription() {
        Integer isoEquiv = ((ExifSubIFDDirectory)this._directory).getInteger(34855);
        if (isoEquiv == null) {
            return null;
        }
        return Integer.toString(isoEquiv);
    }

    @Nullable
    public String getExifVersionDescription() {
        int[] ints = ((ExifSubIFDDirectory)this._directory).getIntArray(36864);
        if (ints == null) {
            return null;
        }
        return ExifSubIFDDescriptor.convertBytesToVersionString(ints, 2);
    }

    @Nullable
    public String getFlashPixVersionDescription() {
        int[] ints = ((ExifSubIFDDirectory)this._directory).getIntArray(40960);
        if (ints == null) {
            return null;
        }
        return ExifSubIFDDescriptor.convertBytesToVersionString(ints, 2);
    }

    @Nullable
    public String getSceneTypeDescription() {
        Integer sceneType = ((ExifSubIFDDirectory)this._directory).getInteger(41729);
        if (sceneType == null) {
            return null;
        }
        return sceneType == 1 ? "Directly photographed image" : "Unknown (" + sceneType + ")";
    }

    @Nullable
    public String getFileSourceDescription() {
        Integer fileSource = ((ExifSubIFDDirectory)this._directory).getInteger(41728);
        if (fileSource == null) {
            return null;
        }
        return fileSource == 3 ? "Digital Still Camera (DSC)" : "Unknown (" + fileSource + ")";
    }

    @Nullable
    public String getExposureBiasDescription() {
        Rational value = ((ExifSubIFDDirectory)this._directory).getRational(37380);
        if (value == null) {
            return null;
        }
        return value.toSimpleString(true) + " EV";
    }

    @Nullable
    public String getMaxApertureValueDescription() {
        Double aperture = ((ExifSubIFDDirectory)this._directory).getDoubleObject(37381);
        if (aperture == null) {
            return null;
        }
        double fStop = PhotographicConversions.apertureToFStop(aperture);
        return "F" + SimpleDecimalFormatter.format(fStop);
    }

    @Nullable
    public String getApertureValueDescription() {
        Double aperture = ((ExifSubIFDDirectory)this._directory).getDoubleObject(37378);
        if (aperture == null) {
            return null;
        }
        double fStop = PhotographicConversions.apertureToFStop(aperture);
        return "F" + SimpleDecimalFormatter.format(fStop);
    }

    @Nullable
    public String getExposureProgramDescription() {
        Integer value = ((ExifSubIFDDirectory)this._directory).getInteger(34850);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                return "Manual control";
            }
            case 2: {
                return "Program normal";
            }
            case 3: {
                return "Aperture priority";
            }
            case 4: {
                return "Shutter priority";
            }
            case 5: {
                return "Program creative (slow program)";
            }
            case 6: {
                return "Program action (high-speed program)";
            }
            case 7: {
                return "Portrait mode";
            }
            case 8: {
                return "Landscape mode";
            }
        }
        return "Unknown program (" + value + ")";
    }

    @Nullable
    public String getYCbCrSubsamplingDescription() {
        int[] positions = ((ExifSubIFDDirectory)this._directory).getIntArray(530);
        if (positions == null) {
            return null;
        }
        if (positions[0] == 2 && positions[1] == 1) {
            return "YCbCr4:2:2";
        }
        if (positions[0] == 2 && positions[1] == 2) {
            return "YCbCr4:2:0";
        }
        return "(Unknown)";
    }

    @Nullable
    public String getPlanarConfigurationDescription() {
        Integer value = ((ExifSubIFDDirectory)this._directory).getInteger(284);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                return "Chunky (contiguous for each subsampling pixel)";
            }
            case 2: {
                return "Separate (Y-plane/Cb-plane/Cr-plane format)";
            }
        }
        return "Unknown configuration";
    }

    @Nullable
    public String getSamplesPerPixelDescription() {
        String value = ((ExifSubIFDDirectory)this._directory).getString(277);
        return value == null ? null : value + " samples/pixel";
    }

    @Nullable
    public String getRowsPerStripDescription() {
        String value = ((ExifSubIFDDirectory)this._directory).getString(278);
        return value == null ? null : value + " rows/strip";
    }

    @Nullable
    public String getStripByteCountsDescription() {
        String value = ((ExifSubIFDDirectory)this._directory).getString(279);
        return value == null ? null : value + " bytes";
    }

    @Nullable
    public String getPhotometricInterpretationDescription() {
        Integer value = ((ExifSubIFDDirectory)this._directory).getInteger(262);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "WhiteIsZero";
            }
            case 1: {
                return "BlackIsZero";
            }
            case 2: {
                return "RGB";
            }
            case 3: {
                return "RGB Palette";
            }
            case 4: {
                return "Transparency Mask";
            }
            case 5: {
                return "CMYK";
            }
            case 6: {
                return "YCbCr";
            }
            case 8: {
                return "CIELab";
            }
            case 9: {
                return "ICCLab";
            }
            case 10: {
                return "ITULab";
            }
            case 32803: {
                return "Color Filter Array";
            }
            case 32844: {
                return "Pixar LogL";
            }
            case 32845: {
                return "Pixar LogLuv";
            }
            case 32892: {
                return "Linear Raw";
            }
        }
        return "Unknown colour space";
    }

    @Nullable
    public String getBitsPerSampleDescription() {
        String value = ((ExifSubIFDDirectory)this._directory).getString(258);
        return value == null ? null : value + " bits/component/pixel";
    }

    @Nullable
    public String getFocalPlaneXResolutionDescription() {
        Rational rational = ((ExifSubIFDDirectory)this._directory).getRational(41486);
        if (rational == null) {
            return null;
        }
        String unit = this.getFocalPlaneResolutionUnitDescription();
        return rational.getReciprocal().toSimpleString(true) + (unit == null ? "" : " " + unit.toLowerCase());
    }

    @Nullable
    public String getFocalPlaneYResolutionDescription() {
        Rational rational = ((ExifSubIFDDirectory)this._directory).getRational(41487);
        if (rational == null) {
            return null;
        }
        String unit = this.getFocalPlaneResolutionUnitDescription();
        return rational.getReciprocal().toSimpleString(true) + (unit == null ? "" : " " + unit.toLowerCase());
    }

    @Nullable
    public String getFocalPlaneResolutionUnitDescription() {
        Integer value = ((ExifSubIFDDirectory)this._directory).getInteger(41488);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                return "(No unit)";
            }
            case 2: {
                return "Inches";
            }
            case 3: {
                return "cm";
            }
        }
        return "";
    }

    @Nullable
    public String getExifImageWidthDescription() {
        Integer value = ((ExifSubIFDDirectory)this._directory).getInteger(40962);
        if (value == null) {
            return null;
        }
        return value + " pixels";
    }

    @Nullable
    public String getExifImageHeightDescription() {
        Integer value = ((ExifSubIFDDirectory)this._directory).getInteger(40963);
        if (value == null) {
            return null;
        }
        return value + " pixels";
    }

    @Nullable
    public String getColorSpaceDescription() {
        Integer value = ((ExifSubIFDDirectory)this._directory).getInteger(40961);
        if (value == null) {
            return null;
        }
        if (value == 1) {
            return "sRGB";
        }
        if (value == 65535) {
            return "Undefined";
        }
        return "Unknown";
    }

    @Nullable
    public String getFocalLengthDescription() {
        Rational value = ((ExifSubIFDDirectory)this._directory).getRational(37386);
        if (value == null) {
            return null;
        }
        DecimalFormat formatter = new DecimalFormat("0.0##");
        return formatter.format(value.doubleValue()) + " mm";
    }

    @Nullable
    public String getFlashDescription() {
        Integer value = ((ExifSubIFDDirectory)this._directory).getInteger(37385);
        if (value == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        if ((value & 1) != 0) {
            sb.append("Flash fired");
        } else {
            sb.append("Flash did not fire");
        }
        if ((value & 4) != 0) {
            if ((value & 2) != 0) {
                sb.append(", return detected");
            } else {
                sb.append(", return not detected");
            }
        }
        if ((value & 0x10) != 0) {
            sb.append(", auto");
        }
        if ((value & 0x40) != 0) {
            sb.append(", red-eye reduction");
        }
        return sb.toString();
    }

    @Nullable
    public String getWhiteBalanceDescription() {
        Integer value = ((ExifSubIFDDirectory)this._directory).getInteger(37384);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "Unknown";
            }
            case 1: {
                return "Daylight";
            }
            case 2: {
                return "Florescent";
            }
            case 3: {
                return "Tungsten";
            }
            case 10: {
                return "Flash";
            }
            case 17: {
                return "Standard light";
            }
            case 18: {
                return "Standard light (B)";
            }
            case 19: {
                return "Standard light (C)";
            }
            case 20: {
                return "D55";
            }
            case 21: {
                return "D65";
            }
            case 22: {
                return "D75";
            }
            case 255: {
                return "(Other)";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getMeteringModeDescription() {
        Integer value = ((ExifSubIFDDirectory)this._directory).getInteger(37383);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "Unknown";
            }
            case 1: {
                return "Average";
            }
            case 2: {
                return "Center weighted average";
            }
            case 3: {
                return "Spot";
            }
            case 4: {
                return "Multi-spot";
            }
            case 5: {
                return "Multi-segment";
            }
            case 6: {
                return "Partial";
            }
            case 255: {
                return "(Other)";
            }
        }
        return "";
    }

    @Nullable
    public String getSubjectDistanceDescription() {
        Rational value = ((ExifSubIFDDirectory)this._directory).getRational(37382);
        if (value == null) {
            return null;
        }
        DecimalFormat formatter = new DecimalFormat("0.0##");
        return formatter.format(value.doubleValue()) + " metres";
    }

    @Nullable
    public String getCompressedAverageBitsPerPixelDescription() {
        Rational value = ((ExifSubIFDDirectory)this._directory).getRational(37122);
        if (value == null) {
            return null;
        }
        String ratio = value.toSimpleString(true);
        if (value.isInteger() && value.intValue() == 1) {
            return ratio + " bit/pixel";
        }
        return ratio + " bits/pixel";
    }

    @Nullable
    public String getExposureTimeDescription() {
        String value = ((ExifSubIFDDirectory)this._directory).getString(33434);
        return value == null ? null : value + " sec";
    }

    @Nullable
    public String getShutterSpeedDescription() {
        Float apexValue = ((ExifSubIFDDirectory)this._directory).getFloatObject(37377);
        if (apexValue == null) {
            return null;
        }
        if (apexValue.floatValue() <= 1.0f) {
            float apexPower = (float)(1.0 / Math.exp((double)apexValue.floatValue() * Math.log(2.0)));
            long apexPower10 = Math.round((double)apexPower * 10.0);
            float fApexPower = (float)apexPower10 / 10.0f;
            return fApexPower + " sec";
        }
        int apexPower = (int)Math.exp((double)apexValue.floatValue() * Math.log(2.0));
        return "1/" + apexPower + " sec";
    }

    @Nullable
    public String getFNumberDescription() {
        Rational value = ((ExifSubIFDDirectory)this._directory).getRational(33437);
        if (value == null) {
            return null;
        }
        return "F" + SimpleDecimalFormatter.format(value.doubleValue());
    }

    @Nullable
    public String getSensingMethodDescription() {
        Integer value = ((ExifSubIFDDirectory)this._directory).getInteger(41495);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                return "(Not defined)";
            }
            case 2: {
                return "One-chip color area sensor";
            }
            case 3: {
                return "Two-chip color area sensor";
            }
            case 4: {
                return "Three-chip color area sensor";
            }
            case 5: {
                return "Color sequential area sensor";
            }
            case 7: {
                return "Trilinear sensor";
            }
            case 8: {
                return "Color sequential linear sensor";
            }
        }
        return "";
    }

    @Nullable
    public String getComponentConfigurationDescription() {
        int[] components = ((ExifSubIFDDirectory)this._directory).getIntArray(37121);
        if (components == null) {
            return null;
        }
        String[] componentStrings = new String[]{"", "Y", "Cb", "Cr", "R", "G", "B"};
        StringBuilder componentConfig = new StringBuilder();
        for (int i = 0; i < Math.min(4, components.length); ++i) {
            int j = components[i];
            if (j <= 0 || j >= componentStrings.length) continue;
            componentConfig.append(componentStrings[j]);
        }
        return componentConfig.toString();
    }
}

