/*
 * Decompiled with CFR 0.152.
 */
package microTiPi.microUtils;

import microTiPi.microscopy.MicroscopeModel;
import microTiPi.microscopy.PSF_Estimation;
import mitiv.array.ArrayUtils;
import mitiv.array.ShapedArray;
import mitiv.jobs.DeconvolutionJob;

public class BlindDeconvJob {
    private int totalNbOfBlindDecLoop;
    private ShapedArray psfArray;
    private boolean debug = false;
    private PSF_Estimation psfEstimation;
    private DeconvolutionJob deconvolver;
    private int[] parametersFlags;
    private boolean run = false;
    private int[] maxIter;

    public BlindDeconvJob(int n, int[] nArray, int[] nArray2, PSF_Estimation pSF_Estimation, DeconvolutionJob deconvolutionJob, boolean bl) {
        this.totalNbOfBlindDecLoop = n;
        this.parametersFlags = nArray;
        this.maxIter = nArray2;
        this.psfEstimation = pSF_Estimation;
        this.deconvolver = deconvolutionJob;
        this.debug = bl;
    }

    public ShapedArray blindDeconv(ShapedArray shapedArray) {
        this.run = true;
        for (int i = 0; i < this.totalNbOfBlindDecLoop; ++i) {
            this.psfArray = ArrayUtils.roll((ShapedArray)this.psfEstimation.getPupil().getPsf());
            this.psfEstimation.freeMem();
            this.deconvolver.updatePsf(this.psfArray);
            shapedArray = this.deconvolver.deconv(shapedArray);
            if (!this.run) {
                return shapedArray;
            }
            this.psfEstimation.setObj(shapedArray);
            for (int j = 0; j < this.parametersFlags.length; ++j) {
                if (this.debug) {
                    System.out.println("------------------");
                    System.out.println("  " + j + " estimation");
                    System.out.println("------------------");
                }
                this.psfEstimation.setRelativeTolerance(0.0);
                this.psfEstimation.setMaximumIterations(this.maxIter[j]);
                this.psfEstimation.fitPSF(this.parametersFlags[j]);
                if (this.run) continue;
                return shapedArray;
            }
        }
        this.run = false;
        return shapedArray;
    }

    public boolean isRunning() {
        return this.run;
    }

    public void abort() {
        System.out.println("abort");
        this.run = false;
        this.deconvolver.abort();
        this.psfEstimation.abort();
    }

    public ShapedArray getPsf() {
        return this.psfArray;
    }

    public MicroscopeModel getPupil() {
        return this.psfEstimation.getPupil();
    }
}

