/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.Array7D;
import mitiv.array.Byte7D;
import mitiv.array.Double7D;
import mitiv.array.Float7D;
import mitiv.array.Int7D;
import mitiv.array.Long7D;
import mitiv.array.ShapedArray;
import mitiv.array.Short1D;
import mitiv.array.Short6D;
import mitiv.array.ShortArray;
import mitiv.array.impl.FlatShort7D;
import mitiv.array.impl.StriddenShort7D;
import mitiv.base.Shape;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.ShortFunction;
import mitiv.base.mapping.ShortScanner;
import mitiv.exception.IllegalTypeException;
import mitiv.exception.NonConformableArrayException;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.random.ShortGenerator;

public abstract class Short7D
extends Array7D
implements ShortArray {
    protected Short7D(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        super(n, n2, n3, n4, n5, n6, n7);
    }

    protected Short7D(int[] nArray) {
        super(nArray);
    }

    protected Short7D(Shape shape) {
        super(shape);
    }

    @Override
    public final int getType() {
        return 1;
    }

    public abstract short get(int var1, int var2, int var3, int var4, int var5, int var6, int var7);

    public abstract void set(int var1, int var2, int var3, int var4, int var5, int var6, int var7, short var8);

    @Override
    public void fill(short s) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        this.set(i, j, k, i2, i3, i4, i5, s);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim7; ++i) {
                for (int j = 0; j < this.dim6; ++j) {
                    for (int k = 0; k < this.dim5; ++k) {
                        for (int i6 = 0; i6 < this.dim4; ++i6) {
                            for (int i7 = 0; i7 < this.dim3; ++i7) {
                                for (int i8 = 0; i8 < this.dim2; ++i8) {
                                    for (int i9 = 0; i9 < this.dim1; ++i9) {
                                        this.set(i9, i8, i7, i6, k, j, i, s);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void increment(short s) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        this.set(i, j, k, i2, i3, i4, i5, (short)(this.get(i, j, k, i2, i3, i4, i5) + s));
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim7; ++i) {
                for (int j = 0; j < this.dim6; ++j) {
                    for (int k = 0; k < this.dim5; ++k) {
                        for (int i6 = 0; i6 < this.dim4; ++i6) {
                            for (int i7 = 0; i7 < this.dim3; ++i7) {
                                for (int i8 = 0; i8 < this.dim2; ++i8) {
                                    for (int i9 = 0; i9 < this.dim1; ++i9) {
                                        this.set(i9, i8, i7, i6, k, j, i, (short)(this.get(i9, i8, i7, i6, k, j, i) + s));
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void decrement(short s) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        this.set(i, j, k, i2, i3, i4, i5, (short)(this.get(i, j, k, i2, i3, i4, i5) - s));
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim7; ++i) {
                for (int j = 0; j < this.dim6; ++j) {
                    for (int k = 0; k < this.dim5; ++k) {
                        for (int i6 = 0; i6 < this.dim4; ++i6) {
                            for (int i7 = 0; i7 < this.dim3; ++i7) {
                                for (int i8 = 0; i8 < this.dim2; ++i8) {
                                    for (int i9 = 0; i9 < this.dim1; ++i9) {
                                        this.set(i9, i8, i7, i6, k, j, i, (short)(this.get(i9, i8, i7, i6, k, j, i) - s));
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void scale(short s) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        this.set(i, j, k, i2, i3, i4, i5, (short)(this.get(i, j, k, i2, i3, i4, i5) * s));
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim7; ++i) {
                for (int j = 0; j < this.dim6; ++j) {
                    for (int k = 0; k < this.dim5; ++k) {
                        for (int i6 = 0; i6 < this.dim4; ++i6) {
                            for (int i7 = 0; i7 < this.dim3; ++i7) {
                                for (int i8 = 0; i8 < this.dim2; ++i8) {
                                    for (int i9 = 0; i9 < this.dim1; ++i9) {
                                        this.set(i9, i8, i7, i6, k, j, i, (short)(this.get(i9, i8, i7, i6, k, j, i) * s));
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void map(ShortFunction shortFunction) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        this.set(i, j, k, i2, i3, i4, i5, shortFunction.apply(this.get(i, j, k, i2, i3, i4, i5)));
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim7; ++i) {
                for (int j = 0; j < this.dim6; ++j) {
                    for (int k = 0; k < this.dim5; ++k) {
                        for (int i6 = 0; i6 < this.dim4; ++i6) {
                            for (int i7 = 0; i7 < this.dim3; ++i7) {
                                for (int i8 = 0; i8 < this.dim2; ++i8) {
                                    for (int i9 = 0; i9 < this.dim1; ++i9) {
                                        this.set(i9, i8, i7, i6, k, j, i, shortFunction.apply(this.get(i9, i8, i7, i6, k, j, i)));
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void fill(ShortGenerator shortGenerator) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        this.set(i, j, k, i2, i3, i4, i5, shortGenerator.nextShort());
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim7; ++i) {
                for (int j = 0; j < this.dim6; ++j) {
                    for (int k = 0; k < this.dim5; ++k) {
                        for (int i6 = 0; i6 < this.dim4; ++i6) {
                            for (int i7 = 0; i7 < this.dim3; ++i7) {
                                for (int i8 = 0; i8 < this.dim2; ++i8) {
                                    for (int i9 = 0; i9 < this.dim1; ++i9) {
                                        this.set(i9, i8, i7, i6, k, j, i, shortGenerator.nextShort());
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void scan(ShortScanner shortScanner) {
        boolean bl = false;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        if (bl) {
                                            shortScanner.update(this.get(i, j, k, i2, i3, i4, i5));
                                            continue;
                                        }
                                        shortScanner.initialize(this.get(i, j, k, i2, i3, i4, i5));
                                        bl = true;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim7; ++i) {
                for (int j = 0; j < this.dim6; ++j) {
                    for (int k = 0; k < this.dim5; ++k) {
                        for (int i6 = 0; i6 < this.dim4; ++i6) {
                            for (int i7 = 0; i7 < this.dim3; ++i7) {
                                for (int i8 = 0; i8 < this.dim2; ++i8) {
                                    for (int i9 = 0; i9 < this.dim1; ++i9) {
                                        if (bl) {
                                            shortScanner.update(this.get(i9, i8, i7, i6, k, j, i));
                                            continue;
                                        }
                                        shortScanner.initialize(this.get(i9, i8, i7, i6, k, j, i));
                                        bl = true;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public final short[] flatten() {
        return this.flatten(false);
    }

    @Override
    public short min() {
        short s = this.get(0, 0, 0, 0, 0, 0, 0);
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        if (bl) {
                                            bl = false;
                                            continue;
                                        }
                                        short s2 = this.get(i, j, k, i2, i3, i4, i5);
                                        if (s2 >= s) continue;
                                        s = s2;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim7; ++i) {
                for (int j = 0; j < this.dim6; ++j) {
                    for (int k = 0; k < this.dim5; ++k) {
                        for (int i6 = 0; i6 < this.dim4; ++i6) {
                            for (int i7 = 0; i7 < this.dim3; ++i7) {
                                for (int i8 = 0; i8 < this.dim2; ++i8) {
                                    for (int i9 = 0; i9 < this.dim1; ++i9) {
                                        if (bl) {
                                            bl = false;
                                            continue;
                                        }
                                        short s3 = this.get(i9, i8, i7, i6, k, j, i);
                                        if (s3 >= s) continue;
                                        s = s3;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return s;
    }

    @Override
    public short max() {
        short s = this.get(0, 0, 0, 0, 0, 0, 0);
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        if (bl) {
                                            bl = false;
                                            continue;
                                        }
                                        short s2 = this.get(i, j, k, i2, i3, i4, i5);
                                        if (s2 <= s) continue;
                                        s = s2;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim7; ++i) {
                for (int j = 0; j < this.dim6; ++j) {
                    for (int k = 0; k < this.dim5; ++k) {
                        for (int i6 = 0; i6 < this.dim4; ++i6) {
                            for (int i7 = 0; i7 < this.dim3; ++i7) {
                                for (int i8 = 0; i8 < this.dim2; ++i8) {
                                    for (int i9 = 0; i9 < this.dim1; ++i9) {
                                        if (bl) {
                                            bl = false;
                                            continue;
                                        }
                                        short s3 = this.get(i9, i8, i7, i6, k, j, i);
                                        if (s3 <= s) continue;
                                        s = s3;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return s;
    }

    @Override
    public short[] getMinAndMax() {
        short[] sArray = new short[2];
        this.getMinAndMax(sArray);
        return sArray;
    }

    @Override
    public void getMinAndMax(short[] sArray) {
        short s;
        short s2 = s = this.get(0, 0, 0, 0, 0, 0, 0);
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        if (bl) {
                                            bl = false;
                                            continue;
                                        }
                                        short s3 = this.get(i, j, k, i2, i3, i4, i5);
                                        if (s3 < s) {
                                            s = s3;
                                        }
                                        if (s3 <= s2) continue;
                                        s2 = s3;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim7; ++i) {
                for (int j = 0; j < this.dim6; ++j) {
                    for (int k = 0; k < this.dim5; ++k) {
                        for (int i6 = 0; i6 < this.dim4; ++i6) {
                            for (int i7 = 0; i7 < this.dim3; ++i7) {
                                for (int i8 = 0; i8 < this.dim2; ++i8) {
                                    for (int i9 = 0; i9 < this.dim1; ++i9) {
                                        if (bl) {
                                            bl = false;
                                            continue;
                                        }
                                        short s4 = this.get(i9, i8, i7, i6, k, j, i);
                                        if (s4 < s) {
                                            s = s4;
                                        }
                                        if (s4 <= s2) continue;
                                        s2 = s4;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        sArray[0] = s;
        sArray[1] = s2;
    }

    @Override
    public int sum() {
        int n = 0;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        n += this.get(i, j, k, i2, i3, i4, i5);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim7; ++i) {
                for (int j = 0; j < this.dim6; ++j) {
                    for (int k = 0; k < this.dim5; ++k) {
                        for (int i6 = 0; i6 < this.dim4; ++i6) {
                            for (int i7 = 0; i7 < this.dim3; ++i7) {
                                for (int i8 = 0; i8 < this.dim2; ++i8) {
                                    for (int i9 = 0; i9 < this.dim1; ++i9) {
                                        n += this.get(i9, i8, i7, i6, k, j, i);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return n;
    }

    @Override
    public double average() {
        return (double)this.sum() / (double)this.number;
    }

    @Override
    public Byte7D toByte() {
        byte[] byArray = new byte[this.number];
        if (this.isFlat()) {
            short[] sArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                byArray[i] = (byte)sArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim7; ++i) {
                for (int j = 0; j < this.dim6; ++j) {
                    for (int k = 0; k < this.dim5; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim3; ++i3) {
                                for (int i4 = 0; i4 < this.dim2; ++i4) {
                                    for (int i5 = 0; i5 < this.dim1; ++i5) {
                                        byArray[++n] = (byte)this.get(i5, i4, i3, i2, k, j, i);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return Byte7D.wrap(byArray, this.getShape());
    }

    @Override
    public Short7D toShort() {
        return this;
    }

    @Override
    public Int7D toInt() {
        int[] nArray = new int[this.number];
        if (this.isFlat()) {
            short[] sArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                nArray[i] = sArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim7; ++i) {
                for (int j = 0; j < this.dim6; ++j) {
                    for (int k = 0; k < this.dim5; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim3; ++i3) {
                                for (int i4 = 0; i4 < this.dim2; ++i4) {
                                    for (int i5 = 0; i5 < this.dim1; ++i5) {
                                        nArray[++n] = this.get(i5, i4, i3, i2, k, j, i);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return Int7D.wrap(nArray, this.getShape());
    }

    @Override
    public Long7D toLong() {
        long[] lArray = new long[this.number];
        if (this.isFlat()) {
            short[] sArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                lArray[i] = sArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim7; ++i) {
                for (int j = 0; j < this.dim6; ++j) {
                    for (int k = 0; k < this.dim5; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim3; ++i3) {
                                for (int i4 = 0; i4 < this.dim2; ++i4) {
                                    for (int i5 = 0; i5 < this.dim1; ++i5) {
                                        lArray[++n] = this.get(i5, i4, i3, i2, k, j, i);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return Long7D.wrap(lArray, this.getShape());
    }

    @Override
    public Float7D toFloat() {
        float[] fArray = new float[this.number];
        if (this.isFlat()) {
            short[] sArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                fArray[i] = sArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim7; ++i) {
                for (int j = 0; j < this.dim6; ++j) {
                    for (int k = 0; k < this.dim5; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim3; ++i3) {
                                for (int i4 = 0; i4 < this.dim2; ++i4) {
                                    for (int i5 = 0; i5 < this.dim1; ++i5) {
                                        fArray[++n] = this.get(i5, i4, i3, i2, k, j, i);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return Float7D.wrap(fArray, this.getShape());
    }

    @Override
    public Double7D toDouble() {
        double[] dArray = new double[this.number];
        if (this.isFlat()) {
            short[] sArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                dArray[i] = sArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim7; ++i) {
                for (int j = 0; j < this.dim6; ++j) {
                    for (int k = 0; k < this.dim5; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim3; ++i3) {
                                for (int i4 = 0; i4 < this.dim2; ++i4) {
                                    for (int i5 = 0; i5 < this.dim1; ++i5) {
                                        dArray[++n] = this.get(i5, i4, i3, i2, k, j, i);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return Double7D.wrap(dArray, this.getShape());
    }

    @Override
    public Short7D copy() {
        return new FlatShort7D(this.flatten(true), this.shape);
    }

    @Override
    public void assign(ShapedArray shapedArray) {
        if (!this.getShape().equals(shapedArray.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        Short7D short7D = shapedArray.getType() == 1 ? (Short7D)shapedArray : (Short7D)shapedArray.toShort();
        if (this.getOrder() == 2 && short7D.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        this.set(i, j, k, i2, i3, i4, i5, short7D.get(i, j, k, i2, i3, i4, i5));
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim7; ++i) {
                for (int j = 0; j < this.dim6; ++j) {
                    for (int k = 0; k < this.dim5; ++k) {
                        for (int i6 = 0; i6 < this.dim4; ++i6) {
                            for (int i7 = 0; i7 < this.dim3; ++i7) {
                                for (int i8 = 0; i8 < this.dim2; ++i8) {
                                    for (int i9 = 0; i9 < this.dim1; ++i9) {
                                        this.set(i9, i8, i7, i6, k, j, i, short7D.get(i9, i8, i7, i6, k, j, i));
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void assign(ShapedVector shapedVector) {
        if (!this.getShape().equals(shapedVector.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        int n = -1;
        if (shapedVector.getType() == 5) {
            DoubleShapedVector doubleShapedVector = (DoubleShapedVector)shapedVector;
            for (int i = 0; i < this.dim7; ++i) {
                for (int j = 0; j < this.dim6; ++j) {
                    for (int k = 0; k < this.dim5; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim3; ++i3) {
                                for (int i4 = 0; i4 < this.dim2; ++i4) {
                                    for (int i5 = 0; i5 < this.dim1; ++i5) {
                                        this.set(i5, i4, i3, i2, k, j, i, (short)doubleShapedVector.get(++n));
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else if (shapedVector.getType() == 4) {
            FloatShapedVector floatShapedVector = (FloatShapedVector)shapedVector;
            for (int i = 0; i < this.dim7; ++i) {
                for (int j = 0; j < this.dim6; ++j) {
                    for (int k = 0; k < this.dim5; ++k) {
                        for (int i6 = 0; i6 < this.dim4; ++i6) {
                            for (int i7 = 0; i7 < this.dim3; ++i7) {
                                for (int i8 = 0; i8 < this.dim2; ++i8) {
                                    for (int i9 = 0; i9 < this.dim1; ++i9) {
                                        this.set(i9, i8, i7, i6, k, j, i, (short)floatShapedVector.get(++n));
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            throw new IllegalTypeException();
        }
    }

    @Override
    public Short7D create() {
        return new FlatShort7D(this.getShape());
    }

    public static Short7D create(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        return new FlatShort7D(n, n2, n3, n4, n5, n6, n7);
    }

    public static Short7D create(int[] nArray) {
        return new FlatShort7D(nArray);
    }

    public static Short7D create(Shape shape) {
        return new FlatShort7D(shape);
    }

    public static Short7D wrap(short[] sArray, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        return new FlatShort7D(sArray, n, n2, n3, n4, n5, n6, n7);
    }

    public static Short7D wrap(short[] sArray, int[] nArray) {
        return new FlatShort7D(sArray, nArray);
    }

    public static Short7D wrap(short[] sArray, Shape shape) {
        return new FlatShort7D(sArray, shape);
    }

    public static Short7D wrap(short[] sArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15) {
        return new StriddenShort7D(sArray, n, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, n13, n14, n15);
    }

    @Override
    public abstract Short6D slice(int var1);

    @Override
    public abstract Short6D slice(int var1, int var2);

    @Override
    public abstract Short7D view(Range var1, Range var2, Range var3, Range var4, Range var5, Range var6, Range var7);

    @Override
    public abstract Short7D view(int[] var1, int[] var2, int[] var3, int[] var4, int[] var5, int[] var6, int[] var7);

    @Override
    public abstract Short1D as1D();
}

