/*
 * Decompiled with CFR 0.152.
 */
package net.phys2d.raw.collide;

import net.phys2d.math.MathUtil;
import net.phys2d.math.Vector2f;
import net.phys2d.raw.Body;
import net.phys2d.raw.Contact;
import net.phys2d.raw.collide.Collider;
import net.phys2d.raw.collide.FeaturePair;
import net.phys2d.raw.shapes.Circle;

public strictfp class CircleCircleCollider
implements Collider {
    public int collide(Contact[] contacts, Body bodyA, Body bodyB) {
        Circle circleB;
        float x1 = bodyA.getPosition().getX();
        float y1 = bodyA.getPosition().getY();
        float x2 = bodyB.getPosition().getX();
        float y2 = bodyB.getPosition().getY();
        boolean touches = bodyA.getShape().getBounds().touches(x1, y1, bodyB.getShape().getBounds(), x2, y2);
        if (!touches) {
            return 0;
        }
        Circle circleA = (Circle)bodyA.getShape();
        touches = circleA.touches(x1, y1, circleB = (Circle)bodyB.getShape(), x2, y2);
        if (!touches) {
            return 0;
        }
        Vector2f normal = MathUtil.sub(bodyB.getPosition(), bodyA.getPosition());
        float sep = circleA.getRadius() + circleB.getRadius() - normal.length();
        normal.normalise();
        Vector2f pt = MathUtil.scale(normal, circleA.getRadius());
        pt.add(bodyA.getPosition());
        contacts[0].setSeparation(-sep);
        contacts[0].setPosition(pt);
        contacts[0].setNormal(normal);
        FeaturePair fp = new FeaturePair();
        contacts[0].setFeature(fp);
        return 1;
    }
}

