/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.Array1D;
import mitiv.array.ByteArray;
import mitiv.array.ByteScalar;
import mitiv.array.Double1D;
import mitiv.array.Float1D;
import mitiv.array.Int1D;
import mitiv.array.Long1D;
import mitiv.array.ShapedArray;
import mitiv.array.Short1D;
import mitiv.array.impl.FlatByte1D;
import mitiv.array.impl.StriddenByte1D;
import mitiv.base.Shape;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.ByteFunction;
import mitiv.base.mapping.ByteScanner;
import mitiv.exception.IllegalTypeException;
import mitiv.exception.NonConformableArrayException;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.random.ByteGenerator;

public abstract class Byte1D
extends Array1D
implements ByteArray {
    protected Byte1D(int n) {
        super(n);
    }

    protected Byte1D(int[] nArray) {
        super(nArray);
    }

    protected Byte1D(Shape shape) {
        super(shape);
    }

    @Override
    public final int getType() {
        return 0;
    }

    public abstract byte get(int var1);

    public abstract void set(int var1, byte var2);

    @Override
    public void fill(byte by) {
        for (int i = 0; i < this.dim1; ++i) {
            this.set(i, by);
        }
    }

    @Override
    public void increment(byte by) {
        for (int i = 0; i < this.dim1; ++i) {
            this.set(i, (byte)(this.get(i) + by));
        }
    }

    @Override
    public void decrement(byte by) {
        for (int i = 0; i < this.dim1; ++i) {
            this.set(i, (byte)(this.get(i) - by));
        }
    }

    @Override
    public void scale(byte by) {
        for (int i = 0; i < this.dim1; ++i) {
            this.set(i, (byte)(this.get(i) * by));
        }
    }

    @Override
    public void map(ByteFunction byteFunction) {
        for (int i = 0; i < this.dim1; ++i) {
            this.set(i, byteFunction.apply(this.get(i)));
        }
    }

    @Override
    public void fill(ByteGenerator byteGenerator) {
        for (int i = 0; i < this.dim1; ++i) {
            this.set(i, byteGenerator.nextByte());
        }
    }

    @Override
    public void scan(ByteScanner byteScanner) {
        byteScanner.initialize(this.get(0));
        for (int i = 1; i < this.dim1; ++i) {
            byteScanner.update(this.get(i));
        }
    }

    @Override
    public final byte[] flatten() {
        return this.flatten(false);
    }

    @Override
    public int min() {
        int n = this.get(0) & 0xFF;
        for (int i = 1; i < this.dim1; ++i) {
            int n2 = this.get(i) & 0xFF;
            if (n2 >= n) continue;
            n = n2;
        }
        return n;
    }

    @Override
    public int max() {
        int n = this.get(0) & 0xFF;
        for (int i = 1; i < this.dim1; ++i) {
            int n2 = this.get(i) & 0xFF;
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    @Override
    public int[] getMinAndMax() {
        int[] nArray = new int[2];
        this.getMinAndMax(nArray);
        return nArray;
    }

    @Override
    public void getMinAndMax(int[] nArray) {
        int n;
        int n2 = n = this.get(0) & 0xFF;
        for (int i = 1; i < this.dim1; ++i) {
            int n3 = this.get(i) & 0xFF;
            if (n3 < n) {
                n = n3;
            }
            if (n3 <= n2) continue;
            n2 = n3;
        }
        nArray[0] = n;
        nArray[1] = n2;
    }

    @Override
    public int sum() {
        int n = this.get(0) & 0xFF;
        for (int i = 1; i < this.dim1; ++i) {
            n += this.get(i) & 0xFF;
        }
        return n;
    }

    @Override
    public double average() {
        return (double)this.sum() / (double)this.number;
    }

    @Override
    public Byte1D toByte() {
        return this;
    }

    @Override
    public Short1D toShort() {
        short[] sArray = new short[this.number];
        if (this.isFlat()) {
            byte[] byArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                sArray[i] = (short)(byArray[i] & 0xFF);
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim1; ++i) {
                sArray[++n] = (short)(this.get(i) & 0xFF);
            }
        }
        return Short1D.wrap(sArray, this.getShape());
    }

    @Override
    public Int1D toInt() {
        int[] nArray = new int[this.number];
        if (this.isFlat()) {
            byte[] byArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                nArray[i] = byArray[i] & 0xFF;
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim1; ++i) {
                nArray[++n] = this.get(i) & 0xFF;
            }
        }
        return Int1D.wrap(nArray, this.getShape());
    }

    @Override
    public Long1D toLong() {
        long[] lArray = new long[this.number];
        if (this.isFlat()) {
            byte[] byArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                lArray[i] = byArray[i] & 0xFF;
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim1; ++i) {
                lArray[++n] = this.get(i) & 0xFF;
            }
        }
        return Long1D.wrap(lArray, this.getShape());
    }

    @Override
    public Float1D toFloat() {
        float[] fArray = new float[this.number];
        if (this.isFlat()) {
            byte[] byArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                fArray[i] = byArray[i] & 0xFF;
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim1; ++i) {
                fArray[++n] = this.get(i) & 0xFF;
            }
        }
        return Float1D.wrap(fArray, this.getShape());
    }

    @Override
    public Double1D toDouble() {
        double[] dArray = new double[this.number];
        if (this.isFlat()) {
            byte[] byArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                dArray[i] = byArray[i] & 0xFF;
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim1; ++i) {
                dArray[++n] = this.get(i) & 0xFF;
            }
        }
        return Double1D.wrap(dArray, this.getShape());
    }

    @Override
    public Byte1D copy() {
        return new FlatByte1D(this.flatten(true), this.shape);
    }

    @Override
    public void assign(ShapedArray shapedArray) {
        if (!this.getShape().equals(shapedArray.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        Byte1D byte1D = shapedArray.getType() == 0 ? (Byte1D)shapedArray : (Byte1D)shapedArray.toByte();
        for (int i = 0; i < this.dim1; ++i) {
            this.set(i, byte1D.get(i));
        }
    }

    @Override
    public void assign(ShapedVector shapedVector) {
        if (!this.getShape().equals(shapedVector.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        if (shapedVector.getType() == 5) {
            DoubleShapedVector doubleShapedVector = (DoubleShapedVector)shapedVector;
            for (int i = 0; i < this.dim1; ++i) {
                this.set(i, (byte)doubleShapedVector.get(i));
            }
        } else if (shapedVector.getType() == 4) {
            FloatShapedVector floatShapedVector = (FloatShapedVector)shapedVector;
            for (int i = 0; i < this.dim1; ++i) {
                this.set(i, (byte)floatShapedVector.get(i));
            }
        } else {
            throw new IllegalTypeException();
        }
    }

    @Override
    public Byte1D create() {
        return new FlatByte1D(this.getShape());
    }

    public static Byte1D create(int n) {
        return new FlatByte1D(n);
    }

    public static Byte1D create(int[] nArray) {
        return new FlatByte1D(nArray);
    }

    public static Byte1D create(Shape shape) {
        return new FlatByte1D(shape);
    }

    public static Byte1D wrap(byte[] byArray, int n) {
        return new FlatByte1D(byArray, n);
    }

    public static Byte1D wrap(byte[] byArray, int[] nArray) {
        return new FlatByte1D(byArray, nArray);
    }

    public static Byte1D wrap(byte[] byArray, Shape shape) {
        return new FlatByte1D(byArray, shape);
    }

    public static Byte1D wrap(byte[] byArray, int n, int n2, int n3) {
        return new StriddenByte1D(byArray, n, n2, n3);
    }

    @Override
    public abstract ByteScalar slice(int var1);

    @Override
    public abstract ByteScalar slice(int var1, int var2);

    @Override
    public abstract Byte1D view(Range var1);

    @Override
    public abstract Byte1D view(int[] var1);

    @Override
    public abstract Byte1D as1D();
}

