/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.SunMidiFileReader;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiFileFormat;
import javax.sound.midi.Sequence;

public class RmfFileReader
extends SunMidiFileReader {
    static final int RMF_MAGIC = 1230128474;
    private static final int MIDI_TYPE_1 = 1;
    private static final int bisBufferSize = 1024;
    public static final int[] types = new int[]{1};

    public MidiFileFormat getMidiFileFormat(InputStream stream) throws InvalidMidiDataException, IOException {
        int maxReadLength = 16;
        int length = -1;
        float divisionType = -1.0f;
        int resolution = -1;
        int duration = -1;
        MidiFileFormat format = null;
        int type = types[0];
        DataInputStream dis = new DataInputStream(stream);
        dis.mark(maxReadLength);
        int magic = dis.readInt();
        if (magic != 1230128474) {
            dis.reset();
            throw new InvalidMidiDataException("not a valid RMF file");
        }
        dis.reset();
        format = new MidiFileFormat(type, divisionType, resolution, length, duration);
        return format;
    }

    public MidiFileFormat getMidiFileFormat(URL url) throws InvalidMidiDataException, IOException {
        InputStream urlStream = null;
        BufferedInputStream bis = null;
        MidiFileFormat fileFormat = null;
        urlStream = url.openStream();
        bis = new BufferedInputStream(urlStream, 1024);
        fileFormat = this.getMidiFileFormat(bis);
        bis.close();
        return fileFormat;
    }

    public MidiFileFormat getMidiFileFormat(File file) throws InvalidMidiDataException, IOException {
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        MidiFileFormat fileFormat = null;
        fis = new FileInputStream(file);
        bis = new BufferedInputStream(fis, 1024);
        fileFormat = this.getMidiFileFormat(bis);
        bis.close();
        return fileFormat;
    }

    public Sequence getSequence(InputStream stream) throws InvalidMidiDataException, IOException {
        throw new InvalidMidiDataException("cannot get sequence from RMF file");
    }

    public Sequence getSequence(URL url) throws InvalidMidiDataException, IOException {
        throw new InvalidMidiDataException("cannot get sequence from RMF file");
    }

    public Sequence getSequence(File file) throws InvalidMidiDataException, IOException {
        throw new InvalidMidiDataException("cannot get sequence from RMF file");
    }
}

