package plugins.tprovoost.sequenceblocks.loop;

import icy.file.SequenceFileImporter;
import icy.sequence.MetaDataUtil;
import plugins.adufour.vars.util.VarException;
import plugins.tprovoost.sequenceblocks.importer.PositionedSequenceFileImporter;

/**
 * Simple batch loop to iterate over all series from the specified opened {@link SequenceFileImporter} object.
 * 
 * @author Stephane
 */
public class SequenceFileImporterSeriesBatch extends SequenceFileImporterBatch
{
    @Override
    public void initializeLoop()
    {
        super.initializeLoop();

        final PositionedSequenceFileImporter pi = positionedImporter.getValue();

        try
        {
            // force series iteration as by default series is set to 0
            limit = MetaDataUtil.getNumSeries(pi.getMetadata());
        }
        catch (Exception e)
        {
            throw new VarException(element,
                    "Error while initializing SequenceFileImporter series batch: " + e.getMessage());
        }
    }

    @Override
    public void beforeIteration()
    {
        // set current position S
        element.getValue().s = getIterationCounter().getValue().intValue();
        // force element changed event so loop get correctly executed
        element.valueChanged(element, element.getValue(), element.getValue());
    }

    @Override
    public boolean isStopConditionReached()
    {
        return getIterationCounter().getValue().intValue() >= limit;
    }
}
