/*
 * Decompiled with CFR 0.152.
 */
package mitiv.base;

public class Shape {
    private static final long LONG_MAX = Long.MAX_VALUE;
    private static final long INT_MAX = Integer.MAX_VALUE;
    private final long number;
    private final int rank;
    private final int[] dims;
    public static final Shape scalarShape = new Shape(new int[0], true);

    @Deprecated
    public static Shape make() {
        return scalarShape;
    }

    @Deprecated
    public static Shape make(int[] nArray) {
        if (nArray == null || nArray.length == 0) {
            return scalarShape;
        }
        return new Shape(nArray, false);
    }

    @Deprecated
    public static Shape make(long[] lArray) {
        if (lArray == null || lArray.length == 0) {
            return scalarShape;
        }
        return new Shape(lArray);
    }

    @Deprecated
    public static Shape make(int n) {
        return new Shape(new int[]{n}, true);
    }

    @Deprecated
    public static Shape make(int n, int n2) {
        return new Shape(new int[]{n, n2}, true);
    }

    @Deprecated
    public static Shape make(int n, int n2, int n3) {
        return new Shape(new int[]{n, n2, n3}, true);
    }

    @Deprecated
    public static Shape make(int n, int n2, int n3, int n4) {
        return new Shape(new int[]{n, n2, n3, n4}, true);
    }

    @Deprecated
    public static Shape make(int n, int n2, int n3, int n4, int n5) {
        return new Shape(new int[]{n, n2, n3, n4, n5}, true);
    }

    @Deprecated
    public static Shape make(int n, int n2, int n3, int n4, int n5, int n6) {
        return new Shape(new int[]{n, n2, n3, n4, n5, n6}, true);
    }

    @Deprecated
    public static Shape make(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        return new Shape(new int[]{n, n2, n3, n4, n5, n6, n7}, true);
    }

    @Deprecated
    public static Shape make(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        return new Shape(new int[]{n, n2, n3, n4, n5, n6, n7, n8}, true);
    }

    @Deprecated
    public static Shape make(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        return new Shape(new int[]{n, n2, n3, n4, n5, n6, n7, n8, n9}, true);
    }

    public final int rank() {
        return this.rank;
    }

    public final long number() {
        return this.number;
    }

    public final int dimension(int n) {
        return this.dims[n];
    }

    public final int[] copyDimensions() {
        if (this.rank == 0) {
            return this.dims;
        }
        int[] nArray = new int[this.rank];
        for (int i = 0; i < this.rank; ++i) {
            nArray[i] = this.dims[i];
        }
        return nArray;
    }

    public final boolean equals(Shape shape) {
        if (shape != this && shape.dims != this.dims) {
            if (this.rank != shape.rank) {
                return false;
            }
            for (int i = 0; i < this.rank; ++i) {
                if (shape.dims[i] == this.dims[i]) continue;
                return false;
            }
        }
        return true;
    }

    private Shape(int[] nArray, boolean bl) {
        long l = 1L;
        this.rank = nArray.length;
        if (bl) {
            this.dims = nArray;
            for (int i = 0; i < this.rank; ++i) {
                int n = nArray[i];
                if (n < 1) {
                    Shape.dimensionTooSmall();
                }
                if ((long)n > Long.MAX_VALUE / l) {
                    Shape.numberOverflow();
                }
                l *= (long)n;
            }
        } else {
            this.dims = new int[this.rank];
            for (int i = 0; i < this.rank; ++i) {
                int n = nArray[i];
                if (n < 1) {
                    Shape.dimensionTooSmall();
                }
                if ((long)n > Long.MAX_VALUE / l) {
                    Shape.numberOverflow();
                }
                l *= (long)n;
                this.dims[i] = n;
            }
        }
        this.number = l;
    }

    public Shape(int[] nArray) {
        this(nArray, false);
    }

    public Shape(long[] lArray) {
        long l = 1L;
        this.rank = lArray.length;
        this.dims = new int[this.rank];
        for (int i = 0; i < this.rank; ++i) {
            long l2 = lArray[i];
            if (l2 < 1L) {
                Shape.dimensionTooSmall();
            }
            if (l2 > Integer.MAX_VALUE) {
                Shape.dimensionTooLarge();
            }
            if (l2 > Long.MAX_VALUE / l) {
                Shape.numberOverflow();
            }
            l *= l2;
            this.dims[i] = (int)l2;
        }
        this.number = l;
    }

    public Shape(int n) {
        this(new int[]{n}, true);
    }

    public Shape(int n, int n2) {
        this(new int[]{n, n2}, true);
    }

    public Shape(int n, int n2, int n3) {
        this(new int[]{n, n2, n3}, true);
    }

    public Shape(int n, int n2, int n3, int n4) {
        this(new int[]{n, n2, n3, n4}, true);
    }

    public Shape(int n, int n2, int n3, int n4, int n5) {
        this(new int[]{n, n2, n3, n4, n5}, true);
    }

    public Shape(int n, int n2, int n3, int n4, int n5, int n6) {
        this(new int[]{n, n2, n3, n4, n5, n6}, true);
    }

    public Shape(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this(new int[]{n, n2, n3, n4, n5, n6, n7}, true);
    }

    public Shape(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this(new int[]{n, n2, n3, n4, n5, n6, n7, n8}, true);
    }

    public Shape(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        this(new int[]{n, n2, n3, n4, n5, n6, n7, n8, n9}, true);
    }

    public String toString() {
        String string = "[";
        for (int i = 0; i < this.rank; ++i) {
            string = string + String.format(i > 0 ? ",%d" : "%d", this.dims[i]);
        }
        return string + "]";
    }

    private static void dimensionTooSmall() {
        throw new IllegalArgumentException("Dimensions must be at least 1");
    }

    private static void dimensionTooLarge() {
        throw new IllegalArgumentException("Dimensions must be at most Integer.MAX_VALUE");
    }

    private static void numberOverflow() {
        throw new IllegalArgumentException("Total number of elements is too large");
    }
}

