/*
 * Decompiled with CFR 0.152.
 */
package mitiv.optim;

import mitiv.linalg.LinearEndomorphism;
import mitiv.linalg.Vector;
import mitiv.linalg.VectorSpace;
import mitiv.optim.BoundProjector;
import mitiv.optim.LBFGSOperator;
import mitiv.optim.OptimStatus;
import mitiv.optim.OptimTask;
import mitiv.optim.QuasiNewton;

public class BLMVM
extends QuasiNewton {
    protected LBFGSOperator H = null;
    protected double pginit;
    protected double pnorm;
    protected double sftol = 0.01;
    protected double[] bnd = new double[2];
    private final boolean saveMemory = true;
    protected Vector x0 = null;
    protected double f0 = 0.0;
    protected Vector g0 = null;
    protected Vector pg0 = null;
    protected Vector pg = null;
    protected double pgnorm = 0.0;
    protected Vector tmp = null;
    protected Vector p = null;
    protected double alpha;
    protected final BoundProjector projector;

    public BLMVM(VectorSpace vectorSpace, BoundProjector boundProjector, int n) {
        this(new LBFGSOperator(vectorSpace, n), boundProjector);
    }

    public BLMVM(LinearEndomorphism linearEndomorphism, BoundProjector boundProjector, int n) {
        this(new LBFGSOperator(linearEndomorphism, n), boundProjector);
    }

    private BLMVM(LBFGSOperator lBFGSOperator, BoundProjector boundProjector) {
        super(lBFGSOperator.getSpace(), null);
        this.H = lBFGSOperator;
        if (boundProjector == null) {
            throw new IllegalArgumentException("Illegal null projector");
        }
        this.projector = boundProjector;
        this.p = lBFGSOperator.getSpace().create();
        this.getClass();
        this.pg0 = lBFGSOperator.getSpace().create();
        this.pg = lBFGSOperator.getSpace().create();
        this.tmp = lBFGSOperator.getSpace().create();
    }

    @Override
    public OptimTask start() {
        this.evaluations = 0;
        this.iterations = 0;
        this.restarts = 0;
        return this.begin();
    }

    @Override
    public OptimTask restart() {
        ++this.restarts;
        return this.begin();
    }

    private OptimTask begin() {
        this.H.reset();
        return this.success(OptimTask.COMPUTE_FG);
    }

    @Override
    public OptimTask iterate(Vector vector, double d, Vector vector2) {
        switch (this.getTask()) {
            case COMPUTE_FG: {
                ++this.evaluations;
                this.projector.projectDirection(vector, vector2, true, this.pg);
                this.pgnorm = this.pg.norm2();
                if (this.evaluations == 1) {
                    this.pginit = this.pgnorm;
                }
                if (this.pgnorm <= this.getGradientThreshold(this.pginit)) {
                    return this.success(OptimTask.FINAL_X);
                }
                if (this.evaluations == 1) {
                    return this.success(OptimTask.NEW_X);
                }
                this.tmp.combine(1.0, vector, -1.0, this.x0);
                if (d <= this.f0 + this.sftol * this.tmp.dot(this.g0)) {
                    ++this.iterations;
                    return this.success(OptimTask.NEW_X);
                }
                this.alpha /= 2.0;
                return this.nextStep(vector);
            }
            case NEW_X: {
                if (this.iterations >= 1) {
                    this.H.update(vector, this.x0, this.pg, this.pg0);
                }
            }
            case FINAL_X: {
                while (true) {
                    this.H.apply(this.p, vector2);
                    this.projector.projectDirection(vector, this.p, true, this.tmp, this.bnd);
                    if (this.tmp.dot(vector2) > 0.0) break;
                    if (this.H.mp < 1) {
                        return this.failure(OptimStatus.BAD_PRECONDITIONER);
                    }
                    this.H.reset();
                    ++this.restarts;
                }
                this.alpha = Math.min(this.initialStep(vector, this.p.norm2()), this.bnd[1]);
                this.x0 = this.H.s(0);
                this.g0 = this.H.y(0);
                if (this.H.mp == this.H.m) {
                    --this.H.mp;
                }
                this.x0.copy(vector);
                this.g0.copy(vector2);
                this.pg0.copy(this.pg);
                this.f0 = d;
                return this.nextStep(vector);
            }
        }
        return this.getTask();
    }

    protected OptimTask nextStep(Vector vector) {
        vector.combine(1.0, this.x0, -this.alpha, this.p);
        this.projector.projectVariables(vector);
        return this.success(OptimTask.COMPUTE_FG);
    }

    protected double initialStep(Vector vector, double d) {
        double d2;
        if (this.H.mp >= 1 || this.H.rule == 0) {
            return 1.0;
        }
        if (0.0 < this.delta && this.delta < 1.0 && (d2 = vector.norm2()) > 0.0) {
            return d2 / d * this.delta;
        }
        return 1.0 / d;
    }

    public Vector getProjectedGradient() {
        return this.evaluations >= 1 ? this.pg : null;
    }

    public double getProjectedGradientNorm2() {
        return this.evaluations >= 1 ? this.pgnorm : -1.0;
    }
}

