/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array.impl;

import mitiv.array.Short1D;
import mitiv.array.ShortScalar;
import mitiv.array.impl.Helper;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.ShortFunction;
import mitiv.base.mapping.ShortScanner;
import mitiv.random.ShortGenerator;

public class SelectedShort1D
extends Short1D {
    static final int order = 0;
    final short[] data;
    final int[] idx1;

    public SelectedShort1D(short[] sArray, int[] nArray) {
        super(nArray.length);
        this.data = sArray;
        this.idx1 = nArray;
    }

    @Override
    public final void checkSanity() {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = n = this.idx1[0];
        for (int i = 1; i < this.dim1; ++i) {
            int n5 = this.idx1[i];
            if (n5 < n4) {
                n4 = n5;
            }
            if (n5 <= n) continue;
            n = n5;
        }
        if ((n2 += n4) < 0 || (n3 += n) >= this.data.length) {
            throw new IndexOutOfBoundsException("Selected indices are out of bounds");
        }
    }

    final int index(int n) {
        return this.idx1[n];
    }

    @Override
    public final short get(int n) {
        return this.data[this.idx1[n]];
    }

    @Override
    public final void set(int n, short s) {
        this.data[this.idx1[n]] = s;
    }

    @Override
    public final int getOrder() {
        return 0;
    }

    @Override
    public void fill(short s) {
        for (int i = 0; i < this.dim1; ++i) {
            int n = this.idx1[i];
            this.data[n] = s;
        }
    }

    @Override
    public void fill(ShortGenerator shortGenerator) {
        for (int i = 0; i < this.dim1; ++i) {
            int n = this.idx1[i];
            this.data[n] = shortGenerator.nextShort();
        }
    }

    @Override
    public void increment(short s) {
        for (int i = 0; i < this.dim1; ++i) {
            int n;
            int n2 = n = this.idx1[i];
            this.data[n2] = (short)(this.data[n2] + s);
        }
    }

    @Override
    public void decrement(short s) {
        for (int i = 0; i < this.dim1; ++i) {
            int n;
            int n2 = n = this.idx1[i];
            this.data[n2] = (short)(this.data[n2] - s);
        }
    }

    @Override
    public void scale(short s) {
        for (int i = 0; i < this.dim1; ++i) {
            int n;
            int n2 = n = this.idx1[i];
            this.data[n2] = (short)(this.data[n2] * s);
        }
    }

    @Override
    public void map(ShortFunction shortFunction) {
        for (int i = 0; i < this.dim1; ++i) {
            int n = this.idx1[i];
            this.data[n] = shortFunction.apply(this.data[n]);
        }
    }

    @Override
    public void scan(ShortScanner shortScanner) {
        boolean bl = false;
        for (int i = 0; i < this.dim1; ++i) {
            int n = this.idx1[i];
            if (bl) {
                shortScanner.update(this.data[n]);
                continue;
            }
            shortScanner.initialize(this.data[n]);
            bl = true;
        }
    }

    @Override
    public final boolean isFlat() {
        return false;
    }

    @Override
    public short[] flatten(boolean bl) {
        short[] sArray = new short[this.number];
        int n = -1;
        for (int i = 0; i < this.dim1; ++i) {
            int n2 = this.idx1[i];
            sArray[++n] = this.data[n2];
        }
        return sArray;
    }

    @Override
    public short[] getData() {
        return null;
    }

    @Override
    public ShortScalar slice(int n) {
        return new ShortScalar(this.data, this.idx1[Helper.fixIndex(n, this.dim1)]);
    }

    @Override
    public ShortScalar slice(int n, int n2) {
        Helper.fixSliceIndex(n2, 1);
        return new ShortScalar(this.data, Helper.fixIndex(n, this.dim1));
    }

    @Override
    public Short1D view(Range range) {
        int[] nArray = Helper.select(this.idx1, range);
        if (nArray == this.idx1) {
            return this;
        }
        return new SelectedShort1D(this.data, nArray);
    }

    @Override
    public Short1D view(int[] nArray) {
        int[] nArray2 = Helper.select(this.idx1, nArray);
        if (nArray2 == this.idx1) {
            return this;
        }
        return new SelectedShort1D(this.data, nArray2);
    }

    @Override
    public Short1D as1D() {
        return this;
    }
}

