/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl;

import com.jogamp.opencl.CLContext;
import com.jogamp.opencl.CLDevice;
import com.jogamp.opencl.CLException;
import com.jogamp.opencl.CLPlatform;
import com.jogamp.opencl.CLProgram;
import com.jogamp.opencl.util.CLBuildConfiguration;
import com.jogamp.opencl.util.CLBuildListener;
import com.jogamp.opencl.util.CLProgramConfiguration;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class CLProgramBuilder
implements CLProgramConfiguration,
Serializable,
Cloneable {
    static final long serialVersionUID = 42L;
    private static final byte[] NO_BINARIES = new byte[0];
    private transient CLProgram program;
    private transient Map<CLDevice, byte[]> binariesMap = new LinkedHashMap<CLDevice, byte[]>();
    private String source;
    private final Set<String> optionSet = new LinkedHashSet<String>();
    private final Set<String> defineSet = new LinkedHashSet<String>();

    private CLProgramBuilder() {
        this(null);
    }

    private CLProgramBuilder(CLProgram cLProgram) {
        this(cLProgram, null, null);
    }

    private CLProgramBuilder(CLProgram cLProgram, String string, Map<CLDevice, byte[]> map) {
        this.program = cLProgram;
        this.source = string;
        if (map != null) {
            this.binariesMap.putAll(map);
        }
    }

    public static CLBuildConfiguration createConfiguration() {
        return CLProgramBuilder.createConfiguration(null);
    }

    public static CLProgramConfiguration createConfiguration(CLProgram cLProgram) {
        return new CLProgramBuilder(cLProgram);
    }

    public static CLBuildConfiguration loadConfiguration(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        return (CLBuildConfiguration)objectInputStream.readObject();
    }

    public static CLProgramConfiguration loadConfiguration(ObjectInputStream objectInputStream, CLContext cLContext) throws IOException, ClassNotFoundException {
        CLProgramBuilder cLProgramBuilder = (CLProgramBuilder)objectInputStream.readObject();
        if (CLProgramBuilder.allBinariesAvailable(cLProgramBuilder)) {
            try {
                cLProgramBuilder.program = cLContext.createProgram(cLProgramBuilder.binariesMap);
            }
            catch (CLException.CLInvalidBinaryException cLInvalidBinaryException) {
                if (cLProgramBuilder.source != null) {
                    cLProgramBuilder.program = cLContext.createProgram(cLProgramBuilder.source);
                }
                throw new IOException("Program configuration contained invalid program binaries and no source.", cLInvalidBinaryException);
            }
        } else if (cLProgramBuilder.source != null) {
            cLProgramBuilder.program = cLContext.createProgram(cLProgramBuilder.source);
        } else {
            throw new IOException("Program configuration did not contain program sources or binaries");
        }
        return cLProgramBuilder;
    }

    private static boolean allBinariesAvailable(CLProgramBuilder cLProgramBuilder) {
        for (Map.Entry<CLDevice, byte[]> entry : cLProgramBuilder.binariesMap.entrySet()) {
            if (!Arrays.equals(NO_BINARIES, entry.getValue())) continue;
            return false;
        }
        return cLProgramBuilder.binariesMap.size() > 0;
    }

    @Override
    public void save(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.program != null) {
            this.source = this.program.getSource();
            if (this.program.isExecutable()) {
                this.binariesMap = this.program.getBinaries();
            }
        }
        objectOutputStream.writeObject(this);
    }

    @Override
    public CLProgramBuilder withOption(String string) {
        this.optionSet.add(string);
        return this;
    }

    @Override
    public CLProgramBuilder withOptions(String ... stringArray) {
        this.optionSet.addAll(Arrays.asList(stringArray));
        return this;
    }

    @Override
    public CLProgramBuilder withDefine(String string) {
        this.defineSet.add(CLProgram.define(string));
        return this;
    }

    @Override
    public CLProgramBuilder withDefines(String ... stringArray) {
        for (String string : stringArray) {
            this.defineSet.add(CLProgram.define(string));
        }
        return this;
    }

    @Override
    public CLProgramBuilder withDefine(String string, Object object) {
        this.defineSet.add(CLProgram.define(string, object.toString()));
        return this;
    }

    @Override
    public CLProgramBuilder withDefines(Map<String, ? extends Object> map) {
        for (Map.Entry<String, ? extends Object> entry : map.entrySet()) {
            String string = entry.getKey();
            Object object = entry.getValue();
            this.defineSet.add(CLProgram.define(string, object));
        }
        return this;
    }

    @Override
    public CLProgramBuilder forDevice(CLDevice cLDevice) {
        if (!this.binariesMap.containsKey(cLDevice)) {
            this.binariesMap.put(cLDevice, NO_BINARIES);
        }
        return this;
    }

    @Override
    public CLProgramBuilder forDevices(CLDevice ... cLDeviceArray) {
        for (CLDevice cLDevice : cLDeviceArray) {
            this.forDevice(cLDevice);
        }
        return this;
    }

    @Override
    public CLProgram build() {
        return this.build(this.program, null);
    }

    @Override
    public CLProgram build(CLBuildListener cLBuildListener) {
        return this.build(this.program, cLBuildListener);
    }

    @Override
    public CLProgram build(CLProgram cLProgram) {
        return this.build(cLProgram, null);
    }

    @Override
    public CLProgram build(CLProgram cLProgram, CLBuildListener cLBuildListener) {
        if (cLProgram == null) {
            throw new NullPointerException("no program has been set");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(this.optionSet);
        arrayList.addAll(this.defineSet);
        String string = CLProgram.optionsOf(arrayList.toArray(new String[arrayList.size()]));
        CLDevice[] cLDeviceArray = this.binariesMap.keySet().toArray(new CLDevice[this.binariesMap.size()]);
        return cLProgram.build(cLBuildListener, string, cLDeviceArray);
    }

    @Override
    public CLProgramBuilder reset() {
        this.resetOptions();
        this.resetDefines();
        this.resetDevices();
        return this;
    }

    @Override
    public CLProgramConfiguration resetDefines() {
        this.defineSet.clear();
        return this;
    }

    @Override
    public CLProgramConfiguration resetDevices() {
        this.binariesMap.clear();
        return this;
    }

    @Override
    public CLProgramConfiguration resetOptions() {
        this.optionSet.clear();
        return this;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Object object;
        objectOutputStream.defaultWriteObject();
        String string = "";
        if (!this.binariesMap.isEmpty() && ((CLDevice)(object = this.binariesMap.keySet().iterator().next())).isICDAvailable()) {
            string = ((CLDevice)object).getPlatform().getICDSuffix();
        }
        objectOutputStream.writeUTF(string);
        objectOutputStream.writeInt(this.binariesMap.size());
        for (Map.Entry entry : this.binariesMap.entrySet()) {
            CLDevice cLDevice = (CLDevice)entry.getKey();
            byte[] byArray = (byte[])entry.getValue();
            objectOutputStream.writeUTF(cLDevice.getName());
            objectOutputStream.writeInt(byArray.length);
            objectOutputStream.write(byArray);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        String string = objectInputStream.readUTF();
        CLPlatform cLPlatform = null;
        for (CLPlatform object : CLPlatform.listCLPlatforms()) {
            if (!string.isEmpty() && !object.getICDSuffix().equals(string)) continue;
            cLPlatform = object;
            break;
        }
        this.binariesMap = new LinkedHashMap<CLDevice, byte[]>();
        List<CLDevice> list = cLPlatform != null ? new ArrayList<CLDevice>(Arrays.asList(cLPlatform.listCLDevices())) : Collections.emptyList();
        int n = objectInputStream.readInt();
        block1: for (int i = 0; i < n; ++i) {
            String string2 = objectInputStream.readUTF();
            int n2 = objectInputStream.readInt();
            byte[] byArray = new byte[n2];
            objectInputStream.readFully(byArray);
            for (int j = 0; j < list.size(); ++j) {
                CLDevice cLDevice = (CLDevice)list.get(j);
                if (!cLDevice.getName().equals(string2)) continue;
                this.binariesMap.put(cLDevice, byArray);
                list.remove(j);
                continue block1;
            }
        }
    }

    @Override
    public CLProgramBuilder asBuildConfiguration() {
        CLProgramBuilder cLProgramBuilder = new CLProgramBuilder();
        cLProgramBuilder.defineSet.addAll(this.defineSet);
        cLProgramBuilder.optionSet.addAll(this.optionSet);
        return cLProgramBuilder;
    }

    @Override
    public CLProgramBuilder clone() {
        CLProgramBuilder cLProgramBuilder = new CLProgramBuilder(this.program, this.source, this.binariesMap);
        cLProgramBuilder.defineSet.addAll(this.defineSet);
        cLProgramBuilder.optionSet.addAll(this.optionSet);
        return cLProgramBuilder;
    }

    @Override
    public CLProgram getProgram() {
        return this.program;
    }

    @Override
    public CLProgramBuilder setProgram(CLProgram cLProgram) {
        this.program = cLProgram;
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("CLProgramBuilder");
        stringBuilder.append("{options=").append(this.optionSet);
        stringBuilder.append(", defines=").append(this.defineSet);
        stringBuilder.append(", devices=").append(this.binariesMap);
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        CLProgramBuilder cLProgramBuilder = (CLProgramBuilder)object;
        if (this.source != null ? !this.source.equals(cLProgramBuilder.source) : cLProgramBuilder.source != null) {
            return false;
        }
        if (this.defineSet != null ? !this.defineSet.equals(cLProgramBuilder.defineSet) : cLProgramBuilder.defineSet != null) {
            return false;
        }
        if (this.optionSet != null ? !this.optionSet.equals(cLProgramBuilder.optionSet) : cLProgramBuilder.optionSet != null) {
            return false;
        }
        if (this.binariesMap != null && cLProgramBuilder.binariesMap != null) {
            if (this.binariesMap.size() != cLProgramBuilder.binariesMap.size()) {
                return false;
            }
            Iterator<CLDevice> iterator = this.binariesMap.keySet().iterator();
            Iterator<CLDevice> iterator2 = cLProgramBuilder.binariesMap.keySet().iterator();
            for (int i = 0; i < this.binariesMap.size(); ++i) {
                CLDevice cLDevice;
                CLDevice cLDevice2 = iterator.next();
                if (cLDevice2.equals(cLDevice = iterator2.next()) && Arrays.equals(this.binariesMap.get(cLDevice2), cLProgramBuilder.binariesMap.get(cLDevice))) continue;
                return false;
            }
        } else if (this.binariesMap != null || cLProgramBuilder.binariesMap != null) {
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = this.optionSet != null ? this.optionSet.hashCode() : 0;
        n = 31 * n + (this.defineSet != null ? this.defineSet.hashCode() : 0);
        n = 31 * n + (this.binariesMap != null ? this.binariesMap.hashCode() : 0);
        return n;
    }
}

