/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.Array1D;
import mitiv.array.Byte1D;
import mitiv.array.Double1D;
import mitiv.array.Float1D;
import mitiv.array.Int1D;
import mitiv.array.Long1D;
import mitiv.array.ShapedArray;
import mitiv.array.ShortArray;
import mitiv.array.ShortScalar;
import mitiv.array.impl.FlatShort1D;
import mitiv.array.impl.StriddenShort1D;
import mitiv.base.Shape;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.ShortFunction;
import mitiv.base.mapping.ShortScanner;
import mitiv.exception.IllegalTypeException;
import mitiv.exception.NonConformableArrayException;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.random.ShortGenerator;

public abstract class Short1D
extends Array1D
implements ShortArray {
    protected Short1D(int n) {
        super(n);
    }

    protected Short1D(int[] nArray) {
        super(nArray);
    }

    protected Short1D(Shape shape) {
        super(shape);
    }

    @Override
    public final int getType() {
        return 1;
    }

    public abstract short get(int var1);

    public abstract void set(int var1, short var2);

    @Override
    public void fill(short s) {
        for (int i = 0; i < this.dim1; ++i) {
            this.set(i, s);
        }
    }

    @Override
    public void increment(short s) {
        for (int i = 0; i < this.dim1; ++i) {
            this.set(i, (short)(this.get(i) + s));
        }
    }

    @Override
    public void decrement(short s) {
        for (int i = 0; i < this.dim1; ++i) {
            this.set(i, (short)(this.get(i) - s));
        }
    }

    @Override
    public void scale(short s) {
        for (int i = 0; i < this.dim1; ++i) {
            this.set(i, (short)(this.get(i) * s));
        }
    }

    @Override
    public void map(ShortFunction shortFunction) {
        for (int i = 0; i < this.dim1; ++i) {
            this.set(i, shortFunction.apply(this.get(i)));
        }
    }

    @Override
    public void fill(ShortGenerator shortGenerator) {
        for (int i = 0; i < this.dim1; ++i) {
            this.set(i, shortGenerator.nextShort());
        }
    }

    @Override
    public void scan(ShortScanner shortScanner) {
        shortScanner.initialize(this.get(0));
        for (int i = 1; i < this.dim1; ++i) {
            shortScanner.update(this.get(i));
        }
    }

    @Override
    public final short[] flatten() {
        return this.flatten(false);
    }

    @Override
    public short min() {
        short s = this.get(0);
        for (int i = 1; i < this.dim1; ++i) {
            short s2 = this.get(i);
            if (s2 >= s) continue;
            s = s2;
        }
        return s;
    }

    @Override
    public short max() {
        short s = this.get(0);
        for (int i = 1; i < this.dim1; ++i) {
            short s2 = this.get(i);
            if (s2 <= s) continue;
            s = s2;
        }
        return s;
    }

    @Override
    public short[] getMinAndMax() {
        short[] sArray = new short[2];
        this.getMinAndMax(sArray);
        return sArray;
    }

    @Override
    public void getMinAndMax(short[] sArray) {
        short s;
        short s2 = s = this.get(0);
        for (int i = 1; i < this.dim1; ++i) {
            short s3 = this.get(i);
            if (s3 < s) {
                s = s3;
            }
            if (s3 <= s2) continue;
            s2 = s3;
        }
        sArray[0] = s;
        sArray[1] = s2;
    }

    @Override
    public int sum() {
        int n = this.get(0);
        for (int i = 1; i < this.dim1; ++i) {
            n += this.get(i);
        }
        return n;
    }

    @Override
    public double average() {
        return (double)this.sum() / (double)this.number;
    }

    @Override
    public Byte1D toByte() {
        byte[] byArray = new byte[this.number];
        if (this.isFlat()) {
            short[] sArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                byArray[i] = (byte)sArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim1; ++i) {
                byArray[++n] = (byte)this.get(i);
            }
        }
        return Byte1D.wrap(byArray, this.getShape());
    }

    @Override
    public Short1D toShort() {
        return this;
    }

    @Override
    public Int1D toInt() {
        int[] nArray = new int[this.number];
        if (this.isFlat()) {
            short[] sArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                nArray[i] = sArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim1; ++i) {
                nArray[++n] = this.get(i);
            }
        }
        return Int1D.wrap(nArray, this.getShape());
    }

    @Override
    public Long1D toLong() {
        long[] lArray = new long[this.number];
        if (this.isFlat()) {
            short[] sArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                lArray[i] = sArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim1; ++i) {
                lArray[++n] = this.get(i);
            }
        }
        return Long1D.wrap(lArray, this.getShape());
    }

    @Override
    public Float1D toFloat() {
        float[] fArray = new float[this.number];
        if (this.isFlat()) {
            short[] sArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                fArray[i] = sArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim1; ++i) {
                fArray[++n] = this.get(i);
            }
        }
        return Float1D.wrap(fArray, this.getShape());
    }

    @Override
    public Double1D toDouble() {
        double[] dArray = new double[this.number];
        if (this.isFlat()) {
            short[] sArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                dArray[i] = sArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim1; ++i) {
                dArray[++n] = this.get(i);
            }
        }
        return Double1D.wrap(dArray, this.getShape());
    }

    @Override
    public Short1D copy() {
        return new FlatShort1D(this.flatten(true), this.shape);
    }

    @Override
    public void assign(ShapedArray shapedArray) {
        if (!this.getShape().equals(shapedArray.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        Short1D short1D = shapedArray.getType() == 1 ? (Short1D)shapedArray : (Short1D)shapedArray.toShort();
        for (int i = 0; i < this.dim1; ++i) {
            this.set(i, short1D.get(i));
        }
    }

    @Override
    public void assign(ShapedVector shapedVector) {
        if (!this.getShape().equals(shapedVector.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        if (shapedVector.getType() == 5) {
            DoubleShapedVector doubleShapedVector = (DoubleShapedVector)shapedVector;
            for (int i = 0; i < this.dim1; ++i) {
                this.set(i, (short)doubleShapedVector.get(i));
            }
        } else if (shapedVector.getType() == 4) {
            FloatShapedVector floatShapedVector = (FloatShapedVector)shapedVector;
            for (int i = 0; i < this.dim1; ++i) {
                this.set(i, (short)floatShapedVector.get(i));
            }
        } else {
            throw new IllegalTypeException();
        }
    }

    @Override
    public Short1D create() {
        return new FlatShort1D(this.getShape());
    }

    public static Short1D create(int n) {
        return new FlatShort1D(n);
    }

    public static Short1D create(int[] nArray) {
        return new FlatShort1D(nArray);
    }

    public static Short1D create(Shape shape) {
        return new FlatShort1D(shape);
    }

    public static Short1D wrap(short[] sArray, int n) {
        return new FlatShort1D(sArray, n);
    }

    public static Short1D wrap(short[] sArray, int[] nArray) {
        return new FlatShort1D(sArray, nArray);
    }

    public static Short1D wrap(short[] sArray, Shape shape) {
        return new FlatShort1D(sArray, shape);
    }

    public static Short1D wrap(short[] sArray, int n, int n2, int n3) {
        return new StriddenShort1D(sArray, n, n2, n3);
    }

    @Override
    public abstract ShortScalar slice(int var1);

    @Override
    public abstract ShortScalar slice(int var1, int var2);

    @Override
    public abstract Short1D view(Range var1);

    @Override
    public abstract Short1D view(int[] var1);

    @Override
    public abstract Short1D as1D();
}

