/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.multiplexer.video;

import com.sun.media.BasicPlugIn;
import com.sun.media.format.AviVideoFormat;
import com.sun.media.format.WavAudioFormat;
import com.sun.media.multiplexer.BasicMux;
import com.sun.media.parser.BasicPullParser;
import com.sun.media.util.ByteBuffer;
import java.awt.Dimension;
import java.io.IOException;
import java.util.Vector;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.format.AudioFormat;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;
import javax.media.format.YUVFormat;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.FileTypeDescriptor;

public class AVIMux
extends BasicMux {
    private int[] suggestedBufferSizes;
    private int[] suggestedBufferSizeOffsets;
    private int[] scaleOffsets;
    private boolean[] endOfMediaStatus;
    private int numberOfEoms = 0;
    private int width = 0;
    private int height = 0;
    private static final int MAX_FRAMES_STORED = 20000;
    private static final int AVIH_HEADER_LENGTH = 56;
    private static final int STRH_HEADER_LENGTH = 56;
    private static final int STRF_VIDEO_HEADER_LENGTH = 40;
    private static final int STRF_AUDIO_HEADER_LENGTH = 16;
    static final String AUDIO = "auds";
    static final String VIDEO = "vids";
    static final int AVIF_HASINDEX = 16;
    static final int AVIF_MUSTUSEINDEX = 32;
    static final int AVIF_ISINTERLEAVED = 256;
    static final int AVIF_WASCAPTUREFILE = 65536;
    static final int AVIF_COPYRIGHTED = 131072;
    static final int AVIF_KEYFRAME = 16;
    private int usecPerFrame = -1;
    private float frameRate = -1.0f;
    private int maxBytesPerSecond;
    private int paddingGranularity;
    private long avgFrameTime;
    private int flags = 16;
    private int totalDataLength = 0;
    private int totalFrames = 0;
    private int totalVideoFrames = 0;
    private int initialFrames;
    private int[] reserved = new int[4];
    private Vector chunkList = new Vector(1);
    private final int BUF_SIZE = 16384;
    private ByteBuffer bbuf = new ByteBuffer(16384);
    private int chunkOffset = 4;
    private int moviOffset = 0;
    private int avihOffset = 0;
    private int hdrlSizeOffset = 0;
    private int totalStrlLength = 0;
    private int blockAlign = 1;
    private int samplesPerBlock = -1;
    private double sampleRate = 0.0;
    private double audioDuration = 0.0;
    private int averageBytesPerSecond = -1;
    private int mp3BitRate = -1;
    private long cumulativeInterFrameTimeVideo = 0L;
    private long previousTimeStampVideo = 0L;
    static final String LISTRECORDCHUNK = "rec ";
    static final String VIDEO_MAGIC = "dc";
    static final String VIDEO_MAGIC_JPEG = "db";
    static final String VIDEO_MAGIC_IV32a = "iv";
    static final String VIDEO_MAGIC_IV32b = "32";
    static final String VIDEO_MAGIC_IV31 = "31";
    static final String VIDEO_MAGIC_CVID = "id";
    static final String AUDIO_MAGIC = "wb";
    Format littleEndian = new AudioFormat(null, -1.0, -1, -1, 0, -1);
    Format signed = new AudioFormat(null, -1.0, -1, -1, 0, 1);
    Format unsigned = new AudioFormat(null, -1.0, -1, -1, 0, 0);

    public AVIMux() {
        this.supportedInputs = new Format[2];
        this.supportedInputs[0] = new AudioFormat(null);
        this.supportedInputs[1] = new VideoFormat(null);
        this.supportedOutputs = new ContentDescriptor[1];
        this.supportedOutputs[0] = new FileTypeDescriptor("video.x_msvideo");
        this.chunkList.addElement(this.bbuf);
    }

    private Format[] createRGBFormats(Dimension size) {
        int NS = -1;
        Format[] rgbFormats = new Format[]{new RGBFormat(size, size.width * size.height * 2, Format.byteArray, NS, 16, 31744, 992, 31, 2, size.width * 2, 1, 1), new RGBFormat(size, size.width * size.height * 3, Format.byteArray, NS, 24, 3, 2, 1, 3, size.width * 3, 1, NS), new RGBFormat(size, size.width * size.height * 4, Format.byteArray, NS, 32, 3, 2, 1, 4, size.width * 4, 1, NS)};
        return rgbFormats;
    }

    private Format[] createYUVFormats(Dimension size) {
        int NS = -1;
        Format[] yuvFormats = new Format[]{new YUVFormat(size, size.width * size.height * 2, Format.byteArray, NS, 32, size.width * 2, size.width * 2, 1, 0, 2), new YUVFormat(size, size.width * size.height * 2, Format.byteArray, NS, 32, size.width * 2, size.width * 2, 0, 1, 3), new YUVFormat(size, size.width * size.height * 3 / 2, Format.byteArray, NS, 2, size.width, size.width / 2, 0, size.width * size.height, size.width * size.height * 5 / 4), new YUVFormat(size, size.width * size.height * 3 / 2, Format.byteArray, NS, 2, size.width, size.width / 2, 0, size.width * size.height * 5 / 4, size.width * size.height)};
        return yuvFormats;
    }

    public String getName() {
        return "AVI Multiplexer";
    }

    public Format setInputFormat(Format input, int trackID) {
        String reason = null;
        if (input instanceof AudioFormat) {
            Integer formatTag;
            String encoding;
            AudioFormat af = (AudioFormat)input;
            WavAudioFormat wavAudioFormat = null;
            if (input instanceof WavAudioFormat) {
                wavAudioFormat = (WavAudioFormat)input;
            }
            if ((encoding = af.getEncoding()) == null) {
                return null;
            }
            if (encoding.equalsIgnoreCase("LINEAR")) {
                if (af.getSampleSizeInBits() > 8) {
                    if (af.getEndian() == 1) {
                        return null;
                    }
                    if (af.getSigned() == 0) {
                        return null;
                    }
                    if (af.getEndian() == -1 || af.getSigned() == -1) {
                        input = (AudioFormat)af.intersects(this.signed);
                    }
                } else {
                    if (af.getSigned() == 1) {
                        return null;
                    }
                    if (af.getEndian() == -1 || af.getSigned() == -1) {
                        input = (AudioFormat)af.intersects(this.unsigned);
                    }
                }
            }
            if ((formatTag = (Integer)WavAudioFormat.reverseFormatMapper.get(encoding.toLowerCase())) == null || af.getEncoding().equalsIgnoreCase("truespeech") || af.getEncoding().toLowerCase().startsWith("voxware")) {
                reason = "Cannot handle format";
                return null;
            }
            short wFormatTag = formatTag.shortValue();
            switch (wFormatTag) {
                case 2: 
                case 17: 
                case 49: {
                    if (wavAudioFormat != null) break;
                    reason = "A WavAudioFormat is required  to provide encoding specific information for this encoding " + wFormatTag;
                    return null;
                }
            }
        } else if (input instanceof VideoFormat) {
            VideoFormat vf = (VideoFormat)input;
            String encoding = vf.getEncoding();
            Dimension size = vf.getSize();
            if (size == null) {
                size = new Dimension(320, 240);
            }
            if (encoding == null) {
                return null;
            }
            if (encoding.equalsIgnoreCase("rgb")) {
                if (BasicPlugIn.matches(vf, this.createRGBFormats(size)) == null) {
                    return null;
                }
            } else if (encoding.equalsIgnoreCase("yuv")) {
                if (BasicPlugIn.matches(vf, this.createYUVFormats(size)) == null) {
                    return null;
                }
            } else {
                if (encoding.equalsIgnoreCase("jpeg")) {
                    return null;
                }
                if (encoding.length() > 4) {
                    return null;
                }
            }
            this.frameRate = vf.getFrameRate();
            if (this.frameRate > 0.0f) {
                this.usecPerFrame = (int)(1.0f / this.frameRate * 1000000.0f);
            }
            this.avgFrameTime = this.usecPerFrame * 1000;
        } else {
            reason = "Can only support Audio and Video formats";
        }
        if (reason != null) {
            return null;
        }
        this.inputs[trackID] = input;
        return input;
    }

    public int setNumTracks(int nTracks) {
        if (nTracks > 2) {
            return 2;
        }
        this.suggestedBufferSizeOffsets = new int[nTracks];
        this.suggestedBufferSizes = new int[nTracks];
        this.endOfMediaStatus = new boolean[nTracks];
        int i2 = 0;
        while (i2 < nTracks) {
            this.suggestedBufferSizes[i2] = -1;
            this.suggestedBufferSizeOffsets[i2] = -1;
            ++i2;
        }
        return super.setNumTracks(nTracks);
    }

    public synchronized int doProcess(Buffer buffer, int trackID) {
        long timeStamp;
        if (buffer.isEOM()) {
            ++this.numberOfEoms;
            if (this.numberOfEoms >= this.numTracks) {
                return super.doProcess(buffer, trackID);
            }
            return 0;
        }
        if (buffer.getData() == null) {
            return 0;
        }
        boolean isVideoFormat = buffer.getFormat() instanceof VideoFormat;
        if (isVideoFormat && (double)((timeStamp = buffer.getTimeStamp()) - this.previousTimeStampVideo) > (double)this.avgFrameTime * 1.9) {
            int blankFrames = (int)((timeStamp - this.previousTimeStampVideo) / this.avgFrameTime);
            int i2 = 0;
            while (i2 < blankFrames) {
                Buffer blankBuffer = new Buffer();
                blankBuffer.setTimeStamp(this.previousTimeStampVideo + (long)i2 * this.avgFrameTime);
                blankBuffer.setFormat(buffer.getFormat());
                blankBuffer.setDuration(this.avgFrameTime);
                blankBuffer.setSequenceNumber(buffer.getSequenceNumber());
                blankBuffer.setFlags(buffer.getFlags() & 0xFFFFFFEF);
                int result = this.writeFrame(blankBuffer, trackID);
                if (result != 0) {
                    return result;
                }
                ++i2;
            }
        }
        return this.writeFrame(buffer, trackID);
    }

    private int writeFrame(Buffer buffer, int trackID) {
        boolean isVideoFormat = buffer.getFormat() instanceof VideoFormat;
        int length = buffer.getLength();
        int pad = (length & 1) > 0 ? 1 : 0;
        String aviEncodingMagic = this.getAviEncodingMagic(trackID, isVideoFormat);
        this.bufClear();
        this.bufWriteBytes(aviEncodingMagic);
        this.bufWriteIntLittleEndian(length + pad);
        this.bufFlush();
        if (length > 0) {
            this.write((byte[])buffer.getData(), buffer.getOffset(), length);
        }
        if (pad > 0) {
            this.bufClear();
            this.bufWriteByte((byte)0);
            this.bufFlush();
        }
        this.totalDataLength += length + pad;
        if (length > this.suggestedBufferSizes[trackID]) {
            this.suggestedBufferSizes[trackID] = length;
        }
        if (this.bbuf.length == 16384) {
            this.bbuf = new ByteBuffer(16384);
            this.chunkList.addElement(this.bbuf);
        }
        this.bbuf.writeBytes(aviEncodingMagic);
        int flag = (buffer.getFlags() & 0x10) != 0 ? 16 : 0;
        this.bbuf.writeIntLittleEndian(flag);
        this.bbuf.writeIntLittleEndian(this.chunkOffset);
        this.bbuf.writeIntLittleEndian(length);
        this.chunkOffset += length + pad + 8;
        if (isVideoFormat) {
            long timeStamp = buffer.getTimeStamp();
            if (this.totalVideoFrames > 0) {
                this.cumulativeInterFrameTimeVideo += timeStamp - this.previousTimeStampVideo;
            }
            this.previousTimeStampVideo = timeStamp;
            ++this.totalVideoFrames;
        } else if (this.samplesPerBlock != -1) {
            int numBlocks = length / this.blockAlign;
            int numSamples = numBlocks * this.samplesPerBlock;
            this.audioDuration += (double)numSamples / this.sampleRate;
        } else if (this.averageBytesPerSecond > 0) {
            this.audioDuration += (double)length / (double)this.averageBytesPerSecond;
        }
        ++this.totalFrames;
        return 0;
    }

    protected void writeHeader() {
        int i2 = 0;
        while (i2 < this.inputs.length) {
            if (this.inputs[i2] instanceof AudioFormat) {
                AudioFormat af = (AudioFormat)this.inputs[i2];
                WavAudioFormat wavAudioFormat = null;
                this.sampleRate = af.getSampleRate();
                if (af.getEncoding().equalsIgnoreCase("LINEAR")) {
                    this.samplesPerBlock = 1;
                }
                if (this.inputs[i2] instanceof WavAudioFormat) {
                    wavAudioFormat = (WavAudioFormat)this.inputs[i2];
                    byte[] codecSpecificHeader = wavAudioFormat.getCodecSpecificHeader();
                    if (!af.getEncoding().equalsIgnoreCase("mpeglayer3") && codecSpecificHeader != null && codecSpecificHeader.length >= 2) {
                        try {
                            this.samplesPerBlock = BasicPullParser.parseShortFromArray(codecSpecificHeader, false);
                        }
                        catch (IOException e2) {
                            System.err.println("Unable to parse codecSpecificHeader");
                        }
                    }
                }
            }
            ++i2;
        }
        this.bufClear();
        this.bufWriteBytes("RIFF");
        this.bufSkip(4);
        this.bufWriteBytes("AVI ");
        this.bufWriteBytes("LIST");
        this.hdrlSizeOffset = this.filePointer;
        this.bufSkip(4);
        this.bufWriteBytes("hdrl");
        this.bufWriteBytes("avih");
        this.bufWriteIntLittleEndian(56);
        this.avihOffset = this.filePointer;
        this.bufSkip(56);
        this.scaleOffsets = new int[this.numTracks];
        int i3 = 0;
        while (i3 < this.numTracks) {
            Format format = this.inputs[i3];
            boolean isVideo = format instanceof VideoFormat;
            this.bufWriteBytes("LIST");
            byte[] codecSpecificHeader = null;
            int extraByteLength = 0;
            AviVideoFormat aviVideoFormat = null;
            WavAudioFormat wavAudioFormat = null;
            int planes = 1;
            int depth = 24;
            String yuvEncoding = null;
            String encoding = format.getEncoding();
            int wFormatTag = -1;
            if (isVideo) {
                int bytesInBitmap = 40;
                RGBFormat rgbFormat = null;
                if (format instanceof RGBFormat) {
                    rgbFormat = (RGBFormat)format;
                } else if (format instanceof YUVFormat) {
                    YUVFormat yuv = (YUVFormat)format;
                    if (yuv.getYuvType() == 32 && yuv.getStrideY() == yuv.getSize().width * 2 && yuv.getOffsetY() == 0 && yuv.getOffsetU() == 1 && yuv.getOffsetV() == 3) {
                        yuvEncoding = "YUY2";
                    } else if (yuv.getYuvType() == 32 && yuv.getStrideY() == yuv.getSize().width * 2 && yuv.getOffsetY() == 1 && yuv.getOffsetU() == 0 && yuv.getOffsetV() == 2) {
                        yuvEncoding = "UYVY";
                    } else if (yuv.getYuvType() == 32 && yuv.getStrideY() == yuv.getSize().width * 2 && yuv.getOffsetY() == 0 && yuv.getOffsetU() == 3 && yuv.getOffsetV() == 1) {
                        yuvEncoding = "YVYU";
                    } else if (yuv.getYuvType() == 2 && yuv.getStrideY() == yuv.getSize().width && yuv.getStrideUV() == yuv.getSize().width / 2) {
                        yuvEncoding = yuv.getOffsetU() < yuv.getOffsetV() ? "I420" : "YV12";
                    }
                }
                if (format instanceof AviVideoFormat) {
                    aviVideoFormat = (AviVideoFormat)format;
                }
                if (aviVideoFormat != null) {
                    planes = aviVideoFormat.getPlanes();
                    depth = aviVideoFormat.getBitsPerPixel();
                    codecSpecificHeader = aviVideoFormat.getCodecSpecificHeader();
                } else if (rgbFormat != null) {
                    depth = rgbFormat.getBitsPerPixel();
                }
            } else {
                Integer formatTag;
                if (format instanceof WavAudioFormat) {
                    wavAudioFormat = (WavAudioFormat)format;
                    codecSpecificHeader = wavAudioFormat.getCodecSpecificHeader();
                }
                if (codecSpecificHeader == null && (formatTag = (Integer)WavAudioFormat.reverseFormatMapper.get(encoding.toLowerCase())) != null && (wFormatTag = (int)formatTag.shortValue()) == 85) {
                    extraByteLength = 12;
                }
            }
            if (extraByteLength <= 0 && codecSpecificHeader != null) {
                extraByteLength = codecSpecificHeader.length;
            }
            int strlLength = 0;
            if (isVideo) {
                strlLength = 116 + extraByteLength;
                this.bufWriteIntLittleEndian(strlLength);
            } else {
                strlLength = extraByteLength > 0 ? 92 + extraByteLength + 2 : 92;
                this.bufWriteIntLittleEndian(strlLength);
            }
            this.totalStrlLength += strlLength;
            this.bufWriteBytes("strl");
            this.bufWriteBytes("strh");
            this.bufWriteIntLittleEndian(56);
            if (isVideo) {
                this.bufWriteBytes(VIDEO);
                if (encoding.startsWith("rgb")) {
                    encoding = "DIB ";
                } else if (yuvEncoding != null) {
                    encoding = yuvEncoding;
                }
                this.bufWriteBytes(encoding);
            } else {
                this.bufWriteBytes(AUDIO);
                this.bufWriteIntLittleEndian(0);
            }
            this.bufWriteIntLittleEndian(0);
            this.bufWriteIntLittleEndian(0);
            this.bufWriteIntLittleEndian(0);
            this.scaleOffsets[i3] = this.filePointer;
            this.bufWriteIntLittleEndian(1);
            this.bufWriteIntLittleEndian(15);
            this.bufWriteIntLittleEndian(0);
            this.bufWriteIntLittleEndian(0);
            this.suggestedBufferSizeOffsets[i3] = this.filePointer;
            this.bufWriteIntLittleEndian(0);
            this.bufWriteIntLittleEndian(10000);
            this.bufWriteIntLittleEndian(0);
            this.bufWriteIntLittleEndian(0);
            this.bufWriteIntLittleEndian(0);
            this.bufWriteBytes("strf");
            if (isVideo) {
                this.bufWriteIntLittleEndian(40 + extraByteLength);
                this.bufWriteIntLittleEndian(40 + extraByteLength);
                this.width = ((VideoFormat)format).getSize().width;
                this.height = ((VideoFormat)format).getSize().height;
                this.bufWriteIntLittleEndian(this.width);
                this.bufWriteIntLittleEndian(this.height);
                this.bufWriteShortLittleEndian((short)planes);
                this.bufWriteShortLittleEndian((short)depth);
                if (encoding.startsWith("DIB")) {
                    this.bufWriteIntLittleEndian(0);
                } else {
                    this.bufWriteBytes(encoding);
                }
                int biSizeImage = 0;
                int biXPelsPerMeter = 0;
                int biYPelsPerMeter = 0;
                int biClrUsed = 0;
                int biClrImportant = 0;
                if (aviVideoFormat != null) {
                    if (aviVideoFormat.getImageSize() != -1) {
                        biSizeImage = aviVideoFormat.getImageSize();
                    }
                    if (aviVideoFormat.getXPelsPerMeter() != -1) {
                        biXPelsPerMeter = aviVideoFormat.getXPelsPerMeter();
                    }
                    if (aviVideoFormat.getYPelsPerMeter() != -1) {
                        biYPelsPerMeter = aviVideoFormat.getYPelsPerMeter();
                    }
                    if (aviVideoFormat.getClrUsed() != -1) {
                        biClrUsed = aviVideoFormat.getClrUsed();
                    }
                    if (aviVideoFormat.getClrImportant() != -1) {
                        biClrImportant = aviVideoFormat.getClrImportant();
                    }
                }
                this.bufWriteIntLittleEndian(biSizeImage);
                this.bufWriteIntLittleEndian(biXPelsPerMeter);
                this.bufWriteIntLittleEndian(biYPelsPerMeter);
                this.bufWriteIntLittleEndian(biClrUsed);
                this.bufWriteIntLittleEndian(biClrImportant);
            } else {
                Integer formatTag;
                AudioFormat audioFormat = (AudioFormat)format;
                if (extraByteLength > 0) {
                    this.bufWriteIntLittleEndian(16 + extraByteLength + 2);
                } else {
                    this.bufWriteIntLittleEndian(16);
                }
                if (encoding.equals("unknown")) {
                    encoding = "LINEAR";
                }
                if ((formatTag = (Integer)WavAudioFormat.reverseFormatMapper.get(encoding.toLowerCase())) != null) {
                    this.bufWriteShortLittleEndian(formatTag.shortValue());
                    short numChannels = (short)audioFormat.getChannels();
                    this.bufWriteShortLittleEndian(numChannels);
                    this.bufWriteIntLittleEndian((int)audioFormat.getSampleRate());
                    short sampleSizeInBits = (short)audioFormat.getSampleSizeInBits();
                    if (wavAudioFormat != null) {
                        this.averageBytesPerSecond = wavAudioFormat.getAverageBytesPerSecond();
                        if (formatTag.shortValue() == 85) {
                            this.mp3BitRate = this.averageBytesPerSecond * 8;
                        }
                    } else if (formatTag.shortValue() == 85) {
                        int frameRate = (int)audioFormat.getFrameRate();
                        if (frameRate != -1) {
                            this.averageBytesPerSecond = frameRate;
                            this.mp3BitRate = this.averageBytesPerSecond * 8;
                        } else {
                            this.averageBytesPerSecond = (int)audioFormat.getSampleRate() * numChannels * (sampleSizeInBits / 8);
                        }
                    } else {
                        this.averageBytesPerSecond = (int)audioFormat.getSampleRate() * numChannels * (sampleSizeInBits / 8);
                    }
                    this.bufWriteIntLittleEndian(this.averageBytesPerSecond);
                    this.blockAlign = audioFormat.getFrameSizeInBits() / 8;
                    if (this.blockAlign < 1) {
                        this.blockAlign = sampleSizeInBits * numChannels / 8;
                    }
                    if (this.blockAlign == 0) {
                        this.blockAlign = 1;
                    }
                    if (this.mp3BitRate > 0) {
                        this.blockAlign = 1;
                    }
                    this.bufWriteShortLittleEndian((short)this.blockAlign);
                    this.bufWriteShortLittleEndian(sampleSizeInBits);
                }
            }
            if (extraByteLength > 0) {
                if (!isVideo) {
                    if (codecSpecificHeader != null) {
                        this.bufWriteShortLittleEndian((short)codecSpecificHeader.length);
                        this.bufWriteBytes(codecSpecificHeader);
                    } else {
                        Integer formatTag = (Integer)WavAudioFormat.reverseFormatMapper.get(encoding.toLowerCase());
                        if (formatTag != null && (wFormatTag = (int)formatTag.shortValue()) == 85) {
                            int blockSize;
                            AudioFormat af = (AudioFormat)this.inputs[i3];
                            int frameRate = (int)af.getFrameRate();
                            if (frameRate > 0) {
                                float temp = 72.0f * (float)frameRate * 8.0f / 8000.0f;
                                temp = (float)((double)temp * (8000.0 / af.getSampleRate()));
                                blockSize = (int)temp;
                            } else {
                                blockSize = 417;
                            }
                            this.bufWriteShortLittleEndian((short)12);
                            this.bufWriteShortLittleEndian((short)1);
                            this.bufWriteIntLittleEndian(2);
                            this.bufWriteShortLittleEndian((short)blockSize);
                            this.bufWriteShortLittleEndian((short)1);
                            this.bufWriteShortLittleEndian((short)1393);
                        }
                    }
                } else {
                    this.bufWriteBytes(codecSpecificHeader);
                }
            }
            ++i3;
        }
        this.bufWriteBytes("LIST");
        this.moviOffset = this.filePointer;
        this.bufSkip(4);
        this.bufWriteBytes("movi");
        this.bufFlush();
        this.seek(this.hdrlSizeOffset);
        int hdrlSize = this.totalStrlLength + 56 + 4 * (3 + 2 * this.numTracks);
        this.bufClear();
        this.bufWriteIntLittleEndian(hdrlSize);
        this.bufFlush();
        this.seek(this.moviOffset + 8);
    }

    protected void writeFooter() {
        this.writeIDX1Chunk();
        this.writeAVIH();
        this.seek(this.moviOffset);
        this.bufClear();
        this.bufWriteIntLittleEndian(4 + this.totalDataLength + this.totalFrames * 8);
        this.bufFlush();
        int i2 = 0;
        while (i2 < this.numTracks) {
            int offset = this.suggestedBufferSizeOffsets[i2];
            if (offset > 0) {
                this.seek(offset);
                this.bufClear();
                this.bufWriteIntLittleEndian(this.suggestedBufferSizes[i2]);
                this.bufFlush();
            }
            this.seek(this.scaleOffsets[i2]);
            if (this.inputs[i2] instanceof VideoFormat) {
                int rateVal = 10000;
                this.bufClear();
                this.bufWriteIntLittleEndian(this.usecPerFrame / 100);
                this.bufWriteIntLittleEndian(rateVal);
                this.bufWriteIntLittleEndian(0);
                this.bufWriteIntLittleEndian(this.totalVideoFrames);
                this.bufFlush();
            } else {
                AudioFormat audioFormat = (AudioFormat)this.inputs[i2];
                if (this.mp3BitRate > 0) {
                    this.bufClear();
                    this.bufWriteIntLittleEndian(8);
                    this.bufFlush();
                    this.bufClear();
                    this.bufWriteIntLittleEndian(this.mp3BitRate);
                    this.bufFlush();
                    this.blockAlign = 1;
                } else {
                    this.bufClear();
                    this.bufWriteIntLittleEndian(this.blockAlign);
                    this.bufFlush();
                    int factor = 1;
                    if (this.samplesPerBlock > 0) {
                        factor = this.samplesPerBlock;
                    }
                    int rate = (int)(audioFormat.getSampleRate() / (double)factor * (double)this.blockAlign);
                    this.bufClear();
                    this.bufWriteIntLittleEndian(rate);
                    this.bufFlush();
                }
                this.seek(this.filePointer + 16);
                this.bufClear();
                this.bufWriteIntLittleEndian(this.blockAlign);
                this.bufFlush();
            }
            ++i2;
        }
        this.seek(4);
        this.bufClear();
        this.bufWriteIntLittleEndian(this.fileSize - 8);
        this.bufFlush();
    }

    private void writeIDX1Chunk() {
        this.bufClear();
        this.bufWriteBytes("idx1");
        this.bufWriteIntLittleEndian(this.totalFrames * 16);
        this.bufFlush();
        int i2 = 0;
        while (i2 < this.chunkList.size()) {
            ByteBuffer bbuf = (ByteBuffer)this.chunkList.elementAt(i2);
            this.write(bbuf.buffer, 0, bbuf.length);
            ++i2;
        }
    }

    private void writeAVIH() {
        int audioFrames = 0;
        if (this.totalVideoFrames <= 0) {
            this.usecPerFrame = 1000;
            audioFrames = (int)(this.audioDuration * 1000000.0 / (double)this.usecPerFrame);
        } else {
            int computedUsecPerFrame;
            this.usecPerFrame = computedUsecPerFrame = (int)((double)this.cumulativeInterFrameTimeVideo / (1000.0 * (double)(this.totalVideoFrames - 1)));
        }
        this.seek(this.avihOffset);
        this.bufClear();
        this.bufWriteIntLittleEndian(this.usecPerFrame);
        this.bufWriteIntLittleEndian(this.maxBytesPerSecond);
        this.bufWriteIntLittleEndian(this.paddingGranularity);
        this.bufWriteIntLittleEndian(this.flags);
        if (this.totalVideoFrames > 0) {
            this.bufWriteIntLittleEndian(this.totalVideoFrames);
        } else {
            this.bufWriteIntLittleEndian(audioFrames);
        }
        this.bufWriteIntLittleEndian(this.initialFrames);
        this.bufWriteIntLittleEndian(this.numTracks);
        this.bufWriteIntLittleEndian(0);
        this.bufWriteIntLittleEndian(this.width);
        this.bufWriteIntLittleEndian(this.height);
        this.bufWriteIntLittleEndian(0);
        this.bufWriteIntLittleEndian(0);
        this.bufWriteIntLittleEndian(0);
        this.bufWriteIntLittleEndian(0);
        this.bufFlush();
    }

    private String getAviEncodingMagic(int streamNumber, boolean isVideoFormat) {
        String encoding = this.inputs[streamNumber].getEncoding().toLowerCase();
        String magic = isVideoFormat ? (encoding.equalsIgnoreCase("cvid") ? VIDEO_MAGIC_CVID : (encoding.startsWith("iv32") ? VIDEO_MAGIC_IV32b : (encoding.startsWith("iv31") ? VIDEO_MAGIC_IV31 : (encoding.startsWith(VIDEO_MAGIC_IV32a) ? VIDEO_MAGIC_IV32a : VIDEO_MAGIC)))) : AUDIO_MAGIC;
        String streamPrefix = null;
        if (streamNumber == 0) {
            streamPrefix = "00";
        } else if (streamNumber == 1) {
            streamPrefix = "01";
        } else if (streamNumber == 2) {
            streamPrefix = "02";
        } else if (streamNumber == 3) {
            streamPrefix = "03";
        } else if (streamNumber == 4) {
            streamPrefix = "04";
        }
        return streamPrefix + magic;
    }
}

