/*
 * Decompiled with CFR 0.152.
 */
package mitiv.linalg.shaped;

import mitiv.array.ShapedArray;
import mitiv.base.ArrayDescriptor;
import mitiv.base.Shape;
import mitiv.base.Shaped;
import mitiv.base.Typed;
import mitiv.linalg.Vector;
import mitiv.linalg.shaped.ShapedVectorSpace;

public abstract class ShapedVector
extends Vector
implements Shaped,
Typed {
    final ArrayDescriptor descr;

    ShapedVector(ShapedVectorSpace shapedVectorSpace) {
        super(shapedVectorSpace);
        this.descr = shapedVectorSpace.descr;
    }

    @Override
    public ShapedVectorSpace getOwner() {
        return (ShapedVectorSpace)this.space;
    }

    @Override
    public ShapedVectorSpace getSpace() {
        return this.getOwner();
    }

    @Override
    public final int getType() {
        return this.descr.getType();
    }

    @Override
    public final int getRank() {
        return this.descr.getRank();
    }

    @Override
    public final int getOrder() {
        return this.descr.getOrder();
    }

    @Override
    public final Shape getShape() {
        return this.descr.getShape();
    }

    @Override
    public final int getDimension(int n) {
        return this.descr.getDimension(n);
    }

    @Override
    public ShapedVector create() {
        return this.getSpace().create();
    }

    @Override
    public ShapedVector clone() {
        return this.getSpace()._clone(this);
    }

    public abstract void assign(ShapedArray var1);

    public abstract ShapedArray asShapedArray();

    @Override
    public String toString() {
        int n = this.getNumber();
        String string = "ShapedVector: " + this.descr.toString() + " = {";
        if (n < 9) {
            for (int i = 0; i < n; ++i) {
                string = string + String.format(i > 0 ? ", %g" : " %g", this.get(i));
            }
        } else {
            int n2;
            for (n2 = 0; n2 < 3; ++n2) {
                string = string + String.format(n2 > 0 ? ", %g" : " %g", this.get(n2));
            }
            string = string + ", ...";
            for (n2 = n - 3; n2 < n; ++n2) {
                string = string + String.format(", %g", this.get(n2));
            }
        }
        return string + "}";
    }
}

