/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.services;

import java.io.IOException;
import loci.common.services.AbstractService;
import loci.formats.FormatException;
import loci.formats.services.WlzService;
import uk.ac.mrc.hgu.Wlz.WlzDVertex3;
import uk.ac.mrc.hgu.Wlz.WlzException;
import uk.ac.mrc.hgu.Wlz.WlzFileInputStream;
import uk.ac.mrc.hgu.Wlz.WlzFileOutputStream;
import uk.ac.mrc.hgu.Wlz.WlzFileStream;
import uk.ac.mrc.hgu.Wlz.WlzIBox3;
import uk.ac.mrc.hgu.Wlz.WlzIVertex2;
import uk.ac.mrc.hgu.Wlz.WlzIVertex3;
import uk.ac.mrc.hgu.Wlz.WlzObject;

public class WlzServiceImpl
extends AbstractService
implements WlzService {
    public static final String WLZ_ORG_LABEL = "WoolzOrigin";
    public static final String NO_WLZ_MSG = "\nWoolz is required to read and write Woolz objects.\nPlease obtain the necessary JAR and native library files from:\nhttp://www.emouseatlas.org/emap/analysis_tools_resources/software/woolz.html.\nThe source code for these is also available from:\nhttps://github.com/ma-tech/Woolz.";
    public static final int WLZ_SERVICE_UNKNOWN = 0;
    public static final int WLZ_SERVICE_READ = 1;
    public static final int WLZ_SERVICE_WRITE = 2;
    private int state = 0;
    private int pixelType = 1;
    private int objType = 0;
    private int objGType = 8;
    private String wlzVersion = new String("unknown");
    private WlzIBox3 bBox = null;
    private WlzDVertex3 voxSz = null;
    private WlzObject wlzObj = null;
    private WlzFileStream wlzFP = null;

    public WlzServiceImpl() {
        this.checkClassDependency(WlzObject.class);
    }

    @Override
    protected void checkClassDependency(Class<? extends Object> klass) {
        String[] v = new String[1];
        WlzObject.WlzGetVersion(v);
    }

    @Override
    public String getNoWlzMsg() {
        return new String(NO_WLZ_MSG);
    }

    @Override
    public String getWlzOrgLabelName() {
        return new String(WLZ_ORG_LABEL);
    }

    @Override
    public void open(String file2, String rw) throws FormatException, IOException {
        try {
            String[] v = new String[1];
            WlzObject.WlzGetVersion(v);
            this.wlzVersion = new String(v[0]);
        }
        catch (UnsatisfiedLinkError e) {
            throw new FormatException(NO_WLZ_MSG, e);
        }
        if (rw.equals("r")) {
            this.openRead(file2);
        } else if (rw.equals("w")) {
            this.openWrite(file2);
        } else {
            throw new IOException("Failed to open file " + file2);
        }
    }

    @Override
    public int getSizeX() {
        int sz = this.bBox == null ? 0 : this.bBox.xMax - this.bBox.xMin + 1;
        return sz;
    }

    @Override
    public int getSizeY() {
        int sz = this.bBox == null ? 0 : this.bBox.yMax - this.bBox.yMin + 1;
        return sz;
    }

    @Override
    public int getSizeZ() {
        int sz = this.bBox == null ? 0 : this.bBox.zMax - this.bBox.zMin + 1;
        return sz;
    }

    @Override
    public int getSizeC() {
        int sz = this.objGType == 7 ? 4 : 1;
        return sz;
    }

    @Override
    public int getSizeT() {
        return 1;
    }

    @Override
    public boolean isRGB() {
        boolean rgb = this.objGType == 7;
        return rgb;
    }

    @Override
    public double getVoxSzX() {
        double sz = this.voxSz == null ? 1.0 : this.voxSz.vtX;
        return sz;
    }

    @Override
    public double getVoxSzY() {
        double sz = this.voxSz == null ? 1.0 : this.voxSz.vtY;
        return sz;
    }

    @Override
    public double getVoxSzZ() {
        double sz = this.voxSz == null ? 1.0 : this.voxSz.vtZ;
        return sz;
    }

    @Override
    public double getOrgX() {
        int og = this.bBox == null ? 0 : this.bBox.xMin;
        return og;
    }

    @Override
    public double getOrgY() {
        int og = this.bBox == null ? 0 : this.bBox.yMin;
        return og;
    }

    @Override
    public double getOrgZ() {
        int og = this.bBox == null ? 0 : this.bBox.zMin;
        return og;
    }

    @Override
    public int[] getSupPixelTypes() {
        return new int[]{1, 2, 4, 6, 7};
    }

    @Override
    public int getPixelType() {
        switch (this.objGType) {
            case 2: {
                this.pixelType = 2;
                break;
            }
            case 1: {
                this.pixelType = 4;
                break;
            }
            case 4: {
                this.pixelType = 6;
                break;
            }
            case 5: {
                this.pixelType = 7;
                break;
            }
            default: {
                this.pixelType = 1;
            }
        }
        return this.pixelType;
    }

    @Override
    public void setupWrite(int orgX, int orgY, int orgZ, int pixSzX, int pixSzY, int pixSzZ, int pixSzC, int pixSzT, double voxSzX, double voxSzY, double voxSzZ, int gType) throws FormatException {
        this.bBox = new WlzIBox3();
        this.bBox.xMin = orgX;
        this.bBox.yMin = orgY;
        this.bBox.zMin = orgZ;
        this.bBox.xMax = orgX + pixSzX - 1;
        this.bBox.yMax = orgY + pixSzY - 1;
        this.bBox.zMax = orgZ + pixSzZ - 1;
        this.voxSz = new WlzDVertex3(voxSzX, voxSzY, voxSzZ);
        if (this.bBox.xMax < this.bBox.xMin || this.bBox.yMax < this.bBox.yMin || this.bBox.zMax < this.bBox.zMin || pixSzC <= 0 || pixSzT <= 0) {
            throw new FormatException("Invalid image size (" + (this.bBox.xMax - this.bBox.xMin + 1) + ", " + (this.bBox.yMax - this.bBox.yMin + 1) + ", " + (this.bBox.zMax - this.bBox.zMin + 1) + ", " + pixSzC + ", " + pixSzT + ")");
        }
        switch (gType) {
            case 1: {
                this.objGType = 3;
                break;
            }
            case 2: {
                this.objGType = 2;
                break;
            }
            case 4: {
                this.objGType = 1;
                break;
            }
            case 6: {
                this.objGType = 4;
                break;
            }
            case 7: {
                this.objGType = 5;
                break;
            }
            default: {
                throw new FormatException("Invalid image value type");
            }
        }
        this.objType = this.bBox.zMax == this.bBox.zMin ? 1 : 2;
        try {
            this.wlzObj = WlzObject.WlzMakeEmpty();
        }
        catch (WlzException e) {
            throw new FormatException("Failed to create Woolz object", e);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.wlzObj != null) {
            if (this.state == 2) {
                try {
                    if (this.objType == 2) {
                        WlzObject.WlzSetVoxelSize(this.wlzObj, this.voxSz.vtX, this.voxSz.vtY, this.voxSz.vtZ);
                    }
                    WlzObject.WlzWriteObj(this.wlzFP, this.wlzObj);
                }
                catch (WlzException e) {
                    throw new IOException("Failed to write to Woolz object (" + e + ")");
                }
            }
            this.wlzObj = null;
        }
        if (this.wlzFP != null) {
            this.wlzFP.close();
            this.wlzFP = null;
        }
    }

    @Override
    public byte[] readBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        if (this.wlzObj == null || this.state != 1) {
            throw new FormatException("Uninitialised Woolz service");
        }
        try {
            switch (this.objType) {
                case 1: {
                    buf = this.readBytes2DDomObj(buf, x, y, w, h);
                    break;
                }
                case 2: {
                    buf = this.readBytes3DDomObj(buf, x, y, no, w, h);
                    break;
                }
                default: {
                    throw new FormatException("Unsupported Woolz object type " + this.objType);
                }
            }
        }
        catch (WlzException e) {
            throw new FormatException("Failed to copy bytes from Woolz object (" + e + ")");
        }
        return buf;
    }

    @Override
    public void saveBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        if (this.state == 2) {
            WlzIVertex3 og = new WlzIVertex3(x + this.bBox.xMin, y + this.bBox.yMin, no + this.bBox.zMin);
            WlzIVertex2 sz = new WlzIVertex2(w, h);
            try {
                this.wlzObj = WlzObject.WlzBuildObj3B(this.wlzObj, og, sz, this.objGType, buf.length, buf);
            }
            catch (WlzException e) {
                throw new FormatException("Failed save bytes to Woolz object", e);
            }
        }
    }

    private void openRead(String file2) throws FormatException, IOException {
        this.state = 1;
        try {
            this.wlzFP = new WlzFileInputStream(file2);
            this.wlzObj = WlzObject.WlzReadObj(this.wlzFP);
            this.bBox = WlzObject.WlzBoundingBox3I(this.wlzObj);
            this.objType = WlzObject.WlzGetObjectType(this.wlzObj);
            this.voxSz = this.objType == 2 ? WlzObject.WlzGetVoxelSize(this.wlzObj) : new WlzDVertex3(1.0, 1.0, 1.0);
        }
        catch (WlzException e) {
            throw new IOException("Failed to read Woolz object (" + e + ")", e);
        }
        try {
            if (this.objType == 80 || this.objType == 81) {
                int count = this.objType == 80 ? 1 : 2;
                WlzObject[][] dest = new WlzObject[1][count];
                WlzObject.WlzExplode(new int[]{count}, dest, this.wlzObj);
                this.wlzObj = dest[0][0];
                this.bBox = WlzObject.WlzBoundingBox3I(this.wlzObj);
                this.objType = WlzObject.WlzGetObjectType(this.wlzObj);
                if (this.objType == 2) {
                    this.voxSz = WlzObject.WlzGetVoxelSize(this.wlzObj);
                }
            }
            if (WlzObject.WlzObjectValuesIsNull(this.wlzObj) != 0) {
                this.objGType = 8;
            } else {
                if (WlzObject.WlzGetObjectValuesType(this.wlzObj) > 7) {
                    throw new FormatException("Value table data not supported");
                }
                this.objGType = WlzObject.WlzGreyTypeFromObj(this.wlzObj);
            }
        }
        catch (WlzException e) {
            throw new FormatException("Unable to determine Woolz object value type (" + e + ")", e);
        }
        switch (this.objGType) {
            case 3: {
                break;
            }
            case 2: {
                break;
            }
            case 1: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                break;
            }
            default: {
                throw new FormatException("Inappropriate Woolz object value type (type = " + this.objGType + ")");
            }
        }
    }

    private void openWrite(String file2) throws FormatException, IOException {
        this.state = 2;
        try {
            this.wlzFP = new WlzFileOutputStream(file2);
        }
        catch (IOException e) {
            throw new IOException("Failed to open " + file2 + "for writing.");
        }
    }

    private byte[] readBytes2DDomObj(byte[] buf, int x, int y, int w, int h) throws WlzException {
        WlzIVertex2 og = new WlzIVertex2(x + this.bBox.xMin, y + this.bBox.yMin);
        WlzIVertex2 sz = new WlzIVertex2(w, h);
        WlzIVertex2[] dstSz = new WlzIVertex2[]{null};
        switch (this.objGType) {
            case 3: {
                byte[][][] dstDat = new byte[1][][];
                WlzObject.WlzToUArray2D(dstSz, dstDat, this.wlzObj, og, sz, 0);
                for (int idY = 0; idY < h; ++idY) {
                    int idYW = idY * w;
                    for (int idX = 0; idX < w; ++idX) {
                        buf[idYW + idX] = dstDat[0][idY][idX];
                    }
                }
                break;
            }
            case 2: {
                int m = 255;
                short[][][] dstDat = new short[1][][];
                WlzObject.WlzToSArray2D(dstSz, dstDat, this.wlzObj, og, sz, 0);
                for (int idY = 0; idY < h; ++idY) {
                    int idYW = idY * w;
                    for (int idX = 0; idX < w; ++idX) {
                        short p = dstDat[0][idY][idX];
                        buf[2 * (idYW + idX)] = (byte)(p >>> 8 & m);
                        buf[2 * (idYW + idX) + 1] = (byte)(p & m);
                    }
                }
                break;
            }
            case 1: {
                int m = 255;
                int[][][] dstDat = new int[1][][];
                WlzObject.WlzToIArray2D(dstSz, dstDat, this.wlzObj, og, sz, 0);
                for (int idY = 0; idY < h; ++idY) {
                    int idYW = idY * w;
                    for (int idX = 0; idX < w; ++idX) {
                        int p = dstDat[0][idY][idX];
                        buf[idYW + 4 * idX] = (byte)(p >> 24 & m);
                        buf[idYW + 4 * idX + 1] = (byte)(p >> 16 & m);
                        buf[idYW + 4 * idX + 2] = (byte)(p >> 8 & m);
                        buf[idYW + 4 * idX + 3] = (byte)(p & m);
                    }
                }
                break;
            }
            case 7: {
                int m = 255;
                int cOff = h * w;
                int[][][] dstDat = new int[1][][];
                WlzObject.WlzToRArray2D(dstSz, dstDat, this.wlzObj, og, sz, 0);
                for (int idY = 0; idY < h; ++idY) {
                    int idYW = idY * w;
                    for (int idX = 0; idX < w; ++idX) {
                        int idYWX = idYW + idX;
                        int p = dstDat[0][idY][idX];
                        buf[idYWX] = (byte)(p >> 0 & m);
                        buf[idYWX + cOff] = (byte)(p >> 8 & m);
                        buf[idYWX + 2 * cOff] = (byte)(p >> 16 & m);
                        buf[idYWX + 3 * cOff] = (byte)(p >> 24 & m);
                    }
                }
                break;
            }
            case 8: {
                int w8 = (w + 7) / 8;
                byte[][][] dstDat = new byte[1][][];
                WlzObject.WlzToBArray2D(dstSz, dstDat, this.wlzObj, og, sz, 0);
                for (int idY = 0; idY < h; ++idY) {
                    int idYW = idY * w;
                    int idYW8 = idY * w8;
                    for (int idX = 0; idX < w; ++idX) {
                        byte p = dstDat[0][idY][idX / 8];
                        byte b = (byte)(p & 1 << idX % 8);
                        buf[idYW + idX] = b == 0 ? 0 : -1;
                    }
                }
                break;
            }
            default: {
                throw new WlzException("Unsupported pixel type");
            }
        }
        return buf;
    }

    private byte[] readBytes3DDomObj(byte[] buf, int x, int y, int z, int w, int h) throws WlzException {
        WlzIVertex3 og = new WlzIVertex3(x + this.bBox.xMin, y + this.bBox.yMin, z + this.bBox.zMin);
        WlzIVertex3 sz = new WlzIVertex3(w, h, 1);
        WlzIVertex3[] dstSz = new WlzIVertex3[]{null};
        switch (this.objGType) {
            case 3: {
                byte[][][][] dstDat = new byte[1][][][];
                WlzObject.WlzToUArray3D(dstSz, dstDat, this.wlzObj, og, sz, 0);
                for (int idY = 0; idY < h; ++idY) {
                    int idYW = idY * w;
                    for (int idX = 0; idX < w; ++idX) {
                        buf[idYW + idX] = dstDat[0][0][idY][idX];
                    }
                }
                break;
            }
            case 2: {
                int m = 255;
                short[][][][] dstDat = new short[1][][][];
                WlzObject.WlzToSArray3D(dstSz, dstDat, this.wlzObj, og, sz, 0);
                for (int idY = 0; idY < h; ++idY) {
                    int idYW = idY * w;
                    for (int idX = 0; idX < w; ++idX) {
                        short p = dstDat[0][0][idY][idX];
                        buf[2 * (idYW + idX)] = (byte)(p >>> 8 & m);
                        buf[2 * (idYW + idX) + 1] = (byte)(p & m);
                    }
                }
                break;
            }
            case 1: {
                int m = 255;
                int[][][][] dstDat = new int[1][][][];
                WlzObject.WlzToIArray3D(dstSz, dstDat, this.wlzObj, og, sz, 0);
                for (int idY = 0; idY < h; ++idY) {
                    int idYW = idY * w;
                    for (int idX = 0; idX < w; ++idX) {
                        int p = dstDat[0][0][idY][idX];
                        buf[idYW + 4 * idX] = (byte)(p >> 24 & m);
                        buf[idYW + 4 * idX + 1] = (byte)(p >> 16 & m);
                        buf[idYW + 4 * idX + 2] = (byte)(p >> 8 & m);
                        buf[idYW + 4 * idX + 3] = (byte)(p & m);
                    }
                }
                break;
            }
            case 7: {
                int m = 255;
                int cOff = h * w;
                int[][][][] dstDat = new int[1][][][];
                WlzObject.WlzToRArray3D(dstSz, dstDat, this.wlzObj, og, sz, 0);
                for (int idY = 0; idY < h; ++idY) {
                    int idYW = idY * w;
                    for (int idX = 0; idX < w; ++idX) {
                        int idYWX = idYW + idX;
                        int p = dstDat[0][0][idY][idX];
                        buf[idYWX] = (byte)(p >> 0 & m);
                        buf[idYWX + cOff] = (byte)(p >> 8 & m);
                        buf[idYWX + 2 * cOff] = (byte)(p >> 16 & m);
                        buf[idYWX + 3 * cOff] = (byte)(p >> 24 & m);
                    }
                }
                break;
            }
            case 8: {
                int w8 = (w + 7) / 8;
                byte[][][][] dstDat = new byte[1][][][];
                WlzObject.WlzToBArray3D(dstSz, dstDat, this.wlzObj, og, sz, 0);
                for (int idY = 0; idY < h; ++idY) {
                    int idYW = idY * w;
                    int idYW8 = idY * w8;
                    for (int idX = 0; idX < w; ++idX) {
                        byte p = dstDat[0][0][idY][idX / 8];
                        byte b = (byte)(p & 1 << idX % 8);
                        buf[idYW + idX] = b == 0 ? 0 : -1;
                    }
                }
                break;
            }
            default: {
                throw new WlzException("Unsupported pixel type");
            }
        }
        return buf;
    }
}

