/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.api.ribbon;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.pushingpixels.flamingo.api.ribbon.RibbonApplicationMenuEntryFooter;
import org.pushingpixels.flamingo.api.ribbon.RibbonApplicationMenuEntryPrimary;

public class RibbonApplicationMenu {
    private boolean isFrozen;
    private List<List<RibbonApplicationMenuEntryPrimary>> primaryEntries = new ArrayList<List<RibbonApplicationMenuEntryPrimary>>();
    private List<RibbonApplicationMenuEntryFooter> footerEntries;
    private RibbonApplicationMenuEntryPrimary.PrimaryRolloverCallback defaultCallback;

    public RibbonApplicationMenu() {
        this.primaryEntries.add(new ArrayList());
        this.footerEntries = new ArrayList<RibbonApplicationMenuEntryFooter>();
    }

    public synchronized void addMenuEntry(RibbonApplicationMenuEntryPrimary entry) {
        if (this.isFrozen) {
            throw new IllegalStateException("Cannot add menu entries after the menu has been set on the ribbon");
        }
        this.primaryEntries.get(this.primaryEntries.size() - 1).add(entry);
    }

    public synchronized void addMenuSeparator() {
        if (this.isFrozen) {
            throw new IllegalStateException("Cannot add menu entries after the menu has been set on the ribbon");
        }
        this.primaryEntries.add(new ArrayList());
    }

    public List<List<RibbonApplicationMenuEntryPrimary>> getPrimaryEntries() {
        return Collections.unmodifiableList(this.primaryEntries);
    }

    public synchronized void addFooterEntry(RibbonApplicationMenuEntryFooter entry) {
        if (this.isFrozen) {
            throw new IllegalStateException("Cannot add footer entries after the menu has been set on the ribbon");
        }
        this.footerEntries.add(entry);
    }

    public List<RibbonApplicationMenuEntryFooter> getFooterEntries() {
        return Collections.unmodifiableList(this.footerEntries);
    }

    public void setDefaultCallback(RibbonApplicationMenuEntryPrimary.PrimaryRolloverCallback defaultCallback) {
        this.defaultCallback = defaultCallback;
    }

    public RibbonApplicationMenuEntryPrimary.PrimaryRolloverCallback getDefaultCallback() {
        return this.defaultCallback;
    }

    synchronized void setFrozen() {
        this.isFrozen = true;
        if (this.primaryEntries.get(this.primaryEntries.size() - 1).isEmpty()) {
            this.primaryEntries.remove(this.primaryEntries.size() - 1);
        }
    }
}

