/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tlong.algo;

import cern.colt.matrix.AbstractFormatter;
import cern.colt.matrix.AbstractMatrix1D;
import cern.colt.matrix.AbstractMatrix2D;
import cern.colt.matrix.Former;
import cern.colt.matrix.tlong.LongMatrix1D;
import cern.colt.matrix.tlong.LongMatrix2D;
import cern.colt.matrix.tlong.LongMatrix3D;
import cern.colt.matrix.tobject.ObjectFactory2D;
import cern.colt.matrix.tobject.algo.ObjectFormatter;

public class LongFormatter
extends AbstractFormatter {
    private static final long serialVersionUID = 1L;

    public LongFormatter() {
        this("%d");
    }

    public LongFormatter(String format) {
        this.setFormat(format);
        this.setAlignment("decimal");
    }

    protected String form(LongMatrix1D matrix, int index, Former formatter) {
        return formatter.form(matrix.get(index));
    }

    @Override
    protected String form(AbstractMatrix1D matrix, int index, Former formatter) {
        return this.form((LongMatrix1D)matrix, index, formatter);
    }

    public String[][] format(LongMatrix2D matrix) {
        String[][] strings = new String[matrix.rows()][matrix.columns()];
        int row = matrix.rows();
        while (--row >= 0) {
            strings[row] = this.formatRow(matrix.viewRow(row));
        }
        return strings;
    }

    @Override
    protected String[][] format(AbstractMatrix2D matrix) {
        return this.format((LongMatrix2D)matrix);
    }

    protected int indexOfDecimalPoint(String s) {
        int i = s.lastIndexOf(46);
        if (i < 0) {
            i = s.lastIndexOf(101);
        }
        if (i < 0) {
            i = s.lastIndexOf(69);
        }
        if (i < 0) {
            i = s.length();
        }
        return i;
    }

    @Override
    protected int lead(String s) {
        if (this.alignment.equals("decimal")) {
            return this.indexOfDecimalPoint(s);
        }
        return super.lead(s);
    }

    public String toSourceCode(LongMatrix1D matrix) {
        LongFormatter copy = (LongFormatter)this.clone();
        copy.setPrintShape(false);
        copy.setColumnSeparator(", ");
        String lead = "{";
        String trail = "};";
        return String.valueOf(lead) + copy.toString(matrix) + trail;
    }

    public String toSourceCode(LongMatrix2D matrix) {
        LongFormatter copy = (LongFormatter)this.clone();
        String b3 = this.blanks(3);
        copy.setPrintShape(false);
        copy.setColumnSeparator(", ");
        copy.setRowSeparator("},\n" + b3 + "{");
        String lead = "{\n" + b3 + "{";
        String trail = "}\n};";
        return String.valueOf(lead) + copy.toString(matrix) + trail;
    }

    public String toSourceCode(LongMatrix3D matrix) {
        LongFormatter copy = (LongFormatter)this.clone();
        String b3 = this.blanks(3);
        String b6 = this.blanks(6);
        copy.setPrintShape(false);
        copy.setColumnSeparator(", ");
        copy.setRowSeparator("},\n" + b6 + "{");
        copy.setSliceSeparator("}\n" + b3 + "},\n" + b3 + "{\n" + b6 + "{");
        String lead = "{\n" + b3 + "{\n" + b6 + "{";
        String trail = "}\n" + b3 + "}\n}";
        return String.valueOf(lead) + copy.toString(matrix) + trail;
    }

    public String toString(LongMatrix1D matrix) {
        LongMatrix2D easy = matrix.like2D(1, (int)matrix.size());
        easy.viewRow(0).assign(matrix);
        return this.toString(easy);
    }

    public String toString(LongMatrix2D matrix) {
        return super.toString(matrix);
    }

    public String toString(LongMatrix3D matrix) {
        StringBuffer buf = new StringBuffer();
        boolean oldPrintShape = this.printShape;
        this.printShape = false;
        int slice = 0;
        while (slice < matrix.slices()) {
            if (slice != 0) {
                buf.append(this.sliceSeparator);
            }
            buf.append(this.toString(matrix.viewSlice(slice)));
            ++slice;
        }
        this.printShape = oldPrintShape;
        if (this.printShape) {
            buf.insert(0, String.valueOf(LongFormatter.shape(matrix)) + "\n");
        }
        return buf.toString();
    }

    @Override
    protected String toString(AbstractMatrix2D matrix) {
        return this.toString((LongMatrix2D)matrix);
    }

    protected String toTitleString(LongMatrix2D matrix, String[] rowNames, String[] columnNames, String rowAxisName, String columnAxisName, String title) {
        if (matrix.size() == 0L) {
            return "Empty matrix";
        }
        Object[][] s = this.format(matrix);
        this.align((String[][])s);
        return new ObjectFormatter().toTitleString(ObjectFactory2D.dense.make(s), rowNames, columnNames, rowAxisName, columnAxisName, title);
    }

    private String xtoTitleString(LongMatrix3D matrix, String[] sliceNames, String[] rowNames, String[] columnNames, String sliceAxisName, String rowAxisName, String columnAxisName, String title) {
        if (matrix.size() == 0L) {
            return "Empty matrix";
        }
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < matrix.slices()) {
            if (i != 0) {
                buf.append(this.sliceSeparator);
            }
            buf.append(this.toTitleString(matrix.viewSlice(i), rowNames, columnNames, rowAxisName, columnAxisName, String.valueOf(title) + "\n" + sliceAxisName + "=" + sliceNames[i]));
            ++i;
        }
        return buf.toString();
    }
}

