/*
 * Decompiled with CFR 0.152.
 */
package com.drew.lang;

import com.drew.lang.BufferBoundsException;
import com.drew.lang.BufferReader;
import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.SuppressWarnings;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;

public class RandomAccessFileReader
implements BufferReader {
    @NotNull
    private final RandomAccessFile _file;
    private final long _length;
    private int _currentIndex;
    private boolean _isMotorolaByteOrder = true;

    @SuppressWarnings(value="EI_EXPOSE_REP2", justification="Design intent")
    public RandomAccessFileReader(@NotNull RandomAccessFile file2) throws IOException {
        if (file2 == null) {
            throw new NullPointerException();
        }
        this._file = file2;
        this._length = this._file.length();
    }

    public long getLength() {
        return this._length;
    }

    public void setMotorolaByteOrder(boolean motorolaByteOrder) {
        this._isMotorolaByteOrder = motorolaByteOrder;
    }

    public boolean isMotorolaByteOrder() {
        return this._isMotorolaByteOrder;
    }

    private byte read() throws BufferBoundsException {
        int b;
        try {
            b = this._file.read();
        }
        catch (IOException e) {
            throw new BufferBoundsException("IOException reading from file.", e);
        }
        if (b < 0) {
            throw new BufferBoundsException("Unexpected end of file encountered.");
        }
        assert (b <= 255);
        ++this._currentIndex;
        return (byte)b;
    }

    private void seek(int index) throws BufferBoundsException {
        if (index == this._currentIndex) {
            return;
        }
        try {
            this._file.seek(index);
            this._currentIndex = index;
        }
        catch (IOException e) {
            throw new BufferBoundsException("IOException seeking in file.", e);
        }
    }

    public short getUInt8(int index) throws BufferBoundsException {
        this.checkBounds(index, 1);
        this.seek(index);
        return (short)(this.read() & 0xFF);
    }

    public byte getInt8(int index) throws BufferBoundsException {
        this.checkBounds(index, 1);
        this.seek(index);
        return this.read();
    }

    public int getUInt16(int index) throws BufferBoundsException {
        this.checkBounds(index, 2);
        this.seek(index);
        if (this._isMotorolaByteOrder) {
            return this.read() << 8 & 0xFF00 | this.read() & 0xFF;
        }
        return this.read() & 0xFF | this.read() << 8 & 0xFF00;
    }

    public short getInt16(int index) throws BufferBoundsException {
        this.checkBounds(index, 2);
        this.seek(index);
        if (this._isMotorolaByteOrder) {
            return (short)((short)this.read() << 8 & 0xFFFFFF00 | (short)this.read() & 0xFF);
        }
        return (short)((short)this.read() & 0xFF | (short)this.read() << 8 & 0xFFFFFF00);
    }

    public long getUInt32(int index) throws BufferBoundsException {
        this.checkBounds(index, 4);
        this.seek(index);
        if (this._isMotorolaByteOrder) {
            return (long)this.read() << 24 & 0xFF000000L | (long)this.read() << 16 & 0xFF0000L | (long)this.read() << 8 & 0xFF00L | (long)this.read() & 0xFFL;
        }
        return (long)this.read() & 0xFFL | (long)this.read() << 8 & 0xFF00L | (long)this.read() << 16 & 0xFF0000L | (long)this.read() << 24 & 0xFF000000L;
    }

    public int getInt32(int index) throws BufferBoundsException {
        this.checkBounds(index, 4);
        this.seek(index);
        if (this._isMotorolaByteOrder) {
            return this.read() << 24 & 0xFF000000 | this.read() << 16 & 0xFF0000 | this.read() << 8 & 0xFF00 | this.read() & 0xFF;
        }
        return this.read() & 0xFF | this.read() << 8 & 0xFF00 | this.read() << 16 & 0xFF0000 | this.read() << 24 & 0xFF000000;
    }

    public long getInt64(int index) throws BufferBoundsException {
        this.checkBounds(index, 8);
        this.seek(index);
        if (this._isMotorolaByteOrder) {
            return (long)this.read() << 56 & 0xFF00000000000000L | (long)this.read() << 48 & 0xFF000000000000L | (long)this.read() << 40 & 0xFF0000000000L | (long)this.read() << 32 & 0xFF00000000L | (long)this.read() << 24 & 0xFF000000L | (long)this.read() << 16 & 0xFF0000L | (long)this.read() << 8 & 0xFF00L | (long)this.read() & 0xFFL;
        }
        return (long)this.read() & 0xFFL | (long)this.read() << 8 & 0xFF00L | (long)this.read() << 16 & 0xFF0000L | (long)this.read() << 24 & 0xFF000000L | (long)this.read() << 32 & 0xFF00000000L | (long)this.read() << 40 & 0xFF0000000000L | (long)this.read() << 48 & 0xFF000000000000L | (long)this.read() << 56 & 0xFF00000000000000L;
    }

    public float getS15Fixed16(int index) throws BufferBoundsException {
        this.checkBounds(index, 4);
        this.seek(index);
        if (this._isMotorolaByteOrder) {
            float res = (this.read() & 0xFF) << 8 | this.read() & 0xFF;
            int d = (this.read() & 0xFF) << 8 | this.read() & 0xFF;
            return (float)((double)res + (double)d / 65536.0);
        }
        int d = this.read() & 0xFF | (this.read() & 0xFF) << 8;
        float res = this.read() & 0xFF | (this.read() & 0xFF) << 8;
        return (float)((double)res + (double)d / 65536.0);
    }

    public float getFloat32(int index) throws BufferBoundsException {
        return Float.intBitsToFloat(this.getInt32(index));
    }

    public double getDouble64(int index) throws BufferBoundsException {
        return Double.longBitsToDouble(this.getInt64(index));
    }

    @NotNull
    public byte[] getBytes(int index, int count) throws BufferBoundsException {
        int bytesRead;
        this.checkBounds(index, count);
        this.seek(index);
        byte[] bytes = new byte[count];
        try {
            bytesRead = this._file.read(bytes);
            this._currentIndex += bytesRead;
        }
        catch (IOException e) {
            throw new BufferBoundsException("Unexpected end of file encountered.", e);
        }
        if (bytesRead != count) {
            throw new BufferBoundsException("Unexpected end of file encountered.");
        }
        return bytes;
    }

    @NotNull
    public String getString(int index, int bytesRequested) throws BufferBoundsException {
        return new String(this.getBytes(index, bytesRequested));
    }

    @NotNull
    public String getString(int index, int bytesRequested, String charset) throws BufferBoundsException {
        this.checkBounds(index, bytesRequested);
        byte[] bytes = this.getBytes(index, bytesRequested);
        try {
            return new String(bytes, charset);
        }
        catch (UnsupportedEncodingException e) {
            return new String(bytes);
        }
    }

    @NotNull
    public String getNullTerminatedString(int index, int maxLengthBytes) throws BufferBoundsException {
        int length;
        this.checkBounds(index, maxLengthBytes);
        this.seek(index);
        for (length = 0; (long)(index + length) < this._length && this.read() != 0 && length < maxLengthBytes; ++length) {
        }
        byte[] bytes = this.getBytes(index, length);
        return new String(bytes);
    }

    private void checkBounds(int index, int bytesRequested) throws BufferBoundsException {
        if (bytesRequested < 0) {
            throw new BufferBoundsException("Requested negative number of bytes.");
        }
        if (index < 0) {
            throw new BufferBoundsException("Requested data from a negative index within the file.");
        }
        if ((long)index + (long)bytesRequested - 1L >= this._length) {
            throw new BufferBoundsException("Requested data from beyond the end of the file.");
        }
    }
}

