package plugins.tprovoost.sequenceblocks.loop;

import java.util.List;

import icy.plugin.interface_.PluginBundled;
import icy.plugin.interface_.PluginLibrary;
import icy.sequence.Sequence;
import icy.sequence.SequenceUtil;
import plugins.adufour.blocks.lang.Batch;
import plugins.adufour.blocks.tools.sequence.SequenceBlock;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarROIArray;
import plugins.adufour.vars.lang.VarSequence;
import plugins.adufour.vars.util.VarException;
import plugins.tprovoost.sequenceblocks.SequenceBlocks;

/**
 * Simple batch loop to iterate over a set of Region (ROIs) from an input Sequence.
 * 
 * @author Stephane
 */
public class SequenceRegionBatch extends Batch implements SequenceBlock, PluginLibrary, PluginBundled
{
    // important to not initialize and create them in getBatchSource() and getBatchElement()
    protected VarSequence inputSequence;
    protected VarSequence element;
    protected final VarROIArray rois;

    public SequenceRegionBatch()
    {
        super();

        rois = new VarROIArray("ROI(s)");
    }

    @Override
    public VarSequence getBatchSource()
    {
        // initialize variable if needed
        if (inputSequence == null)
            inputSequence = new VarSequence("Sequence", null);

        return inputSequence;
    }

    @Override
    public VarSequence getBatchElement()
    {
        // initialize element if needed
        if (element == null)
            element = new VarSequence("Channel Sequence", null);

        return element;
    }

    @Override
    public void initializeLoop()
    {
        final Sequence value = inputSequence.getValue();

        if (value == null)
            throw new VarException(inputSequence, "No input sequence indicated");

        if (rois.getValue() == null)
            throw new VarException(rois, "No roi(s) indicated --> no region to iterate over");
    }

    @Override
    public void beforeIteration()
    {
        // set result in element
        element.setValue(SequenceUtil.getSubSequence(inputSequence.getValue(),
                rois.getValue()[getIterationCounter().getValue().intValue()]));
    }

    @Override
    public boolean isStopConditionReached()
    {
        return getIterationCounter().getValue().intValue() >= rois.getValue().length;
    }

    @Override
    public void declareInput(VarList inputMap)
    {
        super.declareInput(inputMap);

        inputMap.add("ROIs", rois);
    }

    @Override
    public void declareLoopVariables(List<Var<?>> loopVariables)
    {
        super.declareLoopVariables(loopVariables);

        loopVariables.add(rois);
    }

    @Override
    public String getMainPluginClassName()
    {
        return SequenceBlocks.class.getName();
    }
}
