/*
 * Decompiled with CFR 0.152.
 */
package mcib3d.geom;

import ij.measure.ResultsTable;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import mcib3d.geom.MereoObject3D;
import mcib3d.geom.Object3D;
import mcib3d.geom.Object3DVoxels;
import mcib3d.geom.Objects3DPopulation;
import mcib3d.geom.Voxel3D;
import mcib3d.image3d.ImageShort;
import mcib3d.utils.Logger.AbstractLog;
import mcib3d.utils.Logger.IJLog;

public class MereoAnalysis {
    Objects3DPopulation popA;
    Objects3DPopulation popB;
    String[][] relationships;
    AbstractLog log = new IJLog();
    private float RadX;
    private float RadY;
    private float RadZ;

    public MereoAnalysis(Objects3DPopulation popA, Objects3DPopulation popB) {
        this.popA = popA;
        this.popB = popB;
        this.initRelationships();
        this.RadX = 1.0f;
        this.RadY = 1.0f;
        this.RadZ = 1.0f;
    }

    private void initRelationships() {
        this.relationships = new String[this.popA.getNbObjects()][this.popB.getNbObjects()];
        for (int ia = 0; ia < this.popA.getNbObjects(); ++ia) {
            for (int ib = 0; ib < this.popB.getNbObjects(); ++ib) {
                this.relationships[ia][ib] = "DC";
            }
        }
    }

    public Objects3DPopulation getPopA() {
        return this.popA;
    }

    public void setPopA(Objects3DPopulation popA) {
        this.popA = popA;
        this.initRelationships();
    }

    public Objects3DPopulation getPopB() {
        return this.popB;
    }

    public void setPopB(Objects3DPopulation popB) {
        this.popB = popB;
        this.initRelationships();
    }

    public float getRadX() {
        return this.RadX;
    }

    public void setRadX(float RadX) {
        this.RadX = RadX;
    }

    public float getRadY() {
        return this.RadY;
    }

    public void setRadY(float RadY) {
        this.RadY = RadY;
    }

    public float getRadZ() {
        return this.RadZ;
    }

    public void setRadZ(float RadZ) {
        this.RadZ = RadZ;
    }

    public String[][] getRelationships() {
        return this.relationships;
    }

    public void computeSlowRelationships() {
        for (int ia = 0; ia < this.popA.getNbObjects(); ++ia) {
            for (int ib = 0; ib < this.popB.getNbObjects(); ++ib) {
                MereoObject3D mereo = new MereoObject3D(this.popA.getObject(ia), this.popB.getObject(ib), this.RadX, this.RadY, this.RadZ);
                this.relationships[ia][ib] = mereo.getRCC8Relationship();
            }
        }
    }

    public void computeFastRelationships() {
        int[] size = this.popB.getMaxSizeAllObjects();
        ImageShort segB = new ImageShort("popB", size[0] + 1, size[1] + 1, size[2] + 1);
        this.popB.draw(segB);
        boolean[] checkedObject = new boolean[this.popB.getNbObjects()];
        int nbA = this.popA.getNbObjects();
        for (int a = 0; a < nbA; ++a) {
            this.log.log("Processing object A" + a);
            for (int o = 0; o < this.popB.getNbObjects(); ++o) {
                checkedObject[o] = false;
                this.relationships[a][o] = "DC";
            }
            Object3D A = this.popA.getObject(a);
            Object3DVoxels Adil = A.getDilatedObject(this.RadX, this.RadY, this.RadZ);
            ArrayList<Voxel3D> al = Adil.listVoxels(segB);
            for (Voxel3D vox : al) {
                int idx;
                int pix = (int)vox.getValue();
                if (pix == 0 || checkedObject[idx = this.popB.getIndexFromValue(pix)]) continue;
                checkedObject[idx] = true;
                Object3D B = this.popB.getObject(idx);
                MereoObject3D mereo = new MereoObject3D(A, B, this.RadX, this.RadY, this.RadZ);
                this.relationships[a][idx] = mereo.getRCC8Relationship();
            }
        }
    }

    public ArrayList<Object3D> getObjectsRelation(int obj, int pop, String rel) {
        ArrayList<Object3D> res = new ArrayList<Object3D>();
        if (pop == 0) {
            for (int b = 0; b < this.popB.getNbObjects(); ++b) {
                if (this.relationships[obj][b].compareToIgnoreCase(rel) != 0) continue;
                res.add(this.popB.getObject(b));
            }
        } else {
            for (int a = 0; a < this.popA.getNbObjects(); ++a) {
                if (this.relationships[a][obj].compareToIgnoreCase(rel) != 0) continue;
                res.add(this.popA.getObject(a));
            }
        }
        return res;
    }

    public boolean checkObjectsRelation(int obj, int pop, String rel) {
        if (pop == 0) {
            for (int b = 0; b < this.popB.getNbObjects(); ++b) {
                if (this.relationships[obj][b].compareToIgnoreCase(rel) != 0) continue;
                return true;
            }
        } else {
            for (int a = 0; a < this.popA.getNbObjects(); ++a) {
                if (this.relationships[a][obj].compareToIgnoreCase(rel) != 0) continue;
                return true;
            }
        }
        return false;
    }

    public String getResult(int a, int b) {
        return this.relationships[a][b];
    }

    public String getResults(boolean excludeDC) {
        String res = "";
        for (int ia = 0; ia < this.popA.getNbObjects(); ++ia) {
            for (int ib = 0; ib < this.popB.getNbObjects(); ++ib) {
                if (excludeDC) {
                    if (this.relationships[ia][ib].equalsIgnoreCase("DC")) continue;
                    res = res.concat(this.popA.getObject(ia) + " with " + this.popB.getObject(ib) + " : " + this.relationships[ia][ib] + "\n");
                    continue;
                }
                res = res.concat(this.popA.getObject(ia) + " with " + this.popB.getObject(ib) + " : " + this.relationships[ia][ib] + "\n");
            }
        }
        return res;
    }

    public ResultsTable getResultsTable(boolean excludeDC, boolean useValueObject) {
        ResultsTable rt = new ResultsTable();
        for (int ia = 0; ia < this.popA.getNbObjects(); ++ia) {
            rt.incrementCounter();
            if (!useValueObject) {
                rt.setLabel("A" + ia, ia);
            } else {
                rt.setLabel("A" + this.popA.getObject(ia).getValue(), ia);
            }
            for (int ib = 0; ib < this.popB.getNbObjects(); ++ib) {
                if (excludeDC) {
                    if (!this.relationships[ia][ib].equalsIgnoreCase("DC")) {
                        if (!useValueObject) {
                            rt.setValue("B" + ib, ia, this.relationships[ia][ib]);
                            continue;
                        }
                        rt.setValue("B" + this.popB.getObject(ib).getValue(), ia, this.relationships[ia][ib]);
                        continue;
                    }
                    if (!useValueObject) {
                        rt.setValue("B" + ib, ia, ".");
                        continue;
                    }
                    rt.setValue("B" + this.popB.getObject(ib).getValue(), ia, ".");
                    continue;
                }
                if (!useValueObject) {
                    rt.setValue("B" + ib, ia, this.relationships[ia][ib]);
                    continue;
                }
                rt.setValue("B" + this.popB.getObject(ib).getValue(), ia, this.relationships[ia][ib]);
            }
        }
        return rt;
    }

    public void setLog(AbstractLog logger) {
        this.log = logger;
    }

    public void writePrologFacts(String filename, String prefixA, String prefixB, boolean excludeDC, boolean useValue) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(filename));
            for (int ia = 0; ia < this.popA.getNbObjects(); ++ia) {
                for (int ib = 0; ib < this.popB.getNbObjects(); ++ib) {
                    if (excludeDC) {
                        if (this.relationships[ia][ib].equalsIgnoreCase("DC")) continue;
                        if (!useValue) {
                            out.write(this.relationships[ia][ib].toLowerCase() + "(" + prefixA + ia + "," + prefixB + ib + ").\n");
                            continue;
                        }
                        out.write(this.relationships[ia][ib].toLowerCase() + "(" + prefixA + this.popA.getObject(ia).getValue() + "," + prefixB + this.popB.getObject(ib).getValue() + ").\n");
                        continue;
                    }
                    if (!useValue) {
                        out.write(this.relationships[ia][ib].toLowerCase() + "(" + prefixA + ia + "," + prefixB + ib + ").\n");
                        continue;
                    }
                    out.write(this.relationships[ia][ib].toLowerCase() + "(" + prefixA + this.popA.getObject(ia).getValue() + "," + prefixB + this.popB.getObject(ib).getValue() + ").\n");
                }
            }
            out.close();
        }
        catch (IOException ex) {
            Logger.getLogger(MereoAnalysis.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void writeN3Facts(String filename, boolean excludeDC, boolean excludeEQ) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(filename));
            out.write("@prefix  image: <Image.n3#>.\n@prefix algo:<Algo.n3#>.\n@prefix structure:<Structure.n3#>.\n@prefix mereo:<Mereo.n3#>.\n@prefix event:<Event.n3#>.\n");
            out.write("\n##  POPULATION A   ###\n");
            for (int ia = 0; ia < this.popA.getNbObjects(); ++ia) {
                out.write("structure:A" + this.popA.getObject(ia).getValue() + " a structure:Structure;\n");
                out.write("\t structure:id " + (1000 + ia) + ";\n");
                out.write("\t structure:name \"A" + this.popA.getObject(ia).getValue() + "\";\n");
                out.write("\t structure:radius " + this.popA.getObject(ia).getDistCenterMean() + ".\n");
            }
            out.write("##  POPULATION B   ###\n");
            for (int ib = 0; ib < this.popB.getNbObjects(); ++ib) {
                out.write("structure:B" + this.popB.getObject(ib).getValue() + " a structure:Structure;\n");
                out.write("\t structure:id " + (1000 + ib) + ";\n");
                out.write("\t structure:name \"B" + this.popB.getObject(ib).getValue() + "\";\n");
                out.write("\t structure:radius " + this.popB.getObject(ib).getDistCenterMean() + ".\n");
            }
            int count = 0;
            out.write("\n##  RELATIONS   ###\n");
            for (int ia = 0; ia < this.popA.getNbObjects(); ++ia) {
                for (int ib = 0; ib < this.popB.getNbObjects(); ++ib) {
                    boolean write = true;
                    if (this.relationships[ia][ib].equalsIgnoreCase("DC") && excludeDC) {
                        write = false;
                    }
                    if (this.relationships[ia][ib].equalsIgnoreCase("EQ") && excludeEQ) {
                        write = false;
                    }
                    if (write) {
                        out.write("mereo:relation" + count + " a mereo:Relation;\n");
                        out.write("\tmereo:structureA structure:A" + this.popA.getObject(ia).getValue() + ";\n");
                        out.write("\tmereo:structureB structure:B" + this.popB.getObject(ib).getValue() + ";\n");
                        out.write("\tmereo:relation mereo:" + this.relationships[ia][ib] + ".\n");
                    }
                    ++count;
                }
            }
            out.close();
        }
        catch (IOException ex) {
            Logger.getLogger(MereoAnalysis.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

