/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tobject.impl;

import cern.colt.ConcurrencyUtils;
import cern.colt.function.tobject.ObjectFunction;
import cern.colt.function.tobject.ObjectObjectFunction;
import cern.colt.function.tobject.ObjectProcedure;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.tobject.ObjectMatrix1D;
import cern.colt.matrix.tobject.ObjectMatrix2D;
import cern.colt.matrix.tobject.ObjectMatrix3D;
import cern.colt.matrix.tobject.impl.DenseObjectMatrix1D;
import cern.colt.matrix.tobject.impl.DenseObjectMatrix2D;
import cern.colt.matrix.tobject.impl.SelectedDenseObjectMatrix3D;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class DenseObjectMatrix3D
extends ObjectMatrix3D {
    private static final long serialVersionUID = 1L;
    protected Object[] elements;

    public DenseObjectMatrix3D(Object[][][] values) {
        this(values.length, values.length == 0 ? 0 : values[0].length, values.length == 0 ? 0 : (values[0].length == 0 ? 0 : values[0][0].length));
        this.assign(values);
    }

    public DenseObjectMatrix3D(int slices, int rows, int columns) {
        this.setUp(slices, rows, columns);
        this.elements = new Object[slices * rows * columns];
    }

    protected DenseObjectMatrix3D(int slices, int rows, int columns, Object[] elements, int sliceZero, int rowZero, int columnZero, int sliceStride, int rowStride, int columnStride, boolean isView) {
        this.setUp(slices, rows, columns, sliceZero, rowZero, columnZero, sliceStride, rowStride, columnStride);
        this.elements = elements;
        this.isNoView = !isView;
    }

    @Override
    public Object aggregate(final ObjectObjectFunction aggr, final ObjectFunction f) {
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size == 0");
        }
        Object a = null;
        final int zero = (int)this.index(0, 0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        Object a = f.apply(DenseObjectMatrix3D.this.elements[zero + firstSlice * DenseObjectMatrix3D.this.sliceStride]);
                        int d = 1;
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < DenseObjectMatrix3D.this.rows) {
                                int c = d;
                                while (c < DenseObjectMatrix3D.this.columns) {
                                    a = aggr.apply(a, f.apply(DenseObjectMatrix3D.this.elements[zero + s * DenseObjectMatrix3D.this.sliceStride + r * DenseObjectMatrix3D.this.rowStride + c * DenseObjectMatrix3D.this.columnStride]));
                                    ++c;
                                }
                                d = 0;
                                ++r;
                            }
                            ++s;
                        }
                        return a;
                    }
                });
                ++j;
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.elements[zero]);
            int d = 1;
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int c = d;
                    while (c < this.columns) {
                        a = aggr.apply(a, f.apply(this.elements[zero + s * this.sliceStride + r * this.rowStride + c * this.columnStride]));
                        ++c;
                    }
                    d = 0;
                    ++r;
                }
                ++s;
            }
        }
        return a;
    }

    @Override
    public Object aggregate(final ObjectObjectFunction aggr, final ObjectFunction f, final ObjectProcedure cond) {
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size == 0");
        }
        Object a = null;
        final int zero = (int)this.index(0, 0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        Object elem = DenseObjectMatrix3D.this.elements[zero + firstSlice * DenseObjectMatrix3D.this.sliceStride];
                        Object a = 0;
                        if (cond.apply(elem)) {
                            a = aggr.apply(a, f.apply(elem));
                        }
                        int d = 1;
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < DenseObjectMatrix3D.this.rows) {
                                int c = d;
                                while (c < DenseObjectMatrix3D.this.columns) {
                                    elem = DenseObjectMatrix3D.this.elements[zero + s * DenseObjectMatrix3D.this.sliceStride + r * DenseObjectMatrix3D.this.rowStride + c * DenseObjectMatrix3D.this.columnStride];
                                    if (cond.apply(elem)) {
                                        a = aggr.apply(a, f.apply(elem));
                                    }
                                    d = 0;
                                    ++c;
                                }
                                ++r;
                            }
                            ++s;
                        }
                        return a;
                    }
                });
                ++j;
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            Object elem = this.elements[zero];
            if (cond.apply(elem)) {
                a = aggr.apply(a, f.apply(elem));
            }
            int d = 1;
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int c = d;
                    while (c < this.columns) {
                        elem = this.elements[zero + s * this.sliceStride + r * this.rowStride + c * this.columnStride];
                        if (cond.apply(elem)) {
                            a = aggr.apply(a, f.apply(elem));
                        }
                        d = 0;
                        ++c;
                    }
                    ++r;
                }
                ++s;
            }
        }
        return a;
    }

    @Override
    public Object aggregate(final ObjectObjectFunction aggr, final ObjectFunction f, IntArrayList sliceList, IntArrayList rowList, IntArrayList columnList) {
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size == 0");
        }
        if (sliceList.size() == 0 || rowList.size() == 0 || columnList.size() == 0) {
            throw new IllegalArgumentException("size == 0");
        }
        int size = sliceList.size();
        final int[] sliceElements = sliceList.elements();
        final int[] rowElements = rowList.elements();
        final int[] columnElements = columnList.elements();
        final int zero = (int)this.index(0, 0, 0);
        Object a = null;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, size);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        Object a = f.apply(DenseObjectMatrix3D.this.elements[zero + sliceElements[firstIdx] * DenseObjectMatrix3D.this.sliceStride + rowElements[firstIdx] * DenseObjectMatrix3D.this.rowStride + columnElements[firstIdx] * DenseObjectMatrix3D.this.columnStride]);
                        int i = firstIdx + 1;
                        while (i < lastIdx) {
                            Object elem = DenseObjectMatrix3D.this.elements[zero + sliceElements[i] * DenseObjectMatrix3D.this.sliceStride + rowElements[i] * DenseObjectMatrix3D.this.rowStride + columnElements[i] * DenseObjectMatrix3D.this.columnStride];
                            a = aggr.apply(a, f.apply(elem));
                            ++i;
                        }
                        return a;
                    }
                });
                ++j;
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.elements[zero + sliceElements[0] * this.sliceStride + rowElements[0] * this.rowStride + columnElements[0] * this.columnStride]);
            int i = 1;
            while (i < size) {
                Object elem = this.elements[zero + sliceElements[i] * this.sliceStride + rowElements[i] * this.rowStride + columnElements[i] * this.columnStride];
                a = aggr.apply(a, f.apply(elem));
                ++i;
            }
        }
        return a;
    }

    @Override
    public Object aggregate(ObjectMatrix3D other, final ObjectObjectFunction aggr, final ObjectObjectFunction f) {
        if (!(other instanceof DenseObjectMatrix3D)) {
            return super.aggregate(other, aggr, f);
        }
        this.checkShape(other);
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size == 0");
        }
        Object a = null;
        final int zero = (int)this.index(0, 0, 0);
        final int zeroOther = (int)other.index(0, 0, 0);
        final int sliceStrideOther = other.sliceStride();
        final int rowStrideOther = other.rowStride();
        final int colStrideOther = other.columnStride();
        final Object[] elemsOther = (Object[])other.elements();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        int idx = zero + firstSlice * DenseObjectMatrix3D.this.sliceStride;
                        int idxOther = zeroOther + firstSlice * sliceStrideOther;
                        Object a = f.apply(DenseObjectMatrix3D.this.elements[idx], elemsOther[idxOther]);
                        int d = 1;
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < DenseObjectMatrix3D.this.rows) {
                                int c = d;
                                while (c < DenseObjectMatrix3D.this.columns) {
                                    idx = zero + s * DenseObjectMatrix3D.this.sliceStride + r * DenseObjectMatrix3D.this.rowStride + c * DenseObjectMatrix3D.this.columnStride;
                                    idxOther = zeroOther + s * sliceStrideOther + r * rowStrideOther + c * colStrideOther;
                                    a = aggr.apply(a, f.apply(DenseObjectMatrix3D.this.elements[idx], elemsOther[idxOther]));
                                    ++c;
                                }
                                d = 0;
                                ++r;
                            }
                            ++s;
                        }
                        return a;
                    }
                });
                ++j;
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.getQuick(0, 0, 0), other.getQuick(0, 0, 0));
            int d = 1;
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int c = d;
                    while (c < this.columns) {
                        int idx = zero + s * this.sliceStride + r * this.rowStride + c * this.columnStride;
                        int idxOther = zeroOther + s * sliceStrideOther + r * rowStrideOther + c * colStrideOther;
                        a = aggr.apply(a, f.apply(this.elements[idx], elemsOther[idxOther]));
                        ++c;
                    }
                    d = 0;
                    ++r;
                }
                ++s;
            }
        }
        return a;
    }

    @Override
    public ObjectMatrix3D assign(final Object[][][] values) {
        if (values.length != this.slices) {
            throw new IllegalArgumentException("Must have same number of slices: slices=" + values.length + "slices()=" + this.slices());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView) {
            if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
                nthreads = Math.min(nthreads, this.slices);
                Future[] futures = new Future[nthreads];
                int k = this.slices / nthreads;
                int j = 0;
                while (j < nthreads) {
                    final int firstSlice = j * k;
                    final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                    futures[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            int i = firstSlice * DenseObjectMatrix3D.this.sliceStride;
                            int s = firstSlice;
                            while (s < lastSlice) {
                                Object[][] currentSlice = values[s];
                                if (currentSlice.length != DenseObjectMatrix3D.this.rows) {
                                    throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + currentSlice.length + "rows()=" + DenseObjectMatrix3D.this.rows());
                                }
                                int r = 0;
                                while (r < DenseObjectMatrix3D.this.rows) {
                                    Object[] currentRow = currentSlice[r];
                                    if (currentRow.length != DenseObjectMatrix3D.this.columns) {
                                        throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "columns()=" + DenseObjectMatrix3D.this.columns());
                                    }
                                    System.arraycopy(currentRow, 0, DenseObjectMatrix3D.this.elements, i, DenseObjectMatrix3D.this.columns);
                                    i += DenseObjectMatrix3D.this.columns;
                                    ++r;
                                }
                                ++s;
                            }
                        }
                    });
                    ++j;
                }
                try {
                    j = 0;
                    while (j < nthreads) {
                        futures[j].get();
                        ++j;
                    }
                }
                catch (ExecutionException ex) {
                    ex.printStackTrace();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            } else {
                int i = 0;
                int s = 0;
                while (s < this.slices) {
                    Object[][] currentSlice = values[s];
                    if (currentSlice.length != this.rows) {
                        throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + currentSlice.length + "rows()=" + this.rows());
                    }
                    int r = 0;
                    while (r < this.rows) {
                        Object[] currentRow = currentSlice[r];
                        if (currentRow.length != this.columns) {
                            throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "columns()=" + this.columns());
                        }
                        System.arraycopy(currentRow, 0, this.elements, i, this.columns);
                        i += this.columns;
                        ++r;
                    }
                    ++s;
                }
            }
        } else {
            final int zero = (int)this.index(0, 0, 0);
            if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
                nthreads = Math.min(nthreads, this.slices);
                Future[] futures = new Future[nthreads];
                int k = this.slices / nthreads;
                int j = 0;
                while (j < nthreads) {
                    final int firstSlice = j * k;
                    final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                    futures[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            int s = firstSlice;
                            while (s < lastSlice) {
                                Object[][] currentSlice = values[s];
                                if (currentSlice.length != DenseObjectMatrix3D.this.rows) {
                                    throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + currentSlice.length + "rows()=" + DenseObjectMatrix3D.this.rows());
                                }
                                int r = 0;
                                while (r < DenseObjectMatrix3D.this.rows) {
                                    int idx = zero + s * DenseObjectMatrix3D.this.sliceStride + r * DenseObjectMatrix3D.this.rowStride;
                                    Object[] currentRow = currentSlice[r];
                                    if (currentRow.length != DenseObjectMatrix3D.this.columns) {
                                        throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "columns()=" + DenseObjectMatrix3D.this.columns());
                                    }
                                    int c = 0;
                                    while (c < DenseObjectMatrix3D.this.columns) {
                                        DenseObjectMatrix3D.this.elements[idx] = currentRow[c];
                                        idx += DenseObjectMatrix3D.this.columnStride;
                                        ++c;
                                    }
                                    ++r;
                                }
                                ++s;
                            }
                        }
                    });
                    ++j;
                }
                try {
                    j = 0;
                    while (j < nthreads) {
                        futures[j].get();
                        ++j;
                    }
                }
                catch (ExecutionException ex) {
                    ex.printStackTrace();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            } else {
                int s = 0;
                while (s < this.slices) {
                    Object[][] currentSlice = values[s];
                    if (currentSlice.length != this.rows) {
                        throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + currentSlice.length + "rows()=" + this.rows());
                    }
                    int r = 0;
                    while (r < this.rows) {
                        int idx = zero + s * this.sliceStride + r * this.rowStride;
                        Object[] currentRow = currentSlice[r];
                        if (currentRow.length != this.columns) {
                            throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "columns()=" + this.columns());
                        }
                        int c = 0;
                        while (c < this.columns) {
                            this.elements[idx] = currentRow[c];
                            idx += this.columnStride;
                            ++c;
                        }
                        ++r;
                    }
                    ++s;
                }
            }
        }
        return this;
    }

    @Override
    public ObjectMatrix3D assign(final Object[] values) {
        if ((long)values.length != this.size()) {
            throw new IllegalArgumentException("Must have same length: length=" + values.length + "slices()*rows()*columns()=" + this.slices() * this.rows() * this.columns());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView) {
            System.arraycopy(values, 0, this.elements, 0, values.length);
        } else {
            final int zero = (int)this.index(0, 0, 0);
            if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
                nthreads = Math.min(nthreads, this.slices);
                Future[] futures = new Future[nthreads];
                int k = this.slices / nthreads;
                int j = 0;
                while (j < nthreads) {
                    final int firstSlice = j * k;
                    final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                    futures[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            int idxOther = firstSlice * DenseObjectMatrix3D.this.rows * DenseObjectMatrix3D.this.columns;
                            int s = firstSlice;
                            while (s < lastSlice) {
                                int r = 0;
                                while (r < DenseObjectMatrix3D.this.rows) {
                                    int idx = zero + s * DenseObjectMatrix3D.this.sliceStride + r * DenseObjectMatrix3D.this.rowStride;
                                    int c = 0;
                                    while (c < DenseObjectMatrix3D.this.columns) {
                                        DenseObjectMatrix3D.this.elements[idx] = values[idxOther++];
                                        idx += DenseObjectMatrix3D.this.columnStride;
                                        ++c;
                                    }
                                    ++r;
                                }
                                ++s;
                            }
                        }
                    });
                    ++j;
                }
                ConcurrencyUtils.waitForCompletion(futures);
            } else {
                int idxOther = 0;
                int s = 0;
                while (s < this.slices) {
                    int r = 0;
                    while (r < this.rows) {
                        int idx = zero + s * this.sliceStride + r * this.rowStride;
                        int c = 0;
                        while (c < this.columns) {
                            this.elements[idx] = values[idxOther++];
                            idx += this.columnStride;
                            ++c;
                        }
                        ++r;
                    }
                    ++s;
                }
            }
        }
        return this;
    }

    @Override
    public ObjectMatrix3D assign(final Object value) {
        final int zero = (int)this.index(0, 0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < DenseObjectMatrix3D.this.rows) {
                                int idx = zero + s * DenseObjectMatrix3D.this.sliceStride + r * DenseObjectMatrix3D.this.rowStride;
                                int c = 0;
                                while (c < DenseObjectMatrix3D.this.columns) {
                                    DenseObjectMatrix3D.this.elements[idx] = value;
                                    idx += DenseObjectMatrix3D.this.columnStride;
                                    ++c;
                                }
                                ++r;
                            }
                            ++s;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int idx = zero + s * this.sliceStride + r * this.rowStride;
                    int c = 0;
                    while (c < this.columns) {
                        this.elements[idx] = value;
                        idx += this.columnStride;
                        ++c;
                    }
                    ++r;
                }
                ++s;
            }
        }
        return this;
    }

    @Override
    public ObjectMatrix3D assign(final ObjectProcedure cond, final ObjectFunction f) {
        final int zero = (int)this.index(0, 0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < DenseObjectMatrix3D.this.rows) {
                                int idx = zero + s * DenseObjectMatrix3D.this.sliceStride + r * DenseObjectMatrix3D.this.rowStride;
                                int c = 0;
                                while (c < DenseObjectMatrix3D.this.columns) {
                                    Object elem = DenseObjectMatrix3D.this.elements[idx];
                                    if (cond.apply(elem)) {
                                        DenseObjectMatrix3D.this.elements[idx] = f.apply(elem);
                                    }
                                    idx += DenseObjectMatrix3D.this.columnStride;
                                    ++c;
                                }
                                ++r;
                            }
                            ++s;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int idx = zero + s * this.sliceStride + r * this.rowStride;
                    int c = 0;
                    while (c < this.columns) {
                        Object elem = this.elements[idx];
                        if (cond.apply(elem)) {
                            this.elements[idx] = f.apply(elem);
                        }
                        idx += this.columnStride;
                        ++c;
                    }
                    ++r;
                }
                ++s;
            }
        }
        return this;
    }

    @Override
    public ObjectMatrix3D assign(final ObjectProcedure cond, final Object value) {
        final int zero = (int)this.index(0, 0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < DenseObjectMatrix3D.this.rows) {
                                int idx = zero + s * DenseObjectMatrix3D.this.sliceStride + r * DenseObjectMatrix3D.this.rowStride;
                                int c = 0;
                                while (c < DenseObjectMatrix3D.this.columns) {
                                    Object elem = DenseObjectMatrix3D.this.elements[idx];
                                    if (cond.apply(elem)) {
                                        DenseObjectMatrix3D.this.elements[idx] = value;
                                    }
                                    idx += DenseObjectMatrix3D.this.columnStride;
                                    ++c;
                                }
                                ++r;
                            }
                            ++s;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int idx = zero + s * this.sliceStride + r * this.rowStride;
                    int c = 0;
                    while (c < this.columns) {
                        Object elem = this.elements[idx];
                        if (cond.apply(elem)) {
                            this.elements[idx] = value;
                        }
                        idx += this.columnStride;
                        ++c;
                    }
                    ++r;
                }
                ++s;
            }
        }
        return this;
    }

    @Override
    public ObjectMatrix3D assign(ObjectMatrix3D source) {
        if (!(source instanceof DenseObjectMatrix3D)) {
            return super.assign(source);
        }
        DenseObjectMatrix3D other = (DenseObjectMatrix3D)source;
        if (other == this) {
            return this;
        }
        this.checkShape(other);
        if (this.haveSharedCells(other)) {
            ObjectMatrix3D c = other.copy();
            if (!(c instanceof DenseObjectMatrix3D)) {
                super.assign(source);
                return this;
            }
            other = (DenseObjectMatrix3D)c;
        }
        DenseObjectMatrix3D other_final = other;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView && other.isNoView) {
            System.arraycopy(other_final.elements, 0, this.elements, 0, this.elements.length);
            return this;
        }
        final int zero = (int)this.index(0, 0, 0);
        final int zeroOther = (int)other_final.index(0, 0, 0);
        final int sliceStrideOther = other_final.sliceStride;
        final int rowStrideOther = other_final.rowStride;
        final int columnStrideOther = other_final.columnStride;
        final Object[] elemsOther = other_final.elements;
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < DenseObjectMatrix3D.this.rows) {
                                int idx = zero + s * DenseObjectMatrix3D.this.sliceStride + r * DenseObjectMatrix3D.this.rowStride;
                                int idxOther = zeroOther + s * sliceStrideOther + r * rowStrideOther;
                                int c = 0;
                                while (c < DenseObjectMatrix3D.this.columns) {
                                    DenseObjectMatrix3D.this.elements[idx] = elemsOther[idxOther];
                                    idx += DenseObjectMatrix3D.this.columnStride;
                                    idxOther += columnStrideOther;
                                    ++c;
                                }
                                ++r;
                            }
                            ++s;
                        }
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    futures[j].get();
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int idx = zero + s * this.sliceStride + r * this.rowStride;
                    int idxOther = zeroOther + s * sliceStrideOther + r * rowStrideOther;
                    int c = 0;
                    while (c < this.columns) {
                        this.elements[idx] = elemsOther[idxOther];
                        idx += this.columnStride;
                        idxOther += columnStrideOther;
                        ++c;
                    }
                    ++r;
                }
                ++s;
            }
        }
        return this;
    }

    @Override
    public ObjectMatrix3D assign(final ObjectFunction function) {
        final int zero = (int)this.index(0, 0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < DenseObjectMatrix3D.this.rows) {
                                int idx = zero + s * DenseObjectMatrix3D.this.sliceStride + r * DenseObjectMatrix3D.this.rowStride;
                                int c = 0;
                                while (c < DenseObjectMatrix3D.this.columns) {
                                    DenseObjectMatrix3D.this.elements[idx] = function.apply(DenseObjectMatrix3D.this.elements[idx]);
                                    idx += DenseObjectMatrix3D.this.columnStride;
                                    ++c;
                                }
                                ++r;
                            }
                            ++s;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int idx = zero + s * this.sliceStride + r * this.rowStride;
                    int c = 0;
                    while (c < this.columns) {
                        this.elements[idx] = function.apply(this.elements[idx]);
                        idx += this.columnStride;
                        ++c;
                    }
                    ++r;
                }
                ++s;
            }
        }
        return this;
    }

    @Override
    public ObjectMatrix3D assign(ObjectMatrix3D y, final ObjectObjectFunction function) {
        if (!(y instanceof DenseObjectMatrix3D)) {
            super.assign(y, function);
            return this;
        }
        this.checkShape(y);
        final int zero = (int)this.index(0, 0, 0);
        final int zeroOther = (int)y.index(0, 0, 0);
        final int sliceStrideOther = y.sliceStride();
        final int rowStrideOther = y.rowStride();
        final int columnStrideOther = y.columnStride();
        final Object[] elemsOther = (Object[])y.elements();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < DenseObjectMatrix3D.this.rows) {
                                int idx = zero + s * DenseObjectMatrix3D.this.sliceStride + r * DenseObjectMatrix3D.this.rowStride;
                                int idxOther = zeroOther + s * sliceStrideOther + r * rowStrideOther;
                                int c = 0;
                                while (c < DenseObjectMatrix3D.this.columns) {
                                    DenseObjectMatrix3D.this.elements[idx] = function.apply(DenseObjectMatrix3D.this.elements[idx], elemsOther[idxOther]);
                                    idx += DenseObjectMatrix3D.this.columnStride;
                                    idxOther += columnStrideOther;
                                    ++c;
                                }
                                ++r;
                            }
                            ++s;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int idx = zero + s * this.sliceStride + r * this.rowStride;
                    int idxOther = zeroOther + s * sliceStrideOther + r * rowStrideOther;
                    int c = 0;
                    while (c < this.columns) {
                        this.elements[idx] = function.apply(this.elements[idx], elemsOther[idxOther]);
                        idx += this.columnStride;
                        idxOther += columnStrideOther;
                        ++c;
                    }
                    ++r;
                }
                ++s;
            }
        }
        return this;
    }

    @Override
    public ObjectMatrix3D assign(ObjectMatrix3D y, final ObjectObjectFunction function, IntArrayList sliceList, IntArrayList rowList, IntArrayList columnList) {
        if (!(y instanceof DenseObjectMatrix3D)) {
            super.assign(y, function);
            return this;
        }
        this.checkShape(y);
        final int zero = (int)this.index(0, 0, 0);
        final int zeroOther = (int)y.index(0, 0, 0);
        final int sliceStrideOther = y.sliceStride();
        final int rowStrideOther = y.rowStride();
        final int columnStrideOther = y.columnStride();
        final Object[] elemsOther = (Object[])y.elements();
        int size = sliceList.size();
        final int[] sliceElements = sliceList.elements();
        final int[] rowElements = rowList.elements();
        final int[] columnElements = columnList.elements();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, size);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int i = firstIdx;
                        while (i < lastIdx) {
                            int idx = zero + sliceElements[i] * DenseObjectMatrix3D.this.sliceStride + rowElements[i] * DenseObjectMatrix3D.this.rowStride + columnElements[i] * DenseObjectMatrix3D.this.columnStride;
                            int idxOther = zeroOther + sliceElements[i] * sliceStrideOther + rowElements[i] * rowStrideOther + columnElements[i] * columnStrideOther;
                            DenseObjectMatrix3D.this.elements[idx] = function.apply(DenseObjectMatrix3D.this.elements[idx], elemsOther[idxOther]);
                            ++i;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int i = 0;
            while (i < size) {
                int idx = zero + sliceElements[i] * this.sliceStride + rowElements[i] * this.rowStride + columnElements[i] * this.columnStride;
                int idxOther = zeroOther + sliceElements[i] * sliceStrideOther + rowElements[i] * rowStrideOther + columnElements[i] * columnStrideOther;
                this.elements[idx] = function.apply(this.elements[idx], elemsOther[idxOther]);
                ++i;
            }
        }
        return this;
    }

    public Object[] elements() {
        return this.elements;
    }

    @Override
    public Object getQuick(int slice, int row, int column) {
        return this.elements[this.sliceZero + slice * this.sliceStride + this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride];
    }

    @Override
    protected boolean haveSharedCellsRaw(ObjectMatrix3D other) {
        if (other instanceof SelectedDenseObjectMatrix3D) {
            SelectedDenseObjectMatrix3D otherMatrix = (SelectedDenseObjectMatrix3D)other;
            return this.elements == otherMatrix.elements;
        }
        if (other instanceof DenseObjectMatrix3D) {
            DenseObjectMatrix3D otherMatrix = (DenseObjectMatrix3D)other;
            return this.elements == otherMatrix.elements;
        }
        return false;
    }

    @Override
    public long index(int slice, int row, int column) {
        return this.sliceZero + slice * this.sliceStride + this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride;
    }

    @Override
    public ObjectMatrix3D like(int slices, int rows, int columns) {
        return new DenseObjectMatrix3D(slices, rows, columns);
    }

    @Override
    protected ObjectMatrix2D like2D(int rows, int columns, int rowZero, int columnZero, int rowStride, int columnStride) {
        return new DenseObjectMatrix2D(rows, columns, this.elements, rowZero, columnZero, rowStride, columnStride, true);
    }

    @Override
    public void setQuick(int slice, int row, int column, Object value) {
        this.elements[this.sliceZero + slice * this.sliceStride + this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride] = value;
    }

    @Override
    public ObjectMatrix1D vectorize() {
        DenseObjectMatrix1D v = new DenseObjectMatrix1D((int)this.size());
        int length = this.rows * this.columns;
        int s = 0;
        while (s < this.slices) {
            v.viewPart(s * length, length).assign(this.viewSlice(s).vectorize());
            ++s;
        }
        return v;
    }

    @Override
    protected ObjectMatrix3D viewSelectionLike(int[] sliceOffsets, int[] rowOffsets, int[] columnOffsets) {
        return new SelectedDenseObjectMatrix3D(this.elements, sliceOffsets, rowOffsets, columnOffsets, 0);
    }

    @Override
    public ObjectMatrix2D like2D(int rows, int columns) {
        return new DenseObjectMatrix2D(rows, columns);
    }
}

