/*
 * Decompiled with CFR 0.152.
 */
package com.nativelibs4java.opencl;

import com.nativelibs4java.opencl.CLAbstractEntity;
import com.nativelibs4java.opencl.CLBuildException;
import com.nativelibs4java.opencl.CLContext;
import com.nativelibs4java.opencl.CLDevice;
import com.nativelibs4java.opencl.CLException;
import com.nativelibs4java.opencl.CLInfoGetter;
import com.nativelibs4java.opencl.CLKernel;
import com.nativelibs4java.opencl.JavaCL;
import com.nativelibs4java.opencl.library.OpenCLLibrary;
import com.nativelibs4java.util.JNAUtils;
import com.nativelibs4java.util.NIOUtils;
import com.ochafik.io.IOUtils;
import com.ochafik.io.ReadText;
import com.ochafik.lang.jnaerator.runtime.NativeSize;
import com.ochafik.lang.jnaerator.runtime.NativeSizeByReference;
import com.ochafik.util.listenable.Pair;
import com.ochafik.util.string.RegexUtils;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Pattern;
import java.util.zip.CRC32;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class CLProgram
extends CLAbstractEntity<OpenCLLibrary.cl_program> {
    protected final CLContext context;
    private static CLInfoGetter<OpenCLLibrary.cl_program> infos = new CLInfoGetter<OpenCLLibrary.cl_program>(){

        @Override
        protected int getInfo(OpenCLLibrary.cl_program entity, int infoTypeEnum, NativeSize size, Pointer out, NativeSizeByReference sizeOut) {
            return JavaCL.CL.clGetProgramInfo(entity, infoTypeEnum, size, out, sizeOut);
        }
    };
    CLDevice[] devices;
    private static final String BinariesSignatureZipEntryName = "SIGNATURE";
    private static final String SourceZipEntryName = "SOURCE";
    private static final String textEncoding = "utf-8";
    List<String> sources = new ArrayList<String>();
    Map<CLDevice, OpenCLLibrary.cl_program> programByDevice = new HashMap<CLDevice, OpenCLLibrary.cl_program>();
    public static boolean passMacrosAsSources = true;
    List<String> includes;
    static File tempIncludes = new File(new File(System.getProperty("java.io.tmpdir")), "JavaCL");
    Map<String, URL> resolvedInclusions;
    static Pattern includePattern = Pattern.compile("#\\s*include\\s*\"([^\"]+)\"");
    String source;
    Map<String, Object> macros;
    List<String> extraBuildOptions;
    private volatile Boolean cached;
    static File cacheDirectory = new File(new File(System.getProperty("java.io.tmpdir"), "JavaCL"), "cachedProgramBinaries");
    boolean built;

    CLProgram(CLContext context, CLDevice ... devices) {
        super(null, true);
        this.context = context;
        this.devices = devices == null || devices.length == 0 ? context.getDevices() : devices;
    }

    CLProgram(CLContext context, Map<CLDevice, byte[]> binaries, String source) {
        super(null, true);
        this.context = context;
        this.source = source;
        this.setBinaries(binaries);
    }

    protected void setBinaries(Map<CLDevice, byte[]> binaries) {
        if (this.devices == null) {
            this.devices = new CLDevice[binaries.size()];
            int iDevice = 0;
            for (CLDevice device : binaries.keySet()) {
                this.devices[iDevice++] = device;
            }
        }
        int nDevices = this.devices.length;
        NativeSize[] lengths = new NativeSize[nDevices];
        OpenCLLibrary.cl_device_id[] deviceIds = new OpenCLLibrary.cl_device_id[nDevices];
        Memory binariesArray = new Memory(Pointer.SIZE * nDevices);
        Memory[] binariesMems = new Memory[nDevices];
        for (int iDevice = 0; iDevice < nDevices; ++iDevice) {
            CLDevice device = this.devices[iDevice];
            byte[] binary = binaries.get(device);
            Memory binaryMem = binariesMems[iDevice] = new Memory(binary.length);
            binaryMem.write(0L, binary, 0, binary.length);
            binariesArray.setPointer(iDevice * Pointer.SIZE, binaryMem);
            lengths[iDevice] = JNAUtils.toNS(binary.length);
            deviceIds[iDevice] = (OpenCLLibrary.cl_device_id)device.getEntity();
        }
        PointerByReference binariesPtr = new PointerByReference();
        binariesPtr.setPointer(binariesArray);
        IntBuffer errBuff = NIOUtils.directInts(1, ByteOrder.nativeOrder());
        int previousAttempts = 0;
        IntBuffer statuses = NIOUtils.directInts(nDevices, ByteOrder.nativeOrder());
        do {
            this.entity = JavaCL.CL.clCreateProgramWithBinary((OpenCLLibrary.cl_context)this.context.getEntity(), nDevices, deviceIds, lengths, binariesPtr, statuses, errBuff);
        } while (CLException.failedForLackOfMemory(errBuff.get(0), previousAttempts++));
    }

    public void store(OutputStream out) throws CLBuildException, IOException {
        CLProgram.writeBinaries(this.getBinaries(), this.getSource(), null, out);
    }

    private static final void addStoredEntry(ZipOutputStream zout, String name, byte[] data) throws IOException {
        ZipEntry ze = new ZipEntry(name);
        ze.setMethod(0);
        ze.setSize(data.length);
        CRC32 crc = new CRC32();
        crc.update(data, 0, data.length);
        ze.setCrc(crc.getValue());
        zout.putNextEntry(ze);
        zout.write(data);
        zout.closeEntry();
    }

    public static void writeBinaries(Map<CLDevice, byte[]> binaries, String source, String contentSignatureString, OutputStream out) throws IOException {
        HashMap<String, byte[]> binaryBySignature = new HashMap<String, byte[]>();
        for (Map.Entry<CLDevice, byte[]> e : binaries.entrySet()) {
            binaryBySignature.put(e.getKey().createSignature(), e.getValue());
        }
        ZipOutputStream zout = new ZipOutputStream(new GZIPOutputStream(new BufferedOutputStream(out)));
        if (contentSignatureString != null) {
            CLProgram.addStoredEntry(zout, BinariesSignatureZipEntryName, contentSignatureString.getBytes(textEncoding));
        }
        if (source != null) {
            CLProgram.addStoredEntry(zout, SourceZipEntryName, source.getBytes(textEncoding));
        }
        for (Map.Entry e : binaryBySignature.entrySet()) {
            CLProgram.addStoredEntry(zout, (String)e.getKey(), (byte[])e.getValue());
        }
        zout.close();
    }

    public static Pair<Map<CLDevice, byte[]>, String> readBinaries(List<CLDevice> allowedDevices, String expectedContentSignatureString, InputStream in) throws IOException {
        ZipEntry ze;
        HashMap<CLDevice, byte[]> ret = new HashMap<CLDevice, byte[]>();
        Map<String, List<CLDevice>> devicesBySignature = CLDevice.getDevicesBySignature(allowedDevices);
        ZipInputStream zin = new ZipInputStream(new GZIPInputStream(new BufferedInputStream(in)));
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        String source = null;
        boolean first = true;
        byte[] b = new byte[65536];
        while ((ze = zin.getNextEntry()) != null) {
            int len;
            String signature = ze.getName();
            boolean isSignature = signature.equals(BinariesSignatureZipEntryName);
            if (first && !isSignature && expectedContentSignatureString != null || !first && isSignature) {
                throw new IOException("Expected signature to be the first zip entry, got '" + signature + "' instead !");
            }
            first = false;
            bout.reset();
            while ((len = zin.read(b)) > 0) {
                bout.write(b, 0, len);
            }
            byte[] data = bout.toByteArray();
            if (isSignature) {
                String contentSignatureString;
                if (expectedContentSignatureString == null || expectedContentSignatureString.equals(contentSignatureString = new String(data, textEncoding))) continue;
                throw new IOException("Content signature does not match expected one :\nExpected '" + expectedContentSignatureString + "',\nGot '" + contentSignatureString + "'");
            }
            if (signature.equals(SourceZipEntryName)) {
                source = new String(data, textEncoding);
                continue;
            }
            List<CLDevice> devices = devicesBySignature.get(signature);
            for (CLDevice device : devices) {
                ret.put(device, data);
            }
        }
        zin.close();
        return new Pair(ret, source);
    }

    public CLDevice[] getDevices() {
        return (CLDevice[])this.devices.clone();
    }

    public synchronized void allocate() {
        OpenCLLibrary.cl_program program;
        if (this.entity != null) {
            throw new IllegalThreadStateException("Program was already allocated !");
        }
        if (passMacrosAsSources && this.macros != null && !this.macros.isEmpty()) {
            StringBuilder b = new StringBuilder();
            for (Map.Entry<String, Object> m : this.macros.entrySet()) {
                b.append("#define " + m.getKey() + " " + m.getValue() + "\n");
            }
            this.sources.add(0, b.toString());
        }
        if (!"false".equals(System.getProperty("javacl.adjustDoubleExtension")) && !"0".equals(System.getenv("JAVACL_ADJUST_DOUBLE_EXTENSION"))) {
            int len = this.sources.size();
            for (int i = 0; i < len; ++i) {
                String source = this.sources.get(i);
                for (CLDevice device : this.getDevices()) {
                    source = device.replaceDoubleExtensionByExtensionActuallyAvailable(source);
                }
                this.sources.set(i, source);
            }
        }
        String[] sources = this.sources.toArray(new String[this.sources.size()]);
        NativeSize[] lengths = new NativeSize[sources.length];
        for (int i = 0; i < sources.length; ++i) {
            lengths[i] = JNAUtils.toNS(sources[i].length());
        }
        IntBuffer errBuff = NIOUtils.directInts(1, ByteOrder.nativeOrder());
        int previousAttempts = 0;
        do {
            program = JavaCL.CL.clCreateProgramWithSource((OpenCLLibrary.cl_context)this.context.getEntity(), sources.length, sources, lengths, errBuff);
        } while (CLException.failedForLackOfMemory(errBuff.get(0), previousAttempts++));
        this.entity = program;
    }

    @Override
    protected synchronized OpenCLLibrary.cl_program getEntity() {
        if (this.entity == null) {
            this.allocate();
        }
        return (OpenCLLibrary.cl_program)this.entity;
    }

    public synchronized void addInclude(String path) {
        if (this.includes == null) {
            this.includes = new ArrayList<String>();
        }
        this.includes.add(path);
        this.resolvedInclusions = null;
    }

    public synchronized void addSource(String src) {
        if (this.entity != null) {
            throw new IllegalThreadStateException("Program was already allocated : cannot add sources anymore.");
        }
        this.sources.add(src);
        this.resolvedInclusions = null;
    }

    protected Runnable copyIncludesToTemporaryDirectory() throws IOException {
        Map<String, URL> inclusions = this.resolveInclusions();
        tempIncludes.mkdirs();
        File includesDir = File.createTempFile("includes", "", tempIncludes);
        includesDir.delete();
        includesDir.mkdirs();
        final ArrayList<File> filesToDelete = new ArrayList<File>();
        for (Map.Entry<String, URL> e : inclusions.entrySet()) {
            assert (JavaCL.log(Level.INFO, "Copying include '" + e.getKey() + "' from '" + e.getValue() + "' to '" + includesDir + "'"));
            File f = new File(includesDir, e.getKey().replace('/', File.separatorChar));
            File p = f.getParentFile();
            filesToDelete.add(f);
            if (p != null) {
                p.mkdirs();
                filesToDelete.add(p);
            }
            InputStream in = e.getValue().openStream();
            FileOutputStream out = new FileOutputStream(f);
            IOUtils.readWrite(in, out);
            in.close();
            ((OutputStream)out).close();
            f.deleteOnExit();
        }
        filesToDelete.add(includesDir);
        this.addInclude(includesDir.toString());
        return new Runnable(){

            @Override
            public void run() {
                for (File f : filesToDelete) {
                    f.delete();
                }
            }
        };
    }

    public Map<String, URL> resolveInclusions() throws IOException {
        if (this.resolvedInclusions == null) {
            this.resolvedInclusions = new HashMap<String, URL>();
            for (String source : this.sources) {
                this.resolveInclusions(source, this.resolvedInclusions);
            }
        }
        return this.resolvedInclusions;
    }

    private void resolveInclusions(String source, Map<String, URL> ret) throws IOException {
        Collection<String> includedPaths = RegexUtils.find(source, includePattern, 1);
        for (String includedPath : includedPaths) {
            if (ret.containsKey(includedPath)) continue;
            URL url = this.getIncludedSourceURL(includedPath);
            if (url == null) {
                assert (JavaCL.log(Level.SEVERE, "Failed to resolve include '" + includedPath + "'"));
                continue;
            }
            String s = ReadText.readText(url);
            ret.put(includedPath, url);
            this.resolveInclusions(s, ret);
        }
    }

    public String getIncludedSourceContent(String path) throws IOException {
        URL url = this.getIncludedSourceURL(path);
        if (url == null) {
            return null;
        }
        String src = ReadText.readText(url);
        return src;
    }

    public URL getIncludedSourceURL(String path) throws MalformedURLException {
        File f = new File(path);
        if (f.exists()) {
            return f.toURI().toURL();
        }
        URL url = this.getClass().getClassLoader().getResource(path);
        if (url != null) {
            return url;
        }
        if (this.includes != null) {
            for (String include : this.includes) {
                f = new File(new File(include), path);
                if (f.exists()) {
                    return f.toURI().toURL();
                }
                url = this.getClass().getClassLoader().getResource(f.toString());
                if (url != null) {
                    return url;
                }
                try {
                    url = new URL(include + (include.endsWith("/") ? "" : "/") + path);
                    url.openStream().close();
                    return url;
                }
                catch (IOException ex) {
                }
            }
        }
        return null;
    }

    public synchronized String getSource() {
        if (this.source == null) {
            this.source = infos.getString(this.getEntity(), 4452);
        }
        return this.source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<CLDevice, byte[]> getBinaries() throws CLBuildException {
        CLProgram cLProgram = this;
        synchronized (cLProgram) {
            if (!this.built) {
                this.build();
            }
        }
        Memory s = infos.getMemory(this.getEntity(), 4453);
        int n = (int)s.getSize() / Native.SIZE_T_SIZE;
        NativeSize[] sizes = JNAUtils.readNSArray(s, n);
        Memory[] binMems = new Memory[n];
        Memory ptrs = new Memory(n * Native.POINTER_SIZE);
        for (int i = 0; i < n; ++i) {
            binMems[i] = new Memory(sizes[i].intValue());
            ptrs.setPointer(i * Native.POINTER_SIZE, binMems[i]);
        }
        CLException.error(infos.getInfo(this.getEntity(), 4454, JNAUtils.toNS(ptrs.getSize() * (long)Native.POINTER_SIZE), ptrs, null));
        HashMap<CLDevice, byte[]> ret = new HashMap<CLDevice, byte[]>(this.devices.length);
        for (int i = 0; i < n; ++i) {
            CLDevice device = this.devices[i];
            Memory bytes = binMems[i];
            ret.put(device, bytes.getByteArray(0L, sizes[i].intValue()));
        }
        return ret;
    }

    public CLContext getContext() {
        return this.context;
    }

    public CLProgram defineMacro(String name, Object value) {
        this.createMacros();
        this.macros.put(name, value);
        return this;
    }

    public CLProgram undefineMacro(String name) {
        if (this.macros != null) {
            this.macros.remove(name);
        }
        return this;
    }

    private void createMacros() {
        if (this.macros == null) {
            this.macros = new LinkedHashMap<String, Object>();
        }
    }

    public void defineMacros(Map<String, Object> macros) {
        this.createMacros();
        this.macros.putAll(macros);
    }

    public synchronized void addBuildOption(String option) {
        if (option.startsWith("-I")) {
            this.addInclude(option.substring(2));
            return;
        }
        if (this.extraBuildOptions == null) {
            this.extraBuildOptions = new ArrayList<String>();
        }
        this.extraBuildOptions.add(option);
    }

    protected String getOptionsString() {
        StringBuilder b = new StringBuilder("-DJAVACL=1 ");
        if (this.extraBuildOptions != null) {
            for (String string : this.extraBuildOptions) {
                b.append(string).append(' ');
            }
        }
        if (!passMacrosAsSources && this.macros != null && !this.macros.isEmpty()) {
            for (Map.Entry entry : this.macros.entrySet()) {
                b.append("-D" + (String)entry.getKey() + "=" + entry.getValue() + " ");
            }
        }
        if (this.includes != null) {
            for (String string : this.includes) {
                if (!new File(string).exists()) continue;
                b.append("-I").append(string).append(' ');
            }
        }
        return b.toString();
    }

    public synchronized void setCached(boolean cached) {
        this.cached = cached;
    }

    public synchronized boolean isCached() {
        if (this.cached == null) {
            this.cached = this.context.getCacheBinaries();
        }
        return this.cached;
    }

    protected String computeCacheSignature() throws IOException {
        StringBuilder b = new StringBuilder(1024);
        for (CLDevice device : this.getDevices()) {
            b.append(device).append("\n");
        }
        b.append(this.getOptionsString()).append('\n');
        if (this.macros != null) {
            for (Map.Entry entry : this.macros.entrySet()) {
                b.append("-D").append((String)entry.getKey()).append("=").append(entry.getValue()).append('\n');
            }
        }
        if (this.includes != null) {
            for (String string : this.includes) {
                b.append("-I").append(string).append('\n');
            }
        }
        if (this.sources != null) {
            for (String string : this.sources) {
                b.append(string).append("\n");
            }
        }
        Map<String, URL> inclusions = this.resolveInclusions();
        for (Map.Entry<String, URL> e : inclusions.entrySet()) {
            URLConnection con = e.getValue().openConnection();
            InputStream in = con.getInputStream();
            b.append('#').append(e.getKey()).append(con.getLastModified()).append('\n');
            in.close();
        }
        return b.toString();
    }

    public synchronized CLProgram build() throws CLBuildException {
        int err;
        if (this.built) {
            throw new IllegalThreadStateException("Program was already built !");
        }
        String contentSignature = null;
        File cacheFile = null;
        boolean readBinaries = false;
        if (this.isCached()) {
            try {
                contentSignature = this.computeCacheSignature();
                byte[] sha = MessageDigest.getInstance("MD5").digest(contentSignature.getBytes(textEncoding));
                StringBuilder shab = new StringBuilder();
                for (byte b : sha) {
                    shab.append(Integer.toHexString(b & 0xFF));
                }
                String hash = shab.toString();
                cacheFile = new File(cacheDirectory, hash);
                if (cacheFile.exists()) {
                    Pair<Map<CLDevice, byte[]>, String> bins = CLProgram.readBinaries(Arrays.asList(this.getDevices()), contentSignature, new FileInputStream(cacheFile));
                    this.setBinaries(bins.getFirst());
                    this.source = bins.getSecond();
                    assert (JavaCL.log(Level.INFO, "Read binaries cache from '" + cacheFile + "'"));
                    readBinaries = true;
                }
            }
            catch (Exception ex) {
                assert (JavaCL.log(Level.WARNING, "Failed to load cached program", ex));
                this.entity = null;
            }
        }
        if (this.entity == null) {
            this.allocate();
        }
        Runnable deleteTempFiles = null;
        if (!readBinaries) {
            try {
                deleteTempFiles = this.copyIncludesToTemporaryDirectory();
            }
            catch (IOException ex) {
                throw new CLBuildException(this, ex.toString(), Collections.EMPTY_LIST);
            }
        }
        int nDevices = this.devices.length;
        OpenCLLibrary.cl_device_id[] deviceIds = null;
        if (nDevices != 0) {
            deviceIds = new OpenCLLibrary.cl_device_id[nDevices];
            for (int i = 0; i < nDevices; ++i) {
                deviceIds[i] = (OpenCLLibrary.cl_device_id)this.devices[i].getEntity();
            }
        }
        if ((err = JavaCL.CL.clBuildProgram(this.getEntity(), nDevices, deviceIds, readBinaries ? null : this.getOptionsString(), null, null)) != 0) {
            NativeSizeByReference len = new NativeSizeByReference();
            int bufLen = 65536;
            Memory buffer = new Memory(bufLen);
            HashSet<String> errs = new HashSet<String>();
            if (deviceIds == null) {
                CLException.error(JavaCL.CL.clGetProgramBuildInfo(this.getEntity(), null, 4483, JNAUtils.toNS(bufLen), buffer, len));
                String s = buffer.getString(0L);
                errs.add(s);
            } else {
                for (OpenCLLibrary.cl_device_id device : deviceIds) {
                    CLException.error(JavaCL.CL.clGetProgramBuildInfo(this.getEntity(), device, 4483, JNAUtils.toNS(bufLen), buffer, len));
                    String s = buffer.getString(0L);
                    errs.add(s);
                }
            }
            throw new CLBuildException(this, "Compilation failure : " + CLException.errorString(err), errs);
        }
        this.built = true;
        if (deleteTempFiles != null) {
            deleteTempFiles.run();
        }
        if (this.isCached() && !readBinaries) {
            cacheDirectory.mkdirs();
            try {
                CLProgram.writeBinaries(this.getBinaries(), this.getSource(), contentSignature, new FileOutputStream(cacheFile));
                assert (JavaCL.log(Level.INFO, "Wrote binaries cache to '" + cacheFile + "'"));
            }
            catch (Exception ex) {
                new IOException("[JavaCL] Failed to cache program", ex).printStackTrace();
            }
        }
        return this;
    }

    @Override
    protected void clear() {
        CLException.error(JavaCL.CL.clReleaseProgram(this.getEntity()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CLKernel[] createKernels() throws CLBuildException {
        CLProgram cLProgram = this;
        synchronized (cLProgram) {
            if (!this.built) {
                this.build();
            }
        }
        IntByReference pCount = new IntByReference();
        int previousAttempts = 0;
        while (CLException.failedForLackOfMemory(JavaCL.CL.clCreateKernelsInProgram(this.getEntity(), 0, (OpenCLLibrary.cl_kernel[])null, pCount), previousAttempts++)) {
        }
        int count = pCount.getValue();
        OpenCLLibrary.cl_kernel[] kerns = new OpenCLLibrary.cl_kernel[count];
        previousAttempts = 0;
        while (CLException.failedForLackOfMemory(JavaCL.CL.clCreateKernelsInProgram(this.getEntity(), count, kerns, pCount), previousAttempts++)) {
        }
        CLKernel[] kernels = new CLKernel[count];
        for (int i = 0; i < count; ++i) {
            kernels[i] = new CLKernel(this, null, kerns[i]);
        }
        return kernels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CLKernel createKernel(String name, Object ... args) throws CLBuildException {
        OpenCLLibrary.cl_kernel kernel;
        CLProgram cLProgram = this;
        synchronized (cLProgram) {
            if (!this.built) {
                this.build();
            }
        }
        IntBuffer errBuff = NIOUtils.directInts(1, ByteOrder.nativeOrder());
        int previousAttempts = 0;
        do {
            kernel = JavaCL.CL.clCreateKernel(this.getEntity(), name, errBuff);
        } while (CLException.failedForLackOfMemory(errBuff.get(0), previousAttempts++));
        CLKernel kn = new CLKernel(this, name, kernel);
        kn.setArgs(args);
        return kn;
    }
}

