/*
 * Decompiled with CFR 0.152.
 */
package mitiv.cost;

import mitiv.cost.CompositeDifferentiableCostFunction;
import mitiv.cost.DifferentiableCostFunction;
import mitiv.linalg.Vector;
import mitiv.linalg.VectorSpace;
import mitiv.linalg.shaped.ShapedVectorSpace;
import mitiv.optim.BLMVM;
import mitiv.optim.BoundProjector;
import mitiv.optim.IterativeDifferentiableSolver;
import mitiv.optim.LBFGS;
import mitiv.optim.LineSearch;
import mitiv.optim.MoreThuenteLineSearch;
import mitiv.optim.NonLinearConjugateGradient;
import mitiv.optim.OptimTask;
import mitiv.optim.SimpleBounds;
import mitiv.optim.SimpleLowerBound;
import mitiv.optim.SimpleUpperBound;

public class SmoothInverseProblem
extends IterativeDifferentiableSolver {
    protected boolean debug = false;
    private boolean restart = true;
    private DifferentiableCostFunction fdata = null;
    private double mu = 1.0;
    private DifferentiableCostFunction fprior = null;
    private int limitedMemorySize = 5;
    private double lowerBound = Double.NEGATIVE_INFINITY;
    private double upperBound = Double.POSITIVE_INFINITY;
    private BoundProjector projector = null;
    private LineSearch lineSearch = null;
    private double gatol = 0.0;
    private double grtol = 0.001;

    public double getAbsoluteTolerance() {
        return this.gatol;
    }

    public void setAbsoluteTolerance(double d) {
        if (this.nonfinite(d) || d < 0.0) {
            SmoothInverseProblem.error("Absolute tolerance for convergence must be nonnegative");
        }
        this.gatol = d;
    }

    public double getRelativeTolerance() {
        return this.grtol;
    }

    public void setRelativeTolerance(double d) {
        if (this.nonfinite(d) || d < 0.0) {
            SmoothInverseProblem.error("Relative tolerance for convergence must be nonnegative");
        }
        this.grtol = d;
    }

    public int getLimitedMemorySize() {
        return this.limitedMemorySize;
    }

    public void setLimitedMemorySize(int n) {
        if (n < 0) {
            SmoothInverseProblem.error("Limited memory size be nonnegative");
        }
        if (this.limitedMemorySize != n) {
            this.limitedMemorySize = n;
            this.restart = true;
        }
    }

    public double getLowerBound() {
        return this.lowerBound;
    }

    public void setLowerBound(double d) {
        if (Double.isNaN(d) || d == Double.POSITIVE_INFINITY) {
            SmoothInverseProblem.error("Invalid value for the lower bound");
        }
        if (this.lowerBound != d) {
            this.lowerBound = d;
            this.restart = true;
        }
    }

    public double getUpperBound() {
        return this.upperBound;
    }

    public void setUpperBound(double d) {
        if (Double.isNaN(d) || d == Double.NEGATIVE_INFINITY) {
            SmoothInverseProblem.error("Invalid value for the upper bound");
        }
        if (this.upperBound != d) {
            this.upperBound = d;
            this.restart = true;
        }
    }

    public DifferentiableCostFunction getLikelihood() {
        return this.fdata;
    }

    public void setLikelihood(DifferentiableCostFunction differentiableCostFunction) {
        if (this.fdata != differentiableCostFunction) {
            this.fdata = differentiableCostFunction;
            this.restart = true;
        }
    }

    public double getRegularizationLevel() {
        return this.mu;
    }

    public void setRegularizationLevel(double d) {
        if (this.nonfinite(d) || d < 0.0) {
            SmoothInverseProblem.error("Regularization level must be nonnegative");
        }
        if (this.mu != d) {
            this.mu = d;
            this.restart = true;
        }
    }

    public DifferentiableCostFunction getRegularization() {
        return this.fprior;
    }

    public void setRegularization(DifferentiableCostFunction differentiableCostFunction) {
        if (this.fprior != differentiableCostFunction) {
            this.fprior = differentiableCostFunction;
            this.restart = true;
        }
    }

    public boolean getDebug() {
        return this.debug;
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    @Override
    public OptimTask start(Vector vector) {
        return this.start(vector, false);
    }

    @Override
    public OptimTask start(Vector vector, boolean bl) {
        if (this.restart) {
            this.setup(vector);
        }
        return super.start(vector, bl);
    }

    @Override
    public OptimTask iterate(Vector vector) {
        if (this.restart) {
            return this.start(vector);
        }
        return super.iterate(vector);
    }

    public void releaseResources() {
        this.setOptimizer(null);
        this.restart = true;
    }

    private void setup(Vector vector) {
        if (this.fdata == null) {
            SmoothInverseProblem.error("No data cost specified");
        }
        if (this.mu == 0.0) {
            this.setCostFunction(this.fdata);
        } else {
            if (this.fprior == null) {
                SmoothInverseProblem.error("No regularization specified");
            }
            this.setCostFunction(new CompositeDifferentiableCostFunction(1.0, this.fdata, this.mu, this.fprior));
        }
        if (this.lowerBound > this.upperBound) {
            SmoothInverseProblem.error("Incompatible bounds");
        }
        int n = 0;
        if (this.lowerBound != Double.NEGATIVE_INFINITY) {
            n |= 1;
        }
        if (this.upperBound != Double.POSITIVE_INFINITY) {
            n |= 2;
        }
        this.lineSearch = null;
        this.projector = null;
        VectorSpace vectorSpace = this.getSpace();
        if (n == 0) {
            this.lineSearch = new MoreThuenteLineSearch(1.0E-4, 0.9, LBFGS.SXTOL);
            if (this.limitedMemorySize > 0) {
                LBFGS lBFGS = new LBFGS(vectorSpace, this.limitedMemorySize, this.lineSearch);
                lBFGS.setAbsoluteTolerance(this.gatol);
                lBFGS.setRelativeTolerance(this.grtol);
                this.setOptimizer(lBFGS);
                if (this.debug) {
                    System.out.format("Using L-BFGS with %d memorized steps.\n", this.limitedMemorySize);
                }
            } else {
                this.lineSearch = new MoreThuenteLineSearch(0.05, 0.1, NonLinearConjugateGradient.SXTOL);
                int n2 = 771;
                NonLinearConjugateGradient nonLinearConjugateGradient = new NonLinearConjugateGradient(vectorSpace, n2, this.lineSearch);
                nonLinearConjugateGradient.setAbsoluteTolerance(this.gatol);
                nonLinearConjugateGradient.setRelativeTolerance(this.grtol);
                this.setOptimizer(nonLinearConjugateGradient);
                if (this.debug) {
                    System.out.format("Using non-linear conjugate gradients.\n", new Object[0]);
                }
            }
        } else {
            if (!(vectorSpace instanceof ShapedVectorSpace)) {
                SmoothInverseProblem.error("Bounds are only implented for shaped vectors");
            }
            this.projector = n == 1 ? new SimpleLowerBound((ShapedVectorSpace)vectorSpace, this.lowerBound) : (n == 2 ? new SimpleUpperBound((ShapedVectorSpace)vectorSpace, this.upperBound) : new SimpleBounds((ShapedVectorSpace)vectorSpace, this.lowerBound, this.upperBound));
            int n3 = this.limitedMemorySize > 1 ? this.limitedMemorySize : 5;
            BLMVM bLMVM = new BLMVM(vectorSpace, this.projector, n3);
            bLMVM.setAbsoluteTolerance(this.gatol);
            bLMVM.setRelativeTolerance(this.grtol);
            this.setOptimizer(bLMVM);
            this.projector.projectVariables(vector, vector);
            if (this.debug) {
                System.out.format("Using BLMVM with %d memorized steps.\n", this.limitedMemorySize);
            }
        }
        this.restart = false;
    }

    private static void error(String string) {
        throw new IllegalArgumentException(string);
    }

    private boolean nonfinite(double d) {
        return Double.isInfinite(d) || Double.isNaN(d);
    }
}

