/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.hdf5.HDF5CompoundByteifyerFactory;
import ch.systemsx.cisd.hdf5.HDF5CompoundMemberInformation;
import ch.systemsx.cisd.hdf5.HDF5CompoundMemberMapping;
import ch.systemsx.cisd.hdf5.HDF5DataClass;
import ch.systemsx.cisd.hdf5.HDF5DataTypeVariant;
import ch.systemsx.cisd.hdf5.HDF5EnumerationType;
import ch.systemsx.cisd.hdf5.HDF5MemberByteifyer;
import ch.systemsx.cisd.hdf5.HDF5TimeDuration;
import ch.systemsx.cisd.hdf5.HDF5TimeUnit;
import ch.systemsx.cisd.hdf5.HDF5ValueObjectByteifyer;
import ch.systemsx.cisd.hdf5.ReflectionUtils;
import ch.systemsx.cisd.hdf5.hdf5lib.HDF5Constants;
import ch.systemsx.cisd.hdf5.hdf5lib.HDFNativeData;
import java.lang.reflect.Field;

class HDF5CompoundMemberByteifyerHDF5TimeDurationFactory
implements HDF5CompoundByteifyerFactory.IHDF5CompoundMemberBytifyerFactory {
    HDF5CompoundMemberByteifyerHDF5TimeDurationFactory() {
    }

    @Override
    public boolean canHandle(Class<?> clazz, HDF5CompoundMemberInformation memberInfoOrNull) {
        if (memberInfoOrNull != null) {
            return (clazz == HDF5TimeDuration.class || Long.class.isAssignableFrom(clazz)) && memberInfoOrNull.getType().isTimeDuration();
        }
        return clazz == HDF5TimeDuration.class;
    }

    @Override
    public Class<?> tryGetOverrideJavaType(HDF5DataClass dataClass, int rank, int elementSize, HDF5DataTypeVariant typeVariantOrNull) {
        if (dataClass == HDF5DataClass.INTEGER && rank == 0 && elementSize == 8 && typeVariantOrNull != null && typeVariantOrNull.isTimeDuration()) {
            return HDF5TimeDuration.class;
        }
        return null;
    }

    @Override
    public HDF5MemberByteifyer createBytifyer(HDF5CompoundByteifyerFactory.AccessType accessType, Field fieldOrNull, HDF5CompoundMemberMapping member, HDF5CompoundMemberInformation compoundMemberInfoOrNull, HDF5EnumerationType enumTypeOrNull, Class<?> memberClazz, int index, int offset, int memOffset, HDF5ValueObjectByteifyer.IFileAccessProvider fileInfoProvider) {
        String memberName = member.getMemberName();
        HDF5DataTypeVariant typeVariant = HDF5DataTypeVariant.isTypeVariant(member.tryGetTypeVariant()) ? member.tryGetTypeVariant() : HDF5DataTypeVariant.TIME_DURATION_MICROSECONDS;
        switch (accessType) {
            case FIELD: {
                return this.createByteifyerForField(fieldOrNull, memberName, offset, memOffset, typeVariant);
            }
            case MAP: {
                return this.createByteifyerForMap(memberName, offset, memOffset, typeVariant);
            }
            case LIST: {
                return this.createByteifyerForList(memberName, index, offset, memOffset, typeVariant);
            }
            case ARRAY: {
                return this.createByteifyerForArray(memberName, index, offset, memOffset, typeVariant);
            }
        }
        throw new Error("Unknown access type");
    }

    private HDF5MemberByteifyer createByteifyerForField(final Field field, String memberName, int offset, int memOffset, HDF5DataTypeVariant typeVariant) {
        ReflectionUtils.ensureAccessible(field);
        return new HDF5MemberByteifyer(field, memberName, 8, offset, memOffset, false, typeVariant, typeVariant){
            final HDF5TimeUnit timeUnit;
            {
                super($anonymous0, $anonymous1, $anonymous2, $anonymous3, $anonymous4, $anonymous5, $anonymous6);
                this.timeUnit = HDF5DataTypeVariant.getTimeUnit(hDF5DataTypeVariant);
            }

            @Override
            int getElementSize() {
                return 8;
            }

            @Override
            protected int getMemberStorageTypeId() {
                return HDF5Constants.H5T_STD_I64LE;
            }

            @Override
            protected int getMemberNativeTypeId() {
                return -1;
            }

            @Override
            public byte[] byteify(int compoundDataTypeId, Object obj) throws IllegalAccessException {
                HDF5TimeDuration duration = (HDF5TimeDuration)field.get(obj);
                return HDFNativeData.longToByte(this.timeUnit.convert(duration.getValue(), duration.getUnit()));
            }

            @Override
            public void setFromByteArray(int compoundDataTypeId, Object obj, byte[] byteArr, int arrayOffset) throws IllegalAccessException {
                field.set(obj, new HDF5TimeDuration(HDFNativeData.byteToLong(byteArr, arrayOffset + this.offsetInMemory), this.timeUnit));
            }
        };
    }

    private HDF5MemberByteifyer createByteifyerForMap(final String memberName, int offset, int memOffset, HDF5DataTypeVariant typeVariant) {
        return new HDF5MemberByteifyer(null, memberName, 8, offset, memOffset, false, typeVariant, typeVariant){
            final HDF5TimeUnit timeUnit;
            {
                super($anonymous0, $anonymous1, $anonymous2, $anonymous3, $anonymous4, $anonymous5, $anonymous6);
                this.timeUnit = HDF5DataTypeVariant.getTimeUnit(hDF5DataTypeVariant);
            }

            @Override
            int getElementSize() {
                return 8;
            }

            @Override
            protected int getMemberStorageTypeId() {
                return HDF5Constants.H5T_STD_I64LE;
            }

            @Override
            protected int getMemberNativeTypeId() {
                return -1;
            }

            @Override
            public byte[] byteify(int compoundDataTypeId, Object obj) throws IllegalAccessException {
                Object durationObj = HDF5CompoundByteifyerFactory.getMap(obj, memberName);
                if (durationObj instanceof HDF5TimeDuration) {
                    HDF5TimeDuration duration = (HDF5TimeDuration)durationObj;
                    return HDFNativeData.longToByte(this.timeUnit.convert(duration.getValue(), duration.getUnit()));
                }
                return HDFNativeData.longToByte(((Number)durationObj).longValue());
            }

            @Override
            public void setFromByteArray(int compoundDataTypeId, Object obj, byte[] byteArr, int arrayOffset) throws IllegalAccessException {
                HDF5CompoundByteifyerFactory.putMap(obj, memberName, new HDF5TimeDuration(HDFNativeData.byteToLong(byteArr, arrayOffset + this.offsetInMemory), this.timeUnit));
            }
        };
    }

    private HDF5MemberByteifyer createByteifyerForList(String memberName, final int index, int offset, int memOffset, HDF5DataTypeVariant typeVariant) {
        return new HDF5MemberByteifyer(null, memberName, 8, offset, memOffset, false, typeVariant, typeVariant){
            final HDF5TimeUnit timeUnit;
            {
                super($anonymous0, $anonymous1, $anonymous2, $anonymous3, $anonymous4, $anonymous5, $anonymous6);
                this.timeUnit = HDF5DataTypeVariant.getTimeUnit(hDF5DataTypeVariant);
            }

            @Override
            int getElementSize() {
                return 8;
            }

            @Override
            protected int getMemberStorageTypeId() {
                return HDF5Constants.H5T_STD_I64LE;
            }

            @Override
            protected int getMemberNativeTypeId() {
                return -1;
            }

            @Override
            public byte[] byteify(int compoundDataTypeId, Object obj) throws IllegalAccessException {
                Object durationObj = HDF5CompoundByteifyerFactory.getList(obj, index);
                if (durationObj instanceof HDF5TimeDuration) {
                    HDF5TimeDuration duration = (HDF5TimeDuration)durationObj;
                    return HDFNativeData.longToByte(this.timeUnit.convert(duration.getValue(), duration.getUnit()));
                }
                return HDFNativeData.longToByte(((Number)durationObj).longValue());
            }

            @Override
            public void setFromByteArray(int compoundDataTypeId, Object obj, byte[] byteArr, int arrayOffset) throws IllegalAccessException {
                HDF5CompoundByteifyerFactory.setList(obj, index, new HDF5TimeDuration(HDFNativeData.byteToLong(byteArr, arrayOffset + this.offsetInMemory), this.timeUnit));
            }
        };
    }

    private HDF5MemberByteifyer createByteifyerForArray(String memberName, final int index, int offset, int memOffset, HDF5DataTypeVariant typeVariant) {
        return new HDF5MemberByteifyer(null, memberName, 8, offset, memOffset, false, typeVariant, typeVariant){
            final HDF5TimeUnit timeUnit;
            {
                super($anonymous0, $anonymous1, $anonymous2, $anonymous3, $anonymous4, $anonymous5, $anonymous6);
                this.timeUnit = HDF5DataTypeVariant.getTimeUnit(hDF5DataTypeVariant);
            }

            @Override
            int getElementSize() {
                return 8;
            }

            @Override
            protected int getMemberStorageTypeId() {
                return HDF5Constants.H5T_STD_I64LE;
            }

            @Override
            protected int getMemberNativeTypeId() {
                return -1;
            }

            @Override
            public byte[] byteify(int compoundDataTypeId, Object obj) throws IllegalAccessException {
                Object durationObj = HDF5CompoundByteifyerFactory.getArray(obj, index);
                if (durationObj instanceof HDF5TimeDuration) {
                    HDF5TimeDuration duration = (HDF5TimeDuration)durationObj;
                    return HDFNativeData.longToByte(this.timeUnit.convert(duration.getValue(), duration.getUnit()));
                }
                return HDFNativeData.longToByte(((Number)durationObj).longValue());
            }

            @Override
            public void setFromByteArray(int compoundDataTypeId, Object obj, byte[] byteArr, int arrayOffset) throws IllegalAccessException {
                HDF5CompoundByteifyerFactory.setArray(obj, index, new HDF5TimeDuration(HDFNativeData.byteToLong(byteArr, arrayOffset + this.offsetInMemory), this.timeUnit));
            }
        };
    }
}

