/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.Array5D;
import mitiv.array.Byte5D;
import mitiv.array.Double1D;
import mitiv.array.Double4D;
import mitiv.array.DoubleArray;
import mitiv.array.Float5D;
import mitiv.array.Int5D;
import mitiv.array.Long5D;
import mitiv.array.ShapedArray;
import mitiv.array.Short5D;
import mitiv.array.impl.FlatDouble5D;
import mitiv.array.impl.StriddenDouble5D;
import mitiv.base.Shape;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.DoubleFunction;
import mitiv.base.mapping.DoubleScanner;
import mitiv.exception.IllegalTypeException;
import mitiv.exception.NonConformableArrayException;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.random.DoubleGenerator;

public abstract class Double5D
extends Array5D
implements DoubleArray {
    protected Double5D(int n, int n2, int n3, int n4, int n5) {
        super(n, n2, n3, n4, n5);
    }

    protected Double5D(int[] nArray) {
        super(nArray);
    }

    protected Double5D(Shape shape) {
        super(shape);
    }

    @Override
    public final int getType() {
        return 5;
    }

    public abstract double get(int var1, int var2, int var3, int var4, int var5);

    public abstract void set(int var1, int var2, int var3, int var4, int var5, double var6);

    @Override
    public void fill(double d) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                this.set(i, j, k, i2, i3, d);
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim5; ++i) {
                for (int j = 0; j < this.dim4; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i4 = 0; i4 < this.dim2; ++i4) {
                            for (int i5 = 0; i5 < this.dim1; ++i5) {
                                this.set(i5, i4, k, j, i, d);
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void increment(double d) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                this.set(i, j, k, i2, i3, this.get(i, j, k, i2, i3) + d);
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim5; ++i) {
                for (int j = 0; j < this.dim4; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i4 = 0; i4 < this.dim2; ++i4) {
                            for (int i5 = 0; i5 < this.dim1; ++i5) {
                                this.set(i5, i4, k, j, i, this.get(i5, i4, k, j, i) + d);
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void decrement(double d) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                this.set(i, j, k, i2, i3, this.get(i, j, k, i2, i3) - d);
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim5; ++i) {
                for (int j = 0; j < this.dim4; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i4 = 0; i4 < this.dim2; ++i4) {
                            for (int i5 = 0; i5 < this.dim1; ++i5) {
                                this.set(i5, i4, k, j, i, this.get(i5, i4, k, j, i) - d);
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void scale(double d) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                this.set(i, j, k, i2, i3, this.get(i, j, k, i2, i3) * d);
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim5; ++i) {
                for (int j = 0; j < this.dim4; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i4 = 0; i4 < this.dim2; ++i4) {
                            for (int i5 = 0; i5 < this.dim1; ++i5) {
                                this.set(i5, i4, k, j, i, this.get(i5, i4, k, j, i) * d);
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void map(DoubleFunction doubleFunction) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                this.set(i, j, k, i2, i3, doubleFunction.apply(this.get(i, j, k, i2, i3)));
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim5; ++i) {
                for (int j = 0; j < this.dim4; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i4 = 0; i4 < this.dim2; ++i4) {
                            for (int i5 = 0; i5 < this.dim1; ++i5) {
                                this.set(i5, i4, k, j, i, doubleFunction.apply(this.get(i5, i4, k, j, i)));
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void fill(DoubleGenerator doubleGenerator) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                this.set(i, j, k, i2, i3, doubleGenerator.nextDouble());
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim5; ++i) {
                for (int j = 0; j < this.dim4; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i4 = 0; i4 < this.dim2; ++i4) {
                            for (int i5 = 0; i5 < this.dim1; ++i5) {
                                this.set(i5, i4, k, j, i, doubleGenerator.nextDouble());
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void scan(DoubleScanner doubleScanner) {
        boolean bl = false;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                if (bl) {
                                    doubleScanner.update(this.get(i, j, k, i2, i3));
                                    continue;
                                }
                                doubleScanner.initialize(this.get(i, j, k, i2, i3));
                                bl = true;
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim5; ++i) {
                for (int j = 0; j < this.dim4; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i4 = 0; i4 < this.dim2; ++i4) {
                            for (int i5 = 0; i5 < this.dim1; ++i5) {
                                if (bl) {
                                    doubleScanner.update(this.get(i5, i4, k, j, i));
                                    continue;
                                }
                                doubleScanner.initialize(this.get(i5, i4, k, j, i));
                                bl = true;
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public final double[] flatten() {
        return this.flatten(false);
    }

    @Override
    public double min() {
        double d = this.get(0, 0, 0, 0, 0);
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                if (bl) {
                                    bl = false;
                                    continue;
                                }
                                double d2 = this.get(i, j, k, i2, i3);
                                if (!(d2 < d)) continue;
                                d = d2;
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim5; ++i) {
                for (int j = 0; j < this.dim4; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i4 = 0; i4 < this.dim2; ++i4) {
                            for (int i5 = 0; i5 < this.dim1; ++i5) {
                                if (bl) {
                                    bl = false;
                                    continue;
                                }
                                double d3 = this.get(i5, i4, k, j, i);
                                if (!(d3 < d)) continue;
                                d = d3;
                            }
                        }
                    }
                }
            }
        }
        return d;
    }

    @Override
    public double max() {
        double d = this.get(0, 0, 0, 0, 0);
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                if (bl) {
                                    bl = false;
                                    continue;
                                }
                                double d2 = this.get(i, j, k, i2, i3);
                                if (!(d2 > d)) continue;
                                d = d2;
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim5; ++i) {
                for (int j = 0; j < this.dim4; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i4 = 0; i4 < this.dim2; ++i4) {
                            for (int i5 = 0; i5 < this.dim1; ++i5) {
                                if (bl) {
                                    bl = false;
                                    continue;
                                }
                                double d3 = this.get(i5, i4, k, j, i);
                                if (!(d3 > d)) continue;
                                d = d3;
                            }
                        }
                    }
                }
            }
        }
        return d;
    }

    @Override
    public double[] getMinAndMax() {
        double[] dArray = new double[2];
        this.getMinAndMax(dArray);
        return dArray;
    }

    @Override
    public void getMinAndMax(double[] dArray) {
        double d;
        double d2 = d = this.get(0, 0, 0, 0, 0);
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                if (bl) {
                                    bl = false;
                                    continue;
                                }
                                double d3 = this.get(i, j, k, i2, i3);
                                if (d3 < d) {
                                    d = d3;
                                }
                                if (!(d3 > d2)) continue;
                                d2 = d3;
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim5; ++i) {
                for (int j = 0; j < this.dim4; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i4 = 0; i4 < this.dim2; ++i4) {
                            for (int i5 = 0; i5 < this.dim1; ++i5) {
                                if (bl) {
                                    bl = false;
                                    continue;
                                }
                                double d4 = this.get(i5, i4, k, j, i);
                                if (d4 < d) {
                                    d = d4;
                                }
                                if (!(d4 > d2)) continue;
                                d2 = d4;
                            }
                        }
                    }
                }
            }
        }
        dArray[0] = d;
        dArray[1] = d2;
    }

    @Override
    public double sum() {
        double d = 0.0;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                d += this.get(i, j, k, i2, i3);
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim5; ++i) {
                for (int j = 0; j < this.dim4; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i4 = 0; i4 < this.dim2; ++i4) {
                            for (int i5 = 0; i5 < this.dim1; ++i5) {
                                d += this.get(i5, i4, k, j, i);
                            }
                        }
                    }
                }
            }
        }
        return d;
    }

    @Override
    public double average() {
        return this.sum() / (double)this.number;
    }

    @Override
    public Byte5D toByte() {
        byte[] byArray = new byte[this.number];
        if (this.isFlat()) {
            double[] dArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                byArray[i] = (byte)dArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim5; ++i) {
                for (int j = 0; j < this.dim4; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim2; ++i2) {
                            for (int i3 = 0; i3 < this.dim1; ++i3) {
                                byArray[++n] = (byte)this.get(i3, i2, k, j, i);
                            }
                        }
                    }
                }
            }
        }
        return Byte5D.wrap(byArray, this.getShape());
    }

    @Override
    public Short5D toShort() {
        short[] sArray = new short[this.number];
        if (this.isFlat()) {
            double[] dArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                sArray[i] = (short)dArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim5; ++i) {
                for (int j = 0; j < this.dim4; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim2; ++i2) {
                            for (int i3 = 0; i3 < this.dim1; ++i3) {
                                sArray[++n] = (short)this.get(i3, i2, k, j, i);
                            }
                        }
                    }
                }
            }
        }
        return Short5D.wrap(sArray, this.getShape());
    }

    @Override
    public Int5D toInt() {
        int[] nArray = new int[this.number];
        if (this.isFlat()) {
            double[] dArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                nArray[i] = (int)dArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim5; ++i) {
                for (int j = 0; j < this.dim4; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim2; ++i2) {
                            for (int i3 = 0; i3 < this.dim1; ++i3) {
                                nArray[++n] = (int)this.get(i3, i2, k, j, i);
                            }
                        }
                    }
                }
            }
        }
        return Int5D.wrap(nArray, this.getShape());
    }

    @Override
    public Long5D toLong() {
        long[] lArray = new long[this.number];
        if (this.isFlat()) {
            double[] dArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                lArray[i] = (long)dArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim5; ++i) {
                for (int j = 0; j < this.dim4; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim2; ++i2) {
                            for (int i3 = 0; i3 < this.dim1; ++i3) {
                                lArray[++n] = (long)this.get(i3, i2, k, j, i);
                            }
                        }
                    }
                }
            }
        }
        return Long5D.wrap(lArray, this.getShape());
    }

    @Override
    public Float5D toFloat() {
        float[] fArray = new float[this.number];
        if (this.isFlat()) {
            double[] dArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                fArray[i] = (float)dArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim5; ++i) {
                for (int j = 0; j < this.dim4; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim2; ++i2) {
                            for (int i3 = 0; i3 < this.dim1; ++i3) {
                                fArray[++n] = (float)this.get(i3, i2, k, j, i);
                            }
                        }
                    }
                }
            }
        }
        return Float5D.wrap(fArray, this.getShape());
    }

    @Override
    public Double5D toDouble() {
        return this;
    }

    @Override
    public Double5D copy() {
        return new FlatDouble5D(this.flatten(true), this.shape);
    }

    @Override
    public void assign(ShapedArray shapedArray) {
        if (!this.getShape().equals(shapedArray.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        Double5D double5D = shapedArray.getType() == 5 ? (Double5D)shapedArray : (Double5D)shapedArray.toDouble();
        if (this.getOrder() == 2 && double5D.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                this.set(i, j, k, i2, i3, double5D.get(i, j, k, i2, i3));
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim5; ++i) {
                for (int j = 0; j < this.dim4; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i4 = 0; i4 < this.dim2; ++i4) {
                            for (int i5 = 0; i5 < this.dim1; ++i5) {
                                this.set(i5, i4, k, j, i, double5D.get(i5, i4, k, j, i));
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void assign(ShapedVector shapedVector) {
        if (!this.getShape().equals(shapedVector.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        int n = -1;
        if (shapedVector.getType() == 5) {
            DoubleShapedVector doubleShapedVector = (DoubleShapedVector)shapedVector;
            for (int i = 0; i < this.dim5; ++i) {
                for (int j = 0; j < this.dim4; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim2; ++i2) {
                            for (int i3 = 0; i3 < this.dim1; ++i3) {
                                this.set(i3, i2, k, j, i, doubleShapedVector.get(++n));
                            }
                        }
                    }
                }
            }
        } else if (shapedVector.getType() == 4) {
            FloatShapedVector floatShapedVector = (FloatShapedVector)shapedVector;
            for (int i = 0; i < this.dim5; ++i) {
                for (int j = 0; j < this.dim4; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i4 = 0; i4 < this.dim2; ++i4) {
                            for (int i5 = 0; i5 < this.dim1; ++i5) {
                                this.set(i5, i4, k, j, i, floatShapedVector.get(++n));
                            }
                        }
                    }
                }
            }
        } else {
            throw new IllegalTypeException();
        }
    }

    @Override
    public Double5D create() {
        return new FlatDouble5D(this.getShape());
    }

    public static Double5D create(int n, int n2, int n3, int n4, int n5) {
        return new FlatDouble5D(n, n2, n3, n4, n5);
    }

    public static Double5D create(int[] nArray) {
        return new FlatDouble5D(nArray);
    }

    public static Double5D create(Shape shape) {
        return new FlatDouble5D(shape);
    }

    public static Double5D wrap(double[] dArray, int n, int n2, int n3, int n4, int n5) {
        return new FlatDouble5D(dArray, n, n2, n3, n4, n5);
    }

    public static Double5D wrap(double[] dArray, int[] nArray) {
        return new FlatDouble5D(dArray, nArray);
    }

    public static Double5D wrap(double[] dArray, Shape shape) {
        return new FlatDouble5D(dArray, shape);
    }

    public static Double5D wrap(double[] dArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11) {
        return new StriddenDouble5D(dArray, n, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11);
    }

    @Override
    public abstract Double4D slice(int var1);

    @Override
    public abstract Double4D slice(int var1, int var2);

    @Override
    public abstract Double5D view(Range var1, Range var2, Range var3, Range var4, Range var5);

    @Override
    public abstract Double5D view(int[] var1, int[] var2, int[] var3, int[] var4, int[] var5);

    @Override
    public abstract Double1D as1D();
}

