/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfcomplex.impl;

import cern.colt.ConcurrencyUtils;
import cern.colt.matrix.tfcomplex.FComplexMatrix1D;
import cern.colt.matrix.tfcomplex.FComplexMatrix2D;
import cern.colt.matrix.tfcomplex.FComplexMatrix3D;
import cern.colt.matrix.tfcomplex.impl.DelegateFComplexMatrix2D;
import cern.colt.matrix.tfcomplex.impl.DenseFComplexMatrix1D;
import cern.colt.matrix.tfcomplex.impl.DenseLargeFComplexMatrix3D;
import cern.colt.matrix.tfloat.FloatMatrix3D;
import cern.colt.matrix.tfloat.impl.DenseLargeFloatMatrix3D;
import java.util.concurrent.Future;

public class WrapperFComplexMatrix3D
extends FComplexMatrix3D {
    private static final long serialVersionUID = 1L;
    protected FComplexMatrix3D content;

    public WrapperFComplexMatrix3D(FComplexMatrix3D newContent) {
        if (newContent != null) {
            this.setUp(newContent.slices(), newContent.rows(), newContent.columns());
        }
        this.content = newContent;
    }

    @Override
    public Object elements() {
        return this.content.elements();
    }

    public void fft2Slices() {
        if (this.content instanceof DenseLargeFComplexMatrix3D) {
            if (this.isNoView) {
                ((DenseLargeFComplexMatrix3D)this.content).fft2Slices();
            } else {
                DenseLargeFComplexMatrix3D copy = (DenseLargeFComplexMatrix3D)this.copy();
                copy.fft2Slices();
                this.assign(copy);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void fft3() {
        if (this.content instanceof DenseLargeFComplexMatrix3D) {
            if (this.isNoView) {
                ((DenseLargeFComplexMatrix3D)this.content).fft3();
            } else {
                DenseLargeFComplexMatrix3D copy = (DenseLargeFComplexMatrix3D)this.copy();
                copy.fft3();
                this.assign(copy);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void ifft2Slices(boolean scale) {
        if (this.content instanceof DenseLargeFComplexMatrix3D) {
            if (this.isNoView) {
                ((DenseLargeFComplexMatrix3D)this.content).ifft2Slices(scale);
            } else {
                DenseLargeFComplexMatrix3D copy = (DenseLargeFComplexMatrix3D)this.copy();
                copy.ifft2Slices(scale);
                this.assign(copy);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void ifft3(boolean scale) {
        if (this.content instanceof DenseLargeFComplexMatrix3D) {
            if (this.isNoView) {
                ((DenseLargeFComplexMatrix3D)this.content).ifft3(scale);
            } else {
                DenseLargeFComplexMatrix3D copy = (DenseLargeFComplexMatrix3D)this.copy();
                copy.ifft3(scale);
                this.assign(copy);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    @Override
    public synchronized float[] getQuick(int slice, int row, int column) {
        return this.content.getQuick(slice, row, column);
    }

    @Override
    public FComplexMatrix3D like(int slices, int rows, int columns) {
        return this.content.like(slices, rows, columns);
    }

    @Override
    public synchronized void setQuick(int slice, int row, int column, float[] value) {
        this.content.setQuick(slice, row, column, value);
    }

    @Override
    public synchronized void setQuick(int slice, int row, int column, float re, float im) {
        this.content.setQuick(slice, row, column, re, im);
    }

    @Override
    public FComplexMatrix1D vectorize() {
        DenseFComplexMatrix1D v = new DenseFComplexMatrix1D((int)this.size());
        int length = this.rows * this.columns;
        int s = 0;
        while (s < this.slices) {
            v.viewPart(s * length, length).assign(this.viewSlice(s).vectorize());
            ++s;
        }
        return v;
    }

    @Override
    public FComplexMatrix2D viewColumn(int column) {
        this.checkColumn(column);
        return new DelegateFComplexMatrix2D(this, 2, column);
    }

    @Override
    public FComplexMatrix3D viewColumnFlip() {
        if (this.columns == 0) {
            return this;
        }
        WrapperFComplexMatrix3D view = new WrapperFComplexMatrix3D(this){
            private static final long serialVersionUID = 1L;

            @Override
            public synchronized float[] getQuick(int slice, int row, int column) {
                return this.content.getQuick(slice, row, this.columns - 1 - column);
            }

            @Override
            public synchronized void setQuick(int slice, int row, int column, float[] value) {
                this.content.setQuick(slice, row, this.columns - 1 - column, value);
            }

            @Override
            public synchronized void setQuick(int slice, int row, int column, float re, float im) {
                this.content.setQuick(slice, row, this.columns - 1 - column, re, im);
            }

            @Override
            public synchronized float[] get(int slice, int row, int column) {
                return this.content.get(slice, row, this.columns - 1 - column);
            }

            @Override
            public synchronized void set(int slice, int row, int column, float[] value) {
                this.content.set(slice, row, this.columns - 1 - column, value);
            }

            @Override
            public synchronized void set(int slice, int row, int column, float re, float im) {
                this.content.set(slice, row, this.columns - 1 - column, re, im);
            }
        };
        view.isNoView = false;
        return view;
    }

    @Override
    public FComplexMatrix2D viewSlice(int slice) {
        this.checkSlice(slice);
        return new DelegateFComplexMatrix2D(this, 0, slice);
    }

    @Override
    public FComplexMatrix3D viewSliceFlip() {
        if (this.slices == 0) {
            return this;
        }
        WrapperFComplexMatrix3D view = new WrapperFComplexMatrix3D(this){
            private static final long serialVersionUID = 1L;

            @Override
            public synchronized float[] getQuick(int slice, int row, int column) {
                return this.content.getQuick(this.slices - 1 - slice, row, column);
            }

            @Override
            public synchronized void setQuick(int slice, int row, int column, float[] value) {
                this.content.setQuick(this.slices - 1 - slice, row, column, value);
            }

            @Override
            public synchronized void setQuick(int slice, int row, int column, float re, float im) {
                this.content.setQuick(this.slices - 1 - slice, row, column, re, im);
            }

            @Override
            public synchronized float[] get(int slice, int row, int column) {
                return this.content.get(this.slices - 1 - slice, row, column);
            }

            @Override
            public synchronized void set(int slice, int row, int column, float[] value) {
                this.content.set(this.slices - 1 - slice, row, column, value);
            }

            @Override
            public synchronized void set(int slice, int row, int column, float re, float im) {
                this.content.set(this.slices - 1 - slice, row, column, re, im);
            }
        };
        view.isNoView = false;
        return view;
    }

    @Override
    public FComplexMatrix3D viewDice(int axis0, int axis1, int axis2) {
        int d = 3;
        if (axis0 < 0 || axis0 >= d || axis1 < 0 || axis1 >= d || axis2 < 0 || axis2 >= d || axis0 == axis1 || axis0 == axis2 || axis1 == axis2) {
            throw new IllegalArgumentException("Illegal Axes: " + axis0 + ", " + axis1 + ", " + axis2);
        }
        WrapperFComplexMatrix3D view = null;
        if (axis0 == 0 && axis1 == 1 && axis2 == 2) {
            view = new WrapperFComplexMatrix3D(this);
        } else if (axis0 == 1 && axis1 == 0 && axis2 == 2) {
            view = new WrapperFComplexMatrix3D(this){
                private static final long serialVersionUID = 1L;

                @Override
                public synchronized float[] getQuick(int slice, int row, int column) {
                    return this.content.getQuick(row, slice, column);
                }

                @Override
                public synchronized void setQuick(int slice, int row, int column, float[] value) {
                    this.content.setQuick(row, slice, column, value);
                }

                @Override
                public synchronized void setQuick(int slice, int row, int column, float re, float im) {
                    this.content.setQuick(row, slice, column, re, im);
                }

                @Override
                public synchronized float[] get(int slice, int row, int column) {
                    return this.content.get(row, slice, column);
                }

                @Override
                public synchronized void set(int slice, int row, int column, float[] value) {
                    this.content.set(row, slice, column, value);
                }

                @Override
                public synchronized void set(int slice, int row, int column, float re, float im) {
                    this.content.set(row, slice, column, re, im);
                }
            };
        } else if (axis0 == 1 && axis1 == 2 && axis2 == 0) {
            view = new WrapperFComplexMatrix3D(this){
                private static final long serialVersionUID = 1L;

                @Override
                public synchronized float[] getQuick(int slice, int row, int column) {
                    return this.content.getQuick(row, column, slice);
                }

                @Override
                public synchronized void setQuick(int slice, int row, int column, float[] value) {
                    this.content.setQuick(row, column, slice, value);
                }

                @Override
                public synchronized void setQuick(int slice, int row, int column, float re, float im) {
                    this.content.setQuick(row, column, slice, re, im);
                }

                @Override
                public synchronized float[] get(int slice, int row, int column) {
                    return this.content.get(row, column, slice);
                }

                @Override
                public synchronized void set(int slice, int row, int column, float[] value) {
                    this.content.set(row, column, slice, value);
                }

                @Override
                public synchronized void set(int slice, int row, int column, float re, float im) {
                    this.content.set(row, column, slice, re, im);
                }
            };
        } else if (axis0 == 2 && axis1 == 1 && axis2 == 0) {
            view = new WrapperFComplexMatrix3D(this){
                private static final long serialVersionUID = 1L;

                @Override
                public synchronized float[] getQuick(int slice, int row, int column) {
                    return this.content.getQuick(column, row, slice);
                }

                @Override
                public synchronized void setQuick(int slice, int row, int column, float[] value) {
                    this.content.setQuick(column, row, slice, value);
                }

                @Override
                public synchronized void setQuick(int slice, int row, int column, float re, float im) {
                    this.content.setQuick(column, row, slice, re, im);
                }

                @Override
                public synchronized float[] get(int slice, int row, int column) {
                    return this.content.get(column, row, slice);
                }

                @Override
                public synchronized void set(int slice, int row, int column, float[] value) {
                    this.content.set(column, row, slice, value);
                }

                @Override
                public synchronized void set(int slice, int row, int column, float re, float im) {
                    this.content.set(column, row, slice, re, im);
                }
            };
        } else if (axis0 == 2 && axis1 == 0 && axis2 == 1) {
            view = new WrapperFComplexMatrix3D(this){
                private static final long serialVersionUID = 1L;

                @Override
                public synchronized float[] getQuick(int slice, int row, int column) {
                    return this.content.getQuick(column, slice, row);
                }

                @Override
                public synchronized void setQuick(int slice, int row, int column, float[] value) {
                    this.content.setQuick(column, slice, row, value);
                }

                @Override
                public synchronized void setQuick(int slice, int row, int column, float re, float im) {
                    this.content.setQuick(column, slice, row, re, im);
                }

                @Override
                public synchronized float[] get(int slice, int row, int column) {
                    return this.content.get(column, slice, row);
                }

                @Override
                public synchronized void set(int slice, int row, int column, float[] value) {
                    this.content.set(column, slice, row, value);
                }

                @Override
                public synchronized void set(int slice, int row, int column, float re, float im) {
                    this.content.set(column, slice, row, re, im);
                }
            };
        }
        int[] shape = this.shape();
        view.slices = shape[axis0];
        view.rows = shape[axis1];
        view.columns = shape[axis2];
        view.isNoView = false;
        return view;
    }

    @Override
    public FComplexMatrix3D viewPart(final int slice, final int row, final int column, int depth, int height, int width) {
        this.checkBox(slice, row, column, depth, height, width);
        WrapperFComplexMatrix3D view = new WrapperFComplexMatrix3D(this){
            private static final long serialVersionUID = 1L;

            @Override
            public synchronized float[] getQuick(int i, int j, int k) {
                return this.content.getQuick(slice + i, row + j, column + k);
            }

            @Override
            public synchronized void setQuick(int i, int j, int k, float[] value) {
                this.content.setQuick(slice + i, row + j, column + k, value);
            }

            @Override
            public synchronized void setQuick(int i, int j, int k, float re, float im) {
                this.content.setQuick(slice + i, row + j, column + k, re, im);
            }

            @Override
            public synchronized float[] get(int i, int j, int k) {
                return this.content.get(slice + i, row + j, column + k);
            }

            @Override
            public synchronized void set(int i, int j, int k, float[] value) {
                this.content.set(slice + i, row + j, column + k, value);
            }

            @Override
            public synchronized void set(int i, int j, int k, float re, float im) {
                this.content.set(slice + i, row + j, column + k, re, im);
            }
        };
        view.slices = depth;
        view.rows = height;
        view.columns = width;
        view.isNoView = false;
        return view;
    }

    @Override
    public FComplexMatrix2D viewRow(int row) {
        this.checkRow(row);
        return new DelegateFComplexMatrix2D(this, 1, row);
    }

    @Override
    public FComplexMatrix3D viewRowFlip() {
        if (this.rows == 0) {
            return this;
        }
        WrapperFComplexMatrix3D view = new WrapperFComplexMatrix3D(this){
            private static final long serialVersionUID = 1L;

            @Override
            public synchronized float[] getQuick(int slice, int row, int column) {
                return this.content.getQuick(slice, this.rows - 1 - row, column);
            }

            @Override
            public synchronized void setQuick(int slice, int row, int column, float[] value) {
                this.content.setQuick(slice, this.rows - 1 - row, column, value);
            }

            @Override
            public synchronized void setQuick(int slice, int row, int column, float re, float im) {
                this.content.setQuick(slice, this.rows - 1 - row, column, re, im);
            }

            @Override
            public synchronized float[] get(int slice, int row, int column) {
                return this.content.get(slice, this.rows - 1 - row, column);
            }

            @Override
            public synchronized void set(int slice, int row, int column, float[] value) {
                this.content.set(slice, this.rows - 1 - row, column, value);
            }

            @Override
            public synchronized void set(int slice, int row, int column, float re, float im) {
                this.content.set(slice, this.rows - 1 - row, column, re, im);
            }
        };
        view.isNoView = false;
        return view;
    }

    @Override
    public FComplexMatrix3D viewSelection(int[] sliceIndexes, int[] rowIndexes, int[] columnIndexes) {
        int i;
        if (sliceIndexes == null) {
            sliceIndexes = new int[this.slices];
            i = this.slices;
            while (--i >= 0) {
                sliceIndexes[i] = i;
            }
        }
        if (rowIndexes == null) {
            rowIndexes = new int[this.rows];
            i = this.rows;
            while (--i >= 0) {
                rowIndexes[i] = i;
            }
        }
        if (columnIndexes == null) {
            columnIndexes = new int[this.columns];
            i = this.columns;
            while (--i >= 0) {
                columnIndexes[i] = i;
            }
        }
        this.checkSliceIndexes(sliceIndexes);
        this.checkRowIndexes(rowIndexes);
        this.checkColumnIndexes(columnIndexes);
        final int[] six = sliceIndexes;
        final int[] rix = rowIndexes;
        final int[] cix = columnIndexes;
        WrapperFComplexMatrix3D view = new WrapperFComplexMatrix3D(this){
            private static final long serialVersionUID = 1L;

            @Override
            public synchronized float[] getQuick(int i, int j, int k) {
                return this.content.getQuick(six[i], rix[j], cix[k]);
            }

            @Override
            public synchronized void setQuick(int i, int j, int k, float[] value) {
                this.content.setQuick(six[i], rix[j], cix[k], value);
            }

            @Override
            public synchronized void setQuick(int i, int j, int k, float re, float im) {
                this.content.setQuick(six[i], rix[j], cix[k], re, im);
            }

            @Override
            public synchronized float[] get(int i, int j, int k) {
                return this.content.get(six[i], rix[j], cix[k]);
            }

            @Override
            public synchronized void set(int i, int j, int k, float[] value) {
                this.content.set(six[i], rix[j], cix[k], value);
            }

            @Override
            public synchronized void set(int i, int j, int k, float re, float im) {
                this.content.set(six[i], rix[j], cix[k], re, im);
            }
        };
        view.slices = sliceIndexes.length;
        view.rows = rowIndexes.length;
        view.columns = columnIndexes.length;
        view.isNoView = false;
        return view;
    }

    @Override
    public FComplexMatrix3D viewStrides(final int _sliceStride, final int _rowStride, final int _columnStride) {
        if (_sliceStride <= 0 || _rowStride <= 0 || _columnStride <= 0) {
            throw new IndexOutOfBoundsException("illegal stride");
        }
        WrapperFComplexMatrix3D view = new WrapperFComplexMatrix3D(this){
            private static final long serialVersionUID = 1L;

            @Override
            public synchronized float[] getQuick(int slice, int row, int column) {
                return this.content.getQuick(_sliceStride * slice, _rowStride * row, _columnStride * column);
            }

            @Override
            public synchronized void setQuick(int slice, int row, int column, float[] value) {
                this.content.setQuick(_sliceStride * slice, _rowStride * row, _columnStride * column, value);
            }

            @Override
            public synchronized void setQuick(int slice, int row, int column, float re, float im) {
                this.content.setQuick(_sliceStride * slice, _rowStride * row, _columnStride * column, re, im);
            }

            @Override
            public synchronized float[] get(int slice, int row, int column) {
                return this.content.get(_sliceStride * slice, _rowStride * row, _columnStride * column);
            }

            @Override
            public synchronized void set(int slice, int row, int column, float[] value) {
                this.content.set(_sliceStride * slice, _rowStride * row, _columnStride * column, value);
            }

            @Override
            public synchronized void set(int slice, int row, int column, float re, float im) {
                this.content.set(_sliceStride * slice, _rowStride * row, _columnStride * column, re, im);
            }
        };
        if (this.slices != 0) {
            view.slices = (this.slices - 1) / _sliceStride + 1;
        }
        if (this.rows != 0) {
            view.rows = (this.rows - 1) / _rowStride + 1;
        }
        if (this.columns != 0) {
            view.columns = (this.columns - 1) / _columnStride + 1;
        }
        view.isNoView = false;
        return view;
    }

    @Override
    protected FComplexMatrix3D getContent() {
        return this.content;
    }

    @Override
    public FComplexMatrix2D like2D(int rows, int columns) {
        throw new InternalError();
    }

    @Override
    protected FComplexMatrix2D like2D(int rows, int columns, int rowZero, int columnZero, int rowStride, int columnStride) {
        throw new InternalError();
    }

    @Override
    protected FComplexMatrix3D viewSelectionLike(int[] sliceOffsets, int[] rowOffsets, int[] columnOffsets) {
        throw new InternalError();
    }

    @Override
    public FloatMatrix3D getImaginaryPart() {
        final DenseLargeFloatMatrix3D Im = new DenseLargeFloatMatrix3D(this.slices, this.rows, this.columns);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < WrapperFComplexMatrix3D.this.rows) {
                                int c = 0;
                                while (c < WrapperFComplexMatrix3D.this.columns) {
                                    Im.setQuick(s, r, c, WrapperFComplexMatrix3D.this.getQuick(s, r, c)[1]);
                                    ++c;
                                }
                                ++r;
                            }
                            ++s;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int c = 0;
                    while (c < this.columns) {
                        Im.setQuick(s, r, c, this.getQuick(s, r, c)[1]);
                        ++c;
                    }
                    ++r;
                }
                ++s;
            }
        }
        return Im;
    }

    @Override
    public FloatMatrix3D getRealPart() {
        final DenseLargeFloatMatrix3D Re = new DenseLargeFloatMatrix3D(this.slices, this.rows, this.columns);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < WrapperFComplexMatrix3D.this.rows) {
                                int c = 0;
                                while (c < WrapperFComplexMatrix3D.this.columns) {
                                    Re.setQuick(s, r, c, WrapperFComplexMatrix3D.this.getQuick(s, r, c)[0]);
                                    ++c;
                                }
                                ++r;
                            }
                            ++s;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int c = 0;
                    while (c < this.columns) {
                        Re.setQuick(s, r, c, this.getQuick(s, r, c)[0]);
                        ++c;
                    }
                    ++r;
                }
                ++s;
            }
        }
        return Re;
    }
}

