/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array.impl;

import mitiv.array.Double1D;
import mitiv.array.DoubleScalar;
import mitiv.array.impl.Helper;
import mitiv.array.impl.SelectedDouble1D;
import mitiv.base.indexing.CompiledRange;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.DoubleFunction;
import mitiv.base.mapping.DoubleScanner;
import mitiv.random.DoubleGenerator;

public class StriddenDouble1D
extends Double1D {
    final int order;
    final double[] data;
    final int offset;
    final int stride1;
    final boolean flat;

    public StriddenDouble1D(double[] dArray, int n, int[] nArray, int[] nArray2) {
        super(nArray2);
        if (nArray.length != 1) {
            throw new IllegalArgumentException("There must be as many strides as the rank");
        }
        this.data = dArray;
        this.offset = n;
        this.stride1 = nArray[0];
        this.order = Double1D.checkViewStrides(this.data.length, n, this.stride1, this.dim1);
        this.flat = n == 0 && this.stride1 == 1;
    }

    public StriddenDouble1D(double[] dArray, int n, int n2, int n3) {
        super(n3);
        this.data = dArray;
        this.offset = n;
        this.stride1 = n2;
        this.order = Double1D.checkViewStrides(this.data.length, n, n2, n3);
        this.flat = n == 0 && n2 == 1;
    }

    @Override
    public void checkSanity() {
        Double1D.checkViewStrides(this.data.length, this.offset, this.stride1, this.dim1);
    }

    final int index(int n) {
        return this.offset + this.stride1 * n;
    }

    @Override
    public final double get(int n) {
        return this.data[this.offset + this.stride1 * n];
    }

    @Override
    public final void set(int n, double d) {
        this.data[this.offset + this.stride1 * n] = d;
    }

    @Override
    public final int getOrder() {
        return this.order;
    }

    @Override
    public void fill(double d) {
        for (int i = 0; i < this.dim1; ++i) {
            int n = this.stride1 * i + this.offset;
            this.data[n] = d;
        }
    }

    @Override
    public void fill(DoubleGenerator doubleGenerator) {
        for (int i = 0; i < this.dim1; ++i) {
            int n = this.stride1 * i + this.offset;
            this.data[n] = doubleGenerator.nextDouble();
        }
    }

    @Override
    public void increment(double d) {
        for (int i = 0; i < this.dim1; ++i) {
            int n;
            int n2 = n = this.stride1 * i + this.offset;
            this.data[n2] = this.data[n2] + d;
        }
    }

    @Override
    public void decrement(double d) {
        for (int i = 0; i < this.dim1; ++i) {
            int n;
            int n2 = n = this.stride1 * i + this.offset;
            this.data[n2] = this.data[n2] - d;
        }
    }

    @Override
    public void scale(double d) {
        for (int i = 0; i < this.dim1; ++i) {
            int n;
            int n2 = n = this.stride1 * i + this.offset;
            this.data[n2] = this.data[n2] * d;
        }
    }

    @Override
    public void map(DoubleFunction doubleFunction) {
        for (int i = 0; i < this.dim1; ++i) {
            int n = this.stride1 * i + this.offset;
            this.data[n] = doubleFunction.apply(this.data[n]);
        }
    }

    @Override
    public void scan(DoubleScanner doubleScanner) {
        boolean bl = false;
        for (int i = 0; i < this.dim1; ++i) {
            int n = this.stride1 * i + this.offset;
            if (bl) {
                doubleScanner.update(this.data[n]);
                continue;
            }
            doubleScanner.initialize(this.data[n]);
            bl = true;
        }
    }

    @Override
    public final boolean isFlat() {
        return this.flat;
    }

    @Override
    public double[] flatten(boolean bl) {
        if (!bl && this.flat) {
            return this.data;
        }
        double[] dArray = new double[this.number];
        if (this.flat) {
            System.arraycopy(this.data, 0, dArray, 0, this.number);
        } else {
            int n = -1;
            for (int i = 0; i < this.dim1; ++i) {
                int n2 = this.stride1 * i + this.offset;
                dArray[++n] = this.data[n2];
            }
        }
        return dArray;
    }

    @Override
    public double[] getData() {
        return this.flat ? this.data : null;
    }

    @Override
    public DoubleScalar slice(int n) {
        return new DoubleScalar(this.data, this.offset + this.stride1 * n);
    }

    @Override
    public DoubleScalar slice(int n, int n2) {
        if (n2 < 0) {
            ++n2;
        }
        if (n2 != 0) {
            throw new IndexOutOfBoundsException("Dimension index out of bounds");
        }
        int n3 = this.offset + this.stride1 * n;
        return new DoubleScalar(this.data, n3);
    }

    @Override
    public Double1D view(Range range) {
        CompiledRange compiledRange = new CompiledRange(range, this.dim1, this.offset, this.stride1);
        if (compiledRange.doesNothing()) {
            return this;
        }
        return new StriddenDouble1D(this.data, compiledRange.getOffset(), compiledRange.getStride(), compiledRange.getNumber());
    }

    @Override
    public Double1D view(int[] nArray) {
        int[] nArray2 = Helper.select(this.offset, this.stride1, this.dim1, nArray);
        return new SelectedDouble1D(this.data, nArray2);
    }

    @Override
    public Double1D as1D() {
        return this;
    }
}

