/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.openal.sound3d;

import com.jogamp.openal.AL;
import com.jogamp.openal.ALC;
import com.jogamp.openal.ALCcontext;
import com.jogamp.openal.ALCdevice;
import com.jogamp.openal.ALException;
import com.jogamp.openal.ALFactory;
import com.jogamp.openal.UnsupportedAudioFileException;
import com.jogamp.openal.sound3d.Buffer;
import com.jogamp.openal.sound3d.Context;
import com.jogamp.openal.sound3d.Device;
import com.jogamp.openal.sound3d.Listener;
import com.jogamp.openal.sound3d.Source;
import com.jogamp.openal.util.WAVData;
import com.jogamp.openal.util.WAVLoader;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public class AudioSystem3D {
    private static AL al;
    private static ALC alc;
    private static Listener listener;

    public static void init() throws ALException {
        al = ALFactory.getAL();
        alc = ALFactory.getALC();
    }

    public static Context createContext(Device device) {
        Context context = null;
        ALCcontext aLCcontext = alc.alcCreateContext(device.realDevice, null);
        context = new Context(alc, aLCcontext, device);
        return context;
    }

    public static void makeContextCurrent(Context context) {
        ALCcontext aLCcontext = null;
        if (context != null) {
            aLCcontext = context.realContext;
        }
        alc.alcMakeContextCurrent(aLCcontext);
    }

    public static Device openDevice(String string) {
        Device device = null;
        ALCdevice aLCdevice = alc.alcOpenDevice(string);
        device = new Device(alc, aLCdevice);
        return device;
    }

    public static Buffer[] generateBuffers(int n) {
        Buffer[] bufferArray = new Buffer[n];
        int[] nArray = new int[n];
        al.alGenBuffers(n, nArray, 0);
        for (int i = 0; i < n; ++i) {
            bufferArray[i] = new Buffer(al, nArray[i]);
        }
        return bufferArray;
    }

    public static Buffer loadBuffer(String string) throws IOException, UnsupportedAudioFileException {
        Buffer[] bufferArray = AudioSystem3D.generateBuffers(1);
        Buffer buffer = bufferArray[0];
        WAVData wAVData = WAVLoader.loadFromFile(string);
        buffer.configure(wAVData.data, wAVData.format, wAVData.freq);
        return buffer;
    }

    public static Buffer loadBuffer(InputStream inputStream) throws IOException, UnsupportedAudioFileException {
        Buffer[] bufferArray = AudioSystem3D.generateBuffers(1);
        Buffer buffer = bufferArray[0];
        if (!(inputStream instanceof BufferedInputStream)) {
            inputStream = new BufferedInputStream(inputStream);
        }
        WAVData wAVData = WAVLoader.loadFromStream(inputStream);
        buffer.configure(wAVData.data, wAVData.format, wAVData.freq);
        return buffer;
    }

    public static Source loadSource(String string) throws IOException, UnsupportedAudioFileException {
        Buffer buffer = AudioSystem3D.loadBuffer(string);
        return AudioSystem3D.generateSource(buffer);
    }

    public static Source loadSource(InputStream inputStream) throws IOException, UnsupportedAudioFileException {
        Buffer buffer = AudioSystem3D.loadBuffer(inputStream);
        return AudioSystem3D.generateSource(buffer);
    }

    public static Source[] generateSources(int n) {
        Source[] sourceArray = new Source[n];
        int[] nArray = new int[n];
        al.alGenSources(n, nArray, 0);
        for (int i = 0; i < n; ++i) {
            sourceArray[i] = new Source(al, nArray[i]);
        }
        return sourceArray;
    }

    public static Source generateSource(Buffer buffer) {
        Source source = null;
        Source[] sourceArray = AudioSystem3D.generateSources(1);
        source = sourceArray[0];
        source.setBuffer(buffer);
        return source;
    }

    public static Listener getListener() {
        if (listener == null) {
            listener = new Listener(al);
        }
        return listener;
    }
}

