/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array.impl;

import mitiv.array.Short1D;
import mitiv.array.Short2D;
import mitiv.array.Short3D;
import mitiv.array.impl.FlatShort1D;
import mitiv.array.impl.FlatShort2D;
import mitiv.array.impl.Helper;
import mitiv.array.impl.SelectedShort3D;
import mitiv.array.impl.StriddenShort2D;
import mitiv.array.impl.StriddenShort3D;
import mitiv.base.Shape;
import mitiv.base.indexing.CompiledRange;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.ShortFunction;
import mitiv.base.mapping.ShortScanner;
import mitiv.exception.NonConformableArrayException;
import mitiv.random.ShortGenerator;

public class FlatShort3D
extends Short3D {
    static final int order = 1;
    final short[] data;
    final int dim1dim2;

    public FlatShort3D(int n, int n2, int n3) {
        super(n, n2, n3);
        this.data = new short[this.number];
        this.dim1dim2 = n * n2;
    }

    public FlatShort3D(int[] nArray) {
        super(nArray);
        this.data = new short[this.number];
        this.dim1dim2 = this.dim1 * this.dim2;
    }

    public FlatShort3D(Shape shape) {
        super(shape);
        this.data = new short[this.number];
        this.dim1dim2 = this.dim1 * this.dim2;
    }

    public FlatShort3D(short[] sArray, int n, int n2, int n3) {
        super(n, n2, n3);
        this.checkSize(sArray);
        this.data = sArray;
        this.dim1dim2 = n * n2;
    }

    public FlatShort3D(short[] sArray, int[] nArray) {
        super(nArray);
        this.checkSize(sArray);
        this.data = sArray;
        this.dim1dim2 = this.dim1 * this.dim2;
    }

    public FlatShort3D(short[] sArray, Shape shape) {
        super(shape);
        this.checkSize(sArray);
        this.data = sArray;
        this.dim1dim2 = this.dim1 * this.dim2;
    }

    @Override
    public void checkSanity() {
        if (this.data == null) {
            throw new NonConformableArrayException("Wrapped array is null");
        }
        if (this.data.length < this.number) {
            throw new NonConformableArrayException("Wrapped array is too small");
        }
    }

    private void checkSize(short[] sArray) {
        if (sArray == null || sArray.length < this.number) {
            throw new NonConformableArrayException("Wrapped array is too small");
        }
    }

    final int index(int n, int n2, int n3) {
        return this.dim1dim2 * n3 + this.dim1 * n2 + n;
    }

    @Override
    public final short get(int n, int n2, int n3) {
        return this.data[this.dim1dim2 * n3 + this.dim1 * n2 + n];
    }

    @Override
    public final void set(int n, int n2, int n3, short s) {
        this.data[this.dim1dim2 * n3 + this.dim1 * n2 + n] = s;
    }

    @Override
    public final int getOrder() {
        return 1;
    }

    @Override
    public void fill(short s) {
        for (int i = 0; i < this.number; ++i) {
            this.data[i] = s;
        }
    }

    @Override
    public void fill(ShortGenerator shortGenerator) {
        for (int i = 0; i < this.number; ++i) {
            this.data[i] = shortGenerator.nextShort();
        }
    }

    @Override
    public void increment(short s) {
        int n = 0;
        while (n < this.number) {
            int n2 = n++;
            this.data[n2] = (short)(this.data[n2] + s);
        }
    }

    @Override
    public void decrement(short s) {
        int n = 0;
        while (n < this.number) {
            int n2 = n++;
            this.data[n2] = (short)(this.data[n2] - s);
        }
    }

    @Override
    public void scale(short s) {
        int n = 0;
        while (n < this.number) {
            int n2 = n++;
            this.data[n2] = (short)(this.data[n2] * s);
        }
    }

    @Override
    public void map(ShortFunction shortFunction) {
        for (int i = 0; i < this.number; ++i) {
            this.data[i] = shortFunction.apply(this.data[i]);
        }
    }

    @Override
    public void scan(ShortScanner shortScanner) {
        shortScanner.initialize(this.data[0]);
        for (int i = 1; i < this.number; ++i) {
            shortScanner.update(this.data[i]);
        }
    }

    @Override
    public final boolean isFlat() {
        return true;
    }

    @Override
    public short[] flatten(boolean bl) {
        if (bl) {
            short[] sArray = new short[this.number];
            System.arraycopy(this.data, 0, sArray, 0, this.number);
            return sArray;
        }
        return this.data;
    }

    @Override
    public short[] getData() {
        return this.data;
    }

    @Override
    public Short2D slice(int n) {
        if ((n = Helper.fixIndex(n, this.dim3)) == 0) {
            return new FlatShort2D(this.data, this.dim1, this.dim2);
        }
        return new StriddenShort2D(this.data, this.dim1dim2 * n, 1, this.dim1, this.dim1, this.dim2);
    }

    @Override
    public Short2D slice(int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        if ((n2 = Helper.fixSliceIndex(n2, 3)) == 0) {
            n7 = Helper.fixIndex(n, this.dim1);
            n6 = this.dim1;
            n5 = this.dim1dim2;
            n4 = this.dim2;
            n3 = this.dim3;
        } else if (n2 == 1) {
            n7 = this.dim1 * Helper.fixIndex(n, this.dim2);
            n6 = 1;
            n5 = this.dim1dim2;
            n4 = this.dim1;
            n3 = this.dim3;
        } else {
            n7 = this.dim1dim2 * Helper.fixIndex(n, this.dim3);
            n6 = 1;
            n5 = this.dim1;
            n4 = this.dim1;
            n3 = this.dim2;
        }
        return new StriddenShort2D(this.data, n7, n6, n5, n4, n3);
    }

    @Override
    public Short3D view(Range range, Range range2, Range range3) {
        CompiledRange compiledRange = new CompiledRange(range, this.dim1, 0, 1);
        CompiledRange compiledRange2 = new CompiledRange(range2, this.dim2, 0, this.dim1);
        CompiledRange compiledRange3 = new CompiledRange(range3, this.dim3, 0, this.dim1dim2);
        if (compiledRange.doesNothing() && compiledRange2.doesNothing() && compiledRange3.doesNothing()) {
            return this;
        }
        return new StriddenShort3D(this.data, compiledRange.getOffset() + compiledRange2.getOffset() + compiledRange3.getOffset(), compiledRange.getStride(), compiledRange2.getStride(), compiledRange3.getStride(), compiledRange.getNumber(), compiledRange2.getNumber(), compiledRange3.getNumber());
    }

    @Override
    public Short3D view(int[] nArray, int[] nArray2, int[] nArray3) {
        int[] nArray4 = Helper.select(0, 1, this.dim1, nArray);
        int[] nArray5 = Helper.select(0, this.dim1, this.dim2, nArray2);
        int[] nArray6 = Helper.select(0, this.dim1dim2, this.dim3, nArray3);
        return new SelectedShort3D(this.data, nArray4, nArray5, nArray6);
    }

    @Override
    public Short1D as1D() {
        return new FlatShort1D(this.data, this.number);
    }
}

