/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.Array1D;
import mitiv.array.Byte1D;
import mitiv.array.Double1D;
import mitiv.array.FloatArray;
import mitiv.array.FloatScalar;
import mitiv.array.Int1D;
import mitiv.array.Long1D;
import mitiv.array.ShapedArray;
import mitiv.array.Short1D;
import mitiv.array.impl.FlatFloat1D;
import mitiv.array.impl.StriddenFloat1D;
import mitiv.base.Shape;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.FloatFunction;
import mitiv.base.mapping.FloatScanner;
import mitiv.exception.IllegalTypeException;
import mitiv.exception.NonConformableArrayException;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.random.FloatGenerator;

public abstract class Float1D
extends Array1D
implements FloatArray {
    protected Float1D(int n) {
        super(n);
    }

    protected Float1D(int[] nArray) {
        super(nArray);
    }

    protected Float1D(Shape shape) {
        super(shape);
    }

    @Override
    public final int getType() {
        return 4;
    }

    public abstract float get(int var1);

    public abstract void set(int var1, float var2);

    @Override
    public void fill(float f) {
        for (int i = 0; i < this.dim1; ++i) {
            this.set(i, f);
        }
    }

    @Override
    public void increment(float f) {
        for (int i = 0; i < this.dim1; ++i) {
            this.set(i, this.get(i) + f);
        }
    }

    @Override
    public void decrement(float f) {
        for (int i = 0; i < this.dim1; ++i) {
            this.set(i, this.get(i) - f);
        }
    }

    @Override
    public void scale(float f) {
        for (int i = 0; i < this.dim1; ++i) {
            this.set(i, this.get(i) * f);
        }
    }

    @Override
    public void map(FloatFunction floatFunction) {
        for (int i = 0; i < this.dim1; ++i) {
            this.set(i, floatFunction.apply(this.get(i)));
        }
    }

    @Override
    public void fill(FloatGenerator floatGenerator) {
        for (int i = 0; i < this.dim1; ++i) {
            this.set(i, floatGenerator.nextFloat());
        }
    }

    @Override
    public void scan(FloatScanner floatScanner) {
        floatScanner.initialize(this.get(0));
        for (int i = 1; i < this.dim1; ++i) {
            floatScanner.update(this.get(i));
        }
    }

    @Override
    public final float[] flatten() {
        return this.flatten(false);
    }

    @Override
    public float min() {
        float f = this.get(0);
        for (int i = 1; i < this.dim1; ++i) {
            float f2 = this.get(i);
            if (!(f2 < f)) continue;
            f = f2;
        }
        return f;
    }

    @Override
    public float max() {
        float f = this.get(0);
        for (int i = 1; i < this.dim1; ++i) {
            float f2 = this.get(i);
            if (!(f2 > f)) continue;
            f = f2;
        }
        return f;
    }

    @Override
    public float[] getMinAndMax() {
        float[] fArray = new float[2];
        this.getMinAndMax(fArray);
        return fArray;
    }

    @Override
    public void getMinAndMax(float[] fArray) {
        float f;
        float f2 = f = this.get(0);
        for (int i = 1; i < this.dim1; ++i) {
            float f3 = this.get(i);
            if (f3 < f) {
                f = f3;
            }
            if (!(f3 > f2)) continue;
            f2 = f3;
        }
        fArray[0] = f;
        fArray[1] = f2;
    }

    @Override
    public float sum() {
        float f = this.get(0);
        for (int i = 1; i < this.dim1; ++i) {
            f += this.get(i);
        }
        return f;
    }

    @Override
    public double average() {
        return (double)this.sum() / (double)this.number;
    }

    @Override
    public Byte1D toByte() {
        byte[] byArray = new byte[this.number];
        if (this.isFlat()) {
            float[] fArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                byArray[i] = (byte)fArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim1; ++i) {
                byArray[++n] = (byte)this.get(i);
            }
        }
        return Byte1D.wrap(byArray, this.getShape());
    }

    @Override
    public Short1D toShort() {
        short[] sArray = new short[this.number];
        if (this.isFlat()) {
            float[] fArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                sArray[i] = (short)fArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim1; ++i) {
                sArray[++n] = (short)this.get(i);
            }
        }
        return Short1D.wrap(sArray, this.getShape());
    }

    @Override
    public Int1D toInt() {
        int[] nArray = new int[this.number];
        if (this.isFlat()) {
            float[] fArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                nArray[i] = (int)fArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim1; ++i) {
                nArray[++n] = (int)this.get(i);
            }
        }
        return Int1D.wrap(nArray, this.getShape());
    }

    @Override
    public Long1D toLong() {
        long[] lArray = new long[this.number];
        if (this.isFlat()) {
            float[] fArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                lArray[i] = (long)fArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim1; ++i) {
                lArray[++n] = (long)this.get(i);
            }
        }
        return Long1D.wrap(lArray, this.getShape());
    }

    @Override
    public Float1D toFloat() {
        return this;
    }

    @Override
    public Double1D toDouble() {
        double[] dArray = new double[this.number];
        if (this.isFlat()) {
            float[] fArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                dArray[i] = fArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim1; ++i) {
                dArray[++n] = this.get(i);
            }
        }
        return Double1D.wrap(dArray, this.getShape());
    }

    @Override
    public Float1D copy() {
        return new FlatFloat1D(this.flatten(true), this.shape);
    }

    @Override
    public void assign(ShapedArray shapedArray) {
        if (!this.getShape().equals(shapedArray.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        Float1D float1D = shapedArray.getType() == 4 ? (Float1D)shapedArray : (Float1D)shapedArray.toFloat();
        for (int i = 0; i < this.dim1; ++i) {
            this.set(i, float1D.get(i));
        }
    }

    @Override
    public void assign(ShapedVector shapedVector) {
        if (!this.getShape().equals(shapedVector.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        if (shapedVector.getType() == 5) {
            DoubleShapedVector doubleShapedVector = (DoubleShapedVector)shapedVector;
            for (int i = 0; i < this.dim1; ++i) {
                this.set(i, (float)doubleShapedVector.get(i));
            }
        } else if (shapedVector.getType() == 4) {
            FloatShapedVector floatShapedVector = (FloatShapedVector)shapedVector;
            for (int i = 0; i < this.dim1; ++i) {
                this.set(i, (float)floatShapedVector.get(i));
            }
        } else {
            throw new IllegalTypeException();
        }
    }

    @Override
    public Float1D create() {
        return new FlatFloat1D(this.getShape());
    }

    public static Float1D create(int n) {
        return new FlatFloat1D(n);
    }

    public static Float1D create(int[] nArray) {
        return new FlatFloat1D(nArray);
    }

    public static Float1D create(Shape shape) {
        return new FlatFloat1D(shape);
    }

    public static Float1D wrap(float[] fArray, int n) {
        return new FlatFloat1D(fArray, n);
    }

    public static Float1D wrap(float[] fArray, int[] nArray) {
        return new FlatFloat1D(fArray, nArray);
    }

    public static Float1D wrap(float[] fArray, Shape shape) {
        return new FlatFloat1D(fArray, shape);
    }

    public static Float1D wrap(float[] fArray, int n, int n2, int n3) {
        return new StriddenFloat1D(fArray, n, n2, n3);
    }

    @Override
    public abstract FloatScalar slice(int var1);

    @Override
    public abstract FloatScalar slice(int var1, int var2);

    @Override
    public abstract Float1D view(Range var1);

    @Override
    public abstract Float1D view(int[] var1);

    @Override
    public abstract Float1D as1D();
}

