/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array.impl;

import mitiv.array.Int1D;
import mitiv.array.IntScalar;
import mitiv.array.impl.Helper;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.IntFunction;
import mitiv.base.mapping.IntScanner;
import mitiv.random.IntGenerator;

public class SelectedInt1D
extends Int1D {
    static final int order = 0;
    final int[] data;
    final int[] idx1;

    public SelectedInt1D(int[] nArray, int[] nArray2) {
        super(nArray2.length);
        this.data = nArray;
        this.idx1 = nArray2;
    }

    @Override
    public final void checkSanity() {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = n = this.idx1[0];
        for (int i = 1; i < this.dim1; ++i) {
            int n5 = this.idx1[i];
            if (n5 < n4) {
                n4 = n5;
            }
            if (n5 <= n) continue;
            n = n5;
        }
        if ((n2 += n4) < 0 || (n3 += n) >= this.data.length) {
            throw new IndexOutOfBoundsException("Selected indices are out of bounds");
        }
    }

    final int index(int n) {
        return this.idx1[n];
    }

    @Override
    public final int get(int n) {
        return this.data[this.idx1[n]];
    }

    @Override
    public final void set(int n, int n2) {
        this.data[this.idx1[n]] = n2;
    }

    @Override
    public final int getOrder() {
        return 0;
    }

    @Override
    public void fill(int n) {
        for (int i = 0; i < this.dim1; ++i) {
            int n2 = this.idx1[i];
            this.data[n2] = n;
        }
    }

    @Override
    public void fill(IntGenerator intGenerator) {
        for (int i = 0; i < this.dim1; ++i) {
            int n = this.idx1[i];
            this.data[n] = intGenerator.nextInt();
        }
    }

    @Override
    public void increment(int n) {
        for (int i = 0; i < this.dim1; ++i) {
            int n2;
            int n3 = n2 = this.idx1[i];
            this.data[n3] = this.data[n3] + n;
        }
    }

    @Override
    public void decrement(int n) {
        for (int i = 0; i < this.dim1; ++i) {
            int n2;
            int n3 = n2 = this.idx1[i];
            this.data[n3] = this.data[n3] - n;
        }
    }

    @Override
    public void scale(int n) {
        for (int i = 0; i < this.dim1; ++i) {
            int n2;
            int n3 = n2 = this.idx1[i];
            this.data[n3] = this.data[n3] * n;
        }
    }

    @Override
    public void map(IntFunction intFunction) {
        for (int i = 0; i < this.dim1; ++i) {
            int n = this.idx1[i];
            this.data[n] = intFunction.apply(this.data[n]);
        }
    }

    @Override
    public void scan(IntScanner intScanner) {
        boolean bl = false;
        for (int i = 0; i < this.dim1; ++i) {
            int n = this.idx1[i];
            if (bl) {
                intScanner.update(this.data[n]);
                continue;
            }
            intScanner.initialize(this.data[n]);
            bl = true;
        }
    }

    @Override
    public final boolean isFlat() {
        return false;
    }

    @Override
    public int[] flatten(boolean bl) {
        int[] nArray = new int[this.number];
        int n = -1;
        for (int i = 0; i < this.dim1; ++i) {
            int n2 = this.idx1[i];
            nArray[++n] = this.data[n2];
        }
        return nArray;
    }

    @Override
    public int[] getData() {
        return null;
    }

    @Override
    public IntScalar slice(int n) {
        return new IntScalar(this.data, this.idx1[Helper.fixIndex(n, this.dim1)]);
    }

    @Override
    public IntScalar slice(int n, int n2) {
        Helper.fixSliceIndex(n2, 1);
        return new IntScalar(this.data, Helper.fixIndex(n, this.dim1));
    }

    @Override
    public Int1D view(Range range) {
        int[] nArray = Helper.select(this.idx1, range);
        if (nArray == this.idx1) {
            return this;
        }
        return new SelectedInt1D(this.data, nArray);
    }

    @Override
    public Int1D view(int[] nArray) {
        int[] nArray2 = Helper.select(this.idx1, nArray);
        if (nArray2 == this.idx1) {
            return this;
        }
        return new SelectedInt1D(this.data, nArray2);
    }

    @Override
    public Int1D as1D() {
        return this;
    }
}

