/*
 * Decompiled with CFR 0.152.
 */
package mitiv.random;

import mitiv.exception.NotImplementedException;
import mitiv.random.DoubleGenerator;
import mitiv.random.FloatGenerator;
import mitiv.random.RandomEngine;

public class NormalDistribution
implements DoubleGenerator,
FloatGenerator {
    public static final double DEFAULT_MEAN = 0.0;
    public static final double DEFAULT_VARIANCE = 1.0;
    protected RandomEngine engine;
    protected double mean;
    protected double variance;
    protected double standardDeviation;
    private double savedValue;
    private boolean haveSavedValue = false;

    public NormalDistribution(double d, double d2) {
        this.engine = RandomEngine.NewDefaultEngine();
        this.setState(d, d2);
    }

    public NormalDistribution(int n, double d, double d2) {
        this.engine = RandomEngine.NewDefaultEngine(n);
        this.setState(d, d2);
    }

    public NormalDistribution(RandomEngine randomEngine, double d, double d2) {
        this.engine = randomEngine;
        this.setState(d, d2);
    }

    public NormalDistribution() {
        this(0.0, 1.0);
    }

    public NormalDistribution(int n) {
        this(n, 0.0, 1.0);
    }

    public NormalDistribution(RandomEngine randomEngine) {
        this(randomEngine, 0.0, 1.0);
    }

    public void reset(int n) {
        this.haveSavedValue = false;
        this.engine.reset(n);
    }

    public void setState(double d, double d2) {
        this.mean = d;
        this.variance = d2;
        this.standardDeviation = Math.sqrt(d2);
    }

    @Override
    public double nextDouble() {
        double d;
        double d2;
        double d3;
        if (this.haveSavedValue) {
            this.haveSavedValue = false;
            return this.mean + this.standardDeviation * this.savedValue;
        }
        while ((d3 = (d2 = 2.0 * this.engine.nextDouble() - 1.0) * d2 + (d = 2.0 * this.engine.nextDouble() - 1.0) * d) >= 1.0 || d3 == 0.0) {
        }
        d3 = Math.sqrt(-2.0 * Math.log(d3) / d3);
        this.savedValue = d3 * d;
        this.haveSavedValue = true;
        return this.mean + this.standardDeviation * (d3 * d2);
    }

    @Override
    public float nextFloat() {
        return (float)this.nextDouble();
    }

    public double cdf(double d) {
        throw new NotImplementedException();
    }

    public double pdf(double d) {
        throw new NotImplementedException();
    }
}

