/*
 * Decompiled with CFR 0.152.
 */
package mitiv.linalg;

import mitiv.exception.IncorrectSpaceException;
import mitiv.exception.NotImplementedException;
import mitiv.linalg.LinearEndomorphism;
import mitiv.linalg.Vector;
import mitiv.linalg.VectorSpace;

public class DiagonalOperator
extends LinearEndomorphism {
    protected Vector diag;

    protected DiagonalOperator(VectorSpace vectorSpace) {
        super(vectorSpace);
        this.diag = null;
    }

    public DiagonalOperator(Vector vector) {
        super(vector.space);
        this.diag = vector;
    }

    public Vector getDiagonal() {
        return this.diag;
    }

    public void setDiagonal(Vector vector) {
        if (vector == null || !vector.belongsTo(this.space)) {
            throw new IncorrectSpaceException();
        }
        this.diag = vector;
    }

    @Override
    protected void _apply(Vector vector, Vector vector2, int n) throws IncorrectSpaceException, NotImplementedException {
        if (n != DIRECT && n != ADJOINT) {
            throw new NotImplementedException();
        }
        this.space._multiply(vector, vector2, this.diag);
    }
}

