/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.algo;

import cern.colt.ConcurrencyUtils;
import cern.colt.Timer;
import cern.colt.function.tfloat.FloatFloatFunction;
import cern.colt.list.tfloat.FloatArrayList;
import cern.colt.matrix.tfloat.FloatFactory1D;
import cern.colt.matrix.tfloat.FloatFactory2D;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.FloatMatrix3D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix2D;
import cern.jet.math.tfloat.FloatFunctions;
import cern.jet.random.tfloat.engine.FloatMersenneTwister;
import cern.jet.random.tfloat.engine.FloatRandomEngine;
import cern.jet.random.tfloat.sampling.FloatRandomSampler;
import cern.jet.stat.tfloat.FloatDescriptive;
import hep.aida.tfloat.FloatIHistogram1D;
import hep.aida.tfloat.FloatIHistogram2D;
import hep.aida.tfloat.FloatIHistogram3D;
import hep.aida.tfloat.bin.DynamicFloatBin1D;
import hep.aida.tfloat.bin.FloatBinFunction1D;
import hep.aida.tfloat.ref.FloatHistogram2D;
import hep.aida.tfloat.ref.FloatHistogram3D;
import hep.aida.tfloat.ref.FloatVariableAxis;
import java.util.concurrent.Future;

public class FloatStatistic {
    private static final FloatFunctions F = FloatFunctions.functions;
    public static final VectorVectorFunction EUCLID = new VectorVectorFunction(){

        @Override
        public final float apply(FloatMatrix1D a, FloatMatrix1D b) {
            return (float)Math.sqrt(a.aggregate(b, FloatFunctions.plus, FloatFunctions.chain(FloatFunctions.square, FloatFunctions.minus)));
        }
    };
    public static final VectorVectorFunction BRAY_CURTIS = new VectorVectorFunction(){

        @Override
        public final float apply(FloatMatrix1D a, FloatMatrix1D b) {
            return a.aggregate(b, FloatFunctions.plus, FloatFunctions.chain(FloatFunctions.abs, FloatFunctions.minus)) / a.aggregate(b, FloatFunctions.plus, FloatFunctions.plus);
        }
    };
    public static final VectorVectorFunction CANBERRA = new VectorVectorFunction(){
        FloatFloatFunction fun = new FloatFloatFunction(){

            @Override
            public final float apply(float a, float b) {
                return Math.abs(a - b) / Math.abs(a + b);
            }
        };

        @Override
        public final float apply(FloatMatrix1D a, FloatMatrix1D b) {
            return a.aggregate(b, FloatFunctions.plus, this.fun);
        }
    };
    public static final VectorVectorFunction MAXIMUM = new VectorVectorFunction(){

        @Override
        public final float apply(FloatMatrix1D a, FloatMatrix1D b) {
            return a.aggregate(b, FloatFunctions.max, FloatFunctions.chain(FloatFunctions.abs, FloatFunctions.minus));
        }
    };
    public static final VectorVectorFunction MANHATTAN = new VectorVectorFunction(){

        @Override
        public final float apply(FloatMatrix1D a, FloatMatrix1D b) {
            return a.aggregate(b, FloatFunctions.plus, FloatFunctions.chain(FloatFunctions.abs, FloatFunctions.minus));
        }
    };

    protected FloatStatistic() {
    }

    public static FloatMatrix2D aggregate(FloatMatrix2D matrix, FloatBinFunction1D[] aggr, FloatMatrix2D result) {
        DynamicFloatBin1D bin = new DynamicFloatBin1D();
        float[] elements = new float[matrix.rows()];
        FloatArrayList values = new FloatArrayList(elements);
        int column = matrix.columns();
        while (--column >= 0) {
            matrix.viewColumn(column).toArray(elements);
            bin.clear();
            bin.addAllOf(values);
            int i = aggr.length;
            while (--i >= 0) {
                result.set(i, column, aggr[i].apply(bin));
            }
        }
        return result;
    }

    public static DynamicFloatBin1D bin(FloatMatrix1D vector) {
        DynamicFloatBin1D bin = new DynamicFloatBin1D();
        bin.addAllOf(FloatFactory1D.dense.toList(vector));
        return bin;
    }

    public static FloatMatrix2D correlation(FloatMatrix2D covariance) {
        int i = covariance.columns();
        while (--i >= 0) {
            int j = i;
            while (--j >= 0) {
                float stdDev1 = (float)Math.sqrt(covariance.getQuick(i, i));
                float stdDev2 = (float)Math.sqrt(covariance.getQuick(j, j));
                float cov = covariance.getQuick(i, j);
                float corr = cov / (stdDev1 * stdDev2);
                covariance.setQuick(i, j, corr);
                covariance.setQuick(j, i, corr);
            }
        }
        i = covariance.columns();
        while (--i >= 0) {
            covariance.setQuick(i, i, 1.0f);
        }
        return covariance;
    }

    public static FloatMatrix2D covariance(FloatMatrix2D matrix) {
        int rows = matrix.rows();
        int columns = matrix.columns();
        DenseFloatMatrix2D covariance = new DenseFloatMatrix2D(columns, columns);
        float[] sums = new float[columns];
        FloatMatrix1D[] cols = new FloatMatrix1D[columns];
        int i = columns;
        while (--i >= 0) {
            cols[i] = matrix.viewColumn(i);
            sums[i] = cols[i].zSum();
        }
        i = columns;
        while (--i >= 0) {
            int j = i + 1;
            while (--j >= 0) {
                float sumOfProducts = cols[i].zDotProduct(cols[j]);
                float cov = (sumOfProducts - sums[i] * sums[j] / (float)rows) / (float)rows;
                ((FloatMatrix2D)covariance).setQuick(i, j, cov);
                ((FloatMatrix2D)covariance).setQuick(j, i, cov);
            }
        }
        return covariance;
    }

    public static FloatIHistogram2D cube(FloatMatrix1D x, FloatMatrix1D y, FloatMatrix1D weights) {
        if (x.size() != y.size() || y.size() != weights.size()) {
            throw new IllegalArgumentException("vectors must have same size");
        }
        float epsilon = 1.0E-5f;
        FloatArrayList distinct = new FloatArrayList();
        float[] vals = new float[(int)x.size()];
        FloatArrayList sorted = new FloatArrayList(vals);
        x.toArray(vals);
        sorted.sort();
        FloatDescriptive.frequencies(sorted, distinct, null);
        if (distinct.size() > 0) {
            distinct.add(distinct.get(distinct.size() - 1) + epsilon);
        }
        distinct.trimToSize();
        FloatVariableAxis xaxis = new FloatVariableAxis(distinct.elements());
        y.toArray(vals);
        sorted.sort();
        FloatDescriptive.frequencies(sorted, distinct, null);
        if (distinct.size() > 0) {
            distinct.add(distinct.get(distinct.size() - 1) + epsilon);
        }
        distinct.trimToSize();
        FloatVariableAxis yaxis = new FloatVariableAxis(distinct.elements());
        FloatHistogram2D histo = new FloatHistogram2D("Cube", xaxis, yaxis);
        return FloatStatistic.histogram(histo, x, y, weights);
    }

    public static FloatIHistogram3D cube(FloatMatrix1D x, FloatMatrix1D y, FloatMatrix1D z, FloatMatrix1D weights) {
        if (x.size() != y.size() || x.size() != z.size() || x.size() != weights.size()) {
            throw new IllegalArgumentException("vectors must have same size");
        }
        float epsilon = 1.0E-5f;
        FloatArrayList distinct = new FloatArrayList();
        float[] vals = new float[(int)x.size()];
        FloatArrayList sorted = new FloatArrayList(vals);
        x.toArray(vals);
        sorted.sort();
        FloatDescriptive.frequencies(sorted, distinct, null);
        if (distinct.size() > 0) {
            distinct.add(distinct.get(distinct.size() - 1) + epsilon);
        }
        distinct.trimToSize();
        FloatVariableAxis xaxis = new FloatVariableAxis(distinct.elements());
        y.toArray(vals);
        sorted.sort();
        FloatDescriptive.frequencies(sorted, distinct, null);
        if (distinct.size() > 0) {
            distinct.add(distinct.get(distinct.size() - 1) + epsilon);
        }
        distinct.trimToSize();
        FloatVariableAxis yaxis = new FloatVariableAxis(distinct.elements());
        z.toArray(vals);
        sorted.sort();
        FloatDescriptive.frequencies(sorted, distinct, null);
        if (distinct.size() > 0) {
            distinct.add(distinct.get(distinct.size() - 1) + epsilon);
        }
        distinct.trimToSize();
        FloatVariableAxis zaxis = new FloatVariableAxis(distinct.elements());
        FloatHistogram3D histo = new FloatHistogram3D("Cube", xaxis, yaxis, zaxis);
        return FloatStatistic.histogram(histo, x, y, z, weights);
    }

    public static void demo1() {
        float[][] values = new float[][]{{1.0f, 2.0f, 3.0f}, {2.0f, 4.0f, 6.0f}, {3.0f, 6.0f, 9.0f}, {4.0f, -8.0f, -10.0f}};
        FloatFactory2D factory = FloatFactory2D.dense;
        FloatMatrix2D A = factory.make(values);
        System.out.println("\n\nmatrix=" + A);
        System.out.println("\ncovar1=" + FloatStatistic.covariance(A));
    }

    public static void demo2(int rows, int columns, boolean print) {
        System.out.println("\n\ninitializing...");
        FloatFactory2D factory = FloatFactory2D.dense;
        FloatMatrix2D A = factory.ascending(rows, columns);
        System.out.println("benchmarking correlation...");
        Timer timer = new Timer().start();
        FloatMatrix2D corr = FloatStatistic.correlation(FloatStatistic.covariance(A));
        timer.stop().display();
        if (print) {
            System.out.println("printing result...");
            System.out.println(corr);
        }
        System.out.println("done.");
    }

    public static void demo3(VectorVectorFunction norm) {
        float[][] values = new float[][]{{-0.9611052f, -0.25421095f}, {0.4308269f, -0.69932646f}, {-1.2071029f, 0.62030596f}, {1.5345166f, 0.02135884f}, {-1.1341542f, 0.2038843f}};
        System.out.println("\n\ninitializing...");
        FloatFactory2D factory = FloatFactory2D.dense;
        FloatMatrix2D A = factory.make(values).viewDice();
        System.out.println("\nA=" + A.viewDice());
        System.out.println("\ndist=" + FloatStatistic.distance(A, norm).viewDice());
    }

    public static FloatMatrix2D distance(FloatMatrix2D matrix, VectorVectorFunction distanceFunction) {
        int columns = matrix.columns();
        DenseFloatMatrix2D distance = new DenseFloatMatrix2D(columns, columns);
        FloatMatrix1D[] cols = new FloatMatrix1D[columns];
        int i = columns;
        while (--i >= 0) {
            cols[i] = matrix.viewColumn(i);
        }
        i = columns;
        while (--i >= 0) {
            int j = i;
            while (--j >= 0) {
                float d = distanceFunction.apply(cols[i], cols[j]);
                ((FloatMatrix2D)distance).setQuick(i, j, d);
                ((FloatMatrix2D)distance).setQuick(j, i, d);
            }
        }
        return distance;
    }

    public static FloatIHistogram1D histogram(FloatIHistogram1D histo, FloatMatrix1D vector) {
        int i = (int)vector.size();
        while (--i >= 0) {
            histo.fill(vector.getQuick(i));
        }
        return histo;
    }

    public static FloatIHistogram1D histogram(FloatIHistogram1D histo, FloatMatrix2D matrix) {
        histo.fill_2D((float[])matrix.elements(), matrix.rows(), matrix.columns(), (int)matrix.index(0, 0), matrix.rowStride(), matrix.columnStride());
        return histo;
    }

    public static FloatIHistogram1D[][] histogram(final FloatIHistogram1D[][] histo, final FloatMatrix2D matrix, int m, final int n) {
        int rows = matrix.rows();
        int columns = matrix.columns();
        if (m >= rows) {
            throw new IllegalArgumentException("Parameter m must be smaller than the number of rows in the matrix");
        }
        if (n >= columns) {
            throw new IllegalArgumentException("Parameter n must be smaller than the number of columns in the matrix");
        }
        final int row_size = rows / m;
        final int col_size = columns / n;
        final int[] height = new int[m];
        final int[] width = new int[n];
        int r = 0;
        while (r < m - 1) {
            height[r] = row_size;
            ++r;
        }
        height[m - 1] = rows - (m - 1) * row_size;
        int c = 0;
        while (c < n - 1) {
            width[c] = col_size;
            ++c;
        }
        width[n - 1] = columns - (n - 1) * col_size;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && rows * columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, m);
            Future[] futures = new Future[nthreads];
            int k = m / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? m : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        FloatMatrix2D view = null;
                        int r = firstRow;
                        while (r < lastRow) {
                            int c = 0;
                            while (c < n) {
                                view = matrix.viewPart(r * row_size, c * col_size, height[r], width[c]);
                                histo[r][c].fill_2D((float[])view.elements(), view.rows(), view.columns(), (int)view.index(0, 0), view.rowStride(), view.columnStride());
                                ++c;
                            }
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            FloatMatrix2D view = null;
            int r2 = 0;
            while (r2 < m) {
                int c2 = 0;
                while (c2 < n) {
                    view = matrix.viewPart(r2 * row_size, c2 * col_size, height[r2], width[c2]);
                    histo[r2][c2].fill_2D((float[])view.elements(), view.rows(), view.columns(), (int)view.index(0, 0), view.rowStride(), view.columnStride());
                    ++c2;
                }
                ++r2;
            }
        }
        return histo;
    }

    public static FloatIHistogram2D histogram(FloatIHistogram2D histo, FloatMatrix1D x, FloatMatrix1D y) {
        if (x.size() != y.size()) {
            throw new IllegalArgumentException("vectors must have same size");
        }
        int i = (int)x.size();
        while (--i >= 0) {
            histo.fill(x.getQuick(i), y.getQuick(i));
        }
        return histo;
    }

    public static FloatIHistogram2D histogram(FloatIHistogram2D histo, FloatMatrix1D x, FloatMatrix1D y, FloatMatrix1D weights) {
        if (x.size() != y.size() || y.size() != weights.size()) {
            throw new IllegalArgumentException("vectors must have same size");
        }
        int i = (int)x.size();
        while (--i >= 0) {
            histo.fill(x.getQuick(i), y.getQuick(i), weights.getQuick(i));
        }
        return histo;
    }

    public static FloatIHistogram3D histogram(FloatIHistogram3D histo, FloatMatrix1D x, FloatMatrix1D y, FloatMatrix1D z, FloatMatrix1D weights) {
        if (x.size() != y.size() || x.size() != z.size() || x.size() != weights.size()) {
            throw new IllegalArgumentException("vectors must have same size");
        }
        int i = (int)x.size();
        while (--i >= 0) {
            histo.fill(x.getQuick(i), y.getQuick(i), z.getQuick(i), weights.getQuick(i));
        }
        return histo;
    }

    public static void main(String[] args) {
        int rows = Integer.parseInt(args[0]);
        int columns = Integer.parseInt(args[1]);
        boolean print = args[2].equals("print");
        FloatStatistic.demo2(rows, columns, print);
    }

    public static FloatMatrix1D viewSample(FloatMatrix1D matrix, float fraction, FloatRandomEngine randomGenerator) {
        int ncolumns;
        float epsilon = 1.0E-5f;
        if (fraction < 0.0f - epsilon || fraction > 1.0f + epsilon) {
            throw new IllegalArgumentException();
        }
        if (fraction < 0.0f) {
            fraction = 0.0f;
        }
        if (fraction > 1.0f) {
            fraction = 1.0f;
        }
        if (randomGenerator == null) {
            randomGenerator = new FloatMersenneTwister((int)System.currentTimeMillis());
        }
        int max = ncolumns = Math.round((float)matrix.size() * fraction);
        long[] selected = new long[max];
        int n = ncolumns;
        int N = (int)matrix.size();
        FloatRandomSampler.sample(n, N, n, 0L, selected, 0, randomGenerator);
        int[] selectedCols = new int[n];
        int i = 0;
        while (i < n) {
            selectedCols[i] = (int)selected[i];
            ++i;
        }
        return matrix.viewSelection(selectedCols);
    }

    public static FloatMatrix2D viewSample(FloatMatrix2D matrix, float rowFraction, float columnFraction, FloatRandomEngine randomGenerator) {
        float epsilon = 1.0E-5f;
        if (rowFraction < 0.0f - epsilon || rowFraction > 1.0f + epsilon) {
            throw new IllegalArgumentException();
        }
        if (rowFraction < 0.0f) {
            rowFraction = 0.0f;
        }
        if (rowFraction > 1.0f) {
            rowFraction = 1.0f;
        }
        if (columnFraction < 0.0f - epsilon || columnFraction > 1.0f + epsilon) {
            throw new IllegalArgumentException();
        }
        if (columnFraction < 0.0f) {
            columnFraction = 0.0f;
        }
        if (columnFraction > 1.0f) {
            columnFraction = 1.0f;
        }
        if (randomGenerator == null) {
            randomGenerator = new FloatMersenneTwister((int)System.currentTimeMillis());
        }
        int nrows = Math.round((float)matrix.rows() * rowFraction);
        int ncolumns = Math.round((float)matrix.columns() * columnFraction);
        int max = Math.max(nrows, ncolumns);
        long[] selected = new long[max];
        int n = nrows;
        int N = matrix.rows();
        FloatRandomSampler.sample(n, N, n, 0L, selected, 0, randomGenerator);
        int[] selectedRows = new int[n];
        int i = 0;
        while (i < n) {
            selectedRows[i] = (int)selected[i];
            ++i;
        }
        n = ncolumns;
        N = matrix.columns();
        FloatRandomSampler.sample(n, N, n, 0L, selected, 0, randomGenerator);
        int[] selectedCols = new int[n];
        int i2 = 0;
        while (i2 < n) {
            selectedCols[i2] = (int)selected[i2];
            ++i2;
        }
        return matrix.viewSelection(selectedRows, selectedCols);
    }

    public static FloatMatrix3D viewSample(FloatMatrix3D matrix, float sliceFraction, float rowFraction, float columnFraction, FloatRandomEngine randomGenerator) {
        float epsilon = 1.0E-5f;
        if (sliceFraction < 0.0f - epsilon || sliceFraction > 1.0f + epsilon) {
            throw new IllegalArgumentException();
        }
        if (sliceFraction < 0.0f) {
            sliceFraction = 0.0f;
        }
        if (sliceFraction > 1.0f) {
            sliceFraction = 1.0f;
        }
        if (rowFraction < 0.0f - epsilon || rowFraction > 1.0f + epsilon) {
            throw new IllegalArgumentException();
        }
        if (rowFraction < 0.0f) {
            rowFraction = 0.0f;
        }
        if (rowFraction > 1.0f) {
            rowFraction = 1.0f;
        }
        if (columnFraction < 0.0f - epsilon || columnFraction > 1.0f + epsilon) {
            throw new IllegalArgumentException();
        }
        if (columnFraction < 0.0f) {
            columnFraction = 0.0f;
        }
        if (columnFraction > 1.0f) {
            columnFraction = 1.0f;
        }
        if (randomGenerator == null) {
            randomGenerator = new FloatMersenneTwister((int)System.currentTimeMillis());
        }
        int nslices = Math.round((float)matrix.slices() * sliceFraction);
        int nrows = Math.round((float)matrix.rows() * rowFraction);
        int ncolumns = Math.round((float)matrix.columns() * columnFraction);
        int max = Math.max(nslices, Math.max(nrows, ncolumns));
        long[] selected = new long[max];
        int n = nslices;
        int N = matrix.slices();
        FloatRandomSampler.sample(n, N, n, 0L, selected, 0, randomGenerator);
        int[] selectedSlices = new int[n];
        int i = 0;
        while (i < n) {
            selectedSlices[i] = (int)selected[i];
            ++i;
        }
        n = nrows;
        N = matrix.rows();
        FloatRandomSampler.sample(n, N, n, 0L, selected, 0, randomGenerator);
        int[] selectedRows = new int[n];
        int i2 = 0;
        while (i2 < n) {
            selectedRows[i2] = (int)selected[i2];
            ++i2;
        }
        n = ncolumns;
        N = matrix.columns();
        FloatRandomSampler.sample(n, N, n, 0L, selected, 0, randomGenerator);
        int[] selectedCols = new int[n];
        int i3 = 0;
        while (i3 < n) {
            selectedCols[i3] = (int)selected[i3];
            ++i3;
        }
        return matrix.viewSelection(selectedSlices, selectedRows, selectedCols);
    }

    public static interface VectorVectorFunction {
        public float apply(FloatMatrix1D var1, FloatMatrix1D var2);
    }
}

