/*
 * Decompiled with CFR 0.152.
 */
package thredds.filesystem;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import net.jcip.annotations.Immutable;
import thredds.crawlabledataset.CrawlableDataset;
import thredds.crawlabledataset.CrawlableDatasetFilter;
import thredds.inventory.MCollection;
import thredds.inventory.MController;
import thredds.inventory.MFile;
import thredds.inventory.MFileFilter;

@Immutable
public class CrawlableMFile
implements MFile,
CrawlableDataset {
    private final MController controller;
    private final MFile mfile;

    CrawlableMFile(MController controller, MFile mfile) {
        this.controller = controller;
        this.mfile = mfile;
    }

    CrawlableMFile(MController controller, String path) {
        this.controller = controller;
        this.mfile = null;
    }

    @Override
    public long getLastModified() {
        return this.mfile.getLastModified();
    }

    @Override
    public long getLength() {
        return this.mfile.getLength();
    }

    @Override
    public boolean isDirectory() {
        return this.mfile.isDirectory();
    }

    @Override
    public int compareTo(MFile o) {
        return this.mfile.compareTo(o);
    }

    @Override
    public Object getAuxInfo() {
        return this.mfile.getAuxInfo();
    }

    @Override
    public void setAuxInfo(Object info) {
        this.mfile.setAuxInfo(info);
    }

    @Override
    public Object getConfigObject() {
        return null;
    }

    @Override
    public String getPath() {
        return this.mfile.getPath();
    }

    @Override
    public String getName() {
        return this.mfile.getName();
    }

    @Override
    public CrawlableDataset getParentDataset() {
        String path = this.mfile.getPath();
        int pos = path.lastIndexOf("/");
        return new CrawlableMFile(this.controller, path.substring(0, pos));
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public boolean isCollection() {
        return this.mfile.isDirectory();
    }

    @Override
    public CrawlableDataset getDescendant(String relativePath) {
        return new CrawlableMFile(this.controller, this.mfile.getPath() + "/" + relativePath);
    }

    @Override
    public List<CrawlableDataset> listDatasets() throws IOException {
        return this.listDatasets(null);
    }

    @Override
    public List<CrawlableDataset> listDatasets(CrawlableDatasetFilter filter) throws IOException {
        MCollection mc = new MCollection(this.mfile.getPath(), this.mfile.getPath(), false, (MFileFilter)null, null);
        Iterator<MFile> iter = this.controller.getInventoryTop(mc, true);
        ArrayList<CrawlableDataset> result = new ArrayList<CrawlableDataset>();
        while (iter.hasNext()) {
            CrawlableMFile crf = new CrawlableMFile(this.controller, iter.next());
            if (filter != null && !filter.accept(crf)) continue;
            result.add(crf);
        }
        return result;
    }

    @Override
    public long length() {
        return this.getLength();
    }

    @Override
    public Date lastModified() {
        return new Date(this.getLastModified());
    }
}

