/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.algo.solver;

import cern.colt.matrix.Norm;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.algo.DenseDoubleAlgebra;
import cern.colt.matrix.tdouble.algo.solver.DoubleIterationMonitor;
import cern.colt.matrix.tdouble.algo.solver.DoubleIterationReporter;
import cern.colt.matrix.tdouble.algo.solver.IterativeSolverDoubleNotConvergedException;
import cern.colt.matrix.tdouble.algo.solver.NoDoubleIterationReporter;

public abstract class AbstractDoubleIterationMonitor
implements DoubleIterationMonitor {
    protected int iter;
    protected Norm normType = Norm.Two;
    protected DoubleIterationReporter reporter = new NoDoubleIterationReporter();
    protected double residual;

    @Override
    public void setFirst() {
        this.iter = 0;
    }

    @Override
    public boolean isFirst() {
        return this.iter == 0;
    }

    @Override
    public void next() {
        ++this.iter;
    }

    @Override
    public int iterations() {
        return this.iter;
    }

    @Override
    public boolean converged(DoubleMatrix1D r, DoubleMatrix1D x) throws IterativeSolverDoubleNotConvergedException {
        return this.converged(DenseDoubleAlgebra.DEFAULT.norm(r, this.normType), x);
    }

    @Override
    public boolean converged(double r, DoubleMatrix1D x) throws IterativeSolverDoubleNotConvergedException {
        this.reporter.monitor(r, x, this.iter);
        this.residual = r;
        return this.convergedI(r, x);
    }

    @Override
    public boolean converged(double r) throws IterativeSolverDoubleNotConvergedException {
        this.reporter.monitor(r, this.iter);
        this.residual = r;
        return this.convergedI(r);
    }

    protected abstract boolean convergedI(double var1, DoubleMatrix1D var3) throws IterativeSolverDoubleNotConvergedException;

    protected abstract boolean convergedI(double var1) throws IterativeSolverDoubleNotConvergedException;

    @Override
    public boolean converged(DoubleMatrix1D r) throws IterativeSolverDoubleNotConvergedException {
        return this.converged(DenseDoubleAlgebra.DEFAULT.norm(r, this.normType));
    }

    @Override
    public Norm getNormType() {
        return this.normType;
    }

    @Override
    public void setNormType(Norm normType) {
        this.normType = normType;
    }

    @Override
    public DoubleIterationReporter getIterationReporter() {
        return this.reporter;
    }

    @Override
    public void setIterationReporter(DoubleIterationReporter monitor) {
        this.reporter = monitor;
    }

    @Override
    public double residual() {
        return this.residual;
    }
}

