/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.algo.solver.preconditioner;

import cern.colt.matrix.Norm;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.algo.DenseDoubleAlgebra;
import cern.colt.matrix.tdouble.algo.DoubleProperty;
import cern.colt.matrix.tdouble.algo.solver.preconditioner.DoublePreconditioner;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.SparseDoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.SparseRCMDoubleMatrix2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DoubleILUT
implements DoublePreconditioner {
    private SparseRCMDoubleMatrix2D LU;
    private final DoubleMatrix1D y;
    private final double tau;
    private final List<IntDoubleEntry> lower;
    private final List<IntDoubleEntry> upper;
    private final int p;
    private final int n;

    public DoubleILUT(int n, double tau, int p) {
        this.n = n;
        this.tau = tau;
        this.p = p;
        this.lower = new ArrayList<IntDoubleEntry>(n);
        this.upper = new ArrayList<IntDoubleEntry>(n);
        this.y = new DenseDoubleMatrix1D(n);
    }

    public DoubleILUT(int n) {
        this(n, 1.0E-6, 25);
    }

    @Override
    public DoubleMatrix1D apply(DoubleMatrix1D b, DoubleMatrix1D x) {
        if (x == null) {
            x = b.like();
        }
        this.unitLowerSolve(b, this.y);
        return this.upperSolve(this.y, x);
    }

    @Override
    public DoubleMatrix1D transApply(DoubleMatrix1D b, DoubleMatrix1D x) {
        if (x == null) {
            x = b.like();
        }
        this.upperTransSolve(b, this.y);
        return this.unitLowerTransSolve(this.y, x);
    }

    @Override
    public void setMatrix(DoubleMatrix2D A) {
        DoubleProperty.DEFAULT.isSquare(A);
        if (A.rows() != this.n) {
            throw new IllegalArgumentException("A.rows() != n");
        }
        this.LU = new SparseRCMDoubleMatrix2D(this.n, this.n);
        this.LU.assign(A);
        this.LU.trimToSize();
        this.factor();
    }

    private void factor() {
        int n = this.LU.rows();
        int i = 1;
        while (i < n) {
            SparseDoubleMatrix1D rowi = this.LU.viewRow(i);
            double taui = DenseDoubleAlgebra.DEFAULT.norm(rowi, Norm.Two) * this.tau;
            int k = 0;
            while (k < i) {
                SparseDoubleMatrix1D rowk = this.LU.viewRow(k);
                if (rowk.getQuick(k) == 0.0) {
                    throw new RuntimeException("Zero diagonal entry on row " + (k + 1) + " during ILU process");
                }
                double LUik = rowi.getQuick(k) / rowk.getQuick(k);
                if (!(Math.abs(LUik) <= taui)) {
                    int rowUsed = (int)rowk.size();
                    int j = k + 1;
                    while (j < rowUsed) {
                        rowi.setQuick(j, rowi.getQuick(j) - LUik * rowk.getQuick(j));
                        ++j;
                    }
                    rowi.setQuick(k, LUik);
                }
                ++k;
            }
            this.gather(rowi, taui, i);
            ++i;
        }
    }

    private void gather(SparseDoubleMatrix1D v, double taui, int d) {
        IntDoubleEntry e;
        int nl = 0;
        int nu = 0;
        long[] indexes = v.elements().keys().elements();
        int i = 0;
        while (i < indexes.length) {
            if (indexes[i] < (long)d) {
                ++nl;
            } else if (indexes[i] > (long)d) {
                ++nu;
            }
            ++i;
        }
        double[] z = v.toArray();
        v.assign(0.0);
        this.lower.clear();
        int i2 = 0;
        while (i2 < d) {
            if (Math.abs(z[i2]) > taui) {
                this.lower.add(new IntDoubleEntry(i2, z[i2]));
            }
            ++i2;
        }
        this.upper.clear();
        i2 = d + 1;
        while (i2 < z.length) {
            if (Math.abs(z[i2]) > taui) {
                this.upper.add(new IntDoubleEntry(i2, z[i2]));
            }
            ++i2;
        }
        Collections.sort(this.lower);
        Collections.sort(this.upper);
        v.setQuick(d, z[d]);
        i2 = 0;
        while (i2 < Math.min(nl + this.p, this.lower.size())) {
            e = this.lower.get(i2);
            v.setQuick(e.index, e.value);
            ++i2;
        }
        i2 = 0;
        while (i2 < Math.min(nu + this.p, this.upper.size())) {
            e = this.upper.get(i2);
            v.setQuick(e.index, e.value);
            ++i2;
        }
    }

    private DoubleMatrix1D unitLowerSolve(DoubleMatrix1D b, DoubleMatrix1D x) {
        double[] bd = ((DenseDoubleMatrix1D)b).elements();
        double[] xd = ((DenseDoubleMatrix1D)x).elements();
        int rows = this.LU.rows();
        int i = 0;
        while (i < rows) {
            SparseDoubleMatrix1D row = this.LU.viewRow(i);
            double sum = 0.0;
            int j = 0;
            while (j < i) {
                sum += row.getQuick(j) * xd[j];
                ++j;
            }
            xd[i] = bd[i] - sum;
            ++i;
        }
        return x;
    }

    private DoubleMatrix1D unitLowerTransSolve(DoubleMatrix1D b, DoubleMatrix1D x) {
        x.assign(b);
        double[] xd = ((DenseDoubleMatrix1D)x).elements();
        int rows = this.LU.rows();
        int i = rows - 1;
        while (i >= 0) {
            SparseDoubleMatrix1D row = this.LU.viewRow(i);
            int j = 0;
            while (j < i) {
                int n = j;
                xd[n] = xd[n] - row.getQuick(j) * xd[i];
                ++j;
            }
            --i;
        }
        return x;
    }

    private DoubleMatrix1D upperSolve(DoubleMatrix1D b, DoubleMatrix1D x) {
        double[] bd = ((DenseDoubleMatrix1D)b).elements();
        double[] xd = ((DenseDoubleMatrix1D)x).elements();
        int rows = this.LU.rows();
        int i = rows - 1;
        while (i >= 0) {
            SparseDoubleMatrix1D row = this.LU.viewRow(i);
            int used = (int)row.size();
            double sum = 0.0;
            int j = i + 1;
            while (j < used) {
                sum += row.getQuick(j) * xd[j];
                ++j;
            }
            xd[i] = (bd[i] - sum) / row.getQuick(i);
            --i;
        }
        return x;
    }

    private DoubleMatrix1D upperTransSolve(DoubleMatrix1D b, DoubleMatrix1D x) {
        x.assign(b);
        double[] xd = ((DenseDoubleMatrix1D)x).elements();
        int rows = this.LU.rows();
        int i = 0;
        while (i < rows) {
            SparseDoubleMatrix1D row = this.LU.viewRow(i);
            int used = (int)row.size();
            int n = i;
            xd[n] = xd[n] / row.getQuick(i);
            int j = i + 1;
            while (j < used) {
                int n2 = j;
                xd[n2] = xd[n2] - row.getQuick(j) * xd[i];
                ++j;
            }
            ++i;
        }
        return x;
    }

    private static class IntDoubleEntry
    implements Comparable<IntDoubleEntry> {
        public int index;
        public double value;

        public IntDoubleEntry(int index, double value) {
            this.index = index;
            this.value = value;
        }

        @Override
        public int compareTo(IntDoubleEntry o) {
            if (Math.abs(this.value) < Math.abs(o.value)) {
                return 1;
            }
            if (Math.abs(this.value) == Math.abs(o.value)) {
                return 0;
            }
            return -1;
        }

        public String toString() {
            return "(" + this.index + "=" + this.value + ")";
        }
    }
}

