/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.imageio.ImageIO;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.gui.AWTImageTools;
import loci.formats.in.BIFormatReader;
import loci.formats.meta.MetadataStore;

public class MNGReader
extends BIFormatReader {
    public static final long MNG_MAGIC_BYTES = -8481036456200365558L;
    private List<SeriesInfo> seriesInfo;
    private boolean isJNG = false;

    public MNGReader() {
        super("Multiple-image Network Graphics", "mng");
        this.domains = new String[]{"Graphics"};
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 8;
        if (!FormatTools.validStream(stream, 8, false)) {
            return false;
        }
        return stream.readLong() == -8481036456200365558L;
    }

    @Override
    public Object openPlane(int no, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, -1, x, y, w, h);
        SeriesInfo info = this.seriesInfo.get(this.getSeries());
        long offset = info.offsets.get(no);
        this.in.seek(offset);
        long end = info.lengths.get(no);
        BufferedImage img = this.readImage(end);
        return AWTImageTools.getSubimage(img, this.isLittleEndian(), x, y, w, h);
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.seriesInfo = null;
            this.isJNG = false;
        }
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        this.in.order(false);
        LOGGER.info("Verifying MNG format");
        this.seriesInfo = new ArrayList<SeriesInfo>();
        this.seriesInfo.add(new SeriesInfo());
        this.in.skipBytes(12);
        if (!"MHDR".equals(this.in.readString(4))) {
            throw new FormatException("Invalid MNG file.");
        }
        LOGGER.info("Reading dimensions");
        this.in.skipBytes(32);
        ArrayList<Long> stack = new ArrayList<Long>();
        int maxIterations = 0;
        int currentIteration = 0;
        LOGGER.info("Finding image offsets");
        while (this.in.getFilePointer() < this.in.length()) {
            int len = this.in.readInt();
            String code = this.in.readString(4);
            long fp = this.in.getFilePointer();
            if (code.equals("IHDR")) {
                this.seriesInfo.get((int)0).offsets.add(fp - 8L);
            } else if (code.equals("JDAT")) {
                this.isJNG = true;
                this.seriesInfo.get((int)0).offsets.add(fp);
            } else if (code.equals("IEND")) {
                this.seriesInfo.get((int)0).lengths.add(fp + (long)len + 4L);
            } else if (code.equals("LOOP")) {
                stack.add(fp + (long)len + 4L);
                this.in.skipBytes(1);
                maxIterations = this.in.readInt();
            } else if (code.equals("ENDL")) {
                long seek = (Long)stack.get(stack.size() - 1);
                if (currentIteration < maxIterations) {
                    this.in.seek(seek);
                    ++currentIteration;
                } else {
                    stack.remove(stack.size() - 1);
                    maxIterations = 0;
                    currentIteration = 0;
                }
            }
            this.in.seek(fp + (long)len + 4L);
        }
        LOGGER.info("Populating metadata");
        Hashtable<String, ArrayList<Long>> seriesOffsets = new Hashtable<String, ArrayList<Long>>();
        Hashtable seriesLengths = new Hashtable();
        SeriesInfo info = this.seriesInfo.get(0);
        this.addGlobalMeta("Number of frames", info.offsets.size());
        for (int i = 0; i < info.offsets.size(); ++i) {
            long offset = info.offsets.get(i);
            this.in.seek(offset);
            long end = info.lengths.get(i);
            if (end < offset) continue;
            BufferedImage img = this.readImage(end);
            String data = img.getWidth() + "-" + img.getHeight() + "-" + img.getRaster().getNumBands() + "-" + AWTImageTools.getPixelType(img);
            List<Long> v = (ArrayList<Long>)seriesOffsets.get(data);
            if (v == null) {
                v = new ArrayList<Long>();
                seriesOffsets.put(data, (ArrayList<Long>)v);
            }
            v.add(offset);
            v = (List)seriesLengths.get(data);
            if (v == null) {
                v = new ArrayList();
                seriesLengths.put(data, v);
            }
            v.add(end);
        }
        String[] keys = seriesOffsets.keySet().toArray(new String[0]);
        if (keys.length == 0) {
            throw new FormatException("Pixel data not found.");
        }
        int seriesCount = keys.length;
        this.core.clear();
        this.seriesInfo.clear();
        for (int i = 0; i < seriesCount; ++i) {
            CoreMetadata ms = new CoreMetadata();
            this.core.add(ms);
            String[] tokens = keys[i].split("-");
            ms.sizeX = Integer.parseInt(tokens[0]);
            ms.sizeY = Integer.parseInt(tokens[1]);
            ms.sizeC = Integer.parseInt(tokens[2]);
            ms.pixelType = Integer.parseInt(tokens[3]);
            ms.rgb = ms.sizeC > 1;
            ms.sizeZ = 1;
            ms.dimensionOrder = "XYCZT";
            ms.interleaved = false;
            ms.metadataComplete = true;
            ms.indexed = false;
            ms.littleEndian = false;
            ms.falseColor = false;
            SeriesInfo inf = new SeriesInfo();
            inf.offsets = (List)seriesOffsets.get(keys[i]);
            inf.lengths = (List)seriesLengths.get(keys[i]);
            this.seriesInfo.add(inf);
            ms.sizeT = ms.imageCount = inf.offsets.size();
        }
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
        for (int i = 0; i < this.getSeriesCount(); ++i) {
            store.setImageName("Series " + (i + 1), i);
        }
    }

    private BufferedImage readImage(long end) throws IOException {
        int headerSize = this.isJNG ? 0 : 8;
        byte[] b = new byte[(int)(end - this.in.getFilePointer() + (long)headerSize)];
        this.in.read(b, headerSize, b.length - headerSize);
        if (!this.isJNG) {
            b[0] = -119;
            b[1] = 80;
            b[2] = 78;
            b[3] = 71;
            b[4] = 13;
            b[5] = 10;
            b[6] = 26;
            b[7] = 10;
        }
        return ImageIO.read(new ByteArrayInputStream(b));
    }

    private class SeriesInfo {
        public List<Long> offsets = new ArrayList<Long>();
        public List<Long> lengths = new ArrayList<Long>();

        private SeriesInfo() {
        }
    }
}

