/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array.impl;

import mitiv.array.Long1D;
import mitiv.array.LongScalar;
import mitiv.array.impl.Helper;
import mitiv.array.impl.SelectedLong1D;
import mitiv.base.indexing.CompiledRange;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.LongFunction;
import mitiv.base.mapping.LongScanner;
import mitiv.random.LongGenerator;

public class StriddenLong1D
extends Long1D {
    final int order;
    final long[] data;
    final int offset;
    final int stride1;
    final boolean flat;

    public StriddenLong1D(long[] lArray, int n, int[] nArray, int[] nArray2) {
        super(nArray2);
        if (nArray.length != 1) {
            throw new IllegalArgumentException("There must be as many strides as the rank");
        }
        this.data = lArray;
        this.offset = n;
        this.stride1 = nArray[0];
        this.order = Long1D.checkViewStrides(this.data.length, n, this.stride1, this.dim1);
        this.flat = n == 0 && this.stride1 == 1;
    }

    public StriddenLong1D(long[] lArray, int n, int n2, int n3) {
        super(n3);
        this.data = lArray;
        this.offset = n;
        this.stride1 = n2;
        this.order = Long1D.checkViewStrides(this.data.length, n, n2, n3);
        this.flat = n == 0 && n2 == 1;
    }

    @Override
    public void checkSanity() {
        Long1D.checkViewStrides(this.data.length, this.offset, this.stride1, this.dim1);
    }

    final int index(int n) {
        return this.offset + this.stride1 * n;
    }

    @Override
    public final long get(int n) {
        return this.data[this.offset + this.stride1 * n];
    }

    @Override
    public final void set(int n, long l) {
        this.data[this.offset + this.stride1 * n] = l;
    }

    @Override
    public final int getOrder() {
        return this.order;
    }

    @Override
    public void fill(long l) {
        for (int i = 0; i < this.dim1; ++i) {
            int n = this.stride1 * i + this.offset;
            this.data[n] = l;
        }
    }

    @Override
    public void fill(LongGenerator longGenerator) {
        for (int i = 0; i < this.dim1; ++i) {
            int n = this.stride1 * i + this.offset;
            this.data[n] = longGenerator.nextLong();
        }
    }

    @Override
    public void increment(long l) {
        for (int i = 0; i < this.dim1; ++i) {
            int n;
            int n2 = n = this.stride1 * i + this.offset;
            this.data[n2] = this.data[n2] + l;
        }
    }

    @Override
    public void decrement(long l) {
        for (int i = 0; i < this.dim1; ++i) {
            int n;
            int n2 = n = this.stride1 * i + this.offset;
            this.data[n2] = this.data[n2] - l;
        }
    }

    @Override
    public void scale(long l) {
        for (int i = 0; i < this.dim1; ++i) {
            int n;
            int n2 = n = this.stride1 * i + this.offset;
            this.data[n2] = this.data[n2] * l;
        }
    }

    @Override
    public void map(LongFunction longFunction) {
        for (int i = 0; i < this.dim1; ++i) {
            int n = this.stride1 * i + this.offset;
            this.data[n] = longFunction.apply(this.data[n]);
        }
    }

    @Override
    public void scan(LongScanner longScanner) {
        boolean bl = false;
        for (int i = 0; i < this.dim1; ++i) {
            int n = this.stride1 * i + this.offset;
            if (bl) {
                longScanner.update(this.data[n]);
                continue;
            }
            longScanner.initialize(this.data[n]);
            bl = true;
        }
    }

    @Override
    public final boolean isFlat() {
        return this.flat;
    }

    @Override
    public long[] flatten(boolean bl) {
        if (!bl && this.flat) {
            return this.data;
        }
        long[] lArray = new long[this.number];
        if (this.flat) {
            System.arraycopy(this.data, 0, lArray, 0, this.number);
        } else {
            int n = -1;
            for (int i = 0; i < this.dim1; ++i) {
                int n2 = this.stride1 * i + this.offset;
                lArray[++n] = this.data[n2];
            }
        }
        return lArray;
    }

    @Override
    public long[] getData() {
        return this.flat ? this.data : null;
    }

    @Override
    public LongScalar slice(int n) {
        return new LongScalar(this.data, this.offset + this.stride1 * n);
    }

    @Override
    public LongScalar slice(int n, int n2) {
        if (n2 < 0) {
            ++n2;
        }
        if (n2 != 0) {
            throw new IndexOutOfBoundsException("Dimension index out of bounds");
        }
        int n3 = this.offset + this.stride1 * n;
        return new LongScalar(this.data, n3);
    }

    @Override
    public Long1D view(Range range) {
        CompiledRange compiledRange = new CompiledRange(range, this.dim1, this.offset, this.stride1);
        if (compiledRange.doesNothing()) {
            return this;
        }
        return new StriddenLong1D(this.data, compiledRange.getOffset(), compiledRange.getStride(), compiledRange.getNumber());
    }

    @Override
    public Long1D view(int[] nArray) {
        int[] nArray2 = Helper.select(this.offset, this.stride1, this.dim1, nArray);
        return new SelectedLong1D(this.data, nArray2);
    }

    @Override
    public Long1D as1D() {
        return this;
    }
}

