/*
 * Decompiled with CFR 0.152.
 */
package mitiv.cost;

import mitiv.base.Shape;
import mitiv.base.indexing.BoundaryConditions;
import mitiv.exception.IncorrectSpaceException;
import mitiv.linalg.LinearOperator;
import mitiv.linalg.Vector;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.DoubleShapedVectorSpace;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.FloatShapedVectorSpace;
import mitiv.random.DoubleGenerator;
import mitiv.random.FloatGenerator;
import mitiv.random.UniformDistribution;

public class FiniteDifferenceOperator
extends LinearOperator {
    private int[][] index;
    final boolean single;

    private static void testDoubleOperator(DoubleGenerator doubleGenerator, int[] nArray, BoundaryConditions boundaryConditions) {
        DoubleShapedVectorSpace doubleShapedVectorSpace = new DoubleShapedVectorSpace(nArray);
        FiniteDifferenceOperator finiteDifferenceOperator = new FiniteDifferenceOperator(doubleShapedVectorSpace, boundaryConditions);
        DoubleShapedVectorSpace doubleShapedVectorSpace2 = (DoubleShapedVectorSpace)finiteDifferenceOperator.getOutputSpace();
        DoubleShapedVector doubleShapedVector = doubleShapedVectorSpace.create();
        DoubleShapedVector doubleShapedVector2 = doubleShapedVectorSpace2.create();
        doubleShapedVector.fill(doubleGenerator);
        doubleShapedVector2.fill(doubleGenerator);
        System.out.printf("Testing the adjoint in %dD arrays, shape = [%d", nArray.length, nArray[0]);
        for (int i = 1; i < nArray.length; ++i) {
            System.out.printf(",%d", nArray[i]);
        }
        System.out.printf("], of random values:\n", new Object[0]);
        System.out.println("  relative error = " + finiteDifferenceOperator.checkAdjoint(doubleShapedVector, doubleShapedVector2));
    }

    private static void testFloatOperator(FloatGenerator floatGenerator, int[] nArray, BoundaryConditions boundaryConditions) {
        FloatShapedVectorSpace floatShapedVectorSpace = new FloatShapedVectorSpace(nArray);
        FiniteDifferenceOperator finiteDifferenceOperator = new FiniteDifferenceOperator(floatShapedVectorSpace, boundaryConditions);
        FloatShapedVectorSpace floatShapedVectorSpace2 = (FloatShapedVectorSpace)finiteDifferenceOperator.getOutputSpace();
        FloatShapedVector floatShapedVector = floatShapedVectorSpace.create();
        FloatShapedVector floatShapedVector2 = floatShapedVectorSpace2.create();
        floatShapedVector.fill(floatGenerator);
        floatShapedVector2.fill(floatGenerator);
        System.out.printf("Testing the adjoint in %dD arrays, shape = [%d", nArray.length, nArray[0]);
        for (int i = 1; i < nArray.length; ++i) {
            System.out.printf(",%d", nArray[i]);
        }
        System.out.printf("], of random values:\n", new Object[0]);
        System.out.println("  relative error = " + finiteDifferenceOperator.checkAdjoint(floatShapedVector, floatShapedVector2));
    }

    public static void main(String[] stringArray) {
        DoubleShapedVectorSpace doubleShapedVectorSpace = new DoubleShapedVectorSpace(new int[]{5});
        DoubleShapedVector doubleShapedVector = doubleShapedVectorSpace.create();
        doubleShapedVector.set(0, 1.2);
        doubleShapedVector.set(1, 2.7);
        doubleShapedVector.set(2, -3.1);
        doubleShapedVector.set(3, 5.3);
        doubleShapedVector.set(4, -9.0);
        FiniteDifferenceOperator finiteDifferenceOperator = new FiniteDifferenceOperator(doubleShapedVectorSpace);
        DoubleShapedVectorSpace doubleShapedVectorSpace2 = (DoubleShapedVectorSpace)finiteDifferenceOperator.getOutputSpace();
        DoubleShapedVector doubleShapedVector2 = doubleShapedVectorSpace2.create();
        doubleShapedVector2.set(0, 2.1);
        doubleShapedVector2.set(1, 7.2);
        doubleShapedVector2.set(2, -1.3);
        doubleShapedVector2.set(3, 3.5);
        doubleShapedVector2.set(4, -0.9);
        System.out.println("Testing the adjoint:");
        System.out.println("  a = " + doubleShapedVector);
        System.out.println("  b = " + doubleShapedVector2);
        System.out.println("  relative error = " + finiteDifferenceOperator.checkAdjoint(doubleShapedVector, doubleShapedVector2));
        System.out.println("");
        System.out.println("Testing the operator:");
        finiteDifferenceOperator.apply(doubleShapedVector2, doubleShapedVector);
        DoubleShapedVector doubleShapedVector3 = doubleShapedVectorSpace.create();
        finiteDifferenceOperator.apply(doubleShapedVector3, doubleShapedVector2, LinearOperator.ADJOINT);
        System.out.println("a = " + doubleShapedVector);
        System.out.println("b = " + doubleShapedVector2);
        System.out.println("c = " + doubleShapedVector3);
        System.out.println("");
        UniformDistribution uniformDistribution = new UniformDistribution(-1.0, 1.0);
        FiniteDifferenceOperator.testDoubleOperator(uniformDistribution, new int[]{3, 4, 5}, BoundaryConditions.MIRROR);
        FiniteDifferenceOperator.testDoubleOperator(uniformDistribution, new int[]{3, 4, 5}, BoundaryConditions.NORMAL);
        FiniteDifferenceOperator.testFloatOperator(uniformDistribution, new int[]{3, 4, 5, 6}, BoundaryConditions.NORMAL);
        FiniteDifferenceOperator.testFloatOperator(uniformDistribution, new int[]{3, 4, 5, 6, 7}, BoundaryConditions.PERIODIC);
    }

    public FiniteDifferenceOperator(DoubleShapedVectorSpace doubleShapedVectorSpace, BoundaryConditions[] boundaryConditionsArray) {
        super(doubleShapedVectorSpace, new DoubleShapedVectorSpace(FiniteDifferenceOperator.buildShape(doubleShapedVectorSpace.getShape())));
        this.buildIndex(doubleShapedVectorSpace.getShape(), boundaryConditionsArray);
        this.single = false;
    }

    public FiniteDifferenceOperator(DoubleShapedVectorSpace doubleShapedVectorSpace, BoundaryConditions boundaryConditions) {
        super(doubleShapedVectorSpace, new DoubleShapedVectorSpace(FiniteDifferenceOperator.buildShape(doubleShapedVectorSpace.getShape())));
        this.buildIndex(doubleShapedVectorSpace.getShape(), boundaryConditions);
        this.single = false;
    }

    public FiniteDifferenceOperator(DoubleShapedVectorSpace doubleShapedVectorSpace) {
        this(doubleShapedVectorSpace, BoundaryConditions.NORMAL);
    }

    public FiniteDifferenceOperator(FloatShapedVectorSpace floatShapedVectorSpace, BoundaryConditions[] boundaryConditionsArray) {
        super(floatShapedVectorSpace, new FloatShapedVectorSpace(FiniteDifferenceOperator.buildShape(floatShapedVectorSpace.getShape())));
        this.buildIndex(floatShapedVectorSpace.getShape(), boundaryConditionsArray);
        this.single = true;
    }

    public FiniteDifferenceOperator(FloatShapedVectorSpace floatShapedVectorSpace, BoundaryConditions boundaryConditions) {
        super(floatShapedVectorSpace, new FloatShapedVectorSpace(FiniteDifferenceOperator.buildShape(floatShapedVectorSpace.getShape())));
        this.buildIndex(floatShapedVectorSpace.getShape(), boundaryConditions);
        this.single = true;
    }

    public FiniteDifferenceOperator(FloatShapedVectorSpace floatShapedVectorSpace) {
        this(floatShapedVectorSpace, BoundaryConditions.NORMAL);
    }

    private static Shape buildShape(Shape shape) {
        int n = shape.rank();
        if (n == 1) {
            return shape;
        }
        int[] nArray = new int[n + 1];
        nArray[0] = n;
        for (int i = 0; i < n; ++i) {
            nArray[i + 1] = shape.dimension(i);
        }
        return new Shape(nArray);
    }

    private BoundaryConditions getBoundaryConditions(BoundaryConditions[] boundaryConditionsArray, int n) {
        return boundaryConditionsArray == null || n < 0 || n >= boundaryConditionsArray.length ? BoundaryConditions.NORMAL : boundaryConditionsArray[n];
    }

    private void buildIndex(Shape shape, BoundaryConditions[] boundaryConditionsArray) {
        int n = shape.rank();
        this.index = new int[n][];
        for (int i = 0; i < n; ++i) {
            this.index[i] = BoundaryConditions.buildIndex(shape.dimension(i), -1, this.getBoundaryConditions(boundaryConditionsArray, i));
        }
    }

    private void buildIndex(Shape shape, BoundaryConditions boundaryConditions) {
        int n = shape.rank();
        this.index = new int[n][];
        for (int i = 0; i < n; ++i) {
            this.index[i] = BoundaryConditions.buildIndex(shape.dimension(i), -1, boundaryConditions);
        }
    }

    private double[] getDoubleData(Vector vector) {
        return ((DoubleShapedVector)vector).getData();
    }

    private float[] getFloatData(Vector vector) {
        return ((FloatShapedVector)vector).getData();
    }

    @Override
    protected void _apply(Vector vector, Vector vector2, int n) throws IncorrectSpaceException {
        boolean bl;
        if (n == ADJOINT) {
            vector.zero();
            bl = true;
        } else if (n == DIRECT) {
            bl = false;
        } else {
            throw new IllegalArgumentException("illegal job");
        }
        int n2 = this.index.length;
        if (n2 == 1) {
            if (this.single) {
                this.apply1D(this.getFloatData(vector2), this.getFloatData(vector), bl);
            } else {
                this.apply1D(this.getDoubleData(vector2), this.getDoubleData(vector), bl);
            }
        } else if (n2 == 2) {
            if (this.single) {
                this.apply2D(this.getFloatData(vector2), this.getFloatData(vector), bl);
            } else {
                this.apply2D(this.getDoubleData(vector2), this.getDoubleData(vector), bl);
            }
        } else if (n2 == 3) {
            if (this.single) {
                this.apply3D(this.getFloatData(vector2), this.getFloatData(vector), bl);
            } else {
                this.apply3D(this.getDoubleData(vector2), this.getDoubleData(vector), bl);
            }
        } else if (n2 == 4) {
            if (this.single) {
                this.apply4D(this.getFloatData(vector2), this.getFloatData(vector), bl);
            } else {
                this.apply4D(this.getDoubleData(vector2), this.getDoubleData(vector), bl);
            }
        } else if (n2 == 5) {
            if (this.single) {
                this.apply5D(this.getFloatData(vector2), this.getFloatData(vector), bl);
            } else {
                this.apply5D(this.getDoubleData(vector2), this.getDoubleData(vector), bl);
            }
        } else {
            throw new IllegalArgumentException("too many dimensions");
        }
    }

    private final void apply1D(double[] dArray, double[] dArray2, boolean bl) {
        int[] nArray = this.index[0];
        int n = nArray.length;
        if (bl) {
            for (int i = 0; i < n; ++i) {
                double d = dArray[i];
                int n2 = i;
                dArray2[n2] = dArray2[n2] + d;
                int n3 = nArray[i];
                dArray2[n3] = dArray2[n3] - d;
            }
        } else {
            for (int i = 0; i < n; ++i) {
                dArray2[i] = dArray[i] - dArray[nArray[i]];
            }
        }
    }

    private final void apply2D(double[] dArray, double[] dArray2, boolean bl) {
        int[] nArray = this.index[0];
        int n = nArray.length;
        int[] nArray2 = this.index[1];
        int n2 = nArray2.length;
        if (bl) {
            for (int i = 0; i < n2; ++i) {
                int n3 = n * i;
                int n4 = n * (nArray2[i] - i);
                for (int j = 0; j < n; ++j) {
                    int n5 = j + n3;
                    int n6 = nArray[j] - j;
                    int n7 = 2 * n5;
                    double d = dArray[n7];
                    double d2 = dArray[n7 + 1];
                    int n8 = n5;
                    dArray2[n8] = dArray2[n8] + (d + d2);
                    int n9 = n5 + n6;
                    dArray2[n9] = dArray2[n9] - d;
                    int n10 = n5 + n4;
                    dArray2[n10] = dArray2[n10] - d2;
                }
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                int n11 = n * i;
                int n12 = n * (nArray2[i] - i);
                for (int j = 0; j < n; ++j) {
                    int n13 = j + n11;
                    int n14 = nArray[j] - j;
                    int n15 = 2 * n13;
                    double d = dArray[n13];
                    dArray2[n15] = d - dArray[n13 + n14];
                    dArray2[n15 + 1] = d - dArray[n13 + n12];
                }
            }
        }
    }

    private final void apply3D(double[] dArray, double[] dArray2, boolean bl) {
        int[] nArray = this.index[0];
        int n = nArray.length;
        int[] nArray2 = this.index[1];
        int n2 = nArray2.length;
        int[] nArray3 = this.index[2];
        int n3 = nArray3.length;
        int n4 = n * n2;
        if (bl) {
            for (int i = 0; i < n3; ++i) {
                int n5 = n4 * i;
                int n6 = n4 * (nArray3[i] - i);
                for (int j = 0; j < n2; ++j) {
                    int n7 = n * j + n5;
                    int n8 = n * (nArray2[j] - j);
                    for (int k = 0; k < n; ++k) {
                        int n9 = k + n7;
                        int n10 = nArray[k] - k;
                        int n11 = 3 * n9;
                        double d = dArray[n11];
                        double d2 = dArray[n11 + 1];
                        double d3 = dArray[n11 + 2];
                        int n12 = n9;
                        dArray2[n12] = dArray2[n12] + (d + d2 + d3);
                        int n13 = n9 + n10;
                        dArray2[n13] = dArray2[n13] - d;
                        int n14 = n9 + n8;
                        dArray2[n14] = dArray2[n14] - d2;
                        int n15 = n9 + n6;
                        dArray2[n15] = dArray2[n15] - d3;
                    }
                }
            }
        } else {
            for (int i = 0; i < n3; ++i) {
                int n16 = n4 * i;
                int n17 = n4 * (nArray3[i] - i);
                for (int j = 0; j < n2; ++j) {
                    int n18 = n * j + n16;
                    int n19 = n * (nArray2[j] - j);
                    for (int k = 0; k < n; ++k) {
                        int n20 = k + n18;
                        int n21 = nArray[k] - k;
                        int n22 = 3 * n20;
                        double d = dArray[n20];
                        dArray2[n22] = d - dArray[n20 + n21];
                        dArray2[n22 + 1] = d - dArray[n20 + n19];
                        dArray2[n22 + 2] = d - dArray[n20 + n17];
                    }
                }
            }
        }
    }

    private final void apply4D(double[] dArray, double[] dArray2, boolean bl) {
        int[] nArray = this.index[0];
        int n = nArray.length;
        int[] nArray2 = this.index[1];
        int n2 = nArray2.length;
        int[] nArray3 = this.index[2];
        int n3 = nArray3.length;
        int n4 = n * n2;
        int[] nArray4 = this.index[3];
        int n5 = nArray4.length;
        int n6 = n4 * n3;
        if (bl) {
            for (int i = 0; i < n5; ++i) {
                int n7 = n6 * i;
                int n8 = n6 * (nArray4[i] - i);
                for (int j = 0; j < n3; ++j) {
                    int n9 = n4 * j + n7;
                    int n10 = n4 * (nArray3[j] - j);
                    for (int k = 0; k < n2; ++k) {
                        int n11 = n * k + n9;
                        int n12 = n * (nArray2[k] - k);
                        for (int i2 = 0; i2 < n; ++i2) {
                            int n13 = i2 + n11;
                            int n14 = nArray[i2] - i2;
                            int n15 = 4 * n13;
                            double d = dArray[n15];
                            double d2 = dArray[n15 + 1];
                            double d3 = dArray[n15 + 2];
                            double d4 = dArray[n15 + 3];
                            int n16 = n13;
                            dArray2[n16] = dArray2[n16] + (d + d2 + d3 + d4);
                            int n17 = n13 + n14;
                            dArray2[n17] = dArray2[n17] - d;
                            int n18 = n13 + n12;
                            dArray2[n18] = dArray2[n18] - d2;
                            int n19 = n13 + n10;
                            dArray2[n19] = dArray2[n19] - d3;
                            int n20 = n13 + n8;
                            dArray2[n20] = dArray2[n20] - d4;
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < n5; ++i) {
                int n21 = n6 * i;
                int n22 = n6 * (nArray4[i] - i);
                for (int j = 0; j < n3; ++j) {
                    int n23 = n4 * j + n21;
                    int n24 = n4 * (nArray3[j] - j);
                    for (int k = 0; k < n2; ++k) {
                        int n25 = n * k + n23;
                        int n26 = n * (nArray2[k] - k);
                        for (int i3 = 0; i3 < n; ++i3) {
                            int n27 = i3 + n25;
                            int n28 = nArray[i3] - i3;
                            int n29 = 4 * n27;
                            double d = dArray[n27];
                            dArray2[n29] = d - dArray[n27 + n28];
                            dArray2[n29 + 1] = d - dArray[n27 + n26];
                            dArray2[n29 + 2] = d - dArray[n27 + n24];
                            dArray2[n29 + 3] = d - dArray[n27 + n22];
                        }
                    }
                }
            }
        }
    }

    private final void apply5D(double[] dArray, double[] dArray2, boolean bl) {
        int[] nArray = this.index[0];
        int n = nArray.length;
        int[] nArray2 = this.index[1];
        int n2 = nArray2.length;
        int[] nArray3 = this.index[2];
        int n3 = nArray3.length;
        int n4 = n * n2;
        int[] nArray4 = this.index[3];
        int n5 = nArray4.length;
        int n6 = n4 * n3;
        int[] nArray5 = this.index[4];
        int n7 = nArray5.length;
        int n8 = n6 * n5;
        if (bl) {
            for (int i = 0; i < n7; ++i) {
                int n9 = n8 * i;
                int n10 = n8 * (nArray5[i] - i);
                for (int j = 0; j < n5; ++j) {
                    int n11 = n6 * j + n9;
                    int n12 = n6 * (nArray4[j] - j);
                    for (int k = 0; k < n3; ++k) {
                        int n13 = n4 * k + n11;
                        int n14 = n4 * (nArray3[k] - k);
                        for (int i2 = 0; i2 < n2; ++i2) {
                            int n15 = n * i2 + n13;
                            int n16 = n * (nArray2[i2] - i2);
                            for (int i3 = 0; i3 < n; ++i3) {
                                int n17 = i3 + n15;
                                int n18 = nArray[i3] - i3;
                                int n19 = 5 * n17;
                                double d = dArray[n19];
                                double d2 = dArray[n19 + 1];
                                double d3 = dArray[n19 + 2];
                                double d4 = dArray[n19 + 3];
                                double d5 = dArray[n19 + 4];
                                int n20 = n17;
                                dArray2[n20] = dArray2[n20] + (d + d2 + d3 + d4 + d5);
                                int n21 = n17 + n18;
                                dArray2[n21] = dArray2[n21] - d;
                                int n22 = n17 + n16;
                                dArray2[n22] = dArray2[n22] - d2;
                                int n23 = n17 + n14;
                                dArray2[n23] = dArray2[n23] - d3;
                                int n24 = n17 + n12;
                                dArray2[n24] = dArray2[n24] - d4;
                                int n25 = n17 + n10;
                                dArray2[n25] = dArray2[n25] - d5;
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < n7; ++i) {
                int n26 = n8 * i;
                int n27 = n8 * (nArray5[i] - i);
                for (int j = 0; j < n5; ++j) {
                    int n28 = n6 * j + n26;
                    int n29 = n6 * (nArray4[j] - j);
                    for (int k = 0; k < n3; ++k) {
                        int n30 = n4 * k + n28;
                        int n31 = n4 * (nArray3[k] - k);
                        for (int i4 = 0; i4 < n2; ++i4) {
                            int n32 = n * i4 + n30;
                            int n33 = n * (nArray2[i4] - i4);
                            for (int i5 = 0; i5 < n; ++i5) {
                                int n34 = i5 + n32;
                                int n35 = nArray[i5] - i5;
                                int n36 = 5 * n34;
                                double d = dArray[n34];
                                dArray2[n36] = d - dArray[n34 + n35];
                                dArray2[n36 + 1] = d - dArray[n34 + n33];
                                dArray2[n36 + 2] = d - dArray[n34 + n31];
                                dArray2[n36 + 3] = d - dArray[n34 + n29];
                                dArray2[n36 + 4] = d - dArray[n34 + n27];
                            }
                        }
                    }
                }
            }
        }
    }

    private final void apply1D(float[] fArray, float[] fArray2, boolean bl) {
        int[] nArray = this.index[0];
        int n = nArray.length;
        if (bl) {
            for (int i = 0; i < n; ++i) {
                float f = fArray[i];
                int n2 = i;
                fArray2[n2] = fArray2[n2] + f;
                int n3 = nArray[i];
                fArray2[n3] = fArray2[n3] - f;
            }
        } else {
            for (int i = 0; i < n; ++i) {
                fArray2[i] = fArray[i] - fArray[nArray[i]];
            }
        }
    }

    private final void apply2D(float[] fArray, float[] fArray2, boolean bl) {
        int[] nArray = this.index[0];
        int n = nArray.length;
        int[] nArray2 = this.index[1];
        int n2 = nArray2.length;
        if (bl) {
            for (int i = 0; i < n2; ++i) {
                int n3 = n * i;
                int n4 = n * (nArray2[i] - i);
                for (int j = 0; j < n; ++j) {
                    int n5 = j + n3;
                    int n6 = nArray[j] - j;
                    int n7 = 2 * n5;
                    float f = fArray[n7];
                    float f2 = fArray[n7 + 1];
                    int n8 = n5;
                    fArray2[n8] = fArray2[n8] + (f + f2);
                    int n9 = n5 + n6;
                    fArray2[n9] = fArray2[n9] - f;
                    int n10 = n5 + n4;
                    fArray2[n10] = fArray2[n10] - f2;
                }
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                int n11 = n * i;
                int n12 = n * (nArray2[i] - i);
                for (int j = 0; j < n; ++j) {
                    int n13 = j + n11;
                    int n14 = nArray[j] - j;
                    int n15 = 2 * n13;
                    float f = fArray[n13];
                    fArray2[n15] = f - fArray[n13 + n14];
                    fArray2[n15 + 1] = f - fArray[n13 + n12];
                }
            }
        }
    }

    private final void apply3D(float[] fArray, float[] fArray2, boolean bl) {
        int[] nArray = this.index[0];
        int n = nArray.length;
        int[] nArray2 = this.index[1];
        int n2 = nArray2.length;
        int[] nArray3 = this.index[2];
        int n3 = nArray3.length;
        int n4 = n * n2;
        if (bl) {
            for (int i = 0; i < n3; ++i) {
                int n5 = n4 * i;
                int n6 = n4 * (nArray3[i] - i);
                for (int j = 0; j < n2; ++j) {
                    int n7 = n * j + n5;
                    int n8 = n * (nArray2[j] - j);
                    for (int k = 0; k < n; ++k) {
                        int n9 = k + n7;
                        int n10 = nArray[k] - k;
                        int n11 = 3 * n9;
                        float f = fArray[n11];
                        float f2 = fArray[n11 + 1];
                        float f3 = fArray[n11 + 2];
                        int n12 = n9;
                        fArray2[n12] = fArray2[n12] + (f + f2 + f3);
                        int n13 = n9 + n10;
                        fArray2[n13] = fArray2[n13] - f;
                        int n14 = n9 + n8;
                        fArray2[n14] = fArray2[n14] - f2;
                        int n15 = n9 + n6;
                        fArray2[n15] = fArray2[n15] - f3;
                    }
                }
            }
        } else {
            for (int i = 0; i < n3; ++i) {
                int n16 = n4 * i;
                int n17 = n4 * (nArray3[i] - i);
                for (int j = 0; j < n2; ++j) {
                    int n18 = n * j + n16;
                    int n19 = n * (nArray2[j] - j);
                    for (int k = 0; k < n; ++k) {
                        int n20 = k + n18;
                        int n21 = nArray[k] - k;
                        int n22 = 3 * n20;
                        float f = fArray[n20];
                        fArray2[n22] = f - fArray[n20 + n21];
                        fArray2[n22 + 1] = f - fArray[n20 + n19];
                        fArray2[n22 + 2] = f - fArray[n20 + n17];
                    }
                }
            }
        }
    }

    private final void apply4D(float[] fArray, float[] fArray2, boolean bl) {
        int[] nArray = this.index[0];
        int n = nArray.length;
        int[] nArray2 = this.index[1];
        int n2 = nArray2.length;
        int[] nArray3 = this.index[2];
        int n3 = nArray3.length;
        int n4 = n * n2;
        int[] nArray4 = this.index[3];
        int n5 = nArray4.length;
        int n6 = n4 * n3;
        if (bl) {
            for (int i = 0; i < n5; ++i) {
                int n7 = n6 * i;
                int n8 = n6 * (nArray4[i] - i);
                for (int j = 0; j < n3; ++j) {
                    int n9 = n4 * j + n7;
                    int n10 = n4 * (nArray3[j] - j);
                    for (int k = 0; k < n2; ++k) {
                        int n11 = n * k + n9;
                        int n12 = n * (nArray2[k] - k);
                        for (int i2 = 0; i2 < n; ++i2) {
                            int n13 = i2 + n11;
                            int n14 = nArray[i2] - i2;
                            int n15 = 4 * n13;
                            float f = fArray[n15];
                            float f2 = fArray[n15 + 1];
                            float f3 = fArray[n15 + 2];
                            float f4 = fArray[n15 + 3];
                            int n16 = n13;
                            fArray2[n16] = fArray2[n16] + (f + f2 + f3 + f4);
                            int n17 = n13 + n14;
                            fArray2[n17] = fArray2[n17] - f;
                            int n18 = n13 + n12;
                            fArray2[n18] = fArray2[n18] - f2;
                            int n19 = n13 + n10;
                            fArray2[n19] = fArray2[n19] - f3;
                            int n20 = n13 + n8;
                            fArray2[n20] = fArray2[n20] - f4;
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < n5; ++i) {
                int n21 = n6 * i;
                int n22 = n6 * (nArray4[i] - i);
                for (int j = 0; j < n3; ++j) {
                    int n23 = n4 * j + n21;
                    int n24 = n4 * (nArray3[j] - j);
                    for (int k = 0; k < n2; ++k) {
                        int n25 = n * k + n23;
                        int n26 = n * (nArray2[k] - k);
                        for (int i3 = 0; i3 < n; ++i3) {
                            int n27 = i3 + n25;
                            int n28 = nArray[i3] - i3;
                            int n29 = 4 * n27;
                            float f = fArray[n27];
                            fArray2[n29] = f - fArray[n27 + n28];
                            fArray2[n29 + 1] = f - fArray[n27 + n26];
                            fArray2[n29 + 2] = f - fArray[n27 + n24];
                            fArray2[n29 + 3] = f - fArray[n27 + n22];
                        }
                    }
                }
            }
        }
    }

    private final void apply5D(float[] fArray, float[] fArray2, boolean bl) {
        int[] nArray = this.index[0];
        int n = nArray.length;
        int[] nArray2 = this.index[1];
        int n2 = nArray2.length;
        int[] nArray3 = this.index[2];
        int n3 = nArray3.length;
        int n4 = n * n2;
        int[] nArray4 = this.index[3];
        int n5 = nArray4.length;
        int n6 = n4 * n3;
        int[] nArray5 = this.index[4];
        int n7 = nArray5.length;
        int n8 = n6 * n5;
        if (bl) {
            for (int i = 0; i < n7; ++i) {
                int n9 = n8 * i;
                int n10 = n8 * (nArray5[i] - i);
                for (int j = 0; j < n5; ++j) {
                    int n11 = n6 * j + n9;
                    int n12 = n6 * (nArray4[j] - j);
                    for (int k = 0; k < n3; ++k) {
                        int n13 = n4 * k + n11;
                        int n14 = n4 * (nArray3[k] - k);
                        for (int i2 = 0; i2 < n2; ++i2) {
                            int n15 = n * i2 + n13;
                            int n16 = n * (nArray2[i2] - i2);
                            for (int i3 = 0; i3 < n; ++i3) {
                                int n17 = i3 + n15;
                                int n18 = nArray[i3] - i3;
                                int n19 = 5 * n17;
                                float f = fArray[n19];
                                float f2 = fArray[n19 + 1];
                                float f3 = fArray[n19 + 2];
                                float f4 = fArray[n19 + 3];
                                float f5 = fArray[n19 + 4];
                                int n20 = n17;
                                fArray2[n20] = fArray2[n20] + (f + f2 + f3 + f4 + f5);
                                int n21 = n17 + n18;
                                fArray2[n21] = fArray2[n21] - f;
                                int n22 = n17 + n16;
                                fArray2[n22] = fArray2[n22] - f2;
                                int n23 = n17 + n14;
                                fArray2[n23] = fArray2[n23] - f3;
                                int n24 = n17 + n12;
                                fArray2[n24] = fArray2[n24] - f4;
                                int n25 = n17 + n10;
                                fArray2[n25] = fArray2[n25] - f5;
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < n7; ++i) {
                int n26 = n8 * i;
                int n27 = n8 * (nArray5[i] - i);
                for (int j = 0; j < n5; ++j) {
                    int n28 = n6 * j + n26;
                    int n29 = n6 * (nArray4[j] - j);
                    for (int k = 0; k < n3; ++k) {
                        int n30 = n4 * k + n28;
                        int n31 = n4 * (nArray3[k] - k);
                        for (int i4 = 0; i4 < n2; ++i4) {
                            int n32 = n * i4 + n30;
                            int n33 = n * (nArray2[i4] - i4);
                            for (int i5 = 0; i5 < n; ++i5) {
                                int n34 = i5 + n32;
                                int n35 = nArray[i5] - i5;
                                int n36 = 5 * n34;
                                float f = fArray[n34];
                                fArray2[n36] = f - fArray[n34 + n35];
                                fArray2[n36 + 1] = f - fArray[n34 + n33];
                                fArray2[n36 + 2] = f - fArray[n34 + n31];
                                fArray2[n36 + 3] = f - fArray[n34 + n29];
                                fArray2[n36 + 4] = f - fArray[n34 + n27];
                            }
                        }
                    }
                }
            }
        }
    }
}

